(ns javax.net.ssl.SSLEngineResult$HandshakeStatus
  (:refer-clojure :only [require comment defn ->])
  (:import [javax.net.ssl SSLEngineResult$HandshakeStatus]))

(def NOT_HANDSHAKING
  "Enum Constant.

  The SSLEngine is not currently handshaking.

  type: javax.net.ssl.SSLEngineResult$HandshakeStatus"
  SSLEngineResult$HandshakeStatus/NOT_HANDSHAKING)

(def FINISHED
  "Enum Constant.

  The SSLEngine has just finished handshaking.

   This value is only generated by a call to
   SSLEngine.wrap()/unwrap() when that call
   finishes a handshake.  It is never generated by
   SSLEngine.getHandshakeStatus().

  type: javax.net.ssl.SSLEngineResult$HandshakeStatus"
  SSLEngineResult$HandshakeStatus/FINISHED)

(def NEED_TASK
  "Enum Constant.

  The SSLEngine needs the results of one (or more)
   delegated tasks before handshaking can continue.

  type: javax.net.ssl.SSLEngineResult$HandshakeStatus"
  SSLEngineResult$HandshakeStatus/NEED_TASK)

(def NEED_WRAP
  "Enum Constant.

  The SSLEngine must send data to the remote side
   before handshaking can continue, so SSLEngine.wrap()
   should be called.

  type: javax.net.ssl.SSLEngineResult$HandshakeStatus"
  SSLEngineResult$HandshakeStatus/NEED_WRAP)

(def NEED_UNWRAP
  "Enum Constant.

  The SSLEngine needs to receive data from the
   remote side before handshaking can continue.

  type: javax.net.ssl.SSLEngineResult$HandshakeStatus"
  SSLEngineResult$HandshakeStatus/NEED_UNWRAP)

(defn *values
  "Returns an array containing the constants of this enum type, in
  the order they are declared.  This method may be used to iterate
  over the constants as follows:


  for (SSLEngineResult.HandshakeStatus c : SSLEngineResult.HandshakeStatus.values())
      System.out.println(c);

  returns: an array containing the constants of this enum type, in the order they are declared - `javax.net.ssl.SSLEngineResult$HandshakeStatus[]`"
  ([]
    (SSLEngineResult$HandshakeStatus/values )))

(defn *value-of
  "Returns the enum constant of this type with the specified name.
  The string must match exactly an identifier used to declare an
  enum constant in this type.  (Extraneous whitespace characters are
  not permitted.)

  name - the name of the enum constant to be returned. - `java.lang.String`

  returns: the enum constant with the specified name - `javax.net.ssl.SSLEngineResult$HandshakeStatus`

  throws: java.lang.IllegalArgumentException - if this enum type has no constant with the specified name"
  (^javax.net.ssl.SSLEngineResult$HandshakeStatus [^java.lang.String name]
    (SSLEngineResult$HandshakeStatus/valueOf name)))

