(ns javax.print.attribute.standard.MediaSize$NA
  "Class MediaSize.NA includes MediaSize values for North
  American media."
  (:refer-clojure :only [require comment defn ->])
  (:import [javax.print.attribute.standard MediaSize$NA]))

(def *-letter
  "Static Constant.

  Specifies the North American letter size, 8.5 inches by 11 inches.

  type: javax.print.attribute.standard.MediaSize"
  MediaSize$NA/LETTER)

(def *-legal
  "Static Constant.

  Specifies the North American legal size, 8.5 inches by 14 inches.

  type: javax.print.attribute.standard.MediaSize"
  MediaSize$NA/LEGAL)

(def *-na-5-x-7
  "Static Constant.

  Specifies the North American 5 inch by 7 inch paper.

  type: javax.print.attribute.standard.MediaSize"
  MediaSize$NA/NA_5X7)

(def *-na-8-x-10
  "Static Constant.

  Specifies the North American 8 inch by 10 inch paper.

  type: javax.print.attribute.standard.MediaSize"
  MediaSize$NA/NA_8X10)

(def *-na-number-9-envelope
  "Static Constant.

  Specifies the North American Number 9 business envelope size,
   3.875 inches by 8.875 inches.

  type: javax.print.attribute.standard.MediaSize"
  MediaSize$NA/NA_NUMBER_9_ENVELOPE)

(def *-na-number-10-envelope
  "Static Constant.

  Specifies the North American Number 10 business envelope size,
   4.125 inches by 9.5 inches.

  type: javax.print.attribute.standard.MediaSize"
  MediaSize$NA/NA_NUMBER_10_ENVELOPE)

(def *-na-number-11-envelope
  "Static Constant.

  Specifies the North American Number 11 business envelope size,
   4.5 inches by 10.375 inches.

  type: javax.print.attribute.standard.MediaSize"
  MediaSize$NA/NA_NUMBER_11_ENVELOPE)

(def *-na-number-12-envelope
  "Static Constant.

  Specifies the North American Number 12 business envelope size,
   4.75 inches by 11 inches.

  type: javax.print.attribute.standard.MediaSize"
  MediaSize$NA/NA_NUMBER_12_ENVELOPE)

(def *-na-number-14-envelope
  "Static Constant.

  Specifies the North American Number 14 business envelope size,
   5 inches by 11.5 inches.

  type: javax.print.attribute.standard.MediaSize"
  MediaSize$NA/NA_NUMBER_14_ENVELOPE)

(def *-na-6-x-9-envelope
  "Static Constant.

  Specifies the North American 6 inch by 9 inch envelope size.

  type: javax.print.attribute.standard.MediaSize"
  MediaSize$NA/NA_6X9_ENVELOPE)

(def *-na-7-x-9-envelope
  "Static Constant.

  Specifies the North American 7 inch by 9 inch envelope size.

  type: javax.print.attribute.standard.MediaSize"
  MediaSize$NA/NA_7X9_ENVELOPE)

(def *-na-9x-11-envelope
  "Static Constant.

  Specifies the North American 9 inch by 11 inch envelope size.

  type: javax.print.attribute.standard.MediaSize"
  MediaSize$NA/NA_9x11_ENVELOPE)

(def *-na-9x-12-envelope
  "Static Constant.

  Specifies the North American 9 inch by 12 inch envelope size.

  type: javax.print.attribute.standard.MediaSize"
  MediaSize$NA/NA_9x12_ENVELOPE)

(def *-na-10x-13-envelope
  "Static Constant.

  Specifies the North American 10 inch by 13 inch envelope size.

  type: javax.print.attribute.standard.MediaSize"
  MediaSize$NA/NA_10x13_ENVELOPE)

(def *-na-10x-14-envelope
  "Static Constant.

  Specifies the North American 10 inch by 14 inch envelope size.

  type: javax.print.attribute.standard.MediaSize"
  MediaSize$NA/NA_10x14_ENVELOPE)

(def *-na-10-x-15-envelope
  "Static Constant.

  Specifies the North American 10 inch by 15 inch envelope size.

  type: javax.print.attribute.standard.MediaSize"
  MediaSize$NA/NA_10X15_ENVELOPE)

