(ns javax.print.attribute.standard.PagesPerMinuteColor
  "Class PagesPerMinuteColor is an integer valued printing attribute that
  indicates the nominal number of pages per minute to the nearest whole number
  which may be generated by this printer when printing color (e.g., simplex,
  color). For purposes of this attribute, `color` means the same as for the
  ColorSupported attribute, namely, the device is
  capable of any type of color printing at all, including highlight color as
  well as full process color. This attribute is informative, not a service
  guarantee. Generally, it is the value used in the marketing literature to
  describe the color capabilities of this device. A value of 0 indicates a
  device that takes more than two minutes to process a page. If a color device
  has several color modes, it may use the pages-per- minute value for this
  attribute that corresponds to the mode that produces the highest number.

  A black and white only printer must not include the PagesPerMinuteColor
  attribute in its attribute set or service registration. If this attribute is
  present, then the ColorSupported printer description
  attribute must also be present and have a value of SUPPORTED.

  IPP Compatibility: The integer value gives the IPP integer value. The
  category name returned by getName() gives the IPP attribute
  name."
  (:refer-clojure :only [require comment defn ->])
  (:import [javax.print.attribute.standard PagesPerMinuteColor]))

(defn ->pages-per-minute-color
  "Constructor.

  Construct a new pages per minute color attribute with the given integer
   value.

  value - Integer value. - `int`

  throws: java.lang.IllegalArgumentException - (Unchecked exception) Thrown if value is less than 0."
  ([^Integer value]
    (new PagesPerMinuteColor value)))

(defn equals
  "Returns whether this pages per minute color attribute is equivalent to
   the passed in object. To be equivalent, all of the following conditions
   must be true:


   object is not null.

   object is an instance of class PagesPerMinuteColor.

   This pages per minute attribute's value and object's
   value are equal.

  object - Object to compare to. - `java.lang.Object`

  returns: True if object is equivalent to this pages per
            minute color attribute, false otherwise. - `boolean`"
  (^Boolean [^javax.print.attribute.standard.PagesPerMinuteColor this ^java.lang.Object object]
    (-> this (.equals object))))

(defn get-category
  "Get the printing attribute class which is to be used as the `category`
   for this printing attribute value.

   For class PagesPerMinuteColor, the
   category is class PagesPerMinuteColor itself.

  returns: Printing attribute class (category), an instance of class
            java.lang.Class. - `java.lang.Class<? extends javax.print.attribute.Attribute>`"
  ([^javax.print.attribute.standard.PagesPerMinuteColor this]
    (-> this (.getCategory))))

(defn get-name
  "Get the name of the category of which this attribute value is an
   instance.

   For class PagesPerMinuteColor, the
   category name is `pages-per-minute-color`.

  returns: Attribute category name. - `java.lang.String`"
  (^java.lang.String [^javax.print.attribute.standard.PagesPerMinuteColor this]
    (-> this (.getName))))

