(ns javax.print.attribute.standard.MediaSizeName
  "Class MediaSizeName is a subclass of Media.

  This attribute can be used instead of specifying MediaName or MediaTray.

  Class MediaSizeName currently declares a few standard media
  name values.

  IPP Compatibility: MediaSizeName is a representation class for
  values of the IPP \"media\" attribute which names media sizes.
  The names of the media sizes correspond to those in the IPP 1.1 RFC
  RFC 2911"
  (:refer-clojure :only [require comment defn ->])
  (:import [javax.print.attribute.standard MediaSizeName]))

(def *-iso-a-0
  "Static Constant.

  A0 size.

  type: javax.print.attribute.standard.MediaSizeName"
  MediaSizeName/ISO_A0)

(def *-iso-a-1
  "Static Constant.

  A1 size.

  type: javax.print.attribute.standard.MediaSizeName"
  MediaSizeName/ISO_A1)

(def *-iso-a-2
  "Static Constant.

  A2 size.

  type: javax.print.attribute.standard.MediaSizeName"
  MediaSizeName/ISO_A2)

(def *-iso-a-3
  "Static Constant.

  A3 size.

  type: javax.print.attribute.standard.MediaSizeName"
  MediaSizeName/ISO_A3)

(def *-iso-a-4
  "Static Constant.

  A4 size.

  type: javax.print.attribute.standard.MediaSizeName"
  MediaSizeName/ISO_A4)

(def *-iso-a-5
  "Static Constant.

  A5 size.

  type: javax.print.attribute.standard.MediaSizeName"
  MediaSizeName/ISO_A5)

(def *-iso-a-6
  "Static Constant.

  A6 size.

  type: javax.print.attribute.standard.MediaSizeName"
  MediaSizeName/ISO_A6)

(def *-iso-a-7
  "Static Constant.

  A7 size.

  type: javax.print.attribute.standard.MediaSizeName"
  MediaSizeName/ISO_A7)

(def *-iso-a-8
  "Static Constant.

  A8 size.

  type: javax.print.attribute.standard.MediaSizeName"
  MediaSizeName/ISO_A8)

(def *-iso-a-9
  "Static Constant.

  A9 size.

  type: javax.print.attribute.standard.MediaSizeName"
  MediaSizeName/ISO_A9)

(def *-iso-a-10
  "Static Constant.

  A10 size.

  type: javax.print.attribute.standard.MediaSizeName"
  MediaSizeName/ISO_A10)

(def *-iso-b-0
  "Static Constant.

  ISO B0 size.

  type: javax.print.attribute.standard.MediaSizeName"
  MediaSizeName/ISO_B0)

(def *-iso-b-1
  "Static Constant.

  ISO B1 size.

  type: javax.print.attribute.standard.MediaSizeName"
  MediaSizeName/ISO_B1)

(def *-iso-b-2
  "Static Constant.

  ISO B2 size.

  type: javax.print.attribute.standard.MediaSizeName"
  MediaSizeName/ISO_B2)

(def *-iso-b-3
  "Static Constant.

  ISO B3 size.

  type: javax.print.attribute.standard.MediaSizeName"
  MediaSizeName/ISO_B3)

(def *-iso-b-4
  "Static Constant.

  ISO B4 size.

  type: javax.print.attribute.standard.MediaSizeName"
  MediaSizeName/ISO_B4)

(def *-iso-b-5
  "Static Constant.

  ISO B5 size.

  type: javax.print.attribute.standard.MediaSizeName"
  MediaSizeName/ISO_B5)

(def *-iso-b-6
  "Static Constant.

  ISO B6 size.

  type: javax.print.attribute.standard.MediaSizeName"
  MediaSizeName/ISO_B6)

(def *-iso-b-7
  "Static Constant.

  ISO B7 size.

  type: javax.print.attribute.standard.MediaSizeName"
  MediaSizeName/ISO_B7)

(def *-iso-b-8
  "Static Constant.

  ISO B8 size.

  type: javax.print.attribute.standard.MediaSizeName"
  MediaSizeName/ISO_B8)

(def *-iso-b-9
  "Static Constant.

  ISO B9 size.

  type: javax.print.attribute.standard.MediaSizeName"
  MediaSizeName/ISO_B9)

(def *-iso-b-10
  "Static Constant.

  ISO B10 size.

  type: javax.print.attribute.standard.MediaSizeName"
  MediaSizeName/ISO_B10)

(def *-jis-b-0
  "Static Constant.

  JIS B0 size.

  type: javax.print.attribute.standard.MediaSizeName"
  MediaSizeName/JIS_B0)

(def *-jis-b-1
  "Static Constant.

  JIS B1 size.

  type: javax.print.attribute.standard.MediaSizeName"
  MediaSizeName/JIS_B1)

(def *-jis-b-2
  "Static Constant.

  JIS B2 size.

  type: javax.print.attribute.standard.MediaSizeName"
  MediaSizeName/JIS_B2)

(def *-jis-b-3
  "Static Constant.

  JIS B3 size.

  type: javax.print.attribute.standard.MediaSizeName"
  MediaSizeName/JIS_B3)

(def *-jis-b-4
  "Static Constant.

  JIS B4 size.

  type: javax.print.attribute.standard.MediaSizeName"
  MediaSizeName/JIS_B4)

(def *-jis-b-5
  "Static Constant.

  JIS B5 size.

  type: javax.print.attribute.standard.MediaSizeName"
  MediaSizeName/JIS_B5)

(def *-jis-b-6
  "Static Constant.

  JIS B6 size.

  type: javax.print.attribute.standard.MediaSizeName"
  MediaSizeName/JIS_B6)

(def *-jis-b-7
  "Static Constant.

  JIS B7 size.

  type: javax.print.attribute.standard.MediaSizeName"
  MediaSizeName/JIS_B7)

(def *-jis-b-8
  "Static Constant.

  JIS B8 size.

  type: javax.print.attribute.standard.MediaSizeName"
  MediaSizeName/JIS_B8)

(def *-jis-b-9
  "Static Constant.

  JIS B9 size.

  type: javax.print.attribute.standard.MediaSizeName"
  MediaSizeName/JIS_B9)

(def *-jis-b-10
  "Static Constant.

  JIS B10 size.

  type: javax.print.attribute.standard.MediaSizeName"
  MediaSizeName/JIS_B10)

(def *-iso-c-0
  "Static Constant.

  ISO C0 size.

  type: javax.print.attribute.standard.MediaSizeName"
  MediaSizeName/ISO_C0)

(def *-iso-c-1
  "Static Constant.

  ISO C1 size.

  type: javax.print.attribute.standard.MediaSizeName"
  MediaSizeName/ISO_C1)

(def *-iso-c-2
  "Static Constant.

  ISO C2 size.

  type: javax.print.attribute.standard.MediaSizeName"
  MediaSizeName/ISO_C2)

(def *-iso-c-3
  "Static Constant.

  ISO C3 size.

  type: javax.print.attribute.standard.MediaSizeName"
  MediaSizeName/ISO_C3)

(def *-iso-c-4
  "Static Constant.

  ISO C4 size.

  type: javax.print.attribute.standard.MediaSizeName"
  MediaSizeName/ISO_C4)

(def *-iso-c-5
  "Static Constant.

  ISO C5 size.

  type: javax.print.attribute.standard.MediaSizeName"
  MediaSizeName/ISO_C5)

(def *-iso-c-6
  "Static Constant.

  letter size.

  type: javax.print.attribute.standard.MediaSizeName"
  MediaSizeName/ISO_C6)

(def *-na-letter
  "Static Constant.

  letter size.

  type: javax.print.attribute.standard.MediaSizeName"
  MediaSizeName/NA_LETTER)

(def *-na-legal
  "Static Constant.

  legal size .

  type: javax.print.attribute.standard.MediaSizeName"
  MediaSizeName/NA_LEGAL)

(def *-executive
  "Static Constant.

  executive size .

  type: javax.print.attribute.standard.MediaSizeName"
  MediaSizeName/EXECUTIVE)

(def *-ledger
  "Static Constant.

  ledger size .

  type: javax.print.attribute.standard.MediaSizeName"
  MediaSizeName/LEDGER)

(def *-tabloid
  "Static Constant.

  tabloid size .

  type: javax.print.attribute.standard.MediaSizeName"
  MediaSizeName/TABLOID)

(def *-invoice
  "Static Constant.

  invoice size .

  type: javax.print.attribute.standard.MediaSizeName"
  MediaSizeName/INVOICE)

(def *-folio
  "Static Constant.

  folio size .

  type: javax.print.attribute.standard.MediaSizeName"
  MediaSizeName/FOLIO)

(def *-quarto
  "Static Constant.

  quarto size .

  type: javax.print.attribute.standard.MediaSizeName"
  MediaSizeName/QUARTO)

(def *-japanese-postcard
  "Static Constant.

  Japanese Postcard size.

  type: javax.print.attribute.standard.MediaSizeName"
  MediaSizeName/JAPANESE_POSTCARD)

(def *-japanese-double-postcard
  "Static Constant.

  Japanese Double Postcard size.

  type: javax.print.attribute.standard.MediaSizeName"
  MediaSizeName/JAPANESE_DOUBLE_POSTCARD)

(def *-a
  "Static Constant.

  A size .

  type: javax.print.attribute.standard.MediaSizeName"
  MediaSizeName/A)

(def *-b
  "Static Constant.

  B size .

  type: javax.print.attribute.standard.MediaSizeName"
  MediaSizeName/B)

(def *-c
  "Static Constant.

  C size .

  type: javax.print.attribute.standard.MediaSizeName"
  MediaSizeName/C)

(def *-d
  "Static Constant.

  D size .

  type: javax.print.attribute.standard.MediaSizeName"
  MediaSizeName/D)

(def *-e
  "Static Constant.

  E size .

  type: javax.print.attribute.standard.MediaSizeName"
  MediaSizeName/E)

(def *-iso-designated-long
  "Static Constant.

  ISO designated long size .

  type: javax.print.attribute.standard.MediaSizeName"
  MediaSizeName/ISO_DESIGNATED_LONG)

(def *-italy-envelope
  "Static Constant.

  Italy envelope size .

  type: javax.print.attribute.standard.MediaSizeName"
  MediaSizeName/ITALY_ENVELOPE)

(def *-monarch-envelope
  "Static Constant.

  monarch envelope size .

  type: javax.print.attribute.standard.MediaSizeName"
  MediaSizeName/MONARCH_ENVELOPE)

(def *-personal-envelope
  "Static Constant.

  personal envelope size .

  type: javax.print.attribute.standard.MediaSizeName"
  MediaSizeName/PERSONAL_ENVELOPE)

(def *-na-number-9-envelope
  "Static Constant.

  number 9 envelope size .

  type: javax.print.attribute.standard.MediaSizeName"
  MediaSizeName/NA_NUMBER_9_ENVELOPE)

(def *-na-number-10-envelope
  "Static Constant.

  number 10 envelope size .

  type: javax.print.attribute.standard.MediaSizeName"
  MediaSizeName/NA_NUMBER_10_ENVELOPE)

(def *-na-number-11-envelope
  "Static Constant.

  number 11 envelope size .

  type: javax.print.attribute.standard.MediaSizeName"
  MediaSizeName/NA_NUMBER_11_ENVELOPE)

(def *-na-number-12-envelope
  "Static Constant.

  number 12 envelope size .

  type: javax.print.attribute.standard.MediaSizeName"
  MediaSizeName/NA_NUMBER_12_ENVELOPE)

(def *-na-number-14-envelope
  "Static Constant.

  number 14 envelope size .

  type: javax.print.attribute.standard.MediaSizeName"
  MediaSizeName/NA_NUMBER_14_ENVELOPE)

(def *-na-6-x-9-envelope
  "Static Constant.

  6x9 North American envelope size.

  type: javax.print.attribute.standard.MediaSizeName"
  MediaSizeName/NA_6X9_ENVELOPE)

(def *-na-7-x-9-envelope
  "Static Constant.

  7x9 North American envelope size.

  type: javax.print.attribute.standard.MediaSizeName"
  MediaSizeName/NA_7X9_ENVELOPE)

(def *-na-9-x-11-envelope
  "Static Constant.

  9x11 North American envelope size.

  type: javax.print.attribute.standard.MediaSizeName"
  MediaSizeName/NA_9X11_ENVELOPE)

(def *-na-9-x-12-envelope
  "Static Constant.

  9x12 North American envelope size.

  type: javax.print.attribute.standard.MediaSizeName"
  MediaSizeName/NA_9X12_ENVELOPE)

(def *-na-10-x-13-envelope
  "Static Constant.

  10x13 North American envelope size .

  type: javax.print.attribute.standard.MediaSizeName"
  MediaSizeName/NA_10X13_ENVELOPE)

(def *-na-10-x-14-envelope
  "Static Constant.

  10x14North American  envelope size .

  type: javax.print.attribute.standard.MediaSizeName"
  MediaSizeName/NA_10X14_ENVELOPE)

(def *-na-10-x-15-envelope
  "Static Constant.

  10x15 North American envelope size.

  type: javax.print.attribute.standard.MediaSizeName"
  MediaSizeName/NA_10X15_ENVELOPE)

(def *-na-5-x-7
  "Static Constant.

  5x7 North American paper.

  type: javax.print.attribute.standard.MediaSizeName"
  MediaSizeName/NA_5X7)

(def *-na-8-x-10
  "Static Constant.

  8x10 North American paper.

  type: javax.print.attribute.standard.MediaSizeName"
  MediaSizeName/NA_8X10)

