(ns javax.print.attribute.standard.PagesPerMinute
  "Class PagesPerMinute is an integer valued printing attribute that indicates
  the nominal number of pages per minute to the nearest whole number which may
  be generated by this printer (e.g., simplex, black-and-white). This attribute
  is informative, not a service guarantee. Generally, it is the value used in
  the marketing literature to describe the device. A value of 0 indicates a
  device that takes more than two minutes to process a page.

  IPP Compatibility: The integer value gives the IPP integer value. The
  category name returned by getName() gives the IPP attribute
  name."
  (:refer-clojure :only [require comment defn ->])
  (:import [javax.print.attribute.standard PagesPerMinute]))

(defn ->pages-per-minute
  "Constructor.

  Construct a new pages per minute attribute with the given integer
   value.

  value - Integer value. - `int`

  throws: java.lang.IllegalArgumentException - (Unchecked exception) Thrown if value is less than 0."
  (^PagesPerMinute [^Integer value]
    (new PagesPerMinute value)))

(defn equals
  "Returns whether this pages per minute attribute is equivalent to the
   passed in object. To be equivalent, all of the following conditions
   must be true:


   object is not null.

   object is an instance of class PagesPerMinute.

   This pages per minute attribute's value and object's
   value are equal.

  object - Object to compare to. - `java.lang.Object`

  returns: True if object is equivalent to this pages per
            minute attribute, false otherwise. - `boolean`"
  (^Boolean [^PagesPerMinute this ^java.lang.Object object]
    (-> this (.equals object))))

(defn get-category
  "Get the printing attribute class which is to be used as the \"category\"
   for this printing attribute value.

   For class PagesPerMinute, the category is class PagesPerMinute itself.

  returns: Printing attribute class (category), an instance of class
            java.lang.Class. - `java.lang.Class<? extends javax.print.attribute.Attribute>`"
  ([^PagesPerMinute this]
    (-> this (.getCategory))))

(defn get-name
  "Get the name of the category of which this attribute value is an
   instance.

   For class PagesPerMinute, the
   category name is \"pages-per-minute\".

  returns: Attribute category name. - `java.lang.String`"
  (^java.lang.String [^PagesPerMinute this]
    (-> this (.getName))))

