(ns javax.sound.sampled.LineEvent
  "The LineEvent class encapsulates information that a line
  sends its listeners whenever the line opens, closes, starts, or stops.
  Each of these four state changes is represented by a corresponding
  type of event.  A listener receives the event as a parameter to its
  update method.  By querying the event,
  the listener can learn the type of event, the line responsible for
  the event, and how much data the line had processed when the event occurred.

  Although this class implements Serializable, attempts to
  serialize a LineEvent object will fail."
  (:refer-clojure :only [require comment defn ->])
  (:import [javax.sound.sampled LineEvent]))

(defn ->line-event
  "Constructor.

  Constructs a new event of the specified type, originating from the specified line.

  line - the source of this event - `javax.sound.sampled.Line`
  type - the event type (OPEN, CLOSE, START, or STOP) - `javax.sound.sampled.LineEvent.Type`
  position - the number of sample frames that the line had already processed when the event occurred, or AudioSystem.NOT_SPECIFIED - `long`

  throws: java.lang.IllegalArgumentException - if line is null."
  ([^javax.sound.sampled.Line line ^javax.sound.sampled.LineEvent.Type type ^Long position]
    (new LineEvent line type position)))

(defn get-line
  "Obtains the audio line that is the source of this event.

  returns: the line responsible for this event - `javax.sound.sampled.Line`"
  ([^javax.sound.sampled.LineEvent this]
    (-> this (.getLine))))

(defn get-type
  "Obtains the event's type.

  returns: this event's type (LineEvent.Type.OPEN, LineEvent.Type.CLOSE,
   LineEvent.Type.START, or LineEvent.Type.STOP) - `javax.sound.sampled.LineEvent.Type`"
  ([^javax.sound.sampled.LineEvent this]
    (-> this (.getType))))

(defn get-frame-position
  "Obtains the position in the line's audio data when the event occurred, expressed in sample frames.
   For example, if a source line had already played back 14 sample frames at the time it was
   paused, the pause event would report the line's position as 14.  The next frame to be processed
   would be frame number 14 using zero-based numbering, or 15 using one-based numbering.

   Note that this field is relevant only to certain events generated by
   data lines, such as START and STOP.  For
   events generated by lines that do not count sample frames, and for any
   other events for which this value is not known, the position value
   should be AudioSystem.NOT_SPECIFIED.

  returns: the line's position as a sample frame number - `long`"
  ([^javax.sound.sampled.LineEvent this]
    (-> this (.getFramePosition))))

(defn to-string
  "Obtains a string representation of the event.  The contents of the string may vary
   between implementations of Java Sound.

  returns: a string describing the event. - `java.lang.String`"
  ([^javax.sound.sampled.LineEvent this]
    (-> this (.toString))))

