(ns javax.sql.ConnectionEventListener
  " An object that registers to be notified of events generated by a
  PooledConnection object.

  The ConnectionEventListener interface is implemented by a
  connection pooling component.  A connection pooling component will
  usually be provided by a JDBC driver vendor or another system software
  vendor.  A JDBC driver notifies a ConnectionEventListener
  object when an application is finished using a pooled connection with
  which the listener has registered.  The notification
  occurs after the application calls the method close on
  its representation of a PooledConnection object.  A
  ConnectionEventListener is also notified when a
  connection error occurs due to the fact that the PooledConnection
  is unfit for future use---the server has crashed, for example.
  The listener is notified by the JDBC driver just before the driver throws an
  SQLException to the application using the
  PooledConnection object."
  (:refer-clojure :only [require comment defn ->])
  (:import [javax.sql ConnectionEventListener]))

(defn connection-closed
  "Notifies this ConnectionEventListener that
   the application has called the method close on its
   representation of a pooled connection.

  event - an event object describing the source of the event - `javax.sql.ConnectionEvent`"
  ([this event]
    (-> this (.connectionClosed event))))

(defn connection-error-occurred
  "Notifies this ConnectionEventListener that
   a fatal error has occurred and the pooled connection can
   no longer be used.  The driver makes this notification just
   before it throws the application the SQLException
   contained in the given ConnectionEvent object.

  event - an event object describing the source of the event and containing the SQLException that the driver is about to throw - `javax.sql.ConnectionEvent`"
  ([this event]
    (-> this (.connectionErrorOccurred event))))

