# Bindings for javax.swing

These bindings are created to simplify interaction with java classes from clojure.
For each java class was created a separate namespace.
Each method/field has its own function/field binding.
Their names are changed for a more native look in the clojure code. Each function has docstring - information about the parameters, return value and possible exceptions.

## Note

All namespaces starting with **java.** are renamed to **jdk.** (java compiler limitation). 

**java.io.File** renamed to **jdk.io.File** for example. 




## Clojars

```
[clojure-interop/javax.swing "1.0.3"]
```

## Class Members Naming Conventions

| Class Member | Java | Clojure |
|:--|:--|:--|
| constructor | new File() | (->file) |
| instance method | getAnyValue() | (get-any-value) |
| instance field | instanceField | -instance-field |
| static method | staticMethod() | (*static-method) |
| static field | ANY_STATIC_FIELD | *-any-static-field |
| boolean field/method | isExists(), canUse() | (exists?), (can-use?) |

## Classes

- class **javax.swing.AbstractAction**
- class **javax.swing.AbstractButton**
- class **javax.swing.AbstractCellEditor**
- class **javax.swing.AbstractListModel**
- class **javax.swing.AbstractSpinnerModel**
- interface **javax.swing.Action**
- class **javax.swing.ActionMap**
- class **javax.swing.BorderFactory**
- interface **javax.swing.BoundedRangeModel**
- class **javax.swing.Box$Filler**
- class **javax.swing.Box**
- class **javax.swing.BoxLayout**
- class **javax.swing.ButtonGroup**
- interface **javax.swing.ButtonModel**
- interface **javax.swing.CellEditor**
- class **javax.swing.CellRendererPane**
- interface **javax.swing.ComboBoxEditor**
- interface **javax.swing.ComboBoxModel**
- class **javax.swing.ComponentInputMap**
- class **javax.swing.DebugGraphics**
- class **javax.swing.DefaultBoundedRangeModel**
- class **javax.swing.DefaultButtonModel**
- class **javax.swing.DefaultCellEditor**
- class **javax.swing.DefaultComboBoxModel**
- class **javax.swing.DefaultDesktopManager**
- class **javax.swing.DefaultFocusManager**
- class **javax.swing.DefaultListCellRenderer$UIResource**
- class **javax.swing.DefaultListCellRenderer**
- class **javax.swing.DefaultListModel**
- class **javax.swing.DefaultListSelectionModel**
- class **javax.swing.DefaultRowSorter$ModelWrapper**
- class **javax.swing.DefaultRowSorter**
- class **javax.swing.DefaultSingleSelectionModel**
- interface **javax.swing.DesktopManager**
- enum **javax.swing.DropMode**
- class **javax.swing.FocusManager**
- class **javax.swing.GrayFilter**
- enum **javax.swing.GroupLayout$Alignment**
- class **javax.swing.GroupLayout**
- interface **javax.swing.Icon**
- class **javax.swing.ImageIcon**
- class **javax.swing.InputMap**
- class **javax.swing.InputVerifier**
- class **javax.swing.InternalFrameFocusTraversalPolicy**
- class **javax.swing.JApplet**
- class **javax.swing.JButton**
- class **javax.swing.JCheckBox**
- class **javax.swing.JCheckBoxMenuItem**
- class **javax.swing.JColorChooser**
- interface **javax.swing.JComboBox$KeySelectionManager**
- class **javax.swing.JComboBox**
- class **javax.swing.JComponent**
- class **javax.swing.JDesktopPane**
- class **javax.swing.JDialog**
- class **javax.swing.JEditorPane**
- class **javax.swing.JFileChooser**
- class **javax.swing.JFormattedTextField$AbstractFormatter**
- class **javax.swing.JFormattedTextField$AbstractFormatterFactory**
- class **javax.swing.JFormattedTextField**
- class **javax.swing.JFrame**
- class **javax.swing.JInternalFrame$JDesktopIcon**
- class **javax.swing.JInternalFrame**
- class **javax.swing.JLabel**
- class **javax.swing.JLayer**
- class **javax.swing.JLayeredPane**
- class **javax.swing.JList$DropLocation**
- class **javax.swing.JList**
- class **javax.swing.JMenu**
- class **javax.swing.JMenuBar**
- class **javax.swing.JMenuItem**
- class **javax.swing.JOptionPane**
- class **javax.swing.JPanel**
- class **javax.swing.JPasswordField**
- class **javax.swing.JPopupMenu$Separator**
- class **javax.swing.JPopupMenu**
- class **javax.swing.JProgressBar**
- class **javax.swing.JRadioButton**
- class **javax.swing.JRadioButtonMenuItem**
- class **javax.swing.JRootPane**
- class **javax.swing.JScrollBar**
- class **javax.swing.JScrollPane**
- class **javax.swing.JSeparator**
- class **javax.swing.JSlider**
- class **javax.swing.JSpinner$DateEditor**
- class **javax.swing.JSpinner$DefaultEditor**
- class **javax.swing.JSpinner$ListEditor**
- class **javax.swing.JSpinner$NumberEditor**
- class **javax.swing.JSpinner**
- class **javax.swing.JSplitPane**
- class **javax.swing.JTabbedPane**
- class **javax.swing.JTable$DropLocation**
- enum **javax.swing.JTable$PrintMode**
- class **javax.swing.JTable**
- class **javax.swing.JTextArea**
- class **javax.swing.JTextField**
- class **javax.swing.JTextPane**
- class **javax.swing.JToggleButton$ToggleButtonModel**
- class **javax.swing.JToggleButton**
- class **javax.swing.JToolBar$Separator**
- class **javax.swing.JToolBar**
- class **javax.swing.JToolTip**
- class **javax.swing.JTree$DropLocation**
- class **javax.swing.JTree$DynamicUtilTreeNode**
- class **javax.swing.JTree$EmptySelectionModel**
- class **javax.swing.JTree**
- class **javax.swing.JViewport**
- class **javax.swing.JWindow**
- class **javax.swing.KeyStroke**
- class **javax.swing.LayoutFocusTraversalPolicy**
- enum **javax.swing.LayoutStyle$ComponentPlacement**
- class **javax.swing.LayoutStyle**
- interface **javax.swing.ListCellRenderer**
- interface **javax.swing.ListModel**
- interface **javax.swing.ListSelectionModel**
- class **javax.swing.LookAndFeel**
- interface **javax.swing.MenuElement**
- class **javax.swing.MenuSelectionManager**
- interface **javax.swing.MutableComboBoxModel**
- class **javax.swing.OverlayLayout**
- interface **javax.swing.Painter**
- class **javax.swing.Popup**
- class **javax.swing.PopupFactory**
- class **javax.swing.ProgressMonitor**
- class **javax.swing.ProgressMonitorInputStream**
- interface **javax.swing.Renderer**
- class **javax.swing.RepaintManager**
- interface **javax.swing.RootPaneContainer**
- enum **javax.swing.RowFilter$ComparisonType**
- class **javax.swing.RowFilter$Entry**
- class **javax.swing.RowFilter**
- class **javax.swing.RowSorter$SortKey**
- class **javax.swing.RowSorter**
- interface **javax.swing.ScrollPaneConstants**
- class **javax.swing.ScrollPaneLayout$UIResource**
- class **javax.swing.ScrollPaneLayout**
- interface **javax.swing.Scrollable**
- interface **javax.swing.SingleSelectionModel**
- class **javax.swing.SizeRequirements**
- class **javax.swing.SizeSequence**
- enum **javax.swing.SortOrder**
- class **javax.swing.SortingFocusTraversalPolicy**
- class **javax.swing.SpinnerDateModel**
- class **javax.swing.SpinnerListModel**
- interface **javax.swing.SpinnerModel**
- class **javax.swing.SpinnerNumberModel**
- class **javax.swing.Spring**
- class **javax.swing.SpringLayout$Constraints**
- class **javax.swing.SpringLayout**
- interface **javax.swing.SwingConstants**
- class **javax.swing.SwingUtilities**
- enum **javax.swing.SwingWorker$StateValue**
- class **javax.swing.SwingWorker**
- class **javax.swing.Timer**
- class **javax.swing.ToolTipManager**
- class **javax.swing.TransferHandler$DropLocation**
- class **javax.swing.TransferHandler$TransferSupport**
- class **javax.swing.TransferHandler**
- interface **javax.swing.UIDefaults$ActiveValue**
- class **javax.swing.UIDefaults$LazyInputMap**
- interface **javax.swing.UIDefaults$LazyValue**
- class **javax.swing.UIDefaults$ProxyLazyValue**
- class **javax.swing.UIDefaults**
- class **javax.swing.UIManager$LookAndFeelInfo**
- class **javax.swing.UIManager**
- class **javax.swing.UnsupportedLookAndFeelException**
- class **javax.swing.ViewportLayout**
- interface **javax.swing.WindowConstants**
- class **javax.swing.border.AbstractBorder**
- class **javax.swing.border.BevelBorder**
- interface **javax.swing.border.Border**
- class **javax.swing.border.CompoundBorder**
- class **javax.swing.border.EmptyBorder**
- class **javax.swing.border.EtchedBorder**
- class **javax.swing.border.LineBorder**
- class **javax.swing.border.MatteBorder**
- class **javax.swing.border.SoftBevelBorder**
- class **javax.swing.border.StrokeBorder**
- class **javax.swing.border.TitledBorder**
- class **javax.swing.colorchooser.AbstractColorChooserPanel**
- class **javax.swing.colorchooser.ColorChooserComponentFactory**
- interface **javax.swing.colorchooser.ColorSelectionModel**
- class **javax.swing.colorchooser.DefaultColorSelectionModel**
- class **javax.swing.event.AncestorEvent**
- interface **javax.swing.event.AncestorListener**
- class **javax.swing.event.CaretEvent**
- interface **javax.swing.event.CaretListener**
- interface **javax.swing.event.CellEditorListener**
- class **javax.swing.event.ChangeEvent**
- interface **javax.swing.event.ChangeListener**
- interface **javax.swing.event.DocumentEvent$ElementChange**
- class **javax.swing.event.DocumentEvent$EventType**
- interface **javax.swing.event.DocumentEvent**
- interface **javax.swing.event.DocumentListener**
- class **javax.swing.event.EventListenerList**
- class **javax.swing.event.HyperlinkEvent$EventType**
- class **javax.swing.event.HyperlinkEvent**
- interface **javax.swing.event.HyperlinkListener**
- class **javax.swing.event.InternalFrameAdapter**
- class **javax.swing.event.InternalFrameEvent**
- interface **javax.swing.event.InternalFrameListener**
- class **javax.swing.event.ListDataEvent**
- interface **javax.swing.event.ListDataListener**
- class **javax.swing.event.ListSelectionEvent**
- interface **javax.swing.event.ListSelectionListener**
- class **javax.swing.event.MenuDragMouseEvent**
- interface **javax.swing.event.MenuDragMouseListener**
- class **javax.swing.event.MenuEvent**
- class **javax.swing.event.MenuKeyEvent**
- interface **javax.swing.event.MenuKeyListener**
- interface **javax.swing.event.MenuListener**
- class **javax.swing.event.MouseInputAdapter**
- interface **javax.swing.event.MouseInputListener**
- class **javax.swing.event.PopupMenuEvent**
- interface **javax.swing.event.PopupMenuListener**
- enum **javax.swing.event.RowSorterEvent$Type**
- class **javax.swing.event.RowSorterEvent**
- interface **javax.swing.event.RowSorterListener**
- class **javax.swing.event.SwingPropertyChangeSupport**
- class **javax.swing.event.TableColumnModelEvent**
- interface **javax.swing.event.TableColumnModelListener**
- class **javax.swing.event.TableModelEvent**
- interface **javax.swing.event.TableModelListener**
- class **javax.swing.event.TreeExpansionEvent**
- interface **javax.swing.event.TreeExpansionListener**
- class **javax.swing.event.TreeModelEvent**
- interface **javax.swing.event.TreeModelListener**
- class **javax.swing.event.TreeSelectionEvent**
- interface **javax.swing.event.TreeSelectionListener**
- interface **javax.swing.event.TreeWillExpandListener**
- class **javax.swing.event.UndoableEditEvent**
- interface **javax.swing.event.UndoableEditListener**
- class **javax.swing.filechooser.FileFilter**
- class **javax.swing.filechooser.FileNameExtensionFilter**
- class **javax.swing.filechooser.FileSystemView**
- class **javax.swing.filechooser.FileView**
- class **javax.swing.plaf.ActionMapUIResource**
- class **javax.swing.plaf.BorderUIResource$BevelBorderUIResource**
- class **javax.swing.plaf.BorderUIResource$CompoundBorderUIResource**
- class **javax.swing.plaf.BorderUIResource$EmptyBorderUIResource**
- class **javax.swing.plaf.BorderUIResource$EtchedBorderUIResource**
- class **javax.swing.plaf.BorderUIResource$LineBorderUIResource**
- class **javax.swing.plaf.BorderUIResource$MatteBorderUIResource**
- class **javax.swing.plaf.BorderUIResource$TitledBorderUIResource**
- class **javax.swing.plaf.BorderUIResource**
- class **javax.swing.plaf.ButtonUI**
- class **javax.swing.plaf.ColorChooserUI**
- class **javax.swing.plaf.ColorUIResource**
- class **javax.swing.plaf.ComboBoxUI**
- class **javax.swing.plaf.ComponentInputMapUIResource**
- class **javax.swing.plaf.ComponentUI**
- class **javax.swing.plaf.DesktopIconUI**
- class **javax.swing.plaf.DesktopPaneUI**
- class **javax.swing.plaf.DimensionUIResource**
- class **javax.swing.plaf.FileChooserUI**
- class **javax.swing.plaf.FontUIResource**
- class **javax.swing.plaf.IconUIResource**
- class **javax.swing.plaf.InputMapUIResource**
- class **javax.swing.plaf.InsetsUIResource**
- class **javax.swing.plaf.InternalFrameUI**
- class **javax.swing.plaf.LabelUI**
- class **javax.swing.plaf.LayerUI**
- class **javax.swing.plaf.ListUI**
- class **javax.swing.plaf.MenuBarUI**
- class **javax.swing.plaf.MenuItemUI**
- class **javax.swing.plaf.OptionPaneUI**
- class **javax.swing.plaf.PanelUI**
- class **javax.swing.plaf.PopupMenuUI**
- class **javax.swing.plaf.ProgressBarUI**
- class **javax.swing.plaf.RootPaneUI**
- class **javax.swing.plaf.ScrollBarUI**
- class **javax.swing.plaf.ScrollPaneUI**
- class **javax.swing.plaf.SeparatorUI**
- class **javax.swing.plaf.SliderUI**
- class **javax.swing.plaf.SpinnerUI**
- class **javax.swing.plaf.SplitPaneUI**
- class **javax.swing.plaf.TabbedPaneUI**
- class **javax.swing.plaf.TableHeaderUI**
- class **javax.swing.plaf.TableUI**
- class **javax.swing.plaf.TextUI**
- class **javax.swing.plaf.ToolBarUI**
- class **javax.swing.plaf.ToolTipUI**
- class **javax.swing.plaf.TreeUI**
- interface **javax.swing.plaf.UIResource**
- class **javax.swing.plaf.ViewportUI**
- class **javax.swing.plaf.basic.BasicArrowButton**
- class **javax.swing.plaf.basic.BasicBorders$ButtonBorder**
- class **javax.swing.plaf.basic.BasicBorders$FieldBorder**
- class **javax.swing.plaf.basic.BasicBorders$MarginBorder**
- class **javax.swing.plaf.basic.BasicBorders$MenuBarBorder**
- class **javax.swing.plaf.basic.BasicBorders$RadioButtonBorder**
- class **javax.swing.plaf.basic.BasicBorders$RolloverButtonBorder**
- class **javax.swing.plaf.basic.BasicBorders$SplitPaneBorder**
- class **javax.swing.plaf.basic.BasicBorders$ToggleButtonBorder**
- class **javax.swing.plaf.basic.BasicBorders**
- class **javax.swing.plaf.basic.BasicButtonListener**
- class **javax.swing.plaf.basic.BasicButtonUI**
- class **javax.swing.plaf.basic.BasicCheckBoxMenuItemUI**
- class **javax.swing.plaf.basic.BasicCheckBoxUI**
- class **javax.swing.plaf.basic.BasicColorChooserUI**
- class **javax.swing.plaf.basic.BasicComboBoxEditor$UIResource**
- class **javax.swing.plaf.basic.BasicComboBoxEditor**
- class **javax.swing.plaf.basic.BasicComboBoxRenderer$UIResource**
- class **javax.swing.plaf.basic.BasicComboBoxRenderer**
- class **javax.swing.plaf.basic.BasicComboBoxUI**
- class **javax.swing.plaf.basic.BasicComboPopup**
- class **javax.swing.plaf.basic.BasicDesktopIconUI**
- class **javax.swing.plaf.basic.BasicDesktopPaneUI**
- class **javax.swing.plaf.basic.BasicDirectoryModel**
- class **javax.swing.plaf.basic.BasicEditorPaneUI**
- class **javax.swing.plaf.basic.BasicFileChooserUI**
- class **javax.swing.plaf.basic.BasicFormattedTextFieldUI**
- class **javax.swing.plaf.basic.BasicGraphicsUtils**
- class **javax.swing.plaf.basic.BasicHTML**
- class **javax.swing.plaf.basic.BasicIconFactory**
- class **javax.swing.plaf.basic.BasicInternalFrameTitlePane**
- class **javax.swing.plaf.basic.BasicInternalFrameUI**
- class **javax.swing.plaf.basic.BasicLabelUI**
- class **javax.swing.plaf.basic.BasicListUI**
- class **javax.swing.plaf.basic.BasicLookAndFeel**
- class **javax.swing.plaf.basic.BasicMenuBarUI**
- class **javax.swing.plaf.basic.BasicMenuItemUI**
- class **javax.swing.plaf.basic.BasicMenuUI**
- class **javax.swing.plaf.basic.BasicOptionPaneUI$ButtonAreaLayout**
- class **javax.swing.plaf.basic.BasicOptionPaneUI**
- class **javax.swing.plaf.basic.BasicPanelUI**
- class **javax.swing.plaf.basic.BasicPasswordFieldUI**
- class **javax.swing.plaf.basic.BasicPopupMenuSeparatorUI**
- class **javax.swing.plaf.basic.BasicPopupMenuUI**
- class **javax.swing.plaf.basic.BasicProgressBarUI**
- class **javax.swing.plaf.basic.BasicRadioButtonMenuItemUI**
- class **javax.swing.plaf.basic.BasicRadioButtonUI**
- class **javax.swing.plaf.basic.BasicRootPaneUI**
- class **javax.swing.plaf.basic.BasicScrollBarUI**
- class **javax.swing.plaf.basic.BasicScrollPaneUI**
- class **javax.swing.plaf.basic.BasicSeparatorUI**
- class **javax.swing.plaf.basic.BasicSliderUI**
- class **javax.swing.plaf.basic.BasicSpinnerUI**
- class **javax.swing.plaf.basic.BasicSplitPaneDivider**
- class **javax.swing.plaf.basic.BasicSplitPaneUI**
- class **javax.swing.plaf.basic.BasicTabbedPaneUI**
- class **javax.swing.plaf.basic.BasicTableHeaderUI**
- class **javax.swing.plaf.basic.BasicTableUI**
- class **javax.swing.plaf.basic.BasicTextAreaUI**
- class **javax.swing.plaf.basic.BasicTextFieldUI**
- class **javax.swing.plaf.basic.BasicTextPaneUI**
- class **javax.swing.plaf.basic.BasicTextUI$BasicCaret**
- class **javax.swing.plaf.basic.BasicTextUI$BasicHighlighter**
- class **javax.swing.plaf.basic.BasicTextUI**
- class **javax.swing.plaf.basic.BasicToggleButtonUI**
- class **javax.swing.plaf.basic.BasicToolBarSeparatorUI**
- class **javax.swing.plaf.basic.BasicToolBarUI**
- class **javax.swing.plaf.basic.BasicToolTipUI**
- class **javax.swing.plaf.basic.BasicTreeUI**
- class **javax.swing.plaf.basic.BasicViewportUI**
- interface **javax.swing.plaf.basic.ComboPopup**
- class **javax.swing.plaf.basic.DefaultMenuLayout**
- class **javax.swing.plaf.metal.DefaultMetalTheme**
- class **javax.swing.plaf.metal.MetalBorders$ButtonBorder**
- class **javax.swing.plaf.metal.MetalBorders$Flush3DBorder**
- class **javax.swing.plaf.metal.MetalBorders$InternalFrameBorder**
- class **javax.swing.plaf.metal.MetalBorders$MenuBarBorder**
- class **javax.swing.plaf.metal.MetalBorders$MenuItemBorder**
- class **javax.swing.plaf.metal.MetalBorders$OptionDialogBorder**
- class **javax.swing.plaf.metal.MetalBorders$PaletteBorder**
- class **javax.swing.plaf.metal.MetalBorders$PopupMenuBorder**
- class **javax.swing.plaf.metal.MetalBorders$RolloverButtonBorder**
- class **javax.swing.plaf.metal.MetalBorders$ScrollPaneBorder**
- class **javax.swing.plaf.metal.MetalBorders$TableHeaderBorder**
- class **javax.swing.plaf.metal.MetalBorders$TextFieldBorder**
- class **javax.swing.plaf.metal.MetalBorders$ToggleButtonBorder**
- class **javax.swing.plaf.metal.MetalBorders$ToolBarBorder**
- class **javax.swing.plaf.metal.MetalBorders**
- class **javax.swing.plaf.metal.MetalButtonUI**
- class **javax.swing.plaf.metal.MetalCheckBoxIcon**
- class **javax.swing.plaf.metal.MetalCheckBoxUI**
- class **javax.swing.plaf.metal.MetalComboBoxButton**
- class **javax.swing.plaf.metal.MetalComboBoxEditor$UIResource**
- class **javax.swing.plaf.metal.MetalComboBoxEditor**
- class **javax.swing.plaf.metal.MetalComboBoxIcon**
- class **javax.swing.plaf.metal.MetalComboBoxUI**
- class **javax.swing.plaf.metal.MetalDesktopIconUI**
- class **javax.swing.plaf.metal.MetalFileChooserUI**
- class **javax.swing.plaf.metal.MetalIconFactory$FileIcon16**
- class **javax.swing.plaf.metal.MetalIconFactory$FolderIcon16**
- class **javax.swing.plaf.metal.MetalIconFactory$PaletteCloseIcon**
- class **javax.swing.plaf.metal.MetalIconFactory$TreeControlIcon**
- class **javax.swing.plaf.metal.MetalIconFactory$TreeFolderIcon**
- class **javax.swing.plaf.metal.MetalIconFactory$TreeLeafIcon**
- class **javax.swing.plaf.metal.MetalIconFactory**
- class **javax.swing.plaf.metal.MetalInternalFrameTitlePane**
- class **javax.swing.plaf.metal.MetalInternalFrameUI**
- class **javax.swing.plaf.metal.MetalLabelUI**
- class **javax.swing.plaf.metal.MetalLookAndFeel**
- class **javax.swing.plaf.metal.MetalMenuBarUI**
- class **javax.swing.plaf.metal.MetalPopupMenuSeparatorUI**
- class **javax.swing.plaf.metal.MetalProgressBarUI**
- class **javax.swing.plaf.metal.MetalRadioButtonUI**
- class **javax.swing.plaf.metal.MetalRootPaneUI**
- class **javax.swing.plaf.metal.MetalScrollBarUI**
- class **javax.swing.plaf.metal.MetalScrollButton**
- class **javax.swing.plaf.metal.MetalScrollPaneUI**
- class **javax.swing.plaf.metal.MetalSeparatorUI**
- class **javax.swing.plaf.metal.MetalSliderUI**
- class **javax.swing.plaf.metal.MetalSplitPaneUI**
- class **javax.swing.plaf.metal.MetalTabbedPaneUI**
- class **javax.swing.plaf.metal.MetalTextFieldUI**
- class **javax.swing.plaf.metal.MetalTheme**
- class **javax.swing.plaf.metal.MetalToggleButtonUI**
- class **javax.swing.plaf.metal.MetalToolBarUI**
- class **javax.swing.plaf.metal.MetalToolTipUI**
- class **javax.swing.plaf.metal.MetalTreeUI**
- class **javax.swing.plaf.metal.OceanTheme**
- class **javax.swing.plaf.multi.MultiButtonUI**
- class **javax.swing.plaf.multi.MultiColorChooserUI**
- class **javax.swing.plaf.multi.MultiComboBoxUI**
- class **javax.swing.plaf.multi.MultiDesktopIconUI**
- class **javax.swing.plaf.multi.MultiDesktopPaneUI**
- class **javax.swing.plaf.multi.MultiFileChooserUI**
- class **javax.swing.plaf.multi.MultiInternalFrameUI**
- class **javax.swing.plaf.multi.MultiLabelUI**
- class **javax.swing.plaf.multi.MultiListUI**
- class **javax.swing.plaf.multi.MultiLookAndFeel**
- class **javax.swing.plaf.multi.MultiMenuBarUI**
- class **javax.swing.plaf.multi.MultiMenuItemUI**
- class **javax.swing.plaf.multi.MultiOptionPaneUI**
- class **javax.swing.plaf.multi.MultiPanelUI**
- class **javax.swing.plaf.multi.MultiPopupMenuUI**
- class **javax.swing.plaf.multi.MultiProgressBarUI**
- class **javax.swing.plaf.multi.MultiRootPaneUI**
- class **javax.swing.plaf.multi.MultiScrollBarUI**
- class **javax.swing.plaf.multi.MultiScrollPaneUI**
- class **javax.swing.plaf.multi.MultiSeparatorUI**
- class **javax.swing.plaf.multi.MultiSliderUI**
- class **javax.swing.plaf.multi.MultiSpinnerUI**
- class **javax.swing.plaf.multi.MultiSplitPaneUI**
- class **javax.swing.plaf.multi.MultiTabbedPaneUI**
- class **javax.swing.plaf.multi.MultiTableHeaderUI**
- class **javax.swing.plaf.multi.MultiTableUI**
- class **javax.swing.plaf.multi.MultiTextUI**
- class **javax.swing.plaf.multi.MultiToolBarUI**
- class **javax.swing.plaf.multi.MultiToolTipUI**
- class **javax.swing.plaf.multi.MultiTreeUI**
- class **javax.swing.plaf.multi.MultiViewportUI**
- enum **javax.swing.plaf.nimbus.AbstractRegionPainter$PaintContext$CacheMode**
- class **javax.swing.plaf.nimbus.AbstractRegionPainter$PaintContext**
- class **javax.swing.plaf.nimbus.AbstractRegionPainter**
- class **javax.swing.plaf.nimbus.NimbusLookAndFeel**
- class **javax.swing.plaf.nimbus.NimbusStyle**
- class **javax.swing.plaf.nimbus.State**
- class **javax.swing.plaf.synth.ColorType**
- class **javax.swing.plaf.synth.Region**
- class **javax.swing.plaf.synth.SynthButtonUI**
- class **javax.swing.plaf.synth.SynthCheckBoxMenuItemUI**
- class **javax.swing.plaf.synth.SynthCheckBoxUI**
- class **javax.swing.plaf.synth.SynthColorChooserUI**
- class **javax.swing.plaf.synth.SynthComboBoxUI**
- interface **javax.swing.plaf.synth.SynthConstants**
- class **javax.swing.plaf.synth.SynthContext**
- class **javax.swing.plaf.synth.SynthDesktopIconUI**
- class **javax.swing.plaf.synth.SynthDesktopPaneUI**
- class **javax.swing.plaf.synth.SynthEditorPaneUI**
- class **javax.swing.plaf.synth.SynthFormattedTextFieldUI**
- class **javax.swing.plaf.synth.SynthGraphicsUtils**
- class **javax.swing.plaf.synth.SynthInternalFrameUI**
- class **javax.swing.plaf.synth.SynthLabelUI**
- class **javax.swing.plaf.synth.SynthListUI**
- class **javax.swing.plaf.synth.SynthLookAndFeel**
- class **javax.swing.plaf.synth.SynthMenuBarUI**
- class **javax.swing.plaf.synth.SynthMenuItemUI**
- class **javax.swing.plaf.synth.SynthMenuUI**
- class **javax.swing.plaf.synth.SynthOptionPaneUI**
- class **javax.swing.plaf.synth.SynthPainter**
- class **javax.swing.plaf.synth.SynthPanelUI**
- class **javax.swing.plaf.synth.SynthPasswordFieldUI**
- class **javax.swing.plaf.synth.SynthPopupMenuUI**
- class **javax.swing.plaf.synth.SynthProgressBarUI**
- class **javax.swing.plaf.synth.SynthRadioButtonMenuItemUI**
- class **javax.swing.plaf.synth.SynthRadioButtonUI**
- class **javax.swing.plaf.synth.SynthRootPaneUI**
- class **javax.swing.plaf.synth.SynthScrollBarUI**
- class **javax.swing.plaf.synth.SynthScrollPaneUI**
- class **javax.swing.plaf.synth.SynthSeparatorUI**
- class **javax.swing.plaf.synth.SynthSliderUI**
- class **javax.swing.plaf.synth.SynthSpinnerUI**
- class **javax.swing.plaf.synth.SynthSplitPaneUI**
- class **javax.swing.plaf.synth.SynthStyle**
- class **javax.swing.plaf.synth.SynthStyleFactory**
- class **javax.swing.plaf.synth.SynthTabbedPaneUI**
- class **javax.swing.plaf.synth.SynthTableHeaderUI**
- class **javax.swing.plaf.synth.SynthTableUI**
- class **javax.swing.plaf.synth.SynthTextAreaUI**
- class **javax.swing.plaf.synth.SynthTextFieldUI**
- class **javax.swing.plaf.synth.SynthTextPaneUI**
- class **javax.swing.plaf.synth.SynthToggleButtonUI**
- class **javax.swing.plaf.synth.SynthToolBarUI**
- class **javax.swing.plaf.synth.SynthToolTipUI**
- class **javax.swing.plaf.synth.SynthTreeUI**
- interface **javax.swing.plaf.synth.SynthUI**
- class **javax.swing.plaf.synth.SynthViewportUI**
- class **javax.swing.table.AbstractTableModel**
- class **javax.swing.table.DefaultTableCellRenderer$UIResource**
- class **javax.swing.table.DefaultTableCellRenderer**
- class **javax.swing.table.DefaultTableColumnModel**
- class **javax.swing.table.DefaultTableModel**
- class **javax.swing.table.JTableHeader**
- interface **javax.swing.table.TableCellEditor**
- interface **javax.swing.table.TableCellRenderer**
- class **javax.swing.table.TableColumn**
- interface **javax.swing.table.TableColumnModel**
- interface **javax.swing.table.TableModel**
- class **javax.swing.table.TableRowSorter**
- class **javax.swing.table.TableStringConverter**
- interface **javax.swing.text.AbstractDocument$AttributeContext**
- interface **javax.swing.text.AbstractDocument$Content**
- class **javax.swing.text.AbstractDocument$ElementEdit**
- class **javax.swing.text.AbstractDocument**
- class **javax.swing.text.AbstractWriter**
- class **javax.swing.text.AsyncBoxView**
- interface **javax.swing.text.AttributeSet$CharacterAttribute**
- interface **javax.swing.text.AttributeSet$ColorAttribute**
- interface **javax.swing.text.AttributeSet$FontAttribute**
- interface **javax.swing.text.AttributeSet$ParagraphAttribute**
- interface **javax.swing.text.AttributeSet**
- class **javax.swing.text.BadLocationException**
- class **javax.swing.text.BoxView**
- interface **javax.swing.text.Caret**
- class **javax.swing.text.ChangedCharSetException**
- class **javax.swing.text.ComponentView**
- class **javax.swing.text.CompositeView**
- class **javax.swing.text.DateFormatter**
- class **javax.swing.text.DefaultCaret**
- class **javax.swing.text.DefaultEditorKit$BeepAction**
- class **javax.swing.text.DefaultEditorKit$CopyAction**
- class **javax.swing.text.DefaultEditorKit$CutAction**
- class **javax.swing.text.DefaultEditorKit$DefaultKeyTypedAction**
- class **javax.swing.text.DefaultEditorKit$InsertBreakAction**
- class **javax.swing.text.DefaultEditorKit$InsertContentAction**
- class **javax.swing.text.DefaultEditorKit$InsertTabAction**
- class **javax.swing.text.DefaultEditorKit$PasteAction**
- class **javax.swing.text.DefaultEditorKit**
- class **javax.swing.text.DefaultFormatter**
- class **javax.swing.text.DefaultFormatterFactory**
- class **javax.swing.text.DefaultHighlighter$DefaultHighlightPainter**
- class **javax.swing.text.DefaultHighlighter**
- class **javax.swing.text.DefaultStyledDocument$AttributeUndoableEdit**
- class **javax.swing.text.DefaultStyledDocument$ElementSpec**
- class **javax.swing.text.DefaultStyledDocument**
- class **javax.swing.text.DefaultTextUI**
- interface **javax.swing.text.Document**
- class **javax.swing.text.DocumentFilter$FilterBypass**
- class **javax.swing.text.DocumentFilter**
- class **javax.swing.text.EditorKit**
- interface **javax.swing.text.Element**
- class **javax.swing.text.ElementIterator**
- class **javax.swing.text.FieldView**
- class **javax.swing.text.FlowView$FlowStrategy**
- class **javax.swing.text.FlowView**
- class **javax.swing.text.GapContent**
- class **javax.swing.text.GlyphView$GlyphPainter**
- class **javax.swing.text.GlyphView**
- interface **javax.swing.text.Highlighter$Highlight**
- interface **javax.swing.text.Highlighter$HighlightPainter**
- interface **javax.swing.text.Highlighter**
- class **javax.swing.text.IconView**
- class **javax.swing.text.InternationalFormatter**
- class **javax.swing.text.JTextComponent$DropLocation**
- class **javax.swing.text.JTextComponent$KeyBinding**
- class **javax.swing.text.JTextComponent**
- interface **javax.swing.text.Keymap**
- class **javax.swing.text.LabelView**
- class **javax.swing.text.LayeredHighlighter$LayerPainter**
- class **javax.swing.text.LayeredHighlighter**
- class **javax.swing.text.LayoutQueue**
- class **javax.swing.text.MaskFormatter**
- interface **javax.swing.text.MutableAttributeSet**
- class **javax.swing.text.NavigationFilter$FilterBypass**
- class **javax.swing.text.NavigationFilter**
- class **javax.swing.text.NumberFormatter**
- class **javax.swing.text.ParagraphView**
- class **javax.swing.text.PasswordView**
- class **javax.swing.text.PlainDocument**
- class **javax.swing.text.PlainView**
- class **javax.swing.text.Position$Bias**
- interface **javax.swing.text.Position**
- class **javax.swing.text.Segment**
- class **javax.swing.text.SimpleAttributeSet**
- class **javax.swing.text.StringContent**
- interface **javax.swing.text.Style**
- class **javax.swing.text.StyleConstants$CharacterConstants**
- class **javax.swing.text.StyleConstants$ColorConstants**
- class **javax.swing.text.StyleConstants$FontConstants**
- class **javax.swing.text.StyleConstants$ParagraphConstants**
- class **javax.swing.text.StyleConstants**
- class **javax.swing.text.StyleContext**
- interface **javax.swing.text.StyledDocument**
- class **javax.swing.text.StyledEditorKit$AlignmentAction**
- class **javax.swing.text.StyledEditorKit$BoldAction**
- class **javax.swing.text.StyledEditorKit$FontFamilyAction**
- class **javax.swing.text.StyledEditorKit$FontSizeAction**
- class **javax.swing.text.StyledEditorKit$ForegroundAction**
- class **javax.swing.text.StyledEditorKit$ItalicAction**
- class **javax.swing.text.StyledEditorKit$StyledTextAction**
- class **javax.swing.text.StyledEditorKit$UnderlineAction**
- class **javax.swing.text.StyledEditorKit**
- interface **javax.swing.text.TabExpander**
- class **javax.swing.text.TabSet**
- class **javax.swing.text.TabStop**
- interface **javax.swing.text.TabableView**
- class **javax.swing.text.TableView**
- class **javax.swing.text.TextAction**
- class **javax.swing.text.Utilities**
- class **javax.swing.text.View**
- interface **javax.swing.text.ViewFactory**
- class **javax.swing.text.WrappedPlainView**
- class **javax.swing.text.ZoneView**
- class **javax.swing.text.html.BlockView**
- class **javax.swing.text.html.CSS$Attribute**
- class **javax.swing.text.html.CSS**
- enum **javax.swing.text.html.FormSubmitEvent$MethodType**
- class **javax.swing.text.html.FormSubmitEvent**
- class **javax.swing.text.html.FormView**
- class **javax.swing.text.html.HTML$Attribute**
- class **javax.swing.text.html.HTML$Tag**
- class **javax.swing.text.html.HTML$UnknownTag**
- class **javax.swing.text.html.HTML**
- class **javax.swing.text.html.HTMLDocument$Iterator**
- class **javax.swing.text.html.HTMLDocument**
- class **javax.swing.text.html.HTMLEditorKit$HTMLFactory**
- class **javax.swing.text.html.HTMLEditorKit$HTMLTextAction**
- class **javax.swing.text.html.HTMLEditorKit$InsertHTMLTextAction**
- class **javax.swing.text.html.HTMLEditorKit$LinkController**
- class **javax.swing.text.html.HTMLEditorKit$Parser**
- class **javax.swing.text.html.HTMLEditorKit$ParserCallback**
- class **javax.swing.text.html.HTMLEditorKit**
- class **javax.swing.text.html.HTMLFrameHyperlinkEvent**
- class **javax.swing.text.html.HTMLWriter**
- class **javax.swing.text.html.ImageView**
- class **javax.swing.text.html.InlineView**
- class **javax.swing.text.html.ListView**
- class **javax.swing.text.html.MinimalHTMLWriter**
- class **javax.swing.text.html.ObjectView**
- class **javax.swing.text.html.Option**
- class **javax.swing.text.html.ParagraphView**
- class **javax.swing.text.html.StyleSheet$BoxPainter**
- class **javax.swing.text.html.StyleSheet$ListPainter**
- class **javax.swing.text.html.StyleSheet**
- class **javax.swing.text.html.parser.AttributeList**
- class **javax.swing.text.html.parser.ContentModel**
- class **javax.swing.text.html.parser.DTD**
- interface **javax.swing.text.html.parser.DTDConstants**
- class **javax.swing.text.html.parser.DocumentParser**
- class **javax.swing.text.html.parser.Element**
- class **javax.swing.text.html.parser.Entity**
- class **javax.swing.text.html.parser.Parser**
- class **javax.swing.text.html.parser.ParserDelegator**
- class **javax.swing.text.html.parser.TagElement**
- class **javax.swing.text.rtf.RTFEditorKit**
- class **javax.swing.tree.AbstractLayoutCache$NodeDimensions**
- class **javax.swing.tree.AbstractLayoutCache**
- class **javax.swing.tree.DefaultMutableTreeNode**
- class **javax.swing.tree.DefaultTreeCellEditor**
- class **javax.swing.tree.DefaultTreeCellRenderer**
- class **javax.swing.tree.DefaultTreeModel**
- class **javax.swing.tree.DefaultTreeSelectionModel**
- class **javax.swing.tree.ExpandVetoException**
- class **javax.swing.tree.FixedHeightLayoutCache**
- interface **javax.swing.tree.MutableTreeNode**
- interface **javax.swing.tree.RowMapper**
- interface **javax.swing.tree.TreeCellEditor**
- interface **javax.swing.tree.TreeCellRenderer**
- interface **javax.swing.tree.TreeModel**
- interface **javax.swing.tree.TreeNode**
- class **javax.swing.tree.TreePath**
- interface **javax.swing.tree.TreeSelectionModel**
- class **javax.swing.tree.VariableHeightLayoutCache**
- class **javax.swing.undo.AbstractUndoableEdit**
- class **javax.swing.undo.CannotRedoException**
- class **javax.swing.undo.CannotUndoException**
- class **javax.swing.undo.CompoundEdit**
- class **javax.swing.undo.StateEdit**
- interface **javax.swing.undo.StateEditable**
- class **javax.swing.undo.UndoManager**
- interface **javax.swing.undo.UndoableEdit**
- class **javax.swing.undo.UndoableEditSupport**

## Contributors

[Eugene Potapenko](https://github.com/potapenko/)

## License

Distributed under the Eclipse Public License, the same as Clojure.
