(ns javax.swing.plaf.LayerUI
  "The base class for all JLayer's UI delegates.

  paint(java.awt.Graphics, javax.swing.JComponent) method performs the
  painting of the JLayer
  and eventDispatched(AWTEvent, JLayer) method is notified
  about any AWTEvents which have been generated by a JLayer
  or any of its subcomponents.

  The LayerUI differs from the UI delegates of the other components,
  because it is LookAndFeel independent and is not updated by default when
  the system LookAndFeel is changed.

  The subclasses of LayerUI can either be stateless and shareable
  by multiple JLayers or not shareable."
  (:refer-clojure :only [require comment defn ->])
  (:import [javax.swing.plaf LayerUI]))

(defn ->layer-ui
  "Constructor."
  ([]
    (new LayerUI )))

(defn install-ui
  "Configures the JLayer this LayerUI is set to.
   The default implementation registers the passed JLayer component
   as a PropertyChangeListener for the property changes of this LayerUI.

  c - the JLayer component where this UI delegate is being installed - `javax.swing.JComponent`"
  ([^javax.swing.plaf.LayerUI this ^javax.swing.JComponent c]
    (-> this (.installUI c))))

(defn get-minimum-size
  "If the JLayer's view component is not null,
   this returns the result of  the view's getMinimalSize() method.
   Otherwise, the default implementation is used.

  c - JLayer to return preferred size for - `javax.swing.JComponent`

  returns: minimal size for the passed JLayer - `java.awt.Dimension`"
  (^java.awt.Dimension [^javax.swing.plaf.LayerUI this ^javax.swing.JComponent c]
    (-> this (.getMinimumSize c))))

(defn get-maximum-size
  "If the JLayer's view component is not null,
   this returns the result of  the view's getMaximumSize() method.
   Otherwise, the default implementation is used.

  c - JLayer to return preferred size for - `javax.swing.JComponent`

  returns: maximum size for the passed JLayer - `java.awt.Dimension`"
  (^java.awt.Dimension [^javax.swing.plaf.LayerUI this ^javax.swing.JComponent c]
    (-> this (.getMaximumSize c))))

(defn uninstall-ui
  "Reverses the configuration which was previously set
   in the installUI(JComponent) method.
   The default implementation unregisters the passed JLayer component
   as a PropertyChangeListener for the property changes of this LayerUI.

  c - the component from which this UI delegate is being removed. - `javax.swing.JComponent`"
  ([^javax.swing.plaf.LayerUI this ^javax.swing.JComponent c]
    (-> this (.uninstallUI c))))

(defn get-baseline-resize-behavior
  "If the JLayer's view component is not null,
   this returns the result of the view's getBaselineResizeBehavior() method.
   Otherwise, the default implementation is called.

  c - JLayer to return baseline resize behavior for - `javax.swing.JComponent`

  returns: an enum indicating how the baseline changes as the component
           size changes - `java.awt.Component.BaselineResizeBehavior`"
  (^java.awt.Component.BaselineResizeBehavior [^javax.swing.plaf.LayerUI this ^javax.swing.JComponent c]
    (-> this (.getBaselineResizeBehavior c))))

(defn remove-property-change-listener
  "Removes a PropertyChangeListener from the listener
   list for a specific property. This method should be used to remove
   PropertyChangeListeners
   that were registered for a specific bound property.

   If propertyName or listener is null,
   no exception is thrown and no action is taken.

  property-name - a valid property name - `java.lang.String`
  listener - the PropertyChangeListener to be removed - `java.beans.PropertyChangeListener`"
  ([^javax.swing.plaf.LayerUI this ^java.lang.String property-name ^java.beans.PropertyChangeListener listener]
    (-> this (.removePropertyChangeListener property-name listener)))
  ([^javax.swing.plaf.LayerUI this ^java.beans.PropertyChangeListener listener]
    (-> this (.removePropertyChangeListener listener))))

(defn apply-property-change
  "Notifies the LayerUI when any of its property are changed
   and enables updating every JLayer
   this LayerUI instance is set to.

  evt - the PropertyChangeEvent generated by this LayerUI - `java.beans.PropertyChangeEvent`
  l - the JLayer this LayerUI is set to - `LayerUI.V>`"
  ([^javax.swing.plaf.LayerUI this ^java.beans.PropertyChangeEvent evt ^LayerUI.V> l]
    (-> this (.applyPropertyChange evt l))))

(defn paint-immediately
  "Paints the specified region in the JLayer this LayerUI is set to, immediately.

   This method is to be overridden when the dirty region needs to be changed.
   The default implementation delegates its functionality to JComponent.paintImmediately(int, int, int, int).

  x - the x value of the region to be painted - `int`
  y - the y value of the region to be painted - `int`
  width - the width of the region to be painted - `int`
  height - the height of the region to be painted - `int`
  l - `LayerUI.V>`"
  ([^javax.swing.plaf.LayerUI this ^Integer x ^Integer y ^Integer width ^Integer height ^LayerUI.V> l]
    (-> this (.paintImmediately x y width height l))))

(defn paint
  "Paints the specified component.
   Subclasses should override this method and use
   the specified Graphics object to
   render the content of the component.

   The default implementation paints the passed component as is.

  g - the Graphics context in which to paint - `java.awt.Graphics`
  c - the component being painted - `javax.swing.JComponent`"
  ([^javax.swing.plaf.LayerUI this ^java.awt.Graphics g ^javax.swing.JComponent c]
    (-> this (.paint g c))))

(defn get-property-change-listeners
  "Returns an array of all the listeners which have been associated
   with the named property.

  property-name - The name of the property being listened to - `java.lang.String`

  returns: all of the PropertyChangeListeners associated with
           the named property; if no such listeners have been added or
           if propertyName is null, an empty
           array is returned - `java.beans.PropertyChangeListener[]`"
  ([^javax.swing.plaf.LayerUI this ^java.lang.String property-name]
    (-> this (.getPropertyChangeListeners property-name)))
  ([^javax.swing.plaf.LayerUI this]
    (-> this (.getPropertyChangeListeners))))

(defn do-layout
  "Causes the passed instance of JLayer to lay out its components.

  l - the JLayer component where this UI delegate is being installed - `LayerUI.V>`"
  ([^javax.swing.plaf.LayerUI this ^LayerUI.V> l]
    (-> this (.doLayout l))))

(defn event-dispatched
  "Processes AWTEvents for JLayer
   and all its descendants to this LayerUI instance.

   To enable the AWTEvents of a particular type,
   you call JLayer.setLayerEventMask(long)
   in installUI(javax.swing.JComponent)
   and set the layer event mask to 0
   in uninstallUI(javax.swing.JComponent) after that.
   By default this  method calls the appropriate
   process&lt;event&nbsp;type&gt;Event
   method for the given class of event.

   Note: Events are processed only for displayable JLayers.

  e - the event to be dispatched - `java.awt.AWTEvent`
  l - the layer this LayerUI is set to - `LayerUI.V>`"
  ([^javax.swing.plaf.LayerUI this ^java.awt.AWTEvent e ^LayerUI.V> l]
    (-> this (.eventDispatched e l))))

(defn get-baseline
  "If the JLayer's view component is not null,
   this calls the view's getBaseline() method.
   Otherwise, the default implementation is called.

  c - JLayer to return baseline resize behavior for - `javax.swing.JComponent`
  width - the width to get the baseline for - `int`
  height - the height to get the baseline for - `int`

  returns: baseline or a value < 0 indicating there is no reasonable
                    baseline - `int`"
  (^Integer [^javax.swing.plaf.LayerUI this ^javax.swing.JComponent c ^Integer width ^Integer height]
    (-> this (.getBaseline c width height))))

(defn add-property-change-listener
  "Adds a PropertyChangeListener to the listener list for a specific
   property.

   If propertyName or listener is null,
   no exception is thrown and no action is taken.

  property-name - one of the property names listed above - `java.lang.String`
  listener - the property change listener to be added - `java.beans.PropertyChangeListener`"
  ([^javax.swing.plaf.LayerUI this ^java.lang.String property-name ^java.beans.PropertyChangeListener listener]
    (-> this (.addPropertyChangeListener property-name listener)))
  ([^javax.swing.plaf.LayerUI this ^java.beans.PropertyChangeListener listener]
    (-> this (.addPropertyChangeListener listener))))

(defn update-ui
  "Invoked when JLayer.updateUI() is called
   by the JLayer this LayerUI is set to.

  l - the JLayer which UI is updated - `LayerUI.V>`"
  ([^javax.swing.plaf.LayerUI this ^LayerUI.V> l]
    (-> this (.updateUI l))))

(defn get-preferred-size
  "If the JLayer's view component is not null,
   this returns the result of  the view's getPreferredSize() method.
   Otherwise, the default implementation is used.

  c - JLayer to return preferred size for - `javax.swing.JComponent`

  returns: preferred size for the passed JLayer - `java.awt.Dimension`"
  (^java.awt.Dimension [^javax.swing.plaf.LayerUI this ^javax.swing.JComponent c]
    (-> this (.getPreferredSize c))))

