(ns javax.swing.plaf.multi.MultiTextUI
  "A multiplexing UI used to combine TextUIs.

  This file was automatically generated by AutoMulti."
  (:refer-clojure :only [require comment defn ->])
  (:import [javax.swing.plaf.multi MultiTextUI]))

(defn ->multi-text-ui
  "Constructor."
  (^MultiTextUI []
    (new MultiTextUI )))

(defn *create-ui
  "Returns a multiplexing UI instance if any of the auxiliary
   LookAndFeels supports this UI.  Otherwise, just returns the
   UI object obtained from the default LookAndFeel.

  a - `javax.swing.JComponent`

  returns: `javax.swing.plaf.ComponentUI`"
  (^javax.swing.plaf.ComponentUI [^javax.swing.JComponent a]
    (MultiTextUI/createUI a)))

(defn install-ui
  "Invokes the installUI method on each UI handled by this object.

  a - the component where this UI delegate is being installed - `javax.swing.JComponent`"
  ([^MultiTextUI this ^javax.swing.JComponent a]
    (-> this (.installUI a))))

(defn get-minimum-size
  "Invokes the getMinimumSize method on each UI handled by this object.

  a - the component whose minimum size is being queried; this argument is often ignored, but might be used if the UI object is stateless and shared by multiple components - `javax.swing.JComponent`

  returns: the value obtained from the first UI, which is
   the UI obtained from the default LookAndFeel - `java.awt.Dimension`"
  (^java.awt.Dimension [^MultiTextUI this ^javax.swing.JComponent a]
    (-> this (.getMinimumSize a))))

(defn get-maximum-size
  "Invokes the getMaximumSize method on each UI handled by this object.

  a - the component whose maximum size is being queried; this argument is often ignored, but might be used if the UI object is stateless and shared by multiple components - `javax.swing.JComponent`

  returns: the value obtained from the first UI, which is
   the UI obtained from the default LookAndFeel - `java.awt.Dimension`"
  (^java.awt.Dimension [^MultiTextUI this ^javax.swing.JComponent a]
    (-> this (.getMaximumSize a))))

(defn get-accessible-child
  "Invokes the getAccessibleChild method on each UI handled by this object.

  a - `javax.swing.JComponent`
  b - `int`

  returns: the value obtained from the first UI, which is
   the UI obtained from the default LookAndFeel - `javax.accessibility.Accessible`"
  (^javax.accessibility.Accessible [^MultiTextUI this ^javax.swing.JComponent a ^Integer b]
    (-> this (.getAccessibleChild a b))))

(defn get-u-is
  "Returns the list of UIs associated with this multiplexing UI.  This
   allows processing of the UIs by an application aware of multiplexing
   UIs on components.

  returns: `javax.swing.plaf.ComponentUI[]`"
  ([^MultiTextUI this]
    (-> this (.getUIs))))

(defn uninstall-ui
  "Invokes the uninstallUI method on each UI handled by this object.

  a - the component from which this UI delegate is being removed; this argument is often ignored, but might be used if the UI object is stateless and shared by multiple components - `javax.swing.JComponent`"
  ([^MultiTextUI this ^javax.swing.JComponent a]
    (-> this (.uninstallUI a))))

(defn contains
  "Invokes the contains method on each UI handled by this object.

  a - the component where the x,y location is being queried; this argument is often ignored, but might be used if the UI object is stateless and shared by multiple components - `javax.swing.JComponent`
  b - the x coordinate of the point - `int`
  c - the y coordinate of the point - `int`

  returns: the value obtained from the first UI, which is
   the UI obtained from the default LookAndFeel - `boolean`"
  (^Boolean [^MultiTextUI this ^javax.swing.JComponent a ^Integer b ^Integer c]
    (-> this (.contains a b c))))

(defn update
  "Invokes the update method on each UI handled by this object.

  a - the Graphics context in which to paint - `java.awt.Graphics`
  b - the component being painted; this argument is often ignored, but might be used if the UI object is stateless and shared by multiple components - `javax.swing.JComponent`"
  ([^MultiTextUI this ^java.awt.Graphics a ^javax.swing.JComponent b]
    (-> this (.update a b))))

(defn get-tool-tip-text
  "Invokes the getToolTipText method on each UI handled by this object.

  a - `javax.swing.text.JTextComponent`
  b - `java.awt.Point`

  returns: the value obtained from the first UI, which is
   the UI obtained from the default LookAndFeel - `java.lang.String`"
  (^java.lang.String [^MultiTextUI this ^javax.swing.text.JTextComponent a ^java.awt.Point b]
    (-> this (.getToolTipText a b))))

(defn get-accessible-children-count
  "Invokes the getAccessibleChildrenCount method on each UI handled by this object.

  a - `javax.swing.JComponent`

  returns: the value obtained from the first UI, which is
   the UI obtained from the default LookAndFeel - `int`"
  (^Integer [^MultiTextUI this ^javax.swing.JComponent a]
    (-> this (.getAccessibleChildrenCount a))))

(defn paint
  "Invokes the paint method on each UI handled by this object.

  a - the Graphics context in which to paint - `java.awt.Graphics`
  b - the component being painted; this argument is often ignored, but might be used if the UI object is stateless and shared by multiple components - `javax.swing.JComponent`"
  ([^MultiTextUI this ^java.awt.Graphics a ^javax.swing.JComponent b]
    (-> this (.paint a b))))

(defn damage-range
  "Invokes the damageRange method on each UI handled by this object.

  a - `javax.swing.text.JTextComponent`
  b - `int`
  c - `int`
  d - `javax.swing.text.Position$Bias`
  e - `javax.swing.text.Position$Bias`"
  ([^MultiTextUI this ^javax.swing.text.JTextComponent a ^Integer b ^Integer c ^javax.swing.text.Position$Bias d ^javax.swing.text.Position$Bias e]
    (-> this (.damageRange a b c d e)))
  ([^MultiTextUI this ^javax.swing.text.JTextComponent a ^Integer b ^Integer c]
    (-> this (.damageRange a b c))))

(defn view-to-model
  "Invokes the viewToModel method on each UI handled by this object.

  a - `javax.swing.text.JTextComponent`
  b - `java.awt.Point`
  c - `javax.swing.text.Position$Bias[]`

  returns: the value obtained from the first UI, which is
   the UI obtained from the default LookAndFeel - `int`"
  (^Integer [^MultiTextUI this ^javax.swing.text.JTextComponent a ^java.awt.Point b c]
    (-> this (.viewToModel a b c)))
  (^Integer [^MultiTextUI this ^javax.swing.text.JTextComponent a ^java.awt.Point b]
    (-> this (.viewToModel a b))))

(defn get-editor-kit
  "Invokes the getEditorKit method on each UI handled by this object.

  a - `javax.swing.text.JTextComponent`

  returns: the value obtained from the first UI, which is
   the UI obtained from the default LookAndFeel - `javax.swing.text.EditorKit`"
  (^javax.swing.text.EditorKit [^MultiTextUI this ^javax.swing.text.JTextComponent a]
    (-> this (.getEditorKit a))))

(defn model-to-view
  "Invokes the modelToView method on each UI handled by this object.

  a - `javax.swing.text.JTextComponent`
  b - `int`
  c - `javax.swing.text.Position$Bias`

  returns: the value obtained from the first UI, which is
   the UI obtained from the default LookAndFeel - `java.awt.Rectangle`

  throws: javax.swing.text.BadLocationException - if the given position does not represent a valid location in the associated document"
  (^java.awt.Rectangle [^MultiTextUI this ^javax.swing.text.JTextComponent a ^Integer b ^javax.swing.text.Position$Bias c]
    (-> this (.modelToView a b c)))
  (^java.awt.Rectangle [^MultiTextUI this ^javax.swing.text.JTextComponent a ^Integer b]
    (-> this (.modelToView a b))))

(defn get-preferred-size
  "Invokes the getPreferredSize method on each UI handled by this object.

  a - the component whose preferred size is being queried; this argument is often ignored, but might be used if the UI object is stateless and shared by multiple components - `javax.swing.JComponent`

  returns: the value obtained from the first UI, which is
   the UI obtained from the default LookAndFeel - `java.awt.Dimension`"
  (^java.awt.Dimension [^MultiTextUI this ^javax.swing.JComponent a]
    (-> this (.getPreferredSize a))))

(defn get-root-view
  "Invokes the getRootView method on each UI handled by this object.

  a - `javax.swing.text.JTextComponent`

  returns: the value obtained from the first UI, which is
   the UI obtained from the default LookAndFeel - `javax.swing.text.View`"
  (^javax.swing.text.View [^MultiTextUI this ^javax.swing.text.JTextComponent a]
    (-> this (.getRootView a))))

(defn get-next-visual-position-from
  "Invokes the getNextVisualPositionFrom method on each UI handled by this object.

  a - the text component for which this UI is installed - `javax.swing.text.JTextComponent`
  b - the position to convert >= 0 - `int`
  c - the bias for the position - `javax.swing.text.Position$Bias`
  d - the direction from the current position that can be thought of as the arrow keys typically found on a keyboard. This may be SwingConstants.WEST, SwingConstants.EAST, SwingConstants.NORTH, or SwingConstants.SOUTH - `int`
  e - an array to contain the bias for the returned position - `javax.swing.text.Position$Bias[]`

  returns: the value obtained from the first UI, which is
   the UI obtained from the default LookAndFeel - `int`

  throws: javax.swing.text.BadLocationException"
  (^Integer [^MultiTextUI this ^javax.swing.text.JTextComponent a ^Integer b ^javax.swing.text.Position$Bias c ^Integer d e]
    (-> this (.getNextVisualPositionFrom a b c d e))))

