# MinecraftForge Bindings for Clojure.

These bindings are created to simplify interaction with java classes from clojure.
For each java class was created a separate namespace.
Each method/field has its own function/field binding.
Their names are changed for a more native look in the clojure code. Each function has docstring - information about the parameters, return value and possible exceptions.

## Clojars

```
[clojure-interop/minecraft-forge "1.0.0"]
```

## Class Members Naming Conventions

| Class Member | Java | Clojure |
|:--|:--|:--|
| constructor | new File() | (->file) |
| instance method | getAnyValue() | (get-any-value) |
| instance field | instanceField | (-instance-field) |
| static method | staticMethod() | (*static-method) |
| static field | ANY_STATIC_FIELD | (*-any-static-field) |
| boolean field/method | isExists(), canUse() | (exists?), (can-use?) |

## Classes

- class **ibxm.Channel**
- class **ibxm.Envelope**
- class **ibxm.FastTracker2**
- class **ibxm.IBXM**
- class **ibxm.Instrument**
- class **ibxm.LogTable**
- class **ibxm.Module**
- class **ibxm.Pattern**
- class **ibxm.Player**
- class **ibxm.ProTracker**
- class **ibxm.Sample**
- class **ibxm.ScreamTracker3**
- enum **net.minecraft.block.Block$EnumOffsetType**
- class **net.minecraft.block.Block**
- class **net.minecraft.block.BlockAir**
- class **net.minecraft.block.BlockAnvil$Anvil**
- class **net.minecraft.block.BlockAnvil**
- class **net.minecraft.block.BlockBanner$BlockBannerHanging**
- class **net.minecraft.block.BlockBanner$BlockBannerStanding**
- class **net.minecraft.block.BlockBanner**
- class **net.minecraft.block.BlockBarrier**
- class **net.minecraft.block.BlockBasePressurePlate**
- class **net.minecraft.block.BlockBeacon**
- enum **net.minecraft.block.BlockBed$EnumPartType**
- class **net.minecraft.block.BlockBed**
- class **net.minecraft.block.BlockBeetroot**
- class **net.minecraft.block.BlockBone**
- class **net.minecraft.block.BlockBookshelf**
- class **net.minecraft.block.BlockBreakable**
- class **net.minecraft.block.BlockBrewingStand**
- class **net.minecraft.block.BlockBush**
- class **net.minecraft.block.BlockButton**
- class **net.minecraft.block.BlockButtonStone**
- class **net.minecraft.block.BlockButtonWood**
- class **net.minecraft.block.BlockCactus**
- class **net.minecraft.block.BlockCake**
- class **net.minecraft.block.BlockCarpet**
- class **net.minecraft.block.BlockCarrot**
- class **net.minecraft.block.BlockCauldron**
- enum **net.minecraft.block.BlockChest$Type**
- class **net.minecraft.block.BlockChest**
- class **net.minecraft.block.BlockChorusFlower**
- class **net.minecraft.block.BlockChorusPlant**
- class **net.minecraft.block.BlockClay**
- class **net.minecraft.block.BlockCocoa**
- class **net.minecraft.block.BlockColored**
- class **net.minecraft.block.BlockCommandBlock**
- class **net.minecraft.block.BlockCompressedPowered**
- class **net.minecraft.block.BlockContainer**
- class **net.minecraft.block.BlockCrops**
- class **net.minecraft.block.BlockDaylightDetector**
- class **net.minecraft.block.BlockDeadBush**
- class **net.minecraft.block.BlockDirectional**
- enum **net.minecraft.block.BlockDirt$DirtType**
- class **net.minecraft.block.BlockDirt**
- class **net.minecraft.block.BlockDispenser**
- enum **net.minecraft.block.BlockDoor$EnumDoorHalf**
- enum **net.minecraft.block.BlockDoor$EnumHingePosition**
- class **net.minecraft.block.BlockDoor**
- enum **net.minecraft.block.BlockDoublePlant$EnumBlockHalf**
- enum **net.minecraft.block.BlockDoublePlant$EnumPlantType**
- class **net.minecraft.block.BlockDoublePlant**
- class **net.minecraft.block.BlockDoubleStoneSlab**
- class **net.minecraft.block.BlockDoubleStoneSlabNew**
- class **net.minecraft.block.BlockDoubleWoodSlab**
- class **net.minecraft.block.BlockDragonEgg**
- class **net.minecraft.block.BlockDropper**
- class **net.minecraft.block.BlockDynamicLiquid**
- class **net.minecraft.block.BlockEmptyDrops**
- class **net.minecraft.block.BlockEnchantmentTable**
- class **net.minecraft.block.BlockEndGateway**
- class **net.minecraft.block.BlockEndPortal**
- class **net.minecraft.block.BlockEndPortalFrame**
- class **net.minecraft.block.BlockEndRod**
- class **net.minecraft.block.BlockEnderChest**
- class **net.minecraft.block.BlockEventData**
- class **net.minecraft.block.BlockFalling**
- class **net.minecraft.block.BlockFarmland**
- class **net.minecraft.block.BlockFence**
- class **net.minecraft.block.BlockFenceGate**
- class **net.minecraft.block.BlockFire**
- enum **net.minecraft.block.BlockFlower$EnumFlowerColor**
- enum **net.minecraft.block.BlockFlower$EnumFlowerType**
- class **net.minecraft.block.BlockFlower**
- enum **net.minecraft.block.BlockFlowerPot$EnumFlowerType**
- class **net.minecraft.block.BlockFlowerPot**
- class **net.minecraft.block.BlockFrostedIce**
- class **net.minecraft.block.BlockFurnace**
- class **net.minecraft.block.BlockGlass**
- class **net.minecraft.block.BlockGlowstone**
- class **net.minecraft.block.BlockGrass**
- class **net.minecraft.block.BlockGrassPath**
- class **net.minecraft.block.BlockGravel**
- class **net.minecraft.block.BlockHalfStoneSlab**
- class **net.minecraft.block.BlockHalfStoneSlabNew**
- class **net.minecraft.block.BlockHalfWoodSlab**
- class **net.minecraft.block.BlockHardenedClay**
- class **net.minecraft.block.BlockHay**
- class **net.minecraft.block.BlockHopper**
- class **net.minecraft.block.BlockHorizontal**
- enum **net.minecraft.block.BlockHugeMushroom$EnumType**
- class **net.minecraft.block.BlockHugeMushroom**
- class **net.minecraft.block.BlockIce**
- class **net.minecraft.block.BlockJukebox$TileEntityJukebox**
- class **net.minecraft.block.BlockJukebox**
- class **net.minecraft.block.BlockLadder**
- class **net.minecraft.block.BlockLeaves**
- enum **net.minecraft.block.BlockLever$EnumOrientation**
- class **net.minecraft.block.BlockLever**
- class **net.minecraft.block.BlockLilyPad**
- class **net.minecraft.block.BlockLiquid**
- enum **net.minecraft.block.BlockLog$EnumAxis**
- class **net.minecraft.block.BlockLog**
- class **net.minecraft.block.BlockMagma**
- class **net.minecraft.block.BlockMelon**
- class **net.minecraft.block.BlockMobSpawner**
- class **net.minecraft.block.BlockMushroom**
- class **net.minecraft.block.BlockMycelium**
- class **net.minecraft.block.BlockNetherBrick**
- class **net.minecraft.block.BlockNetherWart**
- class **net.minecraft.block.BlockNetherrack**
- class **net.minecraft.block.BlockNewLeaf**
- class **net.minecraft.block.BlockNewLog**
- class **net.minecraft.block.BlockNote**
- class **net.minecraft.block.BlockObserver**
- class **net.minecraft.block.BlockObsidian**
- class **net.minecraft.block.BlockOldLeaf**
- class **net.minecraft.block.BlockOldLog**
- class **net.minecraft.block.BlockOre**
- class **net.minecraft.block.BlockPackedIce**
- class **net.minecraft.block.BlockPane**
- class **net.minecraft.block.BlockPistonBase**
- enum **net.minecraft.block.BlockPistonExtension$EnumPistonType**
- class **net.minecraft.block.BlockPistonExtension**
- class **net.minecraft.block.BlockPistonMoving**
- enum **net.minecraft.block.BlockPlanks$EnumType**
- class **net.minecraft.block.BlockPlanks**
- class **net.minecraft.block.BlockPortal$Size**
- class **net.minecraft.block.BlockPortal**
- class **net.minecraft.block.BlockPotato**
- enum **net.minecraft.block.BlockPressurePlate$Sensitivity**
- class **net.minecraft.block.BlockPressurePlate**
- class **net.minecraft.block.BlockPressurePlateWeighted**
- enum **net.minecraft.block.BlockPrismarine$EnumType**
- class **net.minecraft.block.BlockPrismarine**
- class **net.minecraft.block.BlockPumpkin**
- class **net.minecraft.block.BlockPurpurSlab$Double**
- class **net.minecraft.block.BlockPurpurSlab$Half**
- enum **net.minecraft.block.BlockPurpurSlab$Variant**
- class **net.minecraft.block.BlockPurpurSlab**
- enum **net.minecraft.block.BlockQuartz$EnumType**
- class **net.minecraft.block.BlockQuartz**
- class **net.minecraft.block.BlockRail**
- enum **net.minecraft.block.BlockRailBase$EnumRailDirection**
- class **net.minecraft.block.BlockRailBase**
- class **net.minecraft.block.BlockRailDetector**
- class **net.minecraft.block.BlockRailPowered**
- class **net.minecraft.block.BlockRedFlower**
- enum **net.minecraft.block.BlockRedSandstone$EnumType**
- class **net.minecraft.block.BlockRedSandstone**
- enum **net.minecraft.block.BlockRedstoneComparator$Mode**
- class **net.minecraft.block.BlockRedstoneComparator**
- class **net.minecraft.block.BlockRedstoneDiode**
- class **net.minecraft.block.BlockRedstoneLight**
- class **net.minecraft.block.BlockRedstoneOre**
- class **net.minecraft.block.BlockRedstoneRepeater**
- class **net.minecraft.block.BlockRedstoneTorch**
- class **net.minecraft.block.BlockRedstoneWire**
- class **net.minecraft.block.BlockReed**
- class **net.minecraft.block.BlockRotatedPillar**
- enum **net.minecraft.block.BlockSand$EnumType**
- class **net.minecraft.block.BlockSand**
- enum **net.minecraft.block.BlockSandStone$EnumType**
- class **net.minecraft.block.BlockSandStone**
- class **net.minecraft.block.BlockSapling**
- class **net.minecraft.block.BlockSeaLantern**
- class **net.minecraft.block.BlockShulkerBox**
- class **net.minecraft.block.BlockSign**
- enum **net.minecraft.block.BlockSilverfish$EnumType**
- class **net.minecraft.block.BlockSilverfish**
- class **net.minecraft.block.BlockSkull**
- enum **net.minecraft.block.BlockSlab$EnumBlockHalf**
- class **net.minecraft.block.BlockSlab**
- class **net.minecraft.block.BlockSlime**
- class **net.minecraft.block.BlockSnow**
- class **net.minecraft.block.BlockSnowBlock**
- class **net.minecraft.block.BlockSoulSand**
- class **net.minecraft.block.BlockSourceImpl**
- class **net.minecraft.block.BlockSponge**
- class **net.minecraft.block.BlockStainedGlass**
- class **net.minecraft.block.BlockStainedGlassPane**
- enum **net.minecraft.block.BlockStairs$EnumHalf**
- enum **net.minecraft.block.BlockStairs$EnumShape**
- class **net.minecraft.block.BlockStairs**
- class **net.minecraft.block.BlockStandingSign**
- class **net.minecraft.block.BlockStaticLiquid**
- class **net.minecraft.block.BlockStem**
- enum **net.minecraft.block.BlockStone$EnumType**
- class **net.minecraft.block.BlockStone**
- enum **net.minecraft.block.BlockStoneBrick$EnumType**
- class **net.minecraft.block.BlockStoneBrick**
- enum **net.minecraft.block.BlockStoneSlab$EnumType**
- class **net.minecraft.block.BlockStoneSlab**
- enum **net.minecraft.block.BlockStoneSlabNew$EnumType**
- class **net.minecraft.block.BlockStoneSlabNew**
- class **net.minecraft.block.BlockStructure**
- class **net.minecraft.block.BlockStructureVoid**
- class **net.minecraft.block.BlockTNT**
- enum **net.minecraft.block.BlockTallGrass$EnumType**
- class **net.minecraft.block.BlockTallGrass**
- class **net.minecraft.block.BlockTorch**
- enum **net.minecraft.block.BlockTrapDoor$DoorHalf**
- class **net.minecraft.block.BlockTrapDoor**
- class **net.minecraft.block.BlockTripWire**
- class **net.minecraft.block.BlockTripWireHook**
- class **net.minecraft.block.BlockVine**
- enum **net.minecraft.block.BlockWall$EnumType**
- class **net.minecraft.block.BlockWall**
- class **net.minecraft.block.BlockWallSign**
- class **net.minecraft.block.BlockWeb**
- class **net.minecraft.block.BlockWoodSlab**
- class **net.minecraft.block.BlockWorkbench$InterfaceCraftingTable**
- class **net.minecraft.block.BlockWorkbench**
- class **net.minecraft.block.BlockYellowFlower**
- interface **net.minecraft.block.IGrowable**
- interface **net.minecraft.block.ITileEntityProvider**
- class **net.minecraft.block.SoundType**
- enum **net.minecraft.block.material.EnumPushReaction**
- class **net.minecraft.block.material.MapColor**
- class **net.minecraft.block.material.Material**
- class **net.minecraft.block.material.MaterialLiquid**
- class **net.minecraft.block.material.MaterialLogic**
- class **net.minecraft.block.material.MaterialPortal**
- class **net.minecraft.block.material.MaterialTransparent**
- interface **net.minecraft.block.properties.IProperty**
- class **net.minecraft.block.properties.PropertyBool**
- class **net.minecraft.block.properties.PropertyDirection**
- class **net.minecraft.block.properties.PropertyEnum**
- class **net.minecraft.block.properties.PropertyHelper**
- class **net.minecraft.block.properties.PropertyInteger**
- class **net.minecraft.block.state.BlockPistonStructureHelper**
- class **net.minecraft.block.state.BlockStateBase**
- class **net.minecraft.block.state.BlockStateContainer$Builder**
- class **net.minecraft.block.state.BlockStateContainer$StateImplementation**
- class **net.minecraft.block.state.BlockStateContainer**
- class **net.minecraft.block.state.BlockWorldState**
- interface **net.minecraft.block.state.IBlockBehaviors**
- interface **net.minecraft.block.state.IBlockProperties**
- interface **net.minecraft.block.state.IBlockState**
- class **net.minecraft.block.state.pattern.BlockMatcher**
- class **net.minecraft.block.state.pattern.BlockMaterialMatcher**
- class **net.minecraft.block.state.pattern.BlockPattern$PatternHelper**
- class **net.minecraft.block.state.pattern.BlockPattern**
- class **net.minecraft.block.state.pattern.BlockStateMatcher**
- class **net.minecraft.block.state.pattern.FactoryBlockPattern**
- class **net.minecraft.client.AnvilConverterException**
- class **net.minecraft.client.ClientBrandRetriever**
- class **net.minecraft.client.LoadingScreenRenderer**
- class **net.minecraft.client.Minecraft**
- class **net.minecraft.client.audio.ElytraSound**
- class **net.minecraft.client.audio.GuardianSound**
- enum **net.minecraft.client.audio.ISound$AttenuationType**
- interface **net.minecraft.client.audio.ISound**
- interface **net.minecraft.client.audio.ISoundEventAccessor**
- interface **net.minecraft.client.audio.ISoundEventListener**
- interface **net.minecraft.client.audio.ITickableSound**
- class **net.minecraft.client.audio.MovingSound**
- class **net.minecraft.client.audio.MovingSoundMinecart**
- class **net.minecraft.client.audio.MovingSoundMinecartRiding**
- enum **net.minecraft.client.audio.MusicTicker$MusicType**
- class **net.minecraft.client.audio.MusicTicker**
- class **net.minecraft.client.audio.PositionedSound**
- class **net.minecraft.client.audio.PositionedSoundRecord**
- enum **net.minecraft.client.audio.Sound$Type**
- class **net.minecraft.client.audio.Sound**
- class **net.minecraft.client.audio.SoundEventAccessor**
- class **net.minecraft.client.audio.SoundHandler**
- class **net.minecraft.client.audio.SoundList**
- class **net.minecraft.client.audio.SoundListSerializer**
- class **net.minecraft.client.audio.SoundManager**
- class **net.minecraft.client.audio.SoundRegistry**
- class **net.minecraft.client.entity.AbstractClientPlayer**
- class **net.minecraft.client.entity.EntityOtherPlayerMP**
- class **net.minecraft.client.entity.EntityPlayerSP**
- class **net.minecraft.client.gui.ChatLine**
- class **net.minecraft.client.gui.FontRenderer**
- class **net.minecraft.client.gui.Gui**
- class **net.minecraft.client.gui.GuiBossOverlay**
- class **net.minecraft.client.gui.GuiButton**
- class **net.minecraft.client.gui.GuiButtonLanguage**
- class **net.minecraft.client.gui.GuiButtonRealmsProxy**
- class **net.minecraft.client.gui.GuiChat$ChatTabCompleter**
- class **net.minecraft.client.gui.GuiChat**
- class **net.minecraft.client.gui.GuiClickableScrolledSelectionListProxy**
- class **net.minecraft.client.gui.GuiCommandBlock**
- class **net.minecraft.client.gui.GuiConfirmOpenLink**
- class **net.minecraft.client.gui.GuiControls**
- class **net.minecraft.client.gui.GuiCreateFlatWorld**
- class **net.minecraft.client.gui.GuiCreateWorld**
- class **net.minecraft.client.gui.GuiCustomizeSkin**
- class **net.minecraft.client.gui.GuiCustomizeWorldScreen**
- class **net.minecraft.client.gui.GuiDisconnected**
- class **net.minecraft.client.gui.GuiDownloadTerrain**
- class **net.minecraft.client.gui.GuiEnchantment**
- class **net.minecraft.client.gui.GuiErrorScreen**
- class **net.minecraft.client.gui.GuiFlatPresets**
- class **net.minecraft.client.gui.GuiGameOver**
- class **net.minecraft.client.gui.GuiHopper**
- class **net.minecraft.client.gui.GuiIngame**
- class **net.minecraft.client.gui.GuiIngameMenu**
- class **net.minecraft.client.gui.GuiKeyBindingList**
- class **net.minecraft.client.gui.GuiLabel**
- class **net.minecraft.client.gui.GuiLanguage**
- class **net.minecraft.client.gui.GuiListButton**
- interface **net.minecraft.client.gui.GuiListExtended$IGuiListEntry**
- class **net.minecraft.client.gui.GuiListExtended**
- class **net.minecraft.client.gui.GuiListWorldSelection**
- class **net.minecraft.client.gui.GuiListWorldSelectionEntry**
- class **net.minecraft.client.gui.GuiLockIconButton**
- class **net.minecraft.client.gui.GuiMainMenu**
- class **net.minecraft.client.gui.GuiMemoryErrorScreen**
- class **net.minecraft.client.gui.GuiMerchant**
- class **net.minecraft.client.gui.GuiMultiplayer**
- class **net.minecraft.client.gui.GuiNewChat**
- class **net.minecraft.client.gui.GuiOptionButton**
- class **net.minecraft.client.gui.GuiOptionSlider**
- class **net.minecraft.client.gui.GuiOptions**
- class **net.minecraft.client.gui.GuiOptionsRowList$Row**
- class **net.minecraft.client.gui.GuiOptionsRowList**
- class **net.minecraft.client.gui.GuiOverlayDebug**
- class **net.minecraft.client.gui.GuiPageButtonList$EditBoxEntry**
- class **net.minecraft.client.gui.GuiPageButtonList$GuiButtonEntry**
- class **net.minecraft.client.gui.GuiPageButtonList$GuiEntry**
- class **net.minecraft.client.gui.GuiPageButtonList$GuiLabelEntry**
- class **net.minecraft.client.gui.GuiPageButtonList$GuiListEntry**
- interface **net.minecraft.client.gui.GuiPageButtonList$GuiResponder**
- class **net.minecraft.client.gui.GuiPageButtonList$GuiSlideEntry**
- class **net.minecraft.client.gui.GuiPageButtonList**
- class **net.minecraft.client.gui.GuiPlayerTabOverlay**
- class **net.minecraft.client.gui.GuiRepair**
- class **net.minecraft.client.gui.GuiResourcePackAvailable**
- class **net.minecraft.client.gui.GuiResourcePackList**
- class **net.minecraft.client.gui.GuiResourcePackSelected**
- class **net.minecraft.client.gui.GuiScreen**
- class **net.minecraft.client.gui.GuiScreenAddServer**
- class **net.minecraft.client.gui.GuiScreenBook**
- class **net.minecraft.client.gui.GuiScreenCustomizePresets**
- class **net.minecraft.client.gui.GuiScreenDemo**
- class **net.minecraft.client.gui.GuiScreenOptionsSounds**
- class **net.minecraft.client.gui.GuiScreenRealmsProxy**
- class **net.minecraft.client.gui.GuiScreenResourcePacks**
- class **net.minecraft.client.gui.GuiScreenServerList**
- class **net.minecraft.client.gui.GuiScreenWorking**
- class **net.minecraft.client.gui.GuiShareToLan**
- class **net.minecraft.client.gui.GuiSimpleScrolledSelectionListProxy**
- class **net.minecraft.client.gui.GuiSleepMP**
- interface **net.minecraft.client.gui.GuiSlider$FormatHelper**
- class **net.minecraft.client.gui.GuiSlider**
- class **net.minecraft.client.gui.GuiSlot**
- class **net.minecraft.client.gui.GuiSlotRealmsProxy**
- class **net.minecraft.client.gui.GuiSnooper**
- class **net.minecraft.client.gui.GuiSpectator**
- class **net.minecraft.client.gui.GuiSubtitleOverlay**
- class **net.minecraft.client.gui.GuiTextField**
- class **net.minecraft.client.gui.GuiUtilRenderComponents**
- class **net.minecraft.client.gui.GuiVideoSettings**
- class **net.minecraft.client.gui.GuiWinGame**
- class **net.minecraft.client.gui.GuiWorldEdit**
- class **net.minecraft.client.gui.GuiWorldSelection**
- class **net.minecraft.client.gui.GuiYesNo**
- interface **net.minecraft.client.gui.GuiYesNoCallback**
- interface **net.minecraft.client.gui.IProgressMeter**
- class **net.minecraft.client.gui.MapItemRenderer**
- class **net.minecraft.client.gui.ScaledResolution**
- class **net.minecraft.client.gui.ScreenChatOptions**
- class **net.minecraft.client.gui.ServerListEntryLanDetected**
- class **net.minecraft.client.gui.ServerListEntryLanScan**
- class **net.minecraft.client.gui.ServerListEntryNormal**
- class **net.minecraft.client.gui.ServerSelectionList**
- class **net.minecraft.client.gui.achievement.GuiAchievement**
- class **net.minecraft.client.gui.achievement.GuiAchievements**
- class **net.minecraft.client.gui.achievement.GuiStats**
- class **net.minecraft.client.gui.inventory.CreativeCrafting**
- class **net.minecraft.client.gui.inventory.GuiBeacon**
- class **net.minecraft.client.gui.inventory.GuiBrewingStand**
- class **net.minecraft.client.gui.inventory.GuiChest**
- class **net.minecraft.client.gui.inventory.GuiContainer**
- class **net.minecraft.client.gui.inventory.GuiContainerCreative**
- class **net.minecraft.client.gui.inventory.GuiCrafting**
- class **net.minecraft.client.gui.inventory.GuiDispenser**
- class **net.minecraft.client.gui.inventory.GuiEditCommandBlockMinecart**
- class **net.minecraft.client.gui.inventory.GuiEditSign**
- class **net.minecraft.client.gui.inventory.GuiEditStructure**
- class **net.minecraft.client.gui.inventory.GuiFurnace**
- class **net.minecraft.client.gui.inventory.GuiInventory**
- class **net.minecraft.client.gui.inventory.GuiScreenHorseInventory**
- class **net.minecraft.client.gui.inventory.GuiShulkerBox**
- class **net.minecraft.client.gui.spectator.BaseSpectatorGroup**
- interface **net.minecraft.client.gui.spectator.ISpectatorMenuObject**
- interface **net.minecraft.client.gui.spectator.ISpectatorMenuRecipient**
- interface **net.minecraft.client.gui.spectator.ISpectatorMenuView**
- class **net.minecraft.client.gui.spectator.PlayerMenuObject**
- class **net.minecraft.client.gui.spectator.SpectatorMenu**
- class **net.minecraft.client.gui.spectator.categories.SpectatorDetails**
- class **net.minecraft.client.gui.spectator.categories.TeleportToPlayer**
- class **net.minecraft.client.gui.spectator.categories.TeleportToTeam**
- class **net.minecraft.client.main.GameConfiguration$DisplayInformation**
- class **net.minecraft.client.main.GameConfiguration$FolderInformation**
- class **net.minecraft.client.main.GameConfiguration$GameInformation**
- class **net.minecraft.client.main.GameConfiguration$ServerInformation**
- class **net.minecraft.client.main.GameConfiguration$UserInformation**
- class **net.minecraft.client.main.GameConfiguration**
- class **net.minecraft.client.main.Main**
- interface **net.minecraft.client.model.IMultipassModel**
- class **net.minecraft.client.model.ModelArmorStand**
- class **net.minecraft.client.model.ModelArmorStandArmor**
- class **net.minecraft.client.model.ModelBanner**
- class **net.minecraft.client.model.ModelBase**
- class **net.minecraft.client.model.ModelBat**
- enum **net.minecraft.client.model.ModelBiped$ArmPose**
- class **net.minecraft.client.model.ModelBiped**
- class **net.minecraft.client.model.ModelBlaze**
- class **net.minecraft.client.model.ModelBoat**
- class **net.minecraft.client.model.ModelBook**
- class **net.minecraft.client.model.ModelBox**
- class **net.minecraft.client.model.ModelChest**
- class **net.minecraft.client.model.ModelChicken**
- class **net.minecraft.client.model.ModelCow**
- class **net.minecraft.client.model.ModelCreeper**
- class **net.minecraft.client.model.ModelDragon**
- class **net.minecraft.client.model.ModelDragonHead**
- class **net.minecraft.client.model.ModelElytra**
- class **net.minecraft.client.model.ModelEnderCrystal**
- class **net.minecraft.client.model.ModelEnderMite**
- class **net.minecraft.client.model.ModelEnderman**
- class **net.minecraft.client.model.ModelEvoker**
- class **net.minecraft.client.model.ModelEvokerFangs**
- class **net.minecraft.client.model.ModelGhast**
- class **net.minecraft.client.model.ModelGuardian**
- class **net.minecraft.client.model.ModelHorse**
- class **net.minecraft.client.model.ModelHumanoidHead**
- class **net.minecraft.client.model.ModelIllager**
- class **net.minecraft.client.model.ModelIronGolem**
- class **net.minecraft.client.model.ModelLargeChest**
- class **net.minecraft.client.model.ModelLeashKnot**
- class **net.minecraft.client.model.ModelLlama**
- class **net.minecraft.client.model.ModelLlamaSpit**
- class **net.minecraft.client.model.ModelMagmaCube**
- class **net.minecraft.client.model.ModelMinecart**
- class **net.minecraft.client.model.ModelOcelot**
- class **net.minecraft.client.model.ModelPig**
- class **net.minecraft.client.model.ModelPlayer**
- class **net.minecraft.client.model.ModelPolarBear**
- class **net.minecraft.client.model.ModelQuadruped**
- class **net.minecraft.client.model.ModelRabbit**
- class **net.minecraft.client.model.ModelRenderer**
- class **net.minecraft.client.model.ModelSheep1**
- class **net.minecraft.client.model.ModelSheep2**
- class **net.minecraft.client.model.ModelShield**
- class **net.minecraft.client.model.ModelShulker**
- class **net.minecraft.client.model.ModelShulkerBullet**
- class **net.minecraft.client.model.ModelSign**
- class **net.minecraft.client.model.ModelSilverfish**
- class **net.minecraft.client.model.ModelSkeleton**
- class **net.minecraft.client.model.ModelSkeletonHead**
- class **net.minecraft.client.model.ModelSlime**
- class **net.minecraft.client.model.ModelSnowMan**
- class **net.minecraft.client.model.ModelSpider**
- class **net.minecraft.client.model.ModelSquid**
- class **net.minecraft.client.model.ModelVex**
- class **net.minecraft.client.model.ModelVillager**
- class **net.minecraft.client.model.ModelVindicator**
- class **net.minecraft.client.model.ModelWitch**
- class **net.minecraft.client.model.ModelWither**
- class **net.minecraft.client.model.ModelWolf**
- class **net.minecraft.client.model.ModelZombie**
- class **net.minecraft.client.model.ModelZombieVillager**
- class **net.minecraft.client.model.PositionTextureVertex**
- class **net.minecraft.client.model.TextureOffset**
- class **net.minecraft.client.model.TexturedQuad**
- class **net.minecraft.client.multiplayer.ChunkProviderClient**
- class **net.minecraft.client.multiplayer.GuiConnecting**
- class **net.minecraft.client.multiplayer.PlayerControllerMP**
- class **net.minecraft.client.multiplayer.ServerAddress**
- enum **net.minecraft.client.multiplayer.ServerData$ServerResourceMode**
- class **net.minecraft.client.multiplayer.ServerData**
- class **net.minecraft.client.multiplayer.ServerList**
- class **net.minecraft.client.multiplayer.ThreadLanServerPing**
- class **net.minecraft.client.multiplayer.WorldClient**
- class **net.minecraft.client.network.LanServerDetector$LanServerList**
- class **net.minecraft.client.network.LanServerDetector$ThreadLanServerFind**
- class **net.minecraft.client.network.LanServerDetector**
- class **net.minecraft.client.network.LanServerInfo**
- class **net.minecraft.client.network.NetHandlerHandshakeMemory**
- class **net.minecraft.client.network.NetHandlerLoginClient**
- class **net.minecraft.client.network.NetHandlerPlayClient**
- class **net.minecraft.client.network.NetworkPlayerInfo**
- class **net.minecraft.client.network.ServerPinger**
- class **net.minecraft.client.particle.Barrier$Factory**
- class **net.minecraft.client.particle.Barrier**
- interface **net.minecraft.client.particle.IParticleFactory**
- class **net.minecraft.client.particle.Particle**
- class **net.minecraft.client.particle.ParticleBlockDust$Factory**
- class **net.minecraft.client.particle.ParticleBlockDust**
- class **net.minecraft.client.particle.ParticleBreaking$Factory**
- class **net.minecraft.client.particle.ParticleBreaking$SlimeFactory**
- class **net.minecraft.client.particle.ParticleBreaking$SnowballFactory**
- class **net.minecraft.client.particle.ParticleBreaking**
- class **net.minecraft.client.particle.ParticleBubble$Factory**
- class **net.minecraft.client.particle.ParticleBubble**
- class **net.minecraft.client.particle.ParticleCloud$Factory**
- class **net.minecraft.client.particle.ParticleCloud**
- class **net.minecraft.client.particle.ParticleCrit$DamageIndicatorFactory**
- class **net.minecraft.client.particle.ParticleCrit$Factory**
- class **net.minecraft.client.particle.ParticleCrit$MagicFactory**
- class **net.minecraft.client.particle.ParticleCrit**
- class **net.minecraft.client.particle.ParticleDigging$Factory**
- class **net.minecraft.client.particle.ParticleDigging**
- class **net.minecraft.client.particle.ParticleDragonBreath$Factory**
- class **net.minecraft.client.particle.ParticleDragonBreath**
- class **net.minecraft.client.particle.ParticleDrip$LavaFactory**
- class **net.minecraft.client.particle.ParticleDrip$WaterFactory**
- class **net.minecraft.client.particle.ParticleDrip**
- class **net.minecraft.client.particle.ParticleEmitter**
- class **net.minecraft.client.particle.ParticleEnchantmentTable$EnchantmentTable**
- class **net.minecraft.client.particle.ParticleEnchantmentTable**
- class **net.minecraft.client.particle.ParticleEndRod$Factory**
- class **net.minecraft.client.particle.ParticleEndRod**
- class **net.minecraft.client.particle.ParticleExplosion$Factory**
- class **net.minecraft.client.particle.ParticleExplosion**
- class **net.minecraft.client.particle.ParticleExplosionHuge$Factory**
- class **net.minecraft.client.particle.ParticleExplosionHuge**
- class **net.minecraft.client.particle.ParticleExplosionLarge$Factory**
- class **net.minecraft.client.particle.ParticleExplosionLarge**
- class **net.minecraft.client.particle.ParticleFallingDust$Factory**
- class **net.minecraft.client.particle.ParticleFallingDust**
- class **net.minecraft.client.particle.ParticleFirework$Factory**
- class **net.minecraft.client.particle.ParticleFirework$Overlay**
- class **net.minecraft.client.particle.ParticleFirework$Spark**
- class **net.minecraft.client.particle.ParticleFirework$Starter**
- class **net.minecraft.client.particle.ParticleFirework**
- class **net.minecraft.client.particle.ParticleFlame$Factory**
- class **net.minecraft.client.particle.ParticleFlame**
- class **net.minecraft.client.particle.ParticleFootStep$Factory**
- class **net.minecraft.client.particle.ParticleFootStep**
- class **net.minecraft.client.particle.ParticleHeart$AngryVillagerFactory**
- class **net.minecraft.client.particle.ParticleHeart$Factory**
- class **net.minecraft.client.particle.ParticleHeart**
- class **net.minecraft.client.particle.ParticleItemPickup**
- class **net.minecraft.client.particle.ParticleLava$Factory**
- class **net.minecraft.client.particle.ParticleLava**
- class **net.minecraft.client.particle.ParticleManager**
- class **net.minecraft.client.particle.ParticleMobAppearance$Factory**
- class **net.minecraft.client.particle.ParticleMobAppearance**
- class **net.minecraft.client.particle.ParticleNote$Factory**
- class **net.minecraft.client.particle.ParticleNote**
- class **net.minecraft.client.particle.ParticlePortal$Factory**
- class **net.minecraft.client.particle.ParticlePortal**
- class **net.minecraft.client.particle.ParticleRain$Factory**
- class **net.minecraft.client.particle.ParticleRain**
- class **net.minecraft.client.particle.ParticleRedstone$Factory**
- class **net.minecraft.client.particle.ParticleRedstone**
- class **net.minecraft.client.particle.ParticleSimpleAnimated**
- class **net.minecraft.client.particle.ParticleSmokeLarge$Factory**
- class **net.minecraft.client.particle.ParticleSmokeLarge**
- class **net.minecraft.client.particle.ParticleSmokeNormal$Factory**
- class **net.minecraft.client.particle.ParticleSmokeNormal**
- class **net.minecraft.client.particle.ParticleSnowShovel$Factory**
- class **net.minecraft.client.particle.ParticleSnowShovel**
- class **net.minecraft.client.particle.ParticleSpell$AmbientMobFactory**
- class **net.minecraft.client.particle.ParticleSpell$Factory**
- class **net.minecraft.client.particle.ParticleSpell$InstantFactory**
- class **net.minecraft.client.particle.ParticleSpell$MobFactory**
- class **net.minecraft.client.particle.ParticleSpell$WitchFactory**
- class **net.minecraft.client.particle.ParticleSpell**
- class **net.minecraft.client.particle.ParticleSpit$Factory**
- class **net.minecraft.client.particle.ParticleSpit**
- class **net.minecraft.client.particle.ParticleSplash$Factory**
- class **net.minecraft.client.particle.ParticleSplash**
- class **net.minecraft.client.particle.ParticleSuspend$Factory**
- class **net.minecraft.client.particle.ParticleSuspend**
- class **net.minecraft.client.particle.ParticleSuspendedTown$Factory**
- class **net.minecraft.client.particle.ParticleSuspendedTown$HappyVillagerFactory**
- class **net.minecraft.client.particle.ParticleSuspendedTown**
- class **net.minecraft.client.particle.ParticleSweepAttack$Factory**
- class **net.minecraft.client.particle.ParticleSweepAttack**
- class **net.minecraft.client.particle.ParticleTotem$Factory**
- class **net.minecraft.client.particle.ParticleTotem**
- class **net.minecraft.client.particle.ParticleWaterWake$Factory**
- class **net.minecraft.client.particle.ParticleWaterWake**
- class **net.minecraft.client.player.inventory.ContainerLocalMenu**
- class **net.minecraft.client.player.inventory.LocalBlockIntercommunication**
- class **net.minecraft.client.renderer.ActiveRenderInfo**
- class **net.minecraft.client.renderer.BannerTextures$Cache**
- class **net.minecraft.client.renderer.BannerTextures**
- class **net.minecraft.client.renderer.BlockFluidRenderer**
- enum **net.minecraft.client.renderer.BlockModelRenderer$EnumNeighborInfo**
- enum **net.minecraft.client.renderer.BlockModelRenderer$Orientation**
- class **net.minecraft.client.renderer.BlockModelRenderer**
- class **net.minecraft.client.renderer.BlockModelShapes**
- class **net.minecraft.client.renderer.BlockRendererDispatcher**
- class **net.minecraft.client.renderer.ChestRenderer**
- class **net.minecraft.client.renderer.ChunkRenderContainer**
- class **net.minecraft.client.renderer.DestroyBlockProgress**
- class **net.minecraft.client.renderer.EntityRenderer**
- class **net.minecraft.client.renderer.EnumFaceDirection$Constants**
- class **net.minecraft.client.renderer.EnumFaceDirection$VertexInformation**
- enum **net.minecraft.client.renderer.EnumFaceDirection**
- class **net.minecraft.client.renderer.GLAllocation**
- enum **net.minecraft.client.renderer.GlStateManager$CullFace**
- enum **net.minecraft.client.renderer.GlStateManager$DestFactor**
- enum **net.minecraft.client.renderer.GlStateManager$FogMode**
- enum **net.minecraft.client.renderer.GlStateManager$LogicOp**
- enum **net.minecraft.client.renderer.GlStateManager$Profile**
- enum **net.minecraft.client.renderer.GlStateManager$SourceFactor**
- enum **net.minecraft.client.renderer.GlStateManager$TexGen**
- class **net.minecraft.client.renderer.GlStateManager**
- interface **net.minecraft.client.renderer.IImageBuffer**
- class **net.minecraft.client.renderer.ImageBufferDownload**
- class **net.minecraft.client.renderer.InventoryEffectRenderer**
- interface **net.minecraft.client.renderer.ItemMeshDefinition**
- class **net.minecraft.client.renderer.ItemModelMesher**
- class **net.minecraft.client.renderer.ItemRenderer**
- class **net.minecraft.client.renderer.Matrix4f**
- class **net.minecraft.client.renderer.OpenGlHelper**
- class **net.minecraft.client.renderer.RegionRenderCacheBuilder**
- class **net.minecraft.client.renderer.RenderGlobal**
- class **net.minecraft.client.renderer.RenderHelper**
- class **net.minecraft.client.renderer.RenderItem**
- class **net.minecraft.client.renderer.RenderList**
- class **net.minecraft.client.renderer.StitcherException**
- class **net.minecraft.client.renderer.Tessellator**
- class **net.minecraft.client.renderer.ThreadDownloadImageData**
- class **net.minecraft.client.renderer.VboRenderList**
- class **net.minecraft.client.renderer.Vector3d**
- class **net.minecraft.client.renderer.VertexBuffer**
- class **net.minecraft.client.renderer.VertexBufferUploader**
- class **net.minecraft.client.renderer.ViewFrustum**
- class **net.minecraft.client.renderer.WorldVertexBufferUploader**
- class **net.minecraft.client.renderer.block.model.BakedQuad**
- class **net.minecraft.client.renderer.block.model.BakedQuadRetextured**
- class **net.minecraft.client.renderer.block.model.BlockFaceUV**
- class **net.minecraft.client.renderer.block.model.BlockPart**
- class **net.minecraft.client.renderer.block.model.BlockPartFace**
- class **net.minecraft.client.renderer.block.model.BlockPartRotation**
- class **net.minecraft.client.renderer.block.model.BuiltInModel**
- class **net.minecraft.client.renderer.block.model.FaceBakery**
- interface **net.minecraft.client.renderer.block.model.IBakedModel**
- enum **net.minecraft.client.renderer.block.model.ItemCameraTransforms$TransformType**
- class **net.minecraft.client.renderer.block.model.ItemCameraTransforms**
- class **net.minecraft.client.renderer.block.model.ItemModelGenerator**
- class **net.minecraft.client.renderer.block.model.ItemOverride**
- class **net.minecraft.client.renderer.block.model.ItemOverrideList**
- class **net.minecraft.client.renderer.block.model.ItemTransformVec3f**
- class **net.minecraft.client.renderer.block.model.ModelBakery**
- class **net.minecraft.client.renderer.block.model.ModelBlock$Deserializer**
- class **net.minecraft.client.renderer.block.model.ModelBlock$LoopException**
- class **net.minecraft.client.renderer.block.model.ModelBlock**
- class **net.minecraft.client.renderer.block.model.ModelBlockDefinition$Deserializer**
- class **net.minecraft.client.renderer.block.model.ModelBlockDefinition**
- class **net.minecraft.client.renderer.block.model.ModelManager**
- class **net.minecraft.client.renderer.block.model.ModelResourceLocation**
- enum **net.minecraft.client.renderer.block.model.ModelRotation**
- class **net.minecraft.client.renderer.block.model.MultipartBakedModel$Builder**
- class **net.minecraft.client.renderer.block.model.MultipartBakedModel**
- class **net.minecraft.client.renderer.block.model.SimpleBakedModel$Builder**
- class **net.minecraft.client.renderer.block.model.SimpleBakedModel**
- class **net.minecraft.client.renderer.block.model.Variant$Deserializer**
- class **net.minecraft.client.renderer.block.model.Variant**
- class **net.minecraft.client.renderer.block.model.VariantList$Deserializer**
- class **net.minecraft.client.renderer.block.model.VariantList**
- class **net.minecraft.client.renderer.block.model.WeightedBakedModel$Builder**
- class **net.minecraft.client.renderer.block.model.WeightedBakedModel**
- class **net.minecraft.client.renderer.block.model.multipart.ConditionAnd**
- class **net.minecraft.client.renderer.block.model.multipart.ConditionOr**
- class **net.minecraft.client.renderer.block.model.multipart.ConditionPropertyValue**
- interface **net.minecraft.client.renderer.block.model.multipart.ICondition**
- class **net.minecraft.client.renderer.block.model.multipart.Multipart$Deserializer**
- class **net.minecraft.client.renderer.block.model.multipart.Multipart**
- class **net.minecraft.client.renderer.block.model.multipart.Selector$Deserializer**
- class **net.minecraft.client.renderer.block.model.multipart.Selector**
- class **net.minecraft.client.renderer.block.statemap.BlockStateMapper**
- class **net.minecraft.client.renderer.block.statemap.DefaultStateMapper**
- interface **net.minecraft.client.renderer.block.statemap.IStateMapper**
- class **net.minecraft.client.renderer.block.statemap.StateMap$Builder**
- class **net.minecraft.client.renderer.block.statemap.StateMap**
- class **net.minecraft.client.renderer.block.statemap.StateMapperBase**
- enum **net.minecraft.client.renderer.chunk.ChunkCompileTaskGenerator$Status**
- enum **net.minecraft.client.renderer.chunk.ChunkCompileTaskGenerator$Type**
- class **net.minecraft.client.renderer.chunk.ChunkCompileTaskGenerator**
- class **net.minecraft.client.renderer.chunk.ChunkRenderDispatcher**
- class **net.minecraft.client.renderer.chunk.ChunkRenderWorker**
- class **net.minecraft.client.renderer.chunk.CompiledChunk**
- interface **net.minecraft.client.renderer.chunk.IRenderChunkFactory**
- class **net.minecraft.client.renderer.chunk.ListChunkFactory**
- class **net.minecraft.client.renderer.chunk.ListedRenderChunk**
- class **net.minecraft.client.renderer.chunk.RenderChunk**
- class **net.minecraft.client.renderer.chunk.SetVisibility**
- class **net.minecraft.client.renderer.chunk.VboChunkFactory**
- class **net.minecraft.client.renderer.chunk.VisGraph**
- class **net.minecraft.client.renderer.color.BlockColors**
- interface **net.minecraft.client.renderer.color.IBlockColor**
- interface **net.minecraft.client.renderer.color.IItemColor**
- class **net.minecraft.client.renderer.color.ItemColors**
- class **net.minecraft.client.renderer.culling.ClippingHelper**
- class **net.minecraft.client.renderer.culling.ClippingHelperImpl**
- class **net.minecraft.client.renderer.culling.Frustum**
- interface **net.minecraft.client.renderer.culling.ICamera**
- interface **net.minecraft.client.renderer.debug.DebugRenderer$IDebugRenderer**
- class **net.minecraft.client.renderer.debug.DebugRenderer**
- class **net.minecraft.client.renderer.debug.DebugRendererChunkBorder**
- class **net.minecraft.client.renderer.debug.DebugRendererCollisionBox**
- class **net.minecraft.client.renderer.debug.DebugRendererHeightMap**
- class **net.minecraft.client.renderer.debug.DebugRendererNeighborsUpdate**
- class **net.minecraft.client.renderer.debug.DebugRendererPathfinding**
- class **net.minecraft.client.renderer.debug.DebugRendererWater**
- class **net.minecraft.client.renderer.entity.Render**
- class **net.minecraft.client.renderer.entity.RenderAbstractHorse**
- class **net.minecraft.client.renderer.entity.RenderAreaEffectCloud**
- class **net.minecraft.client.renderer.entity.RenderArmorStand**
- class **net.minecraft.client.renderer.entity.RenderArrow**
- class **net.minecraft.client.renderer.entity.RenderBat**
- class **net.minecraft.client.renderer.entity.RenderBiped**
- class **net.minecraft.client.renderer.entity.RenderBlaze**
- class **net.minecraft.client.renderer.entity.RenderBoat**
- class **net.minecraft.client.renderer.entity.RenderCaveSpider**
- class **net.minecraft.client.renderer.entity.RenderChicken**
- class **net.minecraft.client.renderer.entity.RenderCow**
- class **net.minecraft.client.renderer.entity.RenderCreeper**
- class **net.minecraft.client.renderer.entity.RenderDragon**
- class **net.minecraft.client.renderer.entity.RenderDragonFireball**
- class **net.minecraft.client.renderer.entity.RenderElderGuardian**
- class **net.minecraft.client.renderer.entity.RenderEnderman**
- class **net.minecraft.client.renderer.entity.RenderEndermite**
- class **net.minecraft.client.renderer.entity.RenderEntity**
- class **net.minecraft.client.renderer.entity.RenderEntityItem**
- class **net.minecraft.client.renderer.entity.RenderEvoker**
- class **net.minecraft.client.renderer.entity.RenderEvokerFangs**
- class **net.minecraft.client.renderer.entity.RenderFallingBlock**
- class **net.minecraft.client.renderer.entity.RenderFireball**
- class **net.minecraft.client.renderer.entity.RenderFish**
- class **net.minecraft.client.renderer.entity.RenderGhast**
- class **net.minecraft.client.renderer.entity.RenderGiantZombie**
- class **net.minecraft.client.renderer.entity.RenderGuardian**
- class **net.minecraft.client.renderer.entity.RenderHorse**
- class **net.minecraft.client.renderer.entity.RenderHusk**
- class **net.minecraft.client.renderer.entity.RenderIronGolem**
- class **net.minecraft.client.renderer.entity.RenderLeashKnot**
- class **net.minecraft.client.renderer.entity.RenderLightningBolt**
- class **net.minecraft.client.renderer.entity.RenderLiving**
- class **net.minecraft.client.renderer.entity.RenderLivingBase**
- class **net.minecraft.client.renderer.entity.RenderLlama**
- class **net.minecraft.client.renderer.entity.RenderLlamaSpit**
- class **net.minecraft.client.renderer.entity.RenderMagmaCube**
- class **net.minecraft.client.renderer.entity.RenderManager**
- class **net.minecraft.client.renderer.entity.RenderMinecart**
- class **net.minecraft.client.renderer.entity.RenderMinecartMobSpawner**
- class **net.minecraft.client.renderer.entity.RenderMooshroom**
- class **net.minecraft.client.renderer.entity.RenderOcelot**
- class **net.minecraft.client.renderer.entity.RenderPainting**
- class **net.minecraft.client.renderer.entity.RenderPig**
- class **net.minecraft.client.renderer.entity.RenderPigZombie**
- class **net.minecraft.client.renderer.entity.RenderPlayer**
- class **net.minecraft.client.renderer.entity.RenderPolarBear**
- class **net.minecraft.client.renderer.entity.RenderPotion**
- class **net.minecraft.client.renderer.entity.RenderRabbit**
- class **net.minecraft.client.renderer.entity.RenderSheep**
- class **net.minecraft.client.renderer.entity.RenderShulker**
- class **net.minecraft.client.renderer.entity.RenderShulkerBullet**
- class **net.minecraft.client.renderer.entity.RenderSilverfish**
- class **net.minecraft.client.renderer.entity.RenderSkeleton**
- class **net.minecraft.client.renderer.entity.RenderSlime**
- class **net.minecraft.client.renderer.entity.RenderSnowMan**
- class **net.minecraft.client.renderer.entity.RenderSnowball**
- class **net.minecraft.client.renderer.entity.RenderSpectralArrow**
- class **net.minecraft.client.renderer.entity.RenderSpider**
- class **net.minecraft.client.renderer.entity.RenderSquid**
- class **net.minecraft.client.renderer.entity.RenderStray**
- class **net.minecraft.client.renderer.entity.RenderTNTPrimed**
- class **net.minecraft.client.renderer.entity.RenderTippedArrow**
- class **net.minecraft.client.renderer.entity.RenderTntMinecart**
- class **net.minecraft.client.renderer.entity.RenderVex**
- class **net.minecraft.client.renderer.entity.RenderVillager**
- class **net.minecraft.client.renderer.entity.RenderVindicator**
- class **net.minecraft.client.renderer.entity.RenderWitch**
- class **net.minecraft.client.renderer.entity.RenderWither**
- class **net.minecraft.client.renderer.entity.RenderWitherSkeleton**
- class **net.minecraft.client.renderer.entity.RenderWolf**
- class **net.minecraft.client.renderer.entity.RenderXPOrb**
- class **net.minecraft.client.renderer.entity.RenderZombie**
- class **net.minecraft.client.renderer.entity.RenderZombieVillager**
- class **net.minecraft.client.renderer.entity.layers.LayerArmorBase**
- class **net.minecraft.client.renderer.entity.layers.LayerArrow**
- class **net.minecraft.client.renderer.entity.layers.LayerBipedArmor**
- class **net.minecraft.client.renderer.entity.layers.LayerCape**
- class **net.minecraft.client.renderer.entity.layers.LayerCreeperCharge**
- class **net.minecraft.client.renderer.entity.layers.LayerCustomHead**
- class **net.minecraft.client.renderer.entity.layers.LayerDeadmau5Head**
- class **net.minecraft.client.renderer.entity.layers.LayerElytra**
- class **net.minecraft.client.renderer.entity.layers.LayerEnderDragonDeath**
- class **net.minecraft.client.renderer.entity.layers.LayerEnderDragonEyes**
- class **net.minecraft.client.renderer.entity.layers.LayerEndermanEyes**
- class **net.minecraft.client.renderer.entity.layers.LayerHeldBlock**
- class **net.minecraft.client.renderer.entity.layers.LayerHeldItem**
- class **net.minecraft.client.renderer.entity.layers.LayerHeldItemWitch**
- class **net.minecraft.client.renderer.entity.layers.LayerIronGolemFlower**
- class **net.minecraft.client.renderer.entity.layers.LayerLlamaDecor**
- class **net.minecraft.client.renderer.entity.layers.LayerMooshroomMushroom**
- interface **net.minecraft.client.renderer.entity.layers.LayerRenderer**
- class **net.minecraft.client.renderer.entity.layers.LayerSaddle**
- class **net.minecraft.client.renderer.entity.layers.LayerSheepWool**
- class **net.minecraft.client.renderer.entity.layers.LayerSlimeGel**
- class **net.minecraft.client.renderer.entity.layers.LayerSnowmanHead**
- class **net.minecraft.client.renderer.entity.layers.LayerSpiderEyes**
- class **net.minecraft.client.renderer.entity.layers.LayerStrayClothing**
- class **net.minecraft.client.renderer.entity.layers.LayerVillagerArmor**
- class **net.minecraft.client.renderer.entity.layers.LayerWitherAura**
- class **net.minecraft.client.renderer.entity.layers.LayerWolfCollar**
- class **net.minecraft.client.renderer.texture.AbstractTexture**
- class **net.minecraft.client.renderer.texture.DynamicTexture**
- interface **net.minecraft.client.renderer.texture.ITextureMapPopulator**
- interface **net.minecraft.client.renderer.texture.ITextureObject**
- interface **net.minecraft.client.renderer.texture.ITickable**
- interface **net.minecraft.client.renderer.texture.ITickableTextureObject**
- class **net.minecraft.client.renderer.texture.LayeredColorMaskTexture**
- class **net.minecraft.client.renderer.texture.LayeredTexture**
- class **net.minecraft.client.renderer.texture.PngSizeInfo**
- class **net.minecraft.client.renderer.texture.SimpleTexture**
- class **net.minecraft.client.renderer.texture.Stitcher$Holder**
- class **net.minecraft.client.renderer.texture.Stitcher$Slot**
- class **net.minecraft.client.renderer.texture.Stitcher**
- class **net.minecraft.client.renderer.texture.TextureAtlasSprite**
- class **net.minecraft.client.renderer.texture.TextureManager**
- class **net.minecraft.client.renderer.texture.TextureMap**
- class **net.minecraft.client.renderer.texture.TextureUtil**
- class **net.minecraft.client.renderer.tileentity.RenderEnderCrystal**
- class **net.minecraft.client.renderer.tileentity.RenderItemFrame**
- class **net.minecraft.client.renderer.tileentity.RenderWitherSkull**
- class **net.minecraft.client.renderer.tileentity.TileEntityBannerRenderer**
- class **net.minecraft.client.renderer.tileentity.TileEntityBeaconRenderer**
- class **net.minecraft.client.renderer.tileentity.TileEntityChestRenderer**
- class **net.minecraft.client.renderer.tileentity.TileEntityEnchantmentTableRenderer**
- class **net.minecraft.client.renderer.tileentity.TileEntityEndGatewayRenderer**
- class **net.minecraft.client.renderer.tileentity.TileEntityEndPortalRenderer**
- class **net.minecraft.client.renderer.tileentity.TileEntityEnderChestRenderer**
- class **net.minecraft.client.renderer.tileentity.TileEntityItemStackRenderer**
- class **net.minecraft.client.renderer.tileentity.TileEntityMobSpawnerRenderer**
- class **net.minecraft.client.renderer.tileentity.TileEntityPistonRenderer**
- class **net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher**
- class **net.minecraft.client.renderer.tileentity.TileEntityShulkerBoxRenderer**
- class **net.minecraft.client.renderer.tileentity.TileEntitySignRenderer**
- class **net.minecraft.client.renderer.tileentity.TileEntitySkullRenderer**
- class **net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer**
- class **net.minecraft.client.renderer.tileentity.TileEntityStructureRenderer**
- class **net.minecraft.client.renderer.vertex.DefaultVertexFormats**
- class **net.minecraft.client.renderer.vertex.VertexBuffer**
- class **net.minecraft.client.renderer.vertex.VertexFormat**
- enum **net.minecraft.client.renderer.vertex.VertexFormatElement$EnumType**
- enum **net.minecraft.client.renderer.vertex.VertexFormatElement$EnumUsage**
- class **net.minecraft.client.renderer.vertex.VertexFormatElement**
- class **net.minecraft.client.resources.AbstractResourcePack**
- class **net.minecraft.client.resources.DefaultPlayerSkin**
- class **net.minecraft.client.resources.DefaultResourcePack**
- class **net.minecraft.client.resources.FallbackResourceManager**
- class **net.minecraft.client.resources.FileResourcePack**
- class **net.minecraft.client.resources.FolderResourcePack**
- class **net.minecraft.client.resources.FoliageColorReloadListener**
- class **net.minecraft.client.resources.GrassColorReloadListener**
- class **net.minecraft.client.resources.I18n**
- interface **net.minecraft.client.resources.IReloadableResourceManager**
- interface **net.minecraft.client.resources.IResource**
- interface **net.minecraft.client.resources.IResourceManager**
- interface **net.minecraft.client.resources.IResourceManagerReloadListener**
- interface **net.minecraft.client.resources.IResourcePack**
- class **net.minecraft.client.resources.Language**
- class **net.minecraft.client.resources.LanguageManager**
- class **net.minecraft.client.resources.LegacyV2Adapter**
- class **net.minecraft.client.resources.Locale**
- class **net.minecraft.client.resources.ResourceIndex**
- class **net.minecraft.client.resources.ResourceIndexFolder**
- class **net.minecraft.client.resources.ResourcePackFileNotFoundException**
- class **net.minecraft.client.resources.ResourcePackListEntry**
- class **net.minecraft.client.resources.ResourcePackListEntryDefault**
- class **net.minecraft.client.resources.ResourcePackListEntryFound**
- class **net.minecraft.client.resources.ResourcePackListEntryServer**
- class **net.minecraft.client.resources.ResourcePackRepository**
- class **net.minecraft.client.resources.SimpleReloadableResourceManager**
- class **net.minecraft.client.resources.SimpleResource**
- interface **net.minecraft.client.resources.SkinManager$SkinAvailableCallback**
- class **net.minecraft.client.resources.SkinManager**
- class **net.minecraft.client.resources.data.AnimationFrame**
- class **net.minecraft.client.resources.data.AnimationMetadataSection**
- class **net.minecraft.client.resources.data.AnimationMetadataSectionSerializer**
- class **net.minecraft.client.resources.data.BaseMetadataSectionSerializer**
- class **net.minecraft.client.resources.data.FontMetadataSection**
- class **net.minecraft.client.resources.data.FontMetadataSectionSerializer**
- interface **net.minecraft.client.resources.data.IMetadataSection**
- interface **net.minecraft.client.resources.data.IMetadataSectionSerializer**
- class **net.minecraft.client.resources.data.LanguageMetadataSection**
- class **net.minecraft.client.resources.data.LanguageMetadataSectionSerializer**
- class **net.minecraft.client.resources.data.MetadataSerializer**
- class **net.minecraft.client.resources.data.PackMetadataSection**
- class **net.minecraft.client.resources.data.PackMetadataSectionSerializer**
- class **net.minecraft.client.resources.data.TextureMetadataSection**
- class **net.minecraft.client.resources.data.TextureMetadataSectionSerializer**
- enum **net.minecraft.client.settings.GameSettings$Options**
- class **net.minecraft.client.settings.GameSettings**
- class **net.minecraft.client.settings.KeyBinding**
- class **net.minecraft.client.shader.Framebuffer**
- class **net.minecraft.client.shader.Shader**
- class **net.minecraft.client.shader.ShaderDefault**
- class **net.minecraft.client.shader.ShaderGroup**
- class **net.minecraft.client.shader.ShaderLinkHelper**
- enum **net.minecraft.client.shader.ShaderLoader$ShaderType**
- class **net.minecraft.client.shader.ShaderLoader**
- class **net.minecraft.client.shader.ShaderManager**
- class **net.minecraft.client.shader.ShaderUniform**
- class **net.minecraft.client.util.JsonBlendingMode**
- class **net.minecraft.client.util.JsonException$Entry**
- class **net.minecraft.client.util.JsonException**
- class **net.minecraft.command.CommandBase$CoordinateArg**
- class **net.minecraft.command.CommandBase**
- class **net.minecraft.command.CommandBlockData**
- class **net.minecraft.command.CommandClearInventory**
- class **net.minecraft.command.CommandClone**
- class **net.minecraft.command.CommandCompare**
- class **net.minecraft.command.CommandDebug**
- class **net.minecraft.command.CommandDefaultGameMode**
- class **net.minecraft.command.CommandDifficulty**
- class **net.minecraft.command.CommandEffect**
- class **net.minecraft.command.CommandEnchant**
- class **net.minecraft.command.CommandEntityData**
- class **net.minecraft.command.CommandException**
- class **net.minecraft.command.CommandExecuteAt**
- class **net.minecraft.command.CommandFill**
- class **net.minecraft.command.CommandGameMode**
- class **net.minecraft.command.CommandGameRule**
- class **net.minecraft.command.CommandGive**
- class **net.minecraft.command.CommandHandler**
- class **net.minecraft.command.CommandHelp**
- class **net.minecraft.command.CommandKill**
- class **net.minecraft.command.CommandLocate**
- class **net.minecraft.command.CommandNotFoundException**
- class **net.minecraft.command.CommandParticle**
- class **net.minecraft.command.CommandPlaySound**
- class **net.minecraft.command.CommandReplaceItem**
- enum **net.minecraft.command.CommandResultStats$Type**
- class **net.minecraft.command.CommandResultStats**
- class **net.minecraft.command.CommandServerKick**
- class **net.minecraft.command.CommandSetPlayerTimeout**
- class **net.minecraft.command.CommandSetSpawnpoint**
- class **net.minecraft.command.CommandShowSeed**
- class **net.minecraft.command.CommandSpreadPlayers**
- class **net.minecraft.command.CommandStats**
- class **net.minecraft.command.CommandStopSound**
- class **net.minecraft.command.CommandTP**
- class **net.minecraft.command.CommandTime**
- class **net.minecraft.command.CommandTitle**
- class **net.minecraft.command.CommandToggleDownfall**
- class **net.minecraft.command.CommandTrigger**
- class **net.minecraft.command.CommandWeather**
- class **net.minecraft.command.CommandWorldBorder**
- class **net.minecraft.command.CommandXP**
- class **net.minecraft.command.EntityNotFoundException**
- class **net.minecraft.command.EntitySelector**
- interface **net.minecraft.command.ICommand**
- interface **net.minecraft.command.ICommandListener**
- interface **net.minecraft.command.ICommandManager**
- interface **net.minecraft.command.ICommandSender**
- class **net.minecraft.command.InvalidBlockStateException**
- class **net.minecraft.command.NumberInvalidException**
- class **net.minecraft.command.PlayerNotFoundException**
- class **net.minecraft.command.ServerCommandManager**
- class **net.minecraft.command.SyntaxErrorException**
- class **net.minecraft.command.WrongUsageException**
- class **net.minecraft.command.server.CommandAchievement**
- class **net.minecraft.command.server.CommandBanIp**
- class **net.minecraft.command.server.CommandBanPlayer**
- class **net.minecraft.command.server.CommandBroadcast**
- class **net.minecraft.command.server.CommandDeOp**
- class **net.minecraft.command.server.CommandEmote**
- class **net.minecraft.command.server.CommandListBans**
- class **net.minecraft.command.server.CommandListPlayers**
- class **net.minecraft.command.server.CommandMessage**
- class **net.minecraft.command.server.CommandMessageRaw**
- class **net.minecraft.command.server.CommandOp**
- class **net.minecraft.command.server.CommandPardonIp**
- class **net.minecraft.command.server.CommandPardonPlayer**
- class **net.minecraft.command.server.CommandPublishLocalServer**
- class **net.minecraft.command.server.CommandSaveAll**
- class **net.minecraft.command.server.CommandSaveOff**
- class **net.minecraft.command.server.CommandSaveOn**
- class **net.minecraft.command.server.CommandScoreboard**
- class **net.minecraft.command.server.CommandSetBlock**
- class **net.minecraft.command.server.CommandSetDefaultSpawnpoint**
- class **net.minecraft.command.server.CommandStop**
- class **net.minecraft.command.server.CommandSummon**
- class **net.minecraft.command.server.CommandTeleport**
- class **net.minecraft.command.server.CommandTestFor**
- class **net.minecraft.command.server.CommandTestForBlock**
- class **net.minecraft.command.server.CommandWhitelist**
- class **net.minecraft.crash.CrashReport**
- class **net.minecraft.crash.CrashReportCategory**
- interface **net.minecraft.crash.ICrashReportDetail**
- class **net.minecraft.creativetab.CreativeTabs**
- class **net.minecraft.dispenser.BehaviorDefaultDispenseItem**
- class **net.minecraft.dispenser.BehaviorProjectileDispense**
- interface **net.minecraft.dispenser.IBehaviorDispenseItem**
- interface **net.minecraft.dispenser.IBlockSource**
- interface **net.minecraft.dispenser.ILocatableSource**
- interface **net.minecraft.dispenser.ILocation**
- interface **net.minecraft.dispenser.IPosition**
- class **net.minecraft.dispenser.PositionImpl**
- enum **net.minecraft.enchantment.Enchantment$Rarity**
- class **net.minecraft.enchantment.Enchantment**
- class **net.minecraft.enchantment.EnchantmentArrowDamage**
- class **net.minecraft.enchantment.EnchantmentArrowFire**
- class **net.minecraft.enchantment.EnchantmentArrowInfinite**
- class **net.minecraft.enchantment.EnchantmentArrowKnockback**
- class **net.minecraft.enchantment.EnchantmentBindingCurse**
- class **net.minecraft.enchantment.EnchantmentDamage**
- class **net.minecraft.enchantment.EnchantmentData**
- class **net.minecraft.enchantment.EnchantmentDigging**
- class **net.minecraft.enchantment.EnchantmentDurability**
- class **net.minecraft.enchantment.EnchantmentFireAspect**
- class **net.minecraft.enchantment.EnchantmentFishingSpeed**
- class **net.minecraft.enchantment.EnchantmentFrostWalker**
- class **net.minecraft.enchantment.EnchantmentHelper**
- class **net.minecraft.enchantment.EnchantmentKnockback**
- class **net.minecraft.enchantment.EnchantmentLootBonus**
- class **net.minecraft.enchantment.EnchantmentMending**
- class **net.minecraft.enchantment.EnchantmentOxygen**
- enum **net.minecraft.enchantment.EnchantmentProtection$Type**
- class **net.minecraft.enchantment.EnchantmentProtection**
- class **net.minecraft.enchantment.EnchantmentSweepingEdge**
- class **net.minecraft.enchantment.EnchantmentThorns**
- class **net.minecraft.enchantment.EnchantmentUntouching**
- class **net.minecraft.enchantment.EnchantmentVanishingCurse**
- class **net.minecraft.enchantment.EnchantmentWaterWalker**
- class **net.minecraft.enchantment.EnchantmentWaterWorker**
- enum **net.minecraft.enchantment.EnumEnchantmentType**
- class **net.minecraft.entity.Entity**
- class **net.minecraft.entity.EntityAgeable**
- class **net.minecraft.entity.EntityAreaEffectCloud**
- class **net.minecraft.entity.EntityBodyHelper**
- class **net.minecraft.entity.EntityCreature**
- class **net.minecraft.entity.EntityFlying**
- class **net.minecraft.entity.EntityHanging**
- class **net.minecraft.entity.EntityLeashKnot**
- class **net.minecraft.entity.EntityList$EntityEggInfo**
- class **net.minecraft.entity.EntityList**
- enum **net.minecraft.entity.EntityLiving$SpawnPlacementType**
- class **net.minecraft.entity.EntityLiving**
- class **net.minecraft.entity.EntityLivingBase**
- class **net.minecraft.entity.EntitySpawnPlacementRegistry**
- class **net.minecraft.entity.EntityTracker**
- class **net.minecraft.entity.EntityTrackerEntry**
- enum **net.minecraft.entity.EnumCreatureAttribute**
- enum **net.minecraft.entity.EnumCreatureType**
- interface **net.minecraft.entity.IEntityLivingData**
- interface **net.minecraft.entity.IEntityMultiPart**
- interface **net.minecraft.entity.IEntityOwnable**
- interface **net.minecraft.entity.IJumpingMount**
- interface **net.minecraft.entity.IMerchant**
- interface **net.minecraft.entity.INpc**
- interface **net.minecraft.entity.IProjectile**
- interface **net.minecraft.entity.IRangedAttackMob**
- enum **net.minecraft.entity.MoverType**
- class **net.minecraft.entity.NpcMerchant**
- class **net.minecraft.entity.SharedMonsterAttributes**
- class **net.minecraft.entity.ai.EntityAIAttackMelee**
- class **net.minecraft.entity.ai.EntityAIAttackRanged**
- class **net.minecraft.entity.ai.EntityAIAttackRangedBow**
- class **net.minecraft.entity.ai.EntityAIAvoidEntity**
- class **net.minecraft.entity.ai.EntityAIBase**
- class **net.minecraft.entity.ai.EntityAIBeg**
- class **net.minecraft.entity.ai.EntityAIBreakDoor**
- class **net.minecraft.entity.ai.EntityAICreeperSwell**
- class **net.minecraft.entity.ai.EntityAIDefendVillage**
- class **net.minecraft.entity.ai.EntityAIDoorInteract**
- class **net.minecraft.entity.ai.EntityAIEatGrass**
- class **net.minecraft.entity.ai.EntityAIFindEntityNearest**
- class **net.minecraft.entity.ai.EntityAIFindEntityNearestPlayer**
- class **net.minecraft.entity.ai.EntityAIFleeSun**
- class **net.minecraft.entity.ai.EntityAIFollowGolem**
- class **net.minecraft.entity.ai.EntityAIFollowOwner**
- class **net.minecraft.entity.ai.EntityAIFollowParent**
- class **net.minecraft.entity.ai.EntityAIHarvestFarmland**
- class **net.minecraft.entity.ai.EntityAIHurtByTarget**
- class **net.minecraft.entity.ai.EntityAILeapAtTarget**
- class **net.minecraft.entity.ai.EntityAILlamaFollowCaravan**
- class **net.minecraft.entity.ai.EntityAILookAtTradePlayer**
- class **net.minecraft.entity.ai.EntityAILookAtVillager**
- class **net.minecraft.entity.ai.EntityAILookIdle**
- class **net.minecraft.entity.ai.EntityAIMate**
- class **net.minecraft.entity.ai.EntityAIMoveIndoors**
- class **net.minecraft.entity.ai.EntityAIMoveThroughVillage**
- class **net.minecraft.entity.ai.EntityAIMoveToBlock**
- class **net.minecraft.entity.ai.EntityAIMoveTowardsRestriction**
- class **net.minecraft.entity.ai.EntityAIMoveTowardsTarget**
- class **net.minecraft.entity.ai.EntityAINearestAttackableTarget$Sorter**
- class **net.minecraft.entity.ai.EntityAINearestAttackableTarget**
- class **net.minecraft.entity.ai.EntityAIOcelotAttack**
- class **net.minecraft.entity.ai.EntityAIOcelotSit**
- class **net.minecraft.entity.ai.EntityAIOpenDoor**
- class **net.minecraft.entity.ai.EntityAIOwnerHurtByTarget**
- class **net.minecraft.entity.ai.EntityAIOwnerHurtTarget**
- class **net.minecraft.entity.ai.EntityAIPanic**
- class **net.minecraft.entity.ai.EntityAIPlay**
- class **net.minecraft.entity.ai.EntityAIRestrictOpenDoor**
- class **net.minecraft.entity.ai.EntityAIRestrictSun**
- class **net.minecraft.entity.ai.EntityAIRunAroundLikeCrazy**
- class **net.minecraft.entity.ai.EntityAISit**
- class **net.minecraft.entity.ai.EntityAISkeletonRiders**
- class **net.minecraft.entity.ai.EntityAISwimming**
- class **net.minecraft.entity.ai.EntityAITarget**
- class **net.minecraft.entity.ai.EntityAITargetNonTamed**
- class **net.minecraft.entity.ai.EntityAITasks**
- class **net.minecraft.entity.ai.EntityAITempt**
- class **net.minecraft.entity.ai.EntityAITradePlayer**
- class **net.minecraft.entity.ai.EntityAIVillagerInteract**
- class **net.minecraft.entity.ai.EntityAIVillagerMate**
- class **net.minecraft.entity.ai.EntityAIWander**
- class **net.minecraft.entity.ai.EntityAIWanderAvoidWater**
- class **net.minecraft.entity.ai.EntityAIWatchClosest**
- class **net.minecraft.entity.ai.EntityAIWatchClosest2**
- class **net.minecraft.entity.ai.EntityAIZombieAttack**
- class **net.minecraft.entity.ai.EntityJumpHelper**
- class **net.minecraft.entity.ai.EntityLookHelper**
- enum **net.minecraft.entity.ai.EntityMoveHelper$Action**
- class **net.minecraft.entity.ai.EntityMoveHelper**
- class **net.minecraft.entity.ai.EntitySenses**
- class **net.minecraft.entity.ai.RandomPositionGenerator**
- class **net.minecraft.entity.ai.attributes.AbstractAttributeMap**
- class **net.minecraft.entity.ai.attributes.AttributeMap**
- class **net.minecraft.entity.ai.attributes.AttributeModifier**
- class **net.minecraft.entity.ai.attributes.BaseAttribute**
- interface **net.minecraft.entity.ai.attributes.IAttribute**
- interface **net.minecraft.entity.ai.attributes.IAttributeInstance**
- class **net.minecraft.entity.ai.attributes.ModifiableAttributeInstance**
- class **net.minecraft.entity.ai.attributes.RangedAttribute**
- class **net.minecraft.entity.boss.EntityDragon**
- class **net.minecraft.entity.boss.EntityDragonPart**
- class **net.minecraft.entity.boss.EntityWither**
- interface **net.minecraft.entity.boss.dragon.phase.IPhase**
- class **net.minecraft.entity.boss.dragon.phase.PhaseBase**
- class **net.minecraft.entity.boss.dragon.phase.PhaseChargingPlayer**
- class **net.minecraft.entity.boss.dragon.phase.PhaseDying**
- class **net.minecraft.entity.boss.dragon.phase.PhaseHoldingPattern**
- class **net.minecraft.entity.boss.dragon.phase.PhaseHover**
- class **net.minecraft.entity.boss.dragon.phase.PhaseLanding**
- class **net.minecraft.entity.boss.dragon.phase.PhaseLandingApproach**
- class **net.minecraft.entity.boss.dragon.phase.PhaseList**
- class **net.minecraft.entity.boss.dragon.phase.PhaseManager**
- class **net.minecraft.entity.boss.dragon.phase.PhaseSittingAttacking**
- class **net.minecraft.entity.boss.dragon.phase.PhaseSittingBase**
- class **net.minecraft.entity.boss.dragon.phase.PhaseSittingFlaming**
- class **net.minecraft.entity.boss.dragon.phase.PhaseSittingScanning**
- class **net.minecraft.entity.boss.dragon.phase.PhaseStrafePlayer**
- class **net.minecraft.entity.boss.dragon.phase.PhaseTakeoff**
- class **net.minecraft.entity.effect.EntityLightningBolt**
- class **net.minecraft.entity.effect.EntityWeatherEffect**
- class **net.minecraft.entity.item.EntityArmorStand**
- enum **net.minecraft.entity.item.EntityBoat$Status**
- enum **net.minecraft.entity.item.EntityBoat$Type**
- class **net.minecraft.entity.item.EntityBoat**
- class **net.minecraft.entity.item.EntityEnderCrystal**
- class **net.minecraft.entity.item.EntityEnderEye**
- class **net.minecraft.entity.item.EntityEnderPearl**
- class **net.minecraft.entity.item.EntityExpBottle**
- class **net.minecraft.entity.item.EntityFallingBlock**
- class **net.minecraft.entity.item.EntityFireworkRocket**
- class **net.minecraft.entity.item.EntityItem**
- class **net.minecraft.entity.item.EntityItemFrame**
- enum **net.minecraft.entity.item.EntityMinecart$Type**
- class **net.minecraft.entity.item.EntityMinecart**
- class **net.minecraft.entity.item.EntityMinecartChest**
- class **net.minecraft.entity.item.EntityMinecartCommandBlock**
- class **net.minecraft.entity.item.EntityMinecartContainer**
- class **net.minecraft.entity.item.EntityMinecartEmpty**
- class **net.minecraft.entity.item.EntityMinecartFurnace**
- class **net.minecraft.entity.item.EntityMinecartHopper**
- class **net.minecraft.entity.item.EntityMinecartMobSpawner**
- class **net.minecraft.entity.item.EntityMinecartTNT**
- enum **net.minecraft.entity.item.EntityPainting$EnumArt**
- class **net.minecraft.entity.item.EntityPainting**
- class **net.minecraft.entity.item.EntityTNTPrimed**
- class **net.minecraft.entity.item.EntityXPOrb**
- class **net.minecraft.entity.monster.AbstractSkeleton**
- class **net.minecraft.entity.monster.EntityBlaze**
- class **net.minecraft.entity.monster.EntityCaveSpider**
- class **net.minecraft.entity.monster.EntityCreeper**
- class **net.minecraft.entity.monster.EntityElderGuardian**
- class **net.minecraft.entity.monster.EntityEnderman**
- class **net.minecraft.entity.monster.EntityEndermite**
- class **net.minecraft.entity.monster.EntityEvoker**
- class **net.minecraft.entity.monster.EntityGhast**
- class **net.minecraft.entity.monster.EntityGiantZombie**
- class **net.minecraft.entity.monster.EntityGolem**
- class **net.minecraft.entity.monster.EntityGuardian**
- class **net.minecraft.entity.monster.EntityHusk**
- class **net.minecraft.entity.monster.EntityIronGolem**
- class **net.minecraft.entity.monster.EntityMagmaCube**
- class **net.minecraft.entity.monster.EntityMob**
- class **net.minecraft.entity.monster.EntityPigZombie**
- class **net.minecraft.entity.monster.EntityPolarBear**
- class **net.minecraft.entity.monster.EntityShulker**
- class **net.minecraft.entity.monster.EntitySilverfish**
- class **net.minecraft.entity.monster.EntitySkeleton**
- class **net.minecraft.entity.monster.EntitySlime**
- class **net.minecraft.entity.monster.EntitySnowman**
- class **net.minecraft.entity.monster.EntitySpider$GroupData**
- class **net.minecraft.entity.monster.EntitySpider**
- class **net.minecraft.entity.monster.EntityStray**
- class **net.minecraft.entity.monster.EntityVex**
- class **net.minecraft.entity.monster.EntityVindicator**
- class **net.minecraft.entity.monster.EntityWitch**
- class **net.minecraft.entity.monster.EntityWitherSkeleton**
- class **net.minecraft.entity.monster.EntityZombie**
- class **net.minecraft.entity.monster.EntityZombieVillager**
- interface **net.minecraft.entity.monster.IMob**
- class **net.minecraft.entity.passive.AbstractChestHorse**
- class **net.minecraft.entity.passive.AbstractHorse**
- class **net.minecraft.entity.passive.EntityAmbientCreature**
- class **net.minecraft.entity.passive.EntityAnimal**
- class **net.minecraft.entity.passive.EntityBat**
- class **net.minecraft.entity.passive.EntityChicken**
- class **net.minecraft.entity.passive.EntityCow**
- class **net.minecraft.entity.passive.EntityDonkey**
- class **net.minecraft.entity.passive.EntityHorse$GroupData**
- class **net.minecraft.entity.passive.EntityHorse**
- class **net.minecraft.entity.passive.EntityLlama**
- class **net.minecraft.entity.passive.EntityMooshroom**
- class **net.minecraft.entity.passive.EntityMule**
- class **net.minecraft.entity.passive.EntityOcelot**
- class **net.minecraft.entity.passive.EntityPig**
- class **net.minecraft.entity.passive.EntityRabbit$RabbitTypeData**
- class **net.minecraft.entity.passive.EntityRabbit**
- class **net.minecraft.entity.passive.EntitySheep**
- class **net.minecraft.entity.passive.EntitySkeletonHorse**
- class **net.minecraft.entity.passive.EntitySquid**
- class **net.minecraft.entity.passive.EntityTameable**
- class **net.minecraft.entity.passive.EntityVillager$EmeraldForItems**
- interface **net.minecraft.entity.passive.EntityVillager$ITradeList**
- class **net.minecraft.entity.passive.EntityVillager$ItemAndEmeraldToItem**
- class **net.minecraft.entity.passive.EntityVillager$ListEnchantedBookForEmeralds**
- class **net.minecraft.entity.passive.EntityVillager$ListEnchantedItemForEmeralds**
- class **net.minecraft.entity.passive.EntityVillager$ListItemForEmeralds**
- class **net.minecraft.entity.passive.EntityVillager$PriceInfo**
- class **net.minecraft.entity.passive.EntityVillager**
- class **net.minecraft.entity.passive.EntityWaterMob**
- class **net.minecraft.entity.passive.EntityWolf**
- class **net.minecraft.entity.passive.EntityZombieHorse**
- enum **net.minecraft.entity.passive.HorseArmorType**
- interface **net.minecraft.entity.passive.IAnimals**
- enum **net.minecraft.entity.player.EntityPlayer$EnumChatVisibility**
- enum **net.minecraft.entity.player.EntityPlayer$SleepResult**
- class **net.minecraft.entity.player.EntityPlayer**
- class **net.minecraft.entity.player.EntityPlayerMP**
- enum **net.minecraft.entity.player.EnumPlayerModelParts**
- class **net.minecraft.entity.player.InventoryPlayer**
- class **net.minecraft.entity.player.PlayerCapabilities**
- enum **net.minecraft.entity.projectile.EntityArrow$PickupStatus**
- class **net.minecraft.entity.projectile.EntityArrow**
- class **net.minecraft.entity.projectile.EntityDragonFireball**
- class **net.minecraft.entity.projectile.EntityEgg**
- class **net.minecraft.entity.projectile.EntityEvokerFangs**
- class **net.minecraft.entity.projectile.EntityFireball**
- class **net.minecraft.entity.projectile.EntityFishHook**
- class **net.minecraft.entity.projectile.EntityLargeFireball**
- class **net.minecraft.entity.projectile.EntityLlamaSpit**
- class **net.minecraft.entity.projectile.EntityPotion**
- class **net.minecraft.entity.projectile.EntityShulkerBullet**
- class **net.minecraft.entity.projectile.EntitySmallFireball**
- class **net.minecraft.entity.projectile.EntitySnowball**
- class **net.minecraft.entity.projectile.EntitySpectralArrow**
- class **net.minecraft.entity.projectile.EntityThrowable**
- class **net.minecraft.entity.projectile.EntityTippedArrow**
- class **net.minecraft.entity.projectile.EntityWitherSkull**
- class **net.minecraft.entity.projectile.ProjectileHelper**
- class **net.minecraft.init.Biomes**
- class **net.minecraft.init.Blocks**
- class **net.minecraft.init.Bootstrap$BehaviorDispenseBoat**
- class **net.minecraft.init.Bootstrap$BehaviorDispenseOptional**
- class **net.minecraft.init.Bootstrap**
- class **net.minecraft.init.Enchantments**
- class **net.minecraft.init.Items**
- class **net.minecraft.init.MobEffects**
- class **net.minecraft.init.PotionTypes**
- class **net.minecraft.init.SoundEvents**
- enum **net.minecraft.inventory.ClickType**
- class **net.minecraft.inventory.Container**
- class **net.minecraft.inventory.ContainerBeacon**
- class **net.minecraft.inventory.ContainerBrewingStand**
- class **net.minecraft.inventory.ContainerChest**
- class **net.minecraft.inventory.ContainerDispenser**
- class **net.minecraft.inventory.ContainerEnchantment**
- class **net.minecraft.inventory.ContainerFurnace**
- class **net.minecraft.inventory.ContainerHopper**
- class **net.minecraft.inventory.ContainerHorseChest**
- class **net.minecraft.inventory.ContainerHorseInventory**
- class **net.minecraft.inventory.ContainerMerchant**
- class **net.minecraft.inventory.ContainerPlayer**
- class **net.minecraft.inventory.ContainerRepair**
- class **net.minecraft.inventory.ContainerShulkerBox**
- class **net.minecraft.inventory.ContainerWorkbench**
- enum **net.minecraft.inventory.EntityEquipmentSlot$Type**
- enum **net.minecraft.inventory.EntityEquipmentSlot**
- interface **net.minecraft.inventory.IContainerListener**
- interface **net.minecraft.inventory.IInventory**
- interface **net.minecraft.inventory.IInventoryChangedListener**
- interface **net.minecraft.inventory.ISidedInventory**
- class **net.minecraft.inventory.InventoryBasic**
- class **net.minecraft.inventory.InventoryCraftResult**
- class **net.minecraft.inventory.InventoryCrafting**
- class **net.minecraft.inventory.InventoryEnderChest**
- class **net.minecraft.inventory.InventoryHelper**
- class **net.minecraft.inventory.InventoryLargeChest**
- class **net.minecraft.inventory.InventoryMerchant**
- class **net.minecraft.inventory.ItemStackHelper**
- class **net.minecraft.inventory.Slot**
- class **net.minecraft.inventory.SlotCrafting**
- class **net.minecraft.inventory.SlotFurnaceFuel**
- class **net.minecraft.inventory.SlotFurnaceOutput**
- class **net.minecraft.inventory.SlotMerchantResult**
- class **net.minecraft.inventory.SlotShulkerBox**
- enum **net.minecraft.item.EnumAction**
- enum **net.minecraft.item.EnumDyeColor**
- enum **net.minecraft.item.EnumRarity**
- interface **net.minecraft.item.IItemPropertyGetter**
- enum **net.minecraft.item.Item$ToolMaterial**
- class **net.minecraft.item.Item**
- class **net.minecraft.item.ItemAir**
- class **net.minecraft.item.ItemAnvilBlock**
- class **net.minecraft.item.ItemAppleGold**
- enum **net.minecraft.item.ItemArmor$ArmorMaterial**
- class **net.minecraft.item.ItemArmor**
- class **net.minecraft.item.ItemArmorStand**
- class **net.minecraft.item.ItemArrow**
- class **net.minecraft.item.ItemAxe**
- class **net.minecraft.item.ItemBanner**
- class **net.minecraft.item.ItemBed**
- class **net.minecraft.item.ItemBlock**
- class **net.minecraft.item.ItemBlockSpecial**
- class **net.minecraft.item.ItemBoat**
- class **net.minecraft.item.ItemBook**
- class **net.minecraft.item.ItemBow**
- class **net.minecraft.item.ItemBucket**
- class **net.minecraft.item.ItemBucketMilk**
- class **net.minecraft.item.ItemCarrotOnAStick**
- class **net.minecraft.item.ItemChorusFruit**
- class **net.minecraft.item.ItemClock**
- class **net.minecraft.item.ItemCloth**
- class **net.minecraft.item.ItemCoal**
- class **net.minecraft.item.ItemColored**
- class **net.minecraft.item.ItemCompass**
- class **net.minecraft.item.ItemDoor**
- class **net.minecraft.item.ItemDye**
- class **net.minecraft.item.ItemEgg**
- class **net.minecraft.item.ItemElytra**
- class **net.minecraft.item.ItemEmptyMap**
- class **net.minecraft.item.ItemEnchantedBook**
- class **net.minecraft.item.ItemEndCrystal**
- class **net.minecraft.item.ItemEnderEye**
- class **net.minecraft.item.ItemEnderPearl**
- class **net.minecraft.item.ItemExpBottle**
- class **net.minecraft.item.ItemFireball**
- class **net.minecraft.item.ItemFirework**
- class **net.minecraft.item.ItemFireworkCharge**
- enum **net.minecraft.item.ItemFishFood$FishType**
- class **net.minecraft.item.ItemFishFood**
- class **net.minecraft.item.ItemFishingRod**
- class **net.minecraft.item.ItemFlintAndSteel**
- class **net.minecraft.item.ItemFood**
- class **net.minecraft.item.ItemGlassBottle**
- class **net.minecraft.item.ItemHangingEntity**
- class **net.minecraft.item.ItemHoe**
- class **net.minecraft.item.ItemLead**
- class **net.minecraft.item.ItemLeaves**
- class **net.minecraft.item.ItemLilyPad**
- class **net.minecraft.item.ItemLingeringPotion**
- class **net.minecraft.item.ItemMap**
- class **net.minecraft.item.ItemMapBase**
- class **net.minecraft.item.ItemMinecart**
- class **net.minecraft.item.ItemMonsterPlacer**
- interface **net.minecraft.item.ItemMultiTexture$Mapper**
- class **net.minecraft.item.ItemMultiTexture**
- class **net.minecraft.item.ItemNameTag**
- class **net.minecraft.item.ItemPickaxe**
- class **net.minecraft.item.ItemPiston**
- class **net.minecraft.item.ItemPotion**
- class **net.minecraft.item.ItemRecord**
- class **net.minecraft.item.ItemRedstone**
- class **net.minecraft.item.ItemSaddle**
- class **net.minecraft.item.ItemSeedFood**
- class **net.minecraft.item.ItemSeeds**
- class **net.minecraft.item.ItemShears**
- class **net.minecraft.item.ItemShield**
- class **net.minecraft.item.ItemShulkerBox**
- class **net.minecraft.item.ItemSign**
- class **net.minecraft.item.ItemSimpleFoiled**
- class **net.minecraft.item.ItemSkull**
- class **net.minecraft.item.ItemSlab**
- class **net.minecraft.item.ItemSnow**
- class **net.minecraft.item.ItemSnowball**
- class **net.minecraft.item.ItemSoup**
- class **net.minecraft.item.ItemSpade**
- class **net.minecraft.item.ItemSpectralArrow**
- class **net.minecraft.item.ItemSplashPotion**
- class **net.minecraft.item.ItemStack**
- class **net.minecraft.item.ItemSword**
- class **net.minecraft.item.ItemTippedArrow**
- class **net.minecraft.item.ItemTool**
- class **net.minecraft.item.ItemWritableBook**
- class **net.minecraft.item.ItemWrittenBook**
- class **net.minecraft.item.crafting.CraftingManager**
- class **net.minecraft.item.crafting.FurnaceRecipes**
- interface **net.minecraft.item.crafting.IRecipe**
- class **net.minecraft.item.crafting.RecipeBookCloning**
- class **net.minecraft.item.crafting.RecipeFireworks**
- class **net.minecraft.item.crafting.RecipeRepairItem**
- class **net.minecraft.item.crafting.RecipeTippedArrow**
- class **net.minecraft.item.crafting.RecipesArmor**
- class **net.minecraft.item.crafting.RecipesArmorDyes**
- class **net.minecraft.item.crafting.RecipesBanners$RecipeAddPattern**
- class **net.minecraft.item.crafting.RecipesBanners$RecipeDuplicatePattern**
- class **net.minecraft.item.crafting.RecipesBanners**
- class **net.minecraft.item.crafting.RecipesCrafting**
- class **net.minecraft.item.crafting.RecipesDyes**
- class **net.minecraft.item.crafting.RecipesFood**
- class **net.minecraft.item.crafting.RecipesIngots**
- class **net.minecraft.item.crafting.RecipesMapCloning**
- class **net.minecraft.item.crafting.RecipesMapExtending**
- class **net.minecraft.item.crafting.RecipesTools**
- class **net.minecraft.item.crafting.RecipesWeapons**
- class **net.minecraft.item.crafting.ShapedRecipes**
- class **net.minecraft.item.crafting.ShapelessRecipes**
- class **net.minecraft.item.crafting.ShieldRecipes$Decoration**
- class **net.minecraft.item.crafting.ShieldRecipes**
- class **net.minecraft.item.crafting.ShulkerBoxRecipes**
- class **net.minecraft.nbt.CompressedStreamTools**
- class **net.minecraft.nbt.JsonToNBT**
- class **net.minecraft.nbt.NBTBase**
- class **net.minecraft.nbt.NBTException**
- class **net.minecraft.nbt.NBTPrimitive**
- class **net.minecraft.nbt.NBTSizeTracker**
- class **net.minecraft.nbt.NBTTagByte**
- class **net.minecraft.nbt.NBTTagByteArray**
- class **net.minecraft.nbt.NBTTagCompound**
- class **net.minecraft.nbt.NBTTagDouble**
- class **net.minecraft.nbt.NBTTagEnd**
- class **net.minecraft.nbt.NBTTagFloat**
- class **net.minecraft.nbt.NBTTagInt**
- class **net.minecraft.nbt.NBTTagIntArray**
- class **net.minecraft.nbt.NBTTagList**
- class **net.minecraft.nbt.NBTTagLong**
- class **net.minecraft.nbt.NBTTagShort**
- class **net.minecraft.nbt.NBTTagString**
- class **net.minecraft.nbt.NBTUtil**
- enum **net.minecraft.network.EnumConnectionState**
- enum **net.minecraft.network.EnumPacketDirection**
- interface **net.minecraft.network.INetHandler**
- class **net.minecraft.network.LegacyPingHandler**
- class **net.minecraft.network.NetHandlerPlayServer**
- class **net.minecraft.network.NettyCompressionDecoder**
- class **net.minecraft.network.NettyCompressionEncoder**
- class **net.minecraft.network.NettyEncryptingDecoder**
- class **net.minecraft.network.NettyEncryptingEncoder**
- class **net.minecraft.network.NettyEncryptionTranslator**
- class **net.minecraft.network.NettyPacketDecoder**
- class **net.minecraft.network.NettyPacketEncoder**
- class **net.minecraft.network.NettyVarint21FrameDecoder**
- class **net.minecraft.network.NettyVarint21FrameEncoder**
- class **net.minecraft.network.NetworkManager**
- class **net.minecraft.network.NetworkSystem**
- interface **net.minecraft.network.Packet**
- class **net.minecraft.network.PacketBuffer**
- class **net.minecraft.network.PacketThreadUtil**
- class **net.minecraft.network.ServerStatusResponse$Players$Serializer**
- class **net.minecraft.network.ServerStatusResponse$Players**
- class **net.minecraft.network.ServerStatusResponse$Serializer**
- class **net.minecraft.network.ServerStatusResponse$Version$Serializer**
- class **net.minecraft.network.ServerStatusResponse$Version**
- class **net.minecraft.network.ServerStatusResponse**
- class **net.minecraft.network.ThreadQuickExitException**
- class **net.minecraft.network.datasync.DataParameter**
- interface **net.minecraft.network.datasync.DataSerializer**
- class **net.minecraft.network.datasync.DataSerializers**
- class **net.minecraft.network.datasync.EntityDataManager$DataEntry**
- class **net.minecraft.network.datasync.EntityDataManager**
- interface **net.minecraft.network.handshake.INetHandlerHandshakeServer**
- class **net.minecraft.network.handshake.client.C00Handshake**
- interface **net.minecraft.network.login.INetHandlerLoginClient**
- interface **net.minecraft.network.login.INetHandlerLoginServer**
- class **net.minecraft.network.login.client.CPacketEncryptionResponse**
- class **net.minecraft.network.login.client.CPacketLoginStart**
- class **net.minecraft.network.login.server.SPacketDisconnect**
- class **net.minecraft.network.login.server.SPacketEnableCompression**
- class **net.minecraft.network.login.server.SPacketEncryptionRequest**
- class **net.minecraft.network.login.server.SPacketLoginSuccess**
- interface **net.minecraft.network.play.INetHandlerPlayClient**
- interface **net.minecraft.network.play.INetHandlerPlayServer**
- class **net.minecraft.network.play.client.CPacketAnimation**
- class **net.minecraft.network.play.client.CPacketChatMessage**
- class **net.minecraft.network.play.client.CPacketClickWindow**
- class **net.minecraft.network.play.client.CPacketClientSettings**
- enum **net.minecraft.network.play.client.CPacketClientStatus$State**
- class **net.minecraft.network.play.client.CPacketClientStatus**
- class **net.minecraft.network.play.client.CPacketCloseWindow**
- class **net.minecraft.network.play.client.CPacketConfirmTeleport**
- class **net.minecraft.network.play.client.CPacketConfirmTransaction**
- class **net.minecraft.network.play.client.CPacketCreativeInventoryAction**
- class **net.minecraft.network.play.client.CPacketCustomPayload**
- class **net.minecraft.network.play.client.CPacketEnchantItem**
- enum **net.minecraft.network.play.client.CPacketEntityAction$Action**
- class **net.minecraft.network.play.client.CPacketEntityAction**
- class **net.minecraft.network.play.client.CPacketHeldItemChange**
- class **net.minecraft.network.play.client.CPacketInput**
- class **net.minecraft.network.play.client.CPacketKeepAlive**
- class **net.minecraft.network.play.client.CPacketPlayer$Position**
- class **net.minecraft.network.play.client.CPacketPlayer$PositionRotation**
- class **net.minecraft.network.play.client.CPacketPlayer$Rotation**
- class **net.minecraft.network.play.client.CPacketPlayer**
- class **net.minecraft.network.play.client.CPacketPlayerAbilities**
- enum **net.minecraft.network.play.client.CPacketPlayerDigging$Action**
- class **net.minecraft.network.play.client.CPacketPlayerDigging**
- class **net.minecraft.network.play.client.CPacketPlayerTryUseItem**
- class **net.minecraft.network.play.client.CPacketPlayerTryUseItemOnBlock**
- enum **net.minecraft.network.play.client.CPacketResourcePackStatus$Action**
- class **net.minecraft.network.play.client.CPacketResourcePackStatus**
- class **net.minecraft.network.play.client.CPacketSpectate**
- class **net.minecraft.network.play.client.CPacketSteerBoat**
- class **net.minecraft.network.play.client.CPacketTabComplete**
- class **net.minecraft.network.play.client.CPacketUpdateSign**
- enum **net.minecraft.network.play.client.CPacketUseEntity$Action**
- class **net.minecraft.network.play.client.CPacketUseEntity**
- class **net.minecraft.network.play.client.CPacketVehicleMove**
- class **net.minecraft.network.play.server.SPacketAnimation**
- class **net.minecraft.network.play.server.SPacketBlockAction**
- class **net.minecraft.network.play.server.SPacketBlockBreakAnim**
- class **net.minecraft.network.play.server.SPacketBlockChange**
- class **net.minecraft.network.play.server.SPacketCamera**
- class **net.minecraft.network.play.server.SPacketChangeGameState**
- class **net.minecraft.network.play.server.SPacketChat**
- class **net.minecraft.network.play.server.SPacketChunkData**
- class **net.minecraft.network.play.server.SPacketCloseWindow**
- class **net.minecraft.network.play.server.SPacketCollectItem**
- enum **net.minecraft.network.play.server.SPacketCombatEvent$Event**
- class **net.minecraft.network.play.server.SPacketCombatEvent**
- class **net.minecraft.network.play.server.SPacketConfirmTransaction**
- class **net.minecraft.network.play.server.SPacketCooldown**
- class **net.minecraft.network.play.server.SPacketCustomPayload**
- class **net.minecraft.network.play.server.SPacketCustomSound**
- class **net.minecraft.network.play.server.SPacketDestroyEntities**
- class **net.minecraft.network.play.server.SPacketDisconnect**
- class **net.minecraft.network.play.server.SPacketDisplayObjective**
- class **net.minecraft.network.play.server.SPacketEffect**
- class **net.minecraft.network.play.server.SPacketEntity$S15PacketEntityRelMove**
- class **net.minecraft.network.play.server.SPacketEntity$S16PacketEntityLook**
- class **net.minecraft.network.play.server.SPacketEntity$S17PacketEntityLookMove**
- class **net.minecraft.network.play.server.SPacketEntity**
- class **net.minecraft.network.play.server.SPacketEntityAttach**
- class **net.minecraft.network.play.server.SPacketEntityEffect**
- class **net.minecraft.network.play.server.SPacketEntityEquipment**
- class **net.minecraft.network.play.server.SPacketEntityHeadLook**
- class **net.minecraft.network.play.server.SPacketEntityMetadata**
- class **net.minecraft.network.play.server.SPacketEntityProperties**
- class **net.minecraft.network.play.server.SPacketEntityStatus**
- class **net.minecraft.network.play.server.SPacketEntityTeleport**
- class **net.minecraft.network.play.server.SPacketEntityVelocity**
- class **net.minecraft.network.play.server.SPacketExplosion**
- class **net.minecraft.network.play.server.SPacketHeldItemChange**
- class **net.minecraft.network.play.server.SPacketJoinGame**
- class **net.minecraft.network.play.server.SPacketKeepAlive**
- class **net.minecraft.network.play.server.SPacketMaps**
- class **net.minecraft.network.play.server.SPacketMoveVehicle**
- class **net.minecraft.network.play.server.SPacketMultiBlockChange**
- class **net.minecraft.network.play.server.SPacketOpenWindow**
- class **net.minecraft.network.play.server.SPacketParticles**
- class **net.minecraft.network.play.server.SPacketPlayerAbilities**
- class **net.minecraft.network.play.server.SPacketPlayerListHeaderFooter**
- enum **net.minecraft.network.play.server.SPacketPlayerListItem$Action**
- class **net.minecraft.network.play.server.SPacketPlayerListItem**
- enum **net.minecraft.network.play.server.SPacketPlayerPosLook$EnumFlags**
- class **net.minecraft.network.play.server.SPacketPlayerPosLook**
- class **net.minecraft.network.play.server.SPacketRemoveEntityEffect**
- class **net.minecraft.network.play.server.SPacketResourcePackSend**
- class **net.minecraft.network.play.server.SPacketRespawn**
- class **net.minecraft.network.play.server.SPacketScoreboardObjective**
- class **net.minecraft.network.play.server.SPacketServerDifficulty**
- class **net.minecraft.network.play.server.SPacketSetExperience**
- class **net.minecraft.network.play.server.SPacketSetPassengers**
- class **net.minecraft.network.play.server.SPacketSetSlot**
- class **net.minecraft.network.play.server.SPacketSignEditorOpen**
- class **net.minecraft.network.play.server.SPacketSoundEffect**
- class **net.minecraft.network.play.server.SPacketSpawnExperienceOrb**
- class **net.minecraft.network.play.server.SPacketSpawnGlobalEntity**
- class **net.minecraft.network.play.server.SPacketSpawnMob**
- class **net.minecraft.network.play.server.SPacketSpawnObject**
- class **net.minecraft.network.play.server.SPacketSpawnPainting**
- class **net.minecraft.network.play.server.SPacketSpawnPlayer**
- class **net.minecraft.network.play.server.SPacketSpawnPosition**
- class **net.minecraft.network.play.server.SPacketStatistics**
- class **net.minecraft.network.play.server.SPacketTabComplete**
- class **net.minecraft.network.play.server.SPacketTeams**
- class **net.minecraft.network.play.server.SPacketTimeUpdate**
- enum **net.minecraft.network.play.server.SPacketTitle$Type**
- class **net.minecraft.network.play.server.SPacketTitle**
- class **net.minecraft.network.play.server.SPacketUnloadChunk**
- enum **net.minecraft.network.play.server.SPacketUpdateBossInfo$Operation**
- class **net.minecraft.network.play.server.SPacketUpdateBossInfo**
- class **net.minecraft.network.play.server.SPacketUpdateHealth**
- enum **net.minecraft.network.play.server.SPacketUpdateScore$Action**
- class **net.minecraft.network.play.server.SPacketUpdateScore**
- class **net.minecraft.network.play.server.SPacketUpdateTileEntity**
- class **net.minecraft.network.play.server.SPacketUseBed**
- class **net.minecraft.network.play.server.SPacketWindowItems**
- class **net.minecraft.network.play.server.SPacketWindowProperty**
- enum **net.minecraft.network.play.server.SPacketWorldBorder$Action**
- class **net.minecraft.network.play.server.SPacketWorldBorder**
- interface **net.minecraft.network.rcon.IServer**
- class **net.minecraft.network.rcon.RConConsoleSource**
- class **net.minecraft.network.rcon.RConOutputStream**
- class **net.minecraft.network.rcon.RConThreadBase**
- class **net.minecraft.network.rcon.RConThreadClient**
- class **net.minecraft.network.rcon.RConThreadMain**
- class **net.minecraft.network.rcon.RConThreadQuery**
- class **net.minecraft.network.rcon.RConUtils**
- interface **net.minecraft.network.status.INetHandlerStatusClient**
- interface **net.minecraft.network.status.INetHandlerStatusServer**
- class **net.minecraft.network.status.client.CPacketPing**
- class **net.minecraft.network.status.client.CPacketServerQuery**
- class **net.minecraft.network.status.server.SPacketPong**
- class **net.minecraft.network.status.server.SPacketServerInfo**
- class **net.minecraft.pathfinding.NodeProcessor**
- class **net.minecraft.pathfinding.Path**
- class **net.minecraft.pathfinding.PathFinder**
- class **net.minecraft.pathfinding.PathHeap**
- class **net.minecraft.pathfinding.PathNavigate**
- class **net.minecraft.pathfinding.PathNavigateClimber**
- class **net.minecraft.pathfinding.PathNavigateGround**
- class **net.minecraft.pathfinding.PathNavigateSwimmer**
- enum **net.minecraft.pathfinding.PathNodeType**
- class **net.minecraft.pathfinding.PathPoint**
- class **net.minecraft.pathfinding.PathWorldListener**
- class **net.minecraft.pathfinding.SwimNodeProcessor**
- class **net.minecraft.pathfinding.WalkNodeProcessor**
- class **net.minecraft.potion.Potion**
- class **net.minecraft.potion.PotionAbsorption**
- class **net.minecraft.potion.PotionAttackDamage**
- class **net.minecraft.potion.PotionEffect**
- class **net.minecraft.potion.PotionHealth**
- class **net.minecraft.potion.PotionHealthBoost**
- class **net.minecraft.potion.PotionHelper$ItemPredicateInstance**
- class **net.minecraft.potion.PotionHelper$MixPredicate**
- class **net.minecraft.potion.PotionHelper**
- class **net.minecraft.potion.PotionType**
- class **net.minecraft.potion.PotionUtils**
- interface **net.minecraft.profiler.ISnooperInfo**
- class **net.minecraft.profiler.Profiler$Result**
- class **net.minecraft.profiler.Profiler**
- class **net.minecraft.profiler.Snooper**
- class **net.minecraft.realms.DisconnectedRealmsScreen**
- class **net.minecraft.realms.Realms**
- class **net.minecraft.realms.RealmsAnvilLevelStorageSource**
- class **net.minecraft.realms.RealmsBridge**
- class **net.minecraft.realms.RealmsBufferBuilder**
- class **net.minecraft.realms.RealmsButton**
- class **net.minecraft.realms.RealmsClickableScrolledSelectionList**
- class **net.minecraft.realms.RealmsConnect**
- class **net.minecraft.realms.RealmsDefaultVertexFormat**
- class **net.minecraft.realms.RealmsEditBox**
- class **net.minecraft.realms.RealmsLevelSummary**
- class **net.minecraft.realms.RealmsMth**
- class **net.minecraft.realms.RealmsScreen**
- class **net.minecraft.realms.RealmsScrolledSelectionList**
- class **net.minecraft.realms.RealmsServerAddress**
- class **net.minecraft.realms.RealmsSharedConstants**
- class **net.minecraft.realms.RealmsSimpleScrolledSelectionList**
- class **net.minecraft.realms.RealmsSliderButton**
- class **net.minecraft.realms.RealmsVertexFormat**
- class **net.minecraft.realms.RealmsVertexFormatElement**
- class **net.minecraft.realms.Tezzelator**
- enum **net.minecraft.scoreboard.IScoreCriteria$EnumRenderType**
- interface **net.minecraft.scoreboard.IScoreCriteria**
- class **net.minecraft.scoreboard.Score**
- class **net.minecraft.scoreboard.ScoreCriteria**
- class **net.minecraft.scoreboard.ScoreCriteriaColored**
- class **net.minecraft.scoreboard.ScoreCriteriaHealth**
- class **net.minecraft.scoreboard.ScoreCriteriaReadOnly**
- class **net.minecraft.scoreboard.ScoreCriteriaStat**
- class **net.minecraft.scoreboard.ScoreObjective**
- class **net.minecraft.scoreboard.ScorePlayerTeam**
- class **net.minecraft.scoreboard.Scoreboard**
- class **net.minecraft.scoreboard.ScoreboardSaveData**
- class **net.minecraft.scoreboard.ServerScoreboard**
- enum **net.minecraft.scoreboard.Team$CollisionRule**
- enum **net.minecraft.scoreboard.Team$EnumVisible**
- class **net.minecraft.scoreboard.Team**
- class **net.minecraft.server.DebugLoggingPrintStream**
- class **net.minecraft.server.MinecraftServer**
- class **net.minecraft.server.ServerEula**
- class **net.minecraft.server.dedicated.DedicatedPlayerList**
- class **net.minecraft.server.dedicated.DedicatedServer**
- class **net.minecraft.server.dedicated.PendingCommand**
- class **net.minecraft.server.dedicated.PropertyManager**
- class **net.minecraft.server.dedicated.ServerHangWatchdog**
- class **net.minecraft.server.gui.MinecraftServerGui**
- class **net.minecraft.server.gui.PlayerListComponent**
- class **net.minecraft.server.gui.StatsComponent**
- class **net.minecraft.server.integrated.IntegratedPlayerList**
- class **net.minecraft.server.integrated.IntegratedServer**
- class **net.minecraft.server.integrated.IntegratedServerCommandManager**
- class **net.minecraft.server.management.PlayerChunkMap**
- class **net.minecraft.server.management.PlayerChunkMapEntry**
- class **net.minecraft.server.management.PlayerInteractionManager**
- class **net.minecraft.server.management.PlayerList**
- class **net.minecraft.server.management.PlayerProfileCache**
- class **net.minecraft.server.management.PreYggdrasilConverter**
- class **net.minecraft.server.management.UserList**
- class **net.minecraft.server.management.UserListBans**
- class **net.minecraft.server.management.UserListBansEntry**
- class **net.minecraft.server.management.UserListEntry**
- class **net.minecraft.server.management.UserListEntryBan**
- class **net.minecraft.server.management.UserListIPBans**
- class **net.minecraft.server.management.UserListIPBansEntry**
- class **net.minecraft.server.management.UserListOps**
- class **net.minecraft.server.management.UserListOpsEntry**
- class **net.minecraft.server.management.UserListWhitelist**
- class **net.minecraft.server.management.UserListWhitelistEntry**
- class **net.minecraft.server.network.NetHandlerHandshakeTCP**
- class **net.minecraft.server.network.NetHandlerLoginServer**
- class **net.minecraft.server.network.NetHandlerStatusServer**
- class **net.minecraft.stats.Achievement**
- class **net.minecraft.stats.AchievementList**
- interface **net.minecraft.stats.IStatStringFormat**
- interface **net.minecraft.stats.IStatType**
- class **net.minecraft.stats.StatBase**
- class **net.minecraft.stats.StatBasic**
- class **net.minecraft.stats.StatCrafting**
- class **net.minecraft.stats.StatList**
- class **net.minecraft.stats.StatisticsManager**
- class **net.minecraft.stats.StatisticsManagerServer**
- enum **net.minecraft.tileentity.BannerPattern**
- class **net.minecraft.tileentity.CommandBlockBaseLogic**
- interface **net.minecraft.tileentity.IHopper**
- class **net.minecraft.tileentity.MobSpawnerBaseLogic**
- class **net.minecraft.tileentity.TileEntity**
- class **net.minecraft.tileentity.TileEntityBanner**
- class **net.minecraft.tileentity.TileEntityBeacon$BeamSegment**
- class **net.minecraft.tileentity.TileEntityBeacon**
- class **net.minecraft.tileentity.TileEntityBrewingStand**
- class **net.minecraft.tileentity.TileEntityChest**
- enum **net.minecraft.tileentity.TileEntityCommandBlock$Mode**
- class **net.minecraft.tileentity.TileEntityCommandBlock**
- class **net.minecraft.tileentity.TileEntityComparator**
- class **net.minecraft.tileentity.TileEntityDaylightDetector**
- class **net.minecraft.tileentity.TileEntityDispenser**
- class **net.minecraft.tileentity.TileEntityDropper**
- class **net.minecraft.tileentity.TileEntityEnchantmentTable**
- class **net.minecraft.tileentity.TileEntityEndGateway**
- class **net.minecraft.tileentity.TileEntityEndPortal**
- class **net.minecraft.tileentity.TileEntityEnderChest**
- class **net.minecraft.tileentity.TileEntityFlowerPot**
- class **net.minecraft.tileentity.TileEntityFurnace**
- class **net.minecraft.tileentity.TileEntityHopper**
- class **net.minecraft.tileentity.TileEntityLockable**
- class **net.minecraft.tileentity.TileEntityLockableLoot**
- class **net.minecraft.tileentity.TileEntityMobSpawner**
- class **net.minecraft.tileentity.TileEntityNote**
- class **net.minecraft.tileentity.TileEntityPiston**
- enum **net.minecraft.tileentity.TileEntityShulkerBox$AnimationStatus**
- class **net.minecraft.tileentity.TileEntityShulkerBox**
- class **net.minecraft.tileentity.TileEntitySign**
- class **net.minecraft.tileentity.TileEntitySkull**
- enum **net.minecraft.tileentity.TileEntityStructure$Mode**
- class **net.minecraft.tileentity.TileEntityStructure**
- class **net.minecraft.util.ActionResult**
- class **net.minecraft.util.BitArray**
- enum **net.minecraft.util.BlockRenderLayer**
- class **net.minecraft.util.ChatAllowedCharacters**
- class **net.minecraft.util.ClassInheritanceMultiMap**
- class **net.minecraft.util.CombatEntry**
- class **net.minecraft.util.CombatRules**
- class **net.minecraft.util.CombatTracker**
- class **net.minecraft.util.CooldownTracker**
- class **net.minecraft.util.CooldownTrackerServer**
- class **net.minecraft.util.CryptManager**
- class **net.minecraft.util.DamageSource**
- class **net.minecraft.util.EnchantmentNameParts**
- class **net.minecraft.util.EntityDamageSource**
- class **net.minecraft.util.EntityDamageSourceIndirect**
- class **net.minecraft.util.EntitySelectors$ArmoredMob**
- class **net.minecraft.util.EntitySelectors**
- enum **net.minecraft.util.EnumActionResult**
- enum **net.minecraft.util.EnumBlockRenderType**
- enum **net.minecraft.util.EnumFacing$Axis**
- enum **net.minecraft.util.EnumFacing$AxisDirection**
- enum **net.minecraft.util.EnumFacing$Plane**
- enum **net.minecraft.util.EnumFacing**
- enum **net.minecraft.util.EnumHand**
- enum **net.minecraft.util.EnumHandSide**
- enum **net.minecraft.util.EnumParticleTypes**
- class **net.minecraft.util.EnumTypeAdapterFactory**
- class **net.minecraft.util.FoodStats**
- class **net.minecraft.util.FrameTimer**
- class **net.minecraft.util.HttpUtil**
- interface **net.minecraft.util.IJsonSerializable**
- interface **net.minecraft.util.IObjectIntIterable**
- interface **net.minecraft.util.IProgressUpdate**
- interface **net.minecraft.util.IStringSerializable**
- interface **net.minecraft.util.ITabCompleter**
- interface **net.minecraft.util.IThreadListener**
- interface **net.minecraft.util.ITickable**
- class **net.minecraft.util.IntHashMap**
- class **net.minecraft.util.IntIdentityHashBiMap**
- class **net.minecraft.util.IntegerCache**
- class **net.minecraft.util.JsonSerializableSet**
- class **net.minecraft.util.JsonUtils**
- class **net.minecraft.util.LazyLoadBase**
- class **net.minecraft.util.LoggingPrintStream**
- class **net.minecraft.util.LowerStringMap**
- class **net.minecraft.util.MapPopulator**
- class **net.minecraft.util.MinecraftError**
- enum **net.minecraft.util.Mirror**
- class **net.minecraft.util.MouseFilter**
- class **net.minecraft.util.MouseHelper**
- class **net.minecraft.util.MovementInput**
- class **net.minecraft.util.MovementInputFromOptions**
- class **net.minecraft.util.NonNullList**
- class **net.minecraft.util.ObjectIntIdentityMap**
- class **net.minecraft.util.ReportedException**
- class **net.minecraft.util.ResourceLocation**
- enum **net.minecraft.util.Rotation**
- class **net.minecraft.util.ScreenShotHelper**
- enum **net.minecraft.util.Session$Type**
- class **net.minecraft.util.Session**
- enum **net.minecraft.util.SoundCategory**
- class **net.minecraft.util.SoundEvent**
- class **net.minecraft.util.StringUtils**
- class **net.minecraft.util.TabCompleter**
- class **net.minecraft.util.Timer**
- class **net.minecraft.util.Tuple**
- class **net.minecraft.util.TupleIntJsonSerializable**
- enum **net.minecraft.util.Util$EnumOS**
- class **net.minecraft.util.Util**
- class **net.minecraft.util.WeightedRandom$Item**
- class **net.minecraft.util.WeightedRandom**
- class **net.minecraft.util.WeightedSpawnerEntity**
- class **net.minecraft.util.datafix.DataFixer**
- class **net.minecraft.util.datafix.DataFixesManager**
- enum **net.minecraft.util.datafix.FixTypes**
- interface **net.minecraft.util.datafix.IDataFixer**
- interface **net.minecraft.util.datafix.IDataWalker**
- interface **net.minecraft.util.datafix.IFixType**
- interface **net.minecraft.util.datafix.IFixableData**
- class **net.minecraft.util.datafix.fixes.ArmorStandSilent**
- class **net.minecraft.util.datafix.fixes.BannerItemColor**
- class **net.minecraft.util.datafix.fixes.BookPagesStrictJSON**
- class **net.minecraft.util.datafix.fixes.CookedFishIDTypo**
- class **net.minecraft.util.datafix.fixes.ElderGuardianSplit**
- class **net.minecraft.util.datafix.fixes.EntityArmorAndHeld**
- class **net.minecraft.util.datafix.fixes.EntityHealth**
- class **net.minecraft.util.datafix.fixes.EntityId**
- class **net.minecraft.util.datafix.fixes.ForceVBOOn**
- class **net.minecraft.util.datafix.fixes.HorseSaddle**
- class **net.minecraft.util.datafix.fixes.HorseSplit**
- class **net.minecraft.util.datafix.fixes.ItemIntIDToString**
- class **net.minecraft.util.datafix.fixes.MinecartEntityTypes**
- class **net.minecraft.util.datafix.fixes.OptionsLowerCaseLanguage**
- class **net.minecraft.util.datafix.fixes.PaintingDirection**
- class **net.minecraft.util.datafix.fixes.PotionItems**
- class **net.minecraft.util.datafix.fixes.PotionWater**
- class **net.minecraft.util.datafix.fixes.RedundantChanceTags**
- class **net.minecraft.util.datafix.fixes.RidingToPassengers**
- class **net.minecraft.util.datafix.fixes.ShulkerBoxEntityColor**
- class **net.minecraft.util.datafix.fixes.ShulkerBoxItemColor**
- class **net.minecraft.util.datafix.fixes.ShulkerBoxTileColor**
- class **net.minecraft.util.datafix.fixes.SignStrictJSON**
- class **net.minecraft.util.datafix.fixes.SkeletonSplit**
- class **net.minecraft.util.datafix.fixes.SpawnEggNames**
- class **net.minecraft.util.datafix.fixes.SpawnerEntityTypes**
- class **net.minecraft.util.datafix.fixes.StringToUUID**
- class **net.minecraft.util.datafix.fixes.TileEntityId**
- class **net.minecraft.util.datafix.fixes.TotemItemRename**
- class **net.minecraft.util.datafix.fixes.ZombieProfToType**
- class **net.minecraft.util.datafix.fixes.ZombieSplit**
- class **net.minecraft.util.datafix.walkers.BlockEntityTag**
- class **net.minecraft.util.datafix.walkers.EntityTag**
- class **net.minecraft.util.datafix.walkers.Filtered**
- class **net.minecraft.util.datafix.walkers.ItemStackData**
- class **net.minecraft.util.datafix.walkers.ItemStackDataLists**
- class **net.minecraft.util.math.AxisAlignedBB**
- class **net.minecraft.util.math.BlockPos$MutableBlockPos**
- class **net.minecraft.util.math.BlockPos$PooledMutableBlockPos**
- class **net.minecraft.util.math.BlockPos**
- class **net.minecraft.util.math.Cartesian**
- class **net.minecraft.util.math.ChunkPos**
- class **net.minecraft.util.math.MathHelper**
- enum **net.minecraft.util.math.RayTraceResult$Type**
- class **net.minecraft.util.math.RayTraceResult**
- class **net.minecraft.util.math.Rotations**
- class **net.minecraft.util.math.Vec2f**
- class **net.minecraft.util.math.Vec3d**
- class **net.minecraft.util.math.Vec3i**
- interface **net.minecraft.util.registry.IRegistry**
- class **net.minecraft.util.registry.RegistryDefaulted**
- class **net.minecraft.util.registry.RegistryNamespaced**
- class **net.minecraft.util.registry.RegistryNamespacedDefaultedByKey**
- class **net.minecraft.util.registry.RegistrySimple**
- class **net.minecraft.util.text.ITextComponent$Serializer**
- interface **net.minecraft.util.text.ITextComponent**
- class **net.minecraft.util.text.Style$Serializer**
- class **net.minecraft.util.text.Style**
- class **net.minecraft.util.text.TextComponentBase**
- class **net.minecraft.util.text.TextComponentScore**
- class **net.minecraft.util.text.TextComponentSelector**
- class **net.minecraft.util.text.TextComponentString**
- class **net.minecraft.util.text.TextComponentTranslation**
- class **net.minecraft.util.text.TextComponentTranslationFormatException**
- class **net.minecraft.util.text.TextComponentUtils**
- enum **net.minecraft.util.text.TextFormatting**
- enum **net.minecraft.util.text.event.ClickEvent$Action**
- class **net.minecraft.util.text.event.ClickEvent**
- enum **net.minecraft.util.text.event.HoverEvent$Action**
- class **net.minecraft.util.text.event.HoverEvent**
- class **net.minecraft.util.text.translation.I18n**
- class **net.minecraft.util.text.translation.LanguageMap**
- class **net.minecraft.village.MerchantRecipe**
- class **net.minecraft.village.MerchantRecipeList**
- class **net.minecraft.village.Village**
- class **net.minecraft.village.VillageCollection**
- class **net.minecraft.village.VillageDoorInfo**
- class **net.minecraft.village.VillageSiege**
- enum **net.minecraft.world.BossInfo$Color**
- enum **net.minecraft.world.BossInfo$Overlay**
- class **net.minecraft.world.BossInfo**
- class **net.minecraft.world.BossInfoLerping**
- class **net.minecraft.world.BossInfoServer**
- class **net.minecraft.world.ChunkCache**
- class **net.minecraft.world.ColorizerFoliage**
- class **net.minecraft.world.ColorizerGrass**
- class **net.minecraft.world.DifficultyInstance**
- enum **net.minecraft.world.DimensionType**
- enum **net.minecraft.world.EnumDifficulty**
- enum **net.minecraft.world.EnumSkyBlock**
- class **net.minecraft.world.Explosion**
- enum **net.minecraft.world.GameRules$ValueType**
- class **net.minecraft.world.GameRules**
- enum **net.minecraft.world.GameType**
- interface **net.minecraft.world.IBlockAccess**
- interface **net.minecraft.world.IInteractionObject**
- interface **net.minecraft.world.ILockableContainer**
- interface **net.minecraft.world.IWorldEventListener**
- interface **net.minecraft.world.IWorldNameable**
- class **net.minecraft.world.LockCode**
- class **net.minecraft.world.MinecraftException**
- class **net.minecraft.world.NextTickListEntry**
- class **net.minecraft.world.ServerWorldEventHandler**
- class **net.minecraft.world.Teleporter**
- class **net.minecraft.world.World**
- class **net.minecraft.world.WorldEntitySpawner**
- class **net.minecraft.world.WorldProvider**
- class **net.minecraft.world.WorldProviderEnd**
- class **net.minecraft.world.WorldProviderHell**
- class **net.minecraft.world.WorldProviderSurface**
- class **net.minecraft.world.WorldSavedData**
- class **net.minecraft.world.WorldSavedDataCallableSave**
- class **net.minecraft.world.WorldServer**
- class **net.minecraft.world.WorldServerMulti**
- class **net.minecraft.world.WorldSettings**
- class **net.minecraft.world.WorldType**
- class **net.minecraft.world.biome.Biome$BiomeProperties**
- class **net.minecraft.world.biome.Biome$FlowerEntry**
- class **net.minecraft.world.biome.Biome$SpawnListEntry**
- enum **net.minecraft.world.biome.Biome$TempCategory**
- class **net.minecraft.world.biome.Biome**
- class **net.minecraft.world.biome.BiomeBeach**
- class **net.minecraft.world.biome.BiomeCache**
- class **net.minecraft.world.biome.BiomeColorHelper**
- class **net.minecraft.world.biome.BiomeDecorator**
- class **net.minecraft.world.biome.BiomeDesert**
- class **net.minecraft.world.biome.BiomeEnd**
- class **net.minecraft.world.biome.BiomeEndDecorator**
- enum **net.minecraft.world.biome.BiomeForest$Type**
- class **net.minecraft.world.biome.BiomeForest**
- class **net.minecraft.world.biome.BiomeForestMutated**
- class **net.minecraft.world.biome.BiomeHell**
- class **net.minecraft.world.biome.BiomeHellDecorator**
- enum **net.minecraft.world.biome.BiomeHills$Type**
- class **net.minecraft.world.biome.BiomeHills**
- class **net.minecraft.world.biome.BiomeJungle**
- class **net.minecraft.world.biome.BiomeMesa**
- class **net.minecraft.world.biome.BiomeMushroomIsland**
- class **net.minecraft.world.biome.BiomeOcean**
- class **net.minecraft.world.biome.BiomePlains**
- class **net.minecraft.world.biome.BiomeProvider**
- class **net.minecraft.world.biome.BiomeProviderSingle**
- class **net.minecraft.world.biome.BiomeRiver**
- class **net.minecraft.world.biome.BiomeSavanna**
- class **net.minecraft.world.biome.BiomeSavannaMutated**
- class **net.minecraft.world.biome.BiomeSnow**
- class **net.minecraft.world.biome.BiomeStoneBeach**
- class **net.minecraft.world.biome.BiomeSwamp**
- enum **net.minecraft.world.biome.BiomeTaiga$Type**
- class **net.minecraft.world.biome.BiomeTaiga**
- class **net.minecraft.world.biome.BiomeVoid**
- class **net.minecraft.world.biome.BiomeVoidDecorator**
- enum **net.minecraft.world.border.EnumBorderStatus**
- interface **net.minecraft.world.border.IBorderListener**
- class **net.minecraft.world.border.WorldBorder**
- class **net.minecraft.world.chunk.BlockStateContainer**
- class **net.minecraft.world.chunk.BlockStatePaletteHashMap**
- class **net.minecraft.world.chunk.BlockStatePaletteLinear**
- class **net.minecraft.world.chunk.BlockStatePaletteRegistry**
- enum **net.minecraft.world.chunk.Chunk$EnumCreateEntityType**
- class **net.minecraft.world.chunk.Chunk**
- class **net.minecraft.world.chunk.ChunkPrimer**
- class **net.minecraft.world.chunk.EmptyChunk**
- interface **net.minecraft.world.chunk.IBlockStatePalette**
- interface **net.minecraft.world.chunk.IChunkGenerator**
- interface **net.minecraft.world.chunk.IChunkProvider**
- class **net.minecraft.world.chunk.NibbleArray**
- class **net.minecraft.world.chunk.storage.AnvilChunkLoader**
- class **net.minecraft.world.chunk.storage.AnvilSaveConverter**
- class **net.minecraft.world.chunk.storage.AnvilSaveHandler**
- class **net.minecraft.world.chunk.storage.ChunkLoader$AnvilConverterData**
- class **net.minecraft.world.chunk.storage.ChunkLoader**
- class **net.minecraft.world.chunk.storage.ExtendedBlockStorage**
- interface **net.minecraft.world.chunk.storage.IChunkLoader**
- class **net.minecraft.world.chunk.storage.NibbleArrayReader**
- class **net.minecraft.world.chunk.storage.RegionFile**
- class **net.minecraft.world.chunk.storage.RegionFileCache**
- class **net.minecraft.world.demo.DemoWorldManager**
- class **net.minecraft.world.demo.DemoWorldServer**
- class **net.minecraft.world.end.DragonFightManager**
- enum **net.minecraft.world.end.DragonSpawnManager**
- class **net.minecraft.world.gen.ChunkProviderDebug**
- class **net.minecraft.world.gen.ChunkProviderEnd**
- class **net.minecraft.world.gen.ChunkProviderFlat**
- class **net.minecraft.world.gen.ChunkProviderHell**
- class **net.minecraft.world.gen.ChunkProviderOverworld**
- class **net.minecraft.world.gen.ChunkProviderServer**
- class **net.minecraft.world.gen.ChunkProviderSettings$Factory**
- class **net.minecraft.world.gen.ChunkProviderSettings$Serializer**
- class **net.minecraft.world.gen.ChunkProviderSettings**
- class **net.minecraft.world.gen.FlatGeneratorInfo**
- class **net.minecraft.world.gen.FlatLayerInfo**
- class **net.minecraft.world.gen.MapGenBase**
- class **net.minecraft.world.gen.MapGenCaves**
- class **net.minecraft.world.gen.MapGenCavesHell**
- class **net.minecraft.world.gen.MapGenRavine**
- class **net.minecraft.world.gen.NoiseGenerator**
- class **net.minecraft.world.gen.NoiseGeneratorImproved**
- class **net.minecraft.world.gen.NoiseGeneratorOctaves**
- class **net.minecraft.world.gen.NoiseGeneratorPerlin**
- class **net.minecraft.world.gen.NoiseGeneratorSimplex**
- class **net.minecraft.world.gen.feature.WorldGenAbstractTree**
- class **net.minecraft.world.gen.feature.WorldGenBigMushroom**
- class **net.minecraft.world.gen.feature.WorldGenBigTree**
- class **net.minecraft.world.gen.feature.WorldGenBirchTree**
- class **net.minecraft.world.gen.feature.WorldGenBlockBlob**
- class **net.minecraft.world.gen.feature.WorldGenBush**
- class **net.minecraft.world.gen.feature.WorldGenCactus**
- class **net.minecraft.world.gen.feature.WorldGenCanopyTree**
- class **net.minecraft.world.gen.feature.WorldGenClay**
- class **net.minecraft.world.gen.feature.WorldGenDeadBush**
- class **net.minecraft.world.gen.feature.WorldGenDesertWells**
- class **net.minecraft.world.gen.feature.WorldGenDoublePlant**
- class **net.minecraft.world.gen.feature.WorldGenDungeons**
- class **net.minecraft.world.gen.feature.WorldGenEndGateway**
- class **net.minecraft.world.gen.feature.WorldGenEndIsland**
- class **net.minecraft.world.gen.feature.WorldGenEndPodium**
- class **net.minecraft.world.gen.feature.WorldGenFire**
- class **net.minecraft.world.gen.feature.WorldGenFlowers**
- class **net.minecraft.world.gen.feature.WorldGenFossils**
- class **net.minecraft.world.gen.feature.WorldGenGlowStone1**
- class **net.minecraft.world.gen.feature.WorldGenGlowStone2**
- class **net.minecraft.world.gen.feature.WorldGenHellLava**
- class **net.minecraft.world.gen.feature.WorldGenHugeTrees**
- class **net.minecraft.world.gen.feature.WorldGenIcePath**
- class **net.minecraft.world.gen.feature.WorldGenIceSpike**
- class **net.minecraft.world.gen.feature.WorldGenLakes**
- class **net.minecraft.world.gen.feature.WorldGenLiquids**
- class **net.minecraft.world.gen.feature.WorldGenMegaJungle**
- class **net.minecraft.world.gen.feature.WorldGenMegaPineTree**
- class **net.minecraft.world.gen.feature.WorldGenMelon**
- class **net.minecraft.world.gen.feature.WorldGenMinable**
- class **net.minecraft.world.gen.feature.WorldGenPumpkin**
- class **net.minecraft.world.gen.feature.WorldGenReed**
- class **net.minecraft.world.gen.feature.WorldGenSand**
- class **net.minecraft.world.gen.feature.WorldGenSavannaTree**
- class **net.minecraft.world.gen.feature.WorldGenShrub**
- class **net.minecraft.world.gen.feature.WorldGenSpikes$EndSpike**
- class **net.minecraft.world.gen.feature.WorldGenSpikes**
- class **net.minecraft.world.gen.feature.WorldGenSwamp**
- class **net.minecraft.world.gen.feature.WorldGenTaiga1**
- class **net.minecraft.world.gen.feature.WorldGenTaiga2**
- class **net.minecraft.world.gen.feature.WorldGenTallGrass**
- class **net.minecraft.world.gen.feature.WorldGenTrees**
- class **net.minecraft.world.gen.feature.WorldGenVines**
- class **net.minecraft.world.gen.feature.WorldGenWaterlily**
- class **net.minecraft.world.gen.feature.WorldGenerator**
- class **net.minecraft.world.gen.feature.WorldGeneratorBonusChest**
- class **net.minecraft.world.gen.layer.GenLayer**
- class **net.minecraft.world.gen.layer.GenLayerAddIsland**
- class **net.minecraft.world.gen.layer.GenLayerAddMushroomIsland**
- class **net.minecraft.world.gen.layer.GenLayerAddSnow**
- class **net.minecraft.world.gen.layer.GenLayerBiome**
- class **net.minecraft.world.gen.layer.GenLayerBiomeEdge**
- class **net.minecraft.world.gen.layer.GenLayerDeepOcean**
- enum **net.minecraft.world.gen.layer.GenLayerEdge$Mode**
- class **net.minecraft.world.gen.layer.GenLayerEdge**
- class **net.minecraft.world.gen.layer.GenLayerFuzzyZoom**
- class **net.minecraft.world.gen.layer.GenLayerHills**
- class **net.minecraft.world.gen.layer.GenLayerIsland**
- class **net.minecraft.world.gen.layer.GenLayerRareBiome**
- class **net.minecraft.world.gen.layer.GenLayerRemoveTooMuchOcean**
- class **net.minecraft.world.gen.layer.GenLayerRiver**
- class **net.minecraft.world.gen.layer.GenLayerRiverInit**
- class **net.minecraft.world.gen.layer.GenLayerRiverMix**
- class **net.minecraft.world.gen.layer.GenLayerShore**
- class **net.minecraft.world.gen.layer.GenLayerSmooth**
- class **net.minecraft.world.gen.layer.GenLayerVoronoiZoom**
- class **net.minecraft.world.gen.layer.GenLayerZoom**
- class **net.minecraft.world.gen.layer.IntCache**
- class **net.minecraft.world.gen.structure.ComponentScatteredFeaturePieces$DesertPyramid**
- class **net.minecraft.world.gen.structure.ComponentScatteredFeaturePieces$Igloo**
- class **net.minecraft.world.gen.structure.ComponentScatteredFeaturePieces$JunglePyramid**
- class **net.minecraft.world.gen.structure.ComponentScatteredFeaturePieces$SwampHut**
- class **net.minecraft.world.gen.structure.ComponentScatteredFeaturePieces**
- class **net.minecraft.world.gen.structure.MapGenEndCity$Start**
- class **net.minecraft.world.gen.structure.MapGenEndCity**
- enum **net.minecraft.world.gen.structure.MapGenMineshaft$Type**
- class **net.minecraft.world.gen.structure.MapGenMineshaft**
- class **net.minecraft.world.gen.structure.MapGenNetherBridge$Start**
- class **net.minecraft.world.gen.structure.MapGenNetherBridge**
- class **net.minecraft.world.gen.structure.MapGenScatteredFeature$Start**
- class **net.minecraft.world.gen.structure.MapGenScatteredFeature**
- class **net.minecraft.world.gen.structure.MapGenStronghold$Start**
- class **net.minecraft.world.gen.structure.MapGenStronghold**
- class **net.minecraft.world.gen.structure.MapGenStructure**
- class **net.minecraft.world.gen.structure.MapGenStructureData**
- class **net.minecraft.world.gen.structure.MapGenStructureIO**
- class **net.minecraft.world.gen.structure.MapGenVillage$Start**
- class **net.minecraft.world.gen.structure.MapGenVillage**
- class **net.minecraft.world.gen.structure.StructureBoundingBox**
- class **net.minecraft.world.gen.structure.StructureComponent$BlockSelector**
- class **net.minecraft.world.gen.structure.StructureComponent**
- class **net.minecraft.world.gen.structure.StructureComponentTemplate**
- class **net.minecraft.world.gen.structure.StructureEndCityPieces$CityTemplate**
- class **net.minecraft.world.gen.structure.StructureEndCityPieces**
- class **net.minecraft.world.gen.structure.StructureMineshaftPieces$Corridor**
- class **net.minecraft.world.gen.structure.StructureMineshaftPieces$Cross**
- class **net.minecraft.world.gen.structure.StructureMineshaftPieces$Room**
- class **net.minecraft.world.gen.structure.StructureMineshaftPieces$Stairs**
- class **net.minecraft.world.gen.structure.StructureMineshaftPieces**
- class **net.minecraft.world.gen.structure.StructureMineshaftStart**
- class **net.minecraft.world.gen.structure.StructureNetherBridgePieces$Corridor**
- class **net.minecraft.world.gen.structure.StructureNetherBridgePieces$Corridor2**
- class **net.minecraft.world.gen.structure.StructureNetherBridgePieces$Corridor3**
- class **net.minecraft.world.gen.structure.StructureNetherBridgePieces$Corridor4**
- class **net.minecraft.world.gen.structure.StructureNetherBridgePieces$Corridor5**
- class **net.minecraft.world.gen.structure.StructureNetherBridgePieces$Crossing**
- class **net.minecraft.world.gen.structure.StructureNetherBridgePieces$Crossing2**
- class **net.minecraft.world.gen.structure.StructureNetherBridgePieces$Crossing3**
- class **net.minecraft.world.gen.structure.StructureNetherBridgePieces$End**
- class **net.minecraft.world.gen.structure.StructureNetherBridgePieces$Entrance**
- class **net.minecraft.world.gen.structure.StructureNetherBridgePieces$NetherStalkRoom**
- class **net.minecraft.world.gen.structure.StructureNetherBridgePieces$Stairs**
- class **net.minecraft.world.gen.structure.StructureNetherBridgePieces$Start**
- class **net.minecraft.world.gen.structure.StructureNetherBridgePieces$Straight**
- class **net.minecraft.world.gen.structure.StructureNetherBridgePieces$Throne**
- class **net.minecraft.world.gen.structure.StructureNetherBridgePieces**
- class **net.minecraft.world.gen.structure.StructureOceanMonument$StartMonument**
- class **net.minecraft.world.gen.structure.StructureOceanMonument**
- class **net.minecraft.world.gen.structure.StructureOceanMonumentPieces$DoubleXRoom**
- class **net.minecraft.world.gen.structure.StructureOceanMonumentPieces$DoubleXYRoom**
- class **net.minecraft.world.gen.structure.StructureOceanMonumentPieces$DoubleYRoom**
- class **net.minecraft.world.gen.structure.StructureOceanMonumentPieces$DoubleYZRoom**
- class **net.minecraft.world.gen.structure.StructureOceanMonumentPieces$DoubleZRoom**
- class **net.minecraft.world.gen.structure.StructureOceanMonumentPieces$EntryRoom**
- class **net.minecraft.world.gen.structure.StructureOceanMonumentPieces$MonumentBuilding**
- class **net.minecraft.world.gen.structure.StructureOceanMonumentPieces$MonumentCoreRoom**
- class **net.minecraft.world.gen.structure.StructureOceanMonumentPieces$Penthouse**
- class **net.minecraft.world.gen.structure.StructureOceanMonumentPieces$Piece**
- class **net.minecraft.world.gen.structure.StructureOceanMonumentPieces$SimpleRoom**
- class **net.minecraft.world.gen.structure.StructureOceanMonumentPieces$SimpleTopRoom**
- class **net.minecraft.world.gen.structure.StructureOceanMonumentPieces$WingRoom**
- class **net.minecraft.world.gen.structure.StructureOceanMonumentPieces**
- class **net.minecraft.world.gen.structure.StructureStart**
- class **net.minecraft.world.gen.structure.StructureStrongholdPieces$ChestCorridor**
- class **net.minecraft.world.gen.structure.StructureStrongholdPieces$Corridor**
- class **net.minecraft.world.gen.structure.StructureStrongholdPieces$Crossing**
- class **net.minecraft.world.gen.structure.StructureStrongholdPieces$LeftTurn**
- class **net.minecraft.world.gen.structure.StructureStrongholdPieces$Library**
- class **net.minecraft.world.gen.structure.StructureStrongholdPieces$PortalRoom**
- class **net.minecraft.world.gen.structure.StructureStrongholdPieces$Prison**
- class **net.minecraft.world.gen.structure.StructureStrongholdPieces$RightTurn**
- class **net.minecraft.world.gen.structure.StructureStrongholdPieces$RoomCrossing**
- class **net.minecraft.world.gen.structure.StructureStrongholdPieces$Stairs**
- class **net.minecraft.world.gen.structure.StructureStrongholdPieces$Stairs2**
- class **net.minecraft.world.gen.structure.StructureStrongholdPieces$StairsStraight**
- class **net.minecraft.world.gen.structure.StructureStrongholdPieces$Straight**
- enum **net.minecraft.world.gen.structure.StructureStrongholdPieces$Stronghold$Door**
- class **net.minecraft.world.gen.structure.StructureStrongholdPieces$Stronghold**
- class **net.minecraft.world.gen.structure.StructureStrongholdPieces**
- class **net.minecraft.world.gen.structure.StructureVillagePieces$Church**
- class **net.minecraft.world.gen.structure.StructureVillagePieces$Field1**
- class **net.minecraft.world.gen.structure.StructureVillagePieces$Field2**
- class **net.minecraft.world.gen.structure.StructureVillagePieces$Hall**
- class **net.minecraft.world.gen.structure.StructureVillagePieces$House1**
- class **net.minecraft.world.gen.structure.StructureVillagePieces$House2**
- class **net.minecraft.world.gen.structure.StructureVillagePieces$House3**
- class **net.minecraft.world.gen.structure.StructureVillagePieces$House4Garden**
- class **net.minecraft.world.gen.structure.StructureVillagePieces$Path**
- class **net.minecraft.world.gen.structure.StructureVillagePieces$PieceWeight**
- class **net.minecraft.world.gen.structure.StructureVillagePieces$Road**
- class **net.minecraft.world.gen.structure.StructureVillagePieces$Start**
- class **net.minecraft.world.gen.structure.StructureVillagePieces$Torch**
- class **net.minecraft.world.gen.structure.StructureVillagePieces$Village**
- class **net.minecraft.world.gen.structure.StructureVillagePieces$Well**
- class **net.minecraft.world.gen.structure.StructureVillagePieces$WoodHut**
- class **net.minecraft.world.gen.structure.StructureVillagePieces**
- class **net.minecraft.world.gen.structure.WoodlandMansion$Start**
- class **net.minecraft.world.gen.structure.WoodlandMansion**
- class **net.minecraft.world.gen.structure.WoodlandMansionPieces$MansionTemplate**
- class **net.minecraft.world.gen.structure.WoodlandMansionPieces**
- class **net.minecraft.world.gen.structure.template.BlockRotationProcessor**
- interface **net.minecraft.world.gen.structure.template.ITemplateProcessor**
- class **net.minecraft.world.gen.structure.template.PlacementSettings**
- class **net.minecraft.world.gen.structure.template.Template$BlockInfo**
- class **net.minecraft.world.gen.structure.template.Template$EntityInfo**
- class **net.minecraft.world.gen.structure.template.Template**
- class **net.minecraft.world.gen.structure.template.TemplateManager**
- class **net.minecraft.world.storage.DerivedWorldInfo**
- interface **net.minecraft.world.storage.IPlayerFileData**
- interface **net.minecraft.world.storage.ISaveFormat**
- interface **net.minecraft.world.storage.ISaveHandler**
- interface **net.minecraft.world.storage.IThreadedFileIO**
- class **net.minecraft.world.storage.MapData**
- enum **net.minecraft.world.storage.MapDecoration$Type**
- class **net.minecraft.world.storage.MapDecoration**
- class **net.minecraft.world.storage.MapStorage**
- class **net.minecraft.world.storage.SaveDataMemoryStorage**
- class **net.minecraft.world.storage.SaveFormatOld**
- class **net.minecraft.world.storage.SaveHandler**
- class **net.minecraft.world.storage.SaveHandlerMP**
- class **net.minecraft.world.storage.ThreadedFileIOBase**
- class **net.minecraft.world.storage.WorldInfo**
- class **net.minecraft.world.storage.WorldSummary**
- interface **net.minecraft.world.storage.loot.ILootContainer**
- class **net.minecraft.world.storage.loot.LootContext$Builder**
- class **net.minecraft.world.storage.loot.LootContext$EntityTarget$Serializer**
- enum **net.minecraft.world.storage.loot.LootContext$EntityTarget**
- class **net.minecraft.world.storage.loot.LootContext**
- class **net.minecraft.world.storage.loot.LootEntry$Serializer**
- class **net.minecraft.world.storage.loot.LootEntry**
- class **net.minecraft.world.storage.loot.LootEntryEmpty**
- class **net.minecraft.world.storage.loot.LootEntryItem**
- class **net.minecraft.world.storage.loot.LootEntryTable**
- class **net.minecraft.world.storage.loot.LootPool$Serializer**
- class **net.minecraft.world.storage.loot.LootPool**
- class **net.minecraft.world.storage.loot.LootTable$Serializer**
- class **net.minecraft.world.storage.loot.LootTable**
- class **net.minecraft.world.storage.loot.LootTableList**
- class **net.minecraft.world.storage.loot.LootTableManager**
- class **net.minecraft.world.storage.loot.RandomValueRange$Serializer**
- class **net.minecraft.world.storage.loot.RandomValueRange**
- class **net.minecraft.world.storage.loot.conditions.EntityHasProperty$Serializer**
- class **net.minecraft.world.storage.loot.conditions.EntityHasProperty**
- class **net.minecraft.world.storage.loot.conditions.EntityHasScore$Serializer**
- class **net.minecraft.world.storage.loot.conditions.EntityHasScore**
- class **net.minecraft.world.storage.loot.conditions.KilledByPlayer$Serializer**
- class **net.minecraft.world.storage.loot.conditions.KilledByPlayer**
- class **net.minecraft.world.storage.loot.conditions.LootCondition$Serializer**
- interface **net.minecraft.world.storage.loot.conditions.LootCondition**
- class **net.minecraft.world.storage.loot.conditions.LootConditionManager$Serializer**
- class **net.minecraft.world.storage.loot.conditions.LootConditionManager**
- class **net.minecraft.world.storage.loot.conditions.RandomChance$Serializer**
- class **net.minecraft.world.storage.loot.conditions.RandomChance**
- class **net.minecraft.world.storage.loot.conditions.RandomChanceWithLooting$Serializer**
- class **net.minecraft.world.storage.loot.conditions.RandomChanceWithLooting**
- class **net.minecraft.world.storage.loot.functions.EnchantRandomly$Serializer**
- class **net.minecraft.world.storage.loot.functions.EnchantRandomly**
- class **net.minecraft.world.storage.loot.functions.EnchantWithLevels$Serializer**
- class **net.minecraft.world.storage.loot.functions.EnchantWithLevels**
- class **net.minecraft.world.storage.loot.functions.LootFunction$Serializer**
- class **net.minecraft.world.storage.loot.functions.LootFunction**
- class **net.minecraft.world.storage.loot.functions.LootFunctionManager$Serializer**
- class **net.minecraft.world.storage.loot.functions.LootFunctionManager**
- class **net.minecraft.world.storage.loot.functions.LootingEnchantBonus$Serializer**
- class **net.minecraft.world.storage.loot.functions.LootingEnchantBonus**
- class **net.minecraft.world.storage.loot.functions.SetAttributes$Serializer**
- class **net.minecraft.world.storage.loot.functions.SetAttributes**
- class **net.minecraft.world.storage.loot.functions.SetCount$Serializer**
- class **net.minecraft.world.storage.loot.functions.SetCount**
- class **net.minecraft.world.storage.loot.functions.SetDamage$Serializer**
- class **net.minecraft.world.storage.loot.functions.SetDamage**
- class **net.minecraft.world.storage.loot.functions.SetMetadata$Serializer**
- class **net.minecraft.world.storage.loot.functions.SetMetadata**
- class **net.minecraft.world.storage.loot.functions.SetNBT$Serializer**
- class **net.minecraft.world.storage.loot.functions.SetNBT**
- class **net.minecraft.world.storage.loot.functions.Smelt$Serializer**
- class **net.minecraft.world.storage.loot.functions.Smelt**
- class **net.minecraft.world.storage.loot.properties.EntityOnFire$Serializer**
- class **net.minecraft.world.storage.loot.properties.EntityOnFire**
- class **net.minecraft.world.storage.loot.properties.EntityProperty$Serializer**
- interface **net.minecraft.world.storage.loot.properties.EntityProperty**
- class **net.minecraft.world.storage.loot.properties.EntityPropertyManager**
- class **net.minecraftforge.classloading.FMLForgePlugin**
- class **net.minecraftforge.client.ClientCommandHandler**
- class **net.minecraftforge.client.EnumHelperClient**
- class **net.minecraftforge.client.ForgeHooksClient**
- class **net.minecraftforge.client.GuiIngameForge**
- interface **net.minecraftforge.client.IRenderContextHandler**
- class **net.minecraftforge.client.IRenderHandler**
- class **net.minecraftforge.client.ItemModelMesherForge**
- class **net.minecraftforge.client.MinecraftForgeClient**
- class **net.minecraftforge.client.event.ClientChatReceivedEvent**
- class **net.minecraftforge.client.event.DrawBlockHighlightEvent**
- class **net.minecraftforge.client.event.EntityViewRenderEvent$CameraSetup**
- class **net.minecraftforge.client.event.EntityViewRenderEvent$FOVModifier**
- class **net.minecraftforge.client.event.EntityViewRenderEvent$FogColors**
- class **net.minecraftforge.client.event.EntityViewRenderEvent$FogDensity**
- class **net.minecraftforge.client.event.EntityViewRenderEvent$RenderFogEvent**
- class **net.minecraftforge.client.event.EntityViewRenderEvent**
- class **net.minecraftforge.client.event.FOVUpdateEvent**
- class **net.minecraftforge.client.event.GuiOpenEvent**
- class **net.minecraftforge.client.event.GuiScreenEvent$ActionPerformedEvent$Post**
- class **net.minecraftforge.client.event.GuiScreenEvent$ActionPerformedEvent$Pre**
- class **net.minecraftforge.client.event.GuiScreenEvent$ActionPerformedEvent**
- class **net.minecraftforge.client.event.GuiScreenEvent$BackgroundDrawnEvent**
- class **net.minecraftforge.client.event.GuiScreenEvent$DrawScreenEvent$Post**
- class **net.minecraftforge.client.event.GuiScreenEvent$DrawScreenEvent$Pre**
- class **net.minecraftforge.client.event.GuiScreenEvent$DrawScreenEvent**
- class **net.minecraftforge.client.event.GuiScreenEvent$InitGuiEvent$Post**
- class **net.minecraftforge.client.event.GuiScreenEvent$InitGuiEvent$Pre**
- class **net.minecraftforge.client.event.GuiScreenEvent$InitGuiEvent**
- class **net.minecraftforge.client.event.GuiScreenEvent$KeyboardInputEvent$Post**
- class **net.minecraftforge.client.event.GuiScreenEvent$KeyboardInputEvent$Pre**
- class **net.minecraftforge.client.event.GuiScreenEvent$KeyboardInputEvent**
- class **net.minecraftforge.client.event.GuiScreenEvent$MouseInputEvent$Post**
- class **net.minecraftforge.client.event.GuiScreenEvent$MouseInputEvent$Pre**
- class **net.minecraftforge.client.event.GuiScreenEvent$MouseInputEvent**
- class **net.minecraftforge.client.event.GuiScreenEvent$PotionShiftEvent**
- class **net.minecraftforge.client.event.GuiScreenEvent**
- class **net.minecraftforge.client.event.ModelBakeEvent**
- class **net.minecraftforge.client.event.ModelRegistryEvent**
- class **net.minecraftforge.client.event.MouseEvent**
- enum **net.minecraftforge.client.event.RenderBlockOverlayEvent$OverlayType**
- class **net.minecraftforge.client.event.RenderBlockOverlayEvent**
- class **net.minecraftforge.client.event.RenderGameOverlayEvent$BossInfo**
- class **net.minecraftforge.client.event.RenderGameOverlayEvent$Chat**
- enum **net.minecraftforge.client.event.RenderGameOverlayEvent$ElementType**
- class **net.minecraftforge.client.event.RenderGameOverlayEvent$Post**
- class **net.minecraftforge.client.event.RenderGameOverlayEvent$Pre**
- class **net.minecraftforge.client.event.RenderGameOverlayEvent$Text**
- class **net.minecraftforge.client.event.RenderGameOverlayEvent**
- class **net.minecraftforge.client.event.RenderHandEvent**
- class **net.minecraftforge.client.event.RenderItemInFrameEvent**
- class **net.minecraftforge.client.event.RenderLivingEvent$Post**
- class **net.minecraftforge.client.event.RenderLivingEvent$Pre**
- class **net.minecraftforge.client.event.RenderLivingEvent$Specials$Post**
- class **net.minecraftforge.client.event.RenderLivingEvent$Specials$Pre**
- class **net.minecraftforge.client.event.RenderLivingEvent$Specials**
- class **net.minecraftforge.client.event.RenderLivingEvent**
- class **net.minecraftforge.client.event.RenderPlayerEvent$Post**
- class **net.minecraftforge.client.event.RenderPlayerEvent$Pre**
- class **net.minecraftforge.client.event.RenderPlayerEvent$SetArmorModel**
- class **net.minecraftforge.client.event.RenderPlayerEvent$Specials$Post**
- class **net.minecraftforge.client.event.RenderPlayerEvent$Specials$Pre**
- class **net.minecraftforge.client.event.RenderPlayerEvent$Specials**
- class **net.minecraftforge.client.event.RenderPlayerEvent**
- class **net.minecraftforge.client.event.RenderSpecificHandEvent**
- class **net.minecraftforge.client.event.RenderTooltipEvent$Post**
- class **net.minecraftforge.client.event.RenderTooltipEvent$PostBackground**
- class **net.minecraftforge.client.event.RenderTooltipEvent$PostText**
- class **net.minecraftforge.client.event.RenderTooltipEvent$Pre**
- class **net.minecraftforge.client.event.RenderTooltipEvent**
- class **net.minecraftforge.client.event.RenderWorldLastEvent**
- class **net.minecraftforge.client.event.ScreenshotEvent**
- class **net.minecraftforge.client.event.TextureStitchEvent$Post**
- class **net.minecraftforge.client.event.TextureStitchEvent$Pre**
- class **net.minecraftforge.client.event.TextureStitchEvent**
- class **net.minecraftforge.client.event.sound.PlaySoundEvent**
- class **net.minecraftforge.client.event.sound.PlaySoundSourceEvent**
- class **net.minecraftforge.client.event.sound.PlayStreamingSourceEvent**
- class **net.minecraftforge.client.event.sound.SoundEvent$SoundSourceEvent**
- class **net.minecraftforge.client.event.sound.SoundEvent**
- class **net.minecraftforge.client.event.sound.SoundLoadEvent**
- class **net.minecraftforge.client.event.sound.SoundSetupEvent**
- class **net.minecraftforge.client.gui.ForgeGuiFactory$ForgeConfigGui$AddModOverrideEntry**
- class **net.minecraftforge.client.gui.ForgeGuiFactory$ForgeConfigGui$ChunkLoaderEntry**
- class **net.minecraftforge.client.gui.ForgeGuiFactory$ForgeConfigGui$ClientEntry**
- class **net.minecraftforge.client.gui.ForgeGuiFactory$ForgeConfigGui$GeneralEntry**
- class **net.minecraftforge.client.gui.ForgeGuiFactory$ForgeConfigGui$ModIDEntry**
- class **net.minecraftforge.client.gui.ForgeGuiFactory$ForgeConfigGui$ModOverridesEntry**
- class **net.minecraftforge.client.gui.ForgeGuiFactory$ForgeConfigGui$VersionCheckEntry**
- class **net.minecraftforge.client.gui.ForgeGuiFactory$ForgeConfigGui**
- class **net.minecraftforge.client.gui.ForgeGuiFactory**
- class **net.minecraftforge.client.gui.NotificationModUpdateScreen**
- class **net.minecraftforge.client.model.Attributes**
- class **net.minecraftforge.client.model.BlockStateLoader$Marker**
- class **net.minecraftforge.client.model.BlockStateLoader$SubModel**
- class **net.minecraftforge.client.model.BlockStateLoader**
- class **net.minecraftforge.client.model.ForgeBlockStateV1$Deserializer**
- class **net.minecraftforge.client.model.ForgeBlockStateV1$TRSRDeserializer**
- class **net.minecraftforge.client.model.ForgeBlockStateV1$Variant$Deserializer**
- class **net.minecraftforge.client.model.ForgeBlockStateV1$Variant**
- class **net.minecraftforge.client.model.ForgeBlockStateV1**
- interface **net.minecraftforge.client.model.ICustomModelLoader**
- interface **net.minecraftforge.client.model.IModel**
- interface **net.minecraftforge.client.model.IModelCustomData**
- interface **net.minecraftforge.client.model.IModelSimpleProperties**
- interface **net.minecraftforge.client.model.IModelUVLock**
- class **net.minecraftforge.client.model.IPerspectiveAwareModel$MapWrapper**
- interface **net.minecraftforge.client.model.IPerspectiveAwareModel**
- interface **net.minecraftforge.client.model.IRetexturableModel**
- interface **net.minecraftforge.client.model.ISmartVariant**
- enum **net.minecraftforge.client.model.ItemLayerModel$Loader**
- class **net.minecraftforge.client.model.ItemLayerModel**
- class **net.minecraftforge.client.model.ItemTextureQuadConverter**
- class **net.minecraftforge.client.model.MapModelState$Wrapper**
- class **net.minecraftforge.client.model.MapModelState**
- enum **net.minecraftforge.client.model.ModelDynBucket$LoaderDynBucket**
- class **net.minecraftforge.client.model.ModelDynBucket**
- enum **net.minecraftforge.client.model.ModelFluid$FluidLoader**
- class **net.minecraftforge.client.model.ModelFluid**
- enum **net.minecraftforge.client.model.ModelLoader$VanillaLoader**
- enum **net.minecraftforge.client.model.ModelLoader$VariantLoader**
- class **net.minecraftforge.client.model.ModelLoader$White**
- class **net.minecraftforge.client.model.ModelLoader**
- class **net.minecraftforge.client.model.ModelLoaderRegistry$LoaderException**
- class **net.minecraftforge.client.model.ModelLoaderRegistry**
- class **net.minecraftforge.client.model.ModelProcessingHelper**
- class **net.minecraftforge.client.model.ModelStateComposition**
- enum **net.minecraftforge.client.model.MultiLayerModel$Loader**
- class **net.minecraftforge.client.model.MultiLayerModel**
- class **net.minecraftforge.client.model.MultiModel**
- class **net.minecraftforge.client.model.MultiModelState**
- class **net.minecraftforge.client.model.SimpleModelFontRenderer**
- class **net.minecraftforge.client.model.SimpleModelState**
- enum **net.minecraftforge.client.model.animation.Animation**
- class **net.minecraftforge.client.model.animation.AnimationItemOverrideList**
- class **net.minecraftforge.client.model.animation.AnimationModelBase**
- class **net.minecraftforge.client.model.animation.AnimationTESR**
- class **net.minecraftforge.client.model.animation.FastTESR**
- interface **net.minecraftforge.client.model.animation.IAnimatedModel**
- class **net.minecraftforge.client.model.animation.ModelBlockAnimation$MBClip$MBJointClip**
- class **net.minecraftforge.client.model.animation.ModelBlockAnimation$MBClip**
- class **net.minecraftforge.client.model.animation.ModelBlockAnimation$MBJoint**
- class **net.minecraftforge.client.model.animation.ModelBlockAnimation$MBJointWeight**
- class **net.minecraftforge.client.model.animation.ModelBlockAnimation$MBVariableClip**
- enum **net.minecraftforge.client.model.animation.ModelBlockAnimation$Parameter$Interpolation**
- enum **net.minecraftforge.client.model.animation.ModelBlockAnimation$Parameter$Type**
- enum **net.minecraftforge.client.model.animation.ModelBlockAnimation$Parameter$Variable**
- class **net.minecraftforge.client.model.animation.ModelBlockAnimation$Parameter**
- class **net.minecraftforge.client.model.animation.ModelBlockAnimation**
- class **net.minecraftforge.client.model.b3d.B3DClip$NodeClip**
- enum **net.minecraftforge.client.model.b3d.B3DClip**
- enum **net.minecraftforge.client.model.b3d.B3DLoader$B3DFrameProperty**
- class **net.minecraftforge.client.model.b3d.B3DLoader$B3DState**
- enum **net.minecraftforge.client.model.b3d.B3DLoader**
- class **net.minecraftforge.client.model.b3d.B3DModel$Animation**
- class **net.minecraftforge.client.model.b3d.B3DModel$Bone**
- class **net.minecraftforge.client.model.b3d.B3DModel$Brush**
- class **net.minecraftforge.client.model.b3d.B3DModel$Face**
- interface **net.minecraftforge.client.model.b3d.B3DModel$IKind**
- class **net.minecraftforge.client.model.b3d.B3DModel$Key**
- class **net.minecraftforge.client.model.b3d.B3DModel$Mesh**
- class **net.minecraftforge.client.model.b3d.B3DModel$Node**
- class **net.minecraftforge.client.model.b3d.B3DModel$Parser**
- class **net.minecraftforge.client.model.b3d.B3DModel$Pivot**
- class **net.minecraftforge.client.model.b3d.B3DModel$Texture**
- class **net.minecraftforge.client.model.b3d.B3DModel$Vertex**
- class **net.minecraftforge.client.model.b3d.B3DModel**
- enum **net.minecraftforge.client.model.obj.OBJLoader**
- class **net.minecraftforge.client.model.obj.OBJModel$Face**
- class **net.minecraftforge.client.model.obj.OBJModel$Group**
- class **net.minecraftforge.client.model.obj.OBJModel$Material**
- class **net.minecraftforge.client.model.obj.OBJModel$MaterialLibrary**
- class **net.minecraftforge.client.model.obj.OBJModel$Normal**
- enum **net.minecraftforge.client.model.obj.OBJModel$OBJProperty**
- enum **net.minecraftforge.client.model.obj.OBJModel$OBJState$Operation**
- class **net.minecraftforge.client.model.obj.OBJModel$OBJState**
- class **net.minecraftforge.client.model.obj.OBJModel$Parser**
- class **net.minecraftforge.client.model.obj.OBJModel$Texture**
- class **net.minecraftforge.client.model.obj.OBJModel$TextureCoordinate**
- class **net.minecraftforge.client.model.obj.OBJModel$UVsOutOfBoundsException**
- class **net.minecraftforge.client.model.obj.OBJModel$Vertex**
- class **net.minecraftforge.client.model.obj.OBJModel**
- class **net.minecraftforge.client.model.pipeline.BlockInfo**
- class **net.minecraftforge.client.model.pipeline.ForgeBlockModelRenderer**
- interface **net.minecraftforge.client.model.pipeline.IVertexConsumer**
- interface **net.minecraftforge.client.model.pipeline.IVertexProducer**
- class **net.minecraftforge.client.model.pipeline.LightUtil$ItemConsumer**
- class **net.minecraftforge.client.model.pipeline.LightUtil**
- class **net.minecraftforge.client.model.pipeline.QuadGatheringTransformer**
- class **net.minecraftforge.client.model.pipeline.TransformerConsumer**
- class **net.minecraftforge.client.model.pipeline.UnpackedBakedQuad$Builder**
- class **net.minecraftforge.client.model.pipeline.UnpackedBakedQuad**
- class **net.minecraftforge.client.model.pipeline.VertexBufferConsumer**
- class **net.minecraftforge.client.model.pipeline.VertexLighterFlat**
- class **net.minecraftforge.client.model.pipeline.VertexLighterSmoothAo**
- class **net.minecraftforge.client.model.pipeline.VertexTransformer**
- interface **net.minecraftforge.client.settings.IKeyConflictContext**
- class **net.minecraftforge.client.settings.KeyBindingMap**
- enum **net.minecraftforge.client.settings.KeyConflictContext**
- enum **net.minecraftforge.client.settings.KeyModifier**
- class **net.minecraftforge.common.AchievementPage**
- class **net.minecraftforge.common.BiomeDictionary$Type**
- class **net.minecraftforge.common.BiomeDictionary**
- class **net.minecraftforge.common.BiomeManager$BiomeEntry**
- enum **net.minecraftforge.common.BiomeManager$BiomeType**
- class **net.minecraftforge.common.BiomeManager**
- class **net.minecraftforge.common.DimensionManager**
- class **net.minecraftforge.common.DungeonHooks$DungeonMob**
- class **net.minecraftforge.common.DungeonHooks**
- enum **net.minecraftforge.common.EnumPlantType**
- class **net.minecraftforge.common.ForgeChunkManager$ForceChunkEvent**
- interface **net.minecraftforge.common.ForgeChunkManager$LoadingCallback**
- interface **net.minecraftforge.common.ForgeChunkManager$OrderedLoadingCallback**
- interface **net.minecraftforge.common.ForgeChunkManager$PlayerOrderedLoadingCallback**
- class **net.minecraftforge.common.ForgeChunkManager$Ticket**
- enum **net.minecraftforge.common.ForgeChunkManager$Type**
- class **net.minecraftforge.common.ForgeChunkManager$UnforceChunkEvent**
- class **net.minecraftforge.common.ForgeChunkManager**
- class **net.minecraftforge.common.ForgeHooks**
- class **net.minecraftforge.common.ForgeInternalHandler**
- class **net.minecraftforge.common.ForgeModContainer**
- class **net.minecraftforge.common.ForgeVersion$CheckResult**
- enum **net.minecraftforge.common.ForgeVersion$Status**
- class **net.minecraftforge.common.ForgeVersion**
- interface **net.minecraftforge.common.IMinecartCollisionHandler**
- interface **net.minecraftforge.common.IPlantable**
- interface **net.minecraftforge.common.IShearable**
- class **net.minecraftforge.common.ISpecialArmor$ArmorProperties**
- interface **net.minecraftforge.common.ISpecialArmor**
- class **net.minecraftforge.common.MinecraftForge**
- class **net.minecraftforge.common.UsernameCache**
- class **net.minecraftforge.common.WorldSpecificSaveHandler**
- class **net.minecraftforge.common.animation.Event**
- interface **net.minecraftforge.common.animation.IEventHandler**
- interface **net.minecraftforge.common.animation.ITimeValue**
- enum **net.minecraftforge.common.animation.TimeValues$CommonTimeValueTypeAdapterFactory**
- class **net.minecraftforge.common.animation.TimeValues$CompositionValue**
- class **net.minecraftforge.common.animation.TimeValues$ConstValue**
- enum **net.minecraftforge.common.animation.TimeValues$IdentityValue**
- class **net.minecraftforge.common.animation.TimeValues$ParameterValue**
- class **net.minecraftforge.common.animation.TimeValues$SimpleExprValue**
- class **net.minecraftforge.common.animation.TimeValues$VariableValue**
- class **net.minecraftforge.common.animation.TimeValues**
- class **net.minecraftforge.common.brewing.AbstractBrewingRecipe**
- class **net.minecraftforge.common.brewing.BrewingOreRecipe**
- class **net.minecraftforge.common.brewing.BrewingRecipe**
- class **net.minecraftforge.common.brewing.BrewingRecipeRegistry**
- interface **net.minecraftforge.common.brewing.IBrewingRecipe**
- class **net.minecraftforge.common.brewing.VanillaBrewingRecipe**
- interface **net.minecraftforge.common.capabilities.Capability$IStorage**
- class **net.minecraftforge.common.capabilities.Capability**
- class **net.minecraftforge.common.capabilities.CapabilityDispatcher**
- annotation **net.minecraftforge.common.capabilities.CapabilityInject**
- enum **net.minecraftforge.common.capabilities.CapabilityManager**
- interface **net.minecraftforge.common.capabilities.ICapabilityProvider**
- interface **net.minecraftforge.common.capabilities.ICapabilitySerializable**
- class **net.minecraftforge.common.chunkio.ChunkIOExecutor**
- annotation **net.minecraftforge.common.config.Config$Comment**
- annotation **net.minecraftforge.common.config.Config$LangKey**
- annotation **net.minecraftforge.common.config.Config$RangeDouble**
- annotation **net.minecraftforge.common.config.Config$RangeInt**
- enum **net.minecraftforge.common.config.Config$Type**
- annotation **net.minecraftforge.common.config.Config**
- class **net.minecraftforge.common.config.ConfigCategory**
- class **net.minecraftforge.common.config.ConfigElement**
- class **net.minecraftforge.common.config.ConfigManager**
- class **net.minecraftforge.common.config.Configuration$UnicodeInputStreamReader**
- class **net.minecraftforge.common.config.Configuration**
- enum **net.minecraftforge.common.config.Property$Type**
- class **net.minecraftforge.common.config.Property**
- interface **net.minecraftforge.common.model.IModelPart**
- interface **net.minecraftforge.common.model.IModelState**
- interface **net.minecraftforge.common.model.ITransformation**
- enum **net.minecraftforge.common.model.Models**
- class **net.minecraftforge.common.model.TRSRTransformation**
- class **net.minecraftforge.common.model.animation.AnimationStateMachine**
- class **net.minecraftforge.common.model.animation.CapabilityAnimation$DefaultItemAnimationCapabilityProvider**
- class **net.minecraftforge.common.model.animation.CapabilityAnimation**
- class **net.minecraftforge.common.model.animation.Clips$ClipReference**
- enum **net.minecraftforge.common.model.animation.Clips$CommonClipTypeAdapterFactory**
- enum **net.minecraftforge.common.model.animation.Clips$IdentityClip**
- class **net.minecraftforge.common.model.animation.Clips$ModelClip**
- class **net.minecraftforge.common.model.animation.Clips$SlerpClip**
- class **net.minecraftforge.common.model.animation.Clips$TimeClip**
- class **net.minecraftforge.common.model.animation.Clips$TriggerClip**
- class **net.minecraftforge.common.model.animation.Clips**
- interface **net.minecraftforge.common.model.animation.IAnimationStateMachine**
- interface **net.minecraftforge.common.model.animation.IClip**
- interface **net.minecraftforge.common.model.animation.IJoint**
- interface **net.minecraftforge.common.model.animation.IJointClip**
- enum **net.minecraftforge.common.model.animation.JointClips$IdentityJointClip**
- class **net.minecraftforge.common.model.animation.JointClips$NodeJointClip**
- class **net.minecraftforge.common.model.animation.JointClips**
- class **net.minecraftforge.common.network.DimensionMessageHandler**
- class **net.minecraftforge.common.network.FluidIdRegistryMessageHandler**
- class **net.minecraftforge.common.network.ForgeMessage$DimensionRegisterMessage**
- class **net.minecraftforge.common.network.ForgeMessage$FluidIdMapMessage**
- class **net.minecraftforge.common.network.ForgeMessage**
- class **net.minecraftforge.common.network.ForgeNetworkHandler**
- class **net.minecraftforge.common.network.ForgeRuntimeCodec**
- class **net.minecraftforge.common.network.ServerToClientConnectionEstablishedHandler**
- class **net.minecraftforge.common.property.ExtendedBlockState$ExtendedStateImplementation**
- class **net.minecraftforge.common.property.ExtendedBlockState**
- interface **net.minecraftforge.common.property.IExtendedBlockState**
- interface **net.minecraftforge.common.property.IUnlistedProperty**
- class **net.minecraftforge.common.property.Properties$PropertyAdapter**
- class **net.minecraftforge.common.property.Properties**
- class **net.minecraftforge.common.property.PropertyFloat**
- class **net.minecraftforge.common.util.BlockSnapshot**
- class **net.minecraftforge.common.util.ChunkCoordComparator**
- class **net.minecraftforge.common.util.CompoundDataFixer**
- class **net.minecraftforge.common.util.Constants$NBT**
- class **net.minecraftforge.common.util.Constants**
- class **net.minecraftforge.common.util.EnumHelper**
- class **net.minecraftforge.common.util.FakePlayer**
- class **net.minecraftforge.common.util.FakePlayerFactory**
- interface **net.minecraftforge.common.util.IDataFixerData**
- interface **net.minecraftforge.common.util.INBTSerializable**
- class **net.minecraftforge.common.util.Java6Utils**
- enum **net.minecraftforge.common.util.JsonUtils$ImmutableListTypeAdapter**
- enum **net.minecraftforge.common.util.JsonUtils$ImmutableMapTypeAdapter**
- class **net.minecraftforge.common.util.JsonUtils**
- class **net.minecraftforge.common.util.ModFixs**
- class **net.minecraftforge.common.util.WorldCapabilityData**
- class **net.minecraftforge.energy.CapabilityEnergy**
- class **net.minecraftforge.energy.EnergyStorage**
- interface **net.minecraftforge.energy.IEnergyStorage**
- class **net.minecraftforge.event.AnvilUpdateEvent**
- class **net.minecraftforge.event.AttachCapabilitiesEvent$Entity**
- class **net.minecraftforge.event.AttachCapabilitiesEvent$Item**
- class **net.minecraftforge.event.AttachCapabilitiesEvent$TileEntity**
- class **net.minecraftforge.event.AttachCapabilitiesEvent$World**
- class **net.minecraftforge.event.AttachCapabilitiesEvent**
- class **net.minecraftforge.event.CommandEvent**
- class **net.minecraftforge.event.EntitySelectorEvent**
- class **net.minecraftforge.event.ForgeEventFactory**
- class **net.minecraftforge.event.LootTableLoadEvent**
- class **net.minecraftforge.event.RegistryEvent$NewRegistry**
- class **net.minecraftforge.event.RegistryEvent$Register**
- class **net.minecraftforge.event.RegistryEvent**
- class **net.minecraftforge.event.ServerChatEvent**
- class **net.minecraftforge.event.brewing.PlayerBrewedPotionEvent**
- class **net.minecraftforge.event.brewing.PotionBrewEvent$Post**
- class **net.minecraftforge.event.brewing.PotionBrewEvent$Pre**
- class **net.minecraftforge.event.brewing.PotionBrewEvent**
- class **net.minecraftforge.event.enchanting.EnchantmentLevelSetEvent**
- class **net.minecraftforge.event.entity.EntityEvent$CanUpdate**
- class **net.minecraftforge.event.entity.EntityEvent$EnteringChunk**
- class **net.minecraftforge.event.entity.EntityEvent$EntityConstructing**
- class **net.minecraftforge.event.entity.EntityEvent**
- class **net.minecraftforge.event.entity.EntityJoinWorldEvent**
- class **net.minecraftforge.event.entity.EntityMountEvent**
- class **net.minecraftforge.event.entity.EntityStruckByLightningEvent**
- class **net.minecraftforge.event.entity.EntityTravelToDimensionEvent**
- class **net.minecraftforge.event.entity.PlaySoundAtEntityEvent**
- class **net.minecraftforge.event.entity.ThrowableImpactEvent**
- class **net.minecraftforge.event.entity.item.ItemEvent**
- class **net.minecraftforge.event.entity.item.ItemExpireEvent**
- class **net.minecraftforge.event.entity.item.ItemTossEvent**
- class **net.minecraftforge.event.entity.living.BabyEntitySpawnEvent**
- class **net.minecraftforge.event.entity.living.EnderTeleportEvent**
- class **net.minecraftforge.event.entity.living.LivingAttackEvent**
- class **net.minecraftforge.event.entity.living.LivingDeathEvent**
- class **net.minecraftforge.event.entity.living.LivingDropsEvent**
- class **net.minecraftforge.event.entity.living.LivingEntityUseItemEvent$Finish**
- class **net.minecraftforge.event.entity.living.LivingEntityUseItemEvent$Start**
- class **net.minecraftforge.event.entity.living.LivingEntityUseItemEvent$Stop**
- class **net.minecraftforge.event.entity.living.LivingEntityUseItemEvent$Tick**
- class **net.minecraftforge.event.entity.living.LivingEntityUseItemEvent**
- class **net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent**
- class **net.minecraftforge.event.entity.living.LivingEvent$LivingJumpEvent**
- class **net.minecraftforge.event.entity.living.LivingEvent$LivingUpdateEvent**
- class **net.minecraftforge.event.entity.living.LivingEvent**
- class **net.minecraftforge.event.entity.living.LivingExperienceDropEvent**
- class **net.minecraftforge.event.entity.living.LivingFallEvent**
- class **net.minecraftforge.event.entity.living.LivingHealEvent**
- class **net.minecraftforge.event.entity.living.LivingHurtEvent**
- class **net.minecraftforge.event.entity.living.LivingPackSizeEvent**
- class **net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent**
- class **net.minecraftforge.event.entity.living.LivingSpawnEvent$AllowDespawn**
- class **net.minecraftforge.event.entity.living.LivingSpawnEvent$CheckSpawn**
- class **net.minecraftforge.event.entity.living.LivingSpawnEvent$SpecialSpawn**
- class **net.minecraftforge.event.entity.living.LivingSpawnEvent**
- class **net.minecraftforge.event.entity.living.LootingLevelEvent**
- class **net.minecraftforge.event.entity.living.PotionColorCalculationEvent**
- class **net.minecraftforge.event.entity.living.ZombieEvent$SummonAidEvent**
- class **net.minecraftforge.event.entity.living.ZombieEvent**
- class **net.minecraftforge.event.entity.minecart.MinecartCollisionEvent**
- class **net.minecraftforge.event.entity.minecart.MinecartEvent**
- class **net.minecraftforge.event.entity.minecart.MinecartInteractEvent**
- class **net.minecraftforge.event.entity.minecart.MinecartUpdateEvent**
- class **net.minecraftforge.event.entity.player.AchievementEvent**
- class **net.minecraftforge.event.entity.player.AnvilRepairEvent**
- class **net.minecraftforge.event.entity.player.ArrowLooseEvent**
- class **net.minecraftforge.event.entity.player.ArrowNockEvent**
- class **net.minecraftforge.event.entity.player.AttackEntityEvent**
- class **net.minecraftforge.event.entity.player.BonemealEvent**
- class **net.minecraftforge.event.entity.player.EntityItemPickupEvent**
- class **net.minecraftforge.event.entity.player.FillBucketEvent**
- class **net.minecraftforge.event.entity.player.ItemTooltipEvent**
- class **net.minecraftforge.event.entity.player.PlayerContainerEvent$Close**
- class **net.minecraftforge.event.entity.player.PlayerContainerEvent$Open**
- class **net.minecraftforge.event.entity.player.PlayerContainerEvent**
- class **net.minecraftforge.event.entity.player.PlayerDestroyItemEvent**
- class **net.minecraftforge.event.entity.player.PlayerDropsEvent**
- class **net.minecraftforge.event.entity.player.PlayerEvent$BreakSpeed**
- class **net.minecraftforge.event.entity.player.PlayerEvent$Clone**
- class **net.minecraftforge.event.entity.player.PlayerEvent$HarvestCheck**
- class **net.minecraftforge.event.entity.player.PlayerEvent$LoadFromFile**
- class **net.minecraftforge.event.entity.player.PlayerEvent$NameFormat**
- class **net.minecraftforge.event.entity.player.PlayerEvent$SaveToFile**
- class **net.minecraftforge.event.entity.player.PlayerEvent$StartTracking**
- class **net.minecraftforge.event.entity.player.PlayerEvent$StopTracking**
- class **net.minecraftforge.event.entity.player.PlayerEvent$Visibility**
- class **net.minecraftforge.event.entity.player.PlayerEvent**
- class **net.minecraftforge.event.entity.player.PlayerFlyableFallEvent**
- class **net.minecraftforge.event.entity.player.PlayerInteractEvent$EntityInteract**
- class **net.minecraftforge.event.entity.player.PlayerInteractEvent$EntityInteractSpecific**
- class **net.minecraftforge.event.entity.player.PlayerInteractEvent$LeftClickBlock**
- class **net.minecraftforge.event.entity.player.PlayerInteractEvent$LeftClickEmpty**
- class **net.minecraftforge.event.entity.player.PlayerInteractEvent$RightClickBlock**
- class **net.minecraftforge.event.entity.player.PlayerInteractEvent$RightClickEmpty**
- class **net.minecraftforge.event.entity.player.PlayerInteractEvent$RightClickItem**
- class **net.minecraftforge.event.entity.player.PlayerInteractEvent**
- class **net.minecraftforge.event.entity.player.PlayerPickupXpEvent**
- class **net.minecraftforge.event.entity.player.PlayerSetSpawnEvent**
- class **net.minecraftforge.event.entity.player.PlayerSleepInBedEvent**
- class **net.minecraftforge.event.entity.player.PlayerWakeUpEvent**
- class **net.minecraftforge.event.entity.player.SleepingLocationCheckEvent**
- class **net.minecraftforge.event.entity.player.UseHoeEvent**
- class **net.minecraftforge.event.terraingen.BiomeEvent$BiomeColor**
- class **net.minecraftforge.event.terraingen.BiomeEvent$CreateDecorator**
- class **net.minecraftforge.event.terraingen.BiomeEvent$GetFoliageColor**
- class **net.minecraftforge.event.terraingen.BiomeEvent$GetGrassColor**
- class **net.minecraftforge.event.terraingen.BiomeEvent$GetVillageBlockID**
- class **net.minecraftforge.event.terraingen.BiomeEvent$GetWaterColor**
- class **net.minecraftforge.event.terraingen.BiomeEvent**
- class **net.minecraftforge.event.terraingen.ChunkGeneratorEvent$InitNoiseField**
- class **net.minecraftforge.event.terraingen.ChunkGeneratorEvent$ReplaceBiomeBlocks**
- class **net.minecraftforge.event.terraingen.ChunkGeneratorEvent**
- enum **net.minecraftforge.event.terraingen.DecorateBiomeEvent$Decorate$EventType**
- class **net.minecraftforge.event.terraingen.DecorateBiomeEvent$Decorate**
- class **net.minecraftforge.event.terraingen.DecorateBiomeEvent$Post**
- class **net.minecraftforge.event.terraingen.DecorateBiomeEvent$Pre**
- class **net.minecraftforge.event.terraingen.DecorateBiomeEvent**
- class **net.minecraftforge.event.terraingen.DeferredBiomeDecorator**
- enum **net.minecraftforge.event.terraingen.InitMapGenEvent$EventType**
- class **net.minecraftforge.event.terraingen.InitMapGenEvent**
- class **net.minecraftforge.event.terraingen.InitNoiseGensEvent$Context**
- class **net.minecraftforge.event.terraingen.InitNoiseGensEvent$ContextEnd**
- class **net.minecraftforge.event.terraingen.InitNoiseGensEvent$ContextHell**
- class **net.minecraftforge.event.terraingen.InitNoiseGensEvent$ContextOverworld**
- class **net.minecraftforge.event.terraingen.InitNoiseGensEvent**
- enum **net.minecraftforge.event.terraingen.OreGenEvent$GenerateMinable$EventType**
- class **net.minecraftforge.event.terraingen.OreGenEvent$GenerateMinable**
- class **net.minecraftforge.event.terraingen.OreGenEvent$Post**
- class **net.minecraftforge.event.terraingen.OreGenEvent$Pre**
- class **net.minecraftforge.event.terraingen.OreGenEvent**
- enum **net.minecraftforge.event.terraingen.PopulateChunkEvent$Populate$EventType**
- class **net.minecraftforge.event.terraingen.PopulateChunkEvent$Populate**
- class **net.minecraftforge.event.terraingen.PopulateChunkEvent$Post**
- class **net.minecraftforge.event.terraingen.PopulateChunkEvent$Pre**
- class **net.minecraftforge.event.terraingen.PopulateChunkEvent**
- class **net.minecraftforge.event.terraingen.SaplingGrowTreeEvent**
- class **net.minecraftforge.event.terraingen.TerrainGen**
- class **net.minecraftforge.event.terraingen.WorldTypeEvent$BiomeSize**
- class **net.minecraftforge.event.terraingen.WorldTypeEvent$InitBiomeGens**
- class **net.minecraftforge.event.terraingen.WorldTypeEvent**
- class **net.minecraftforge.event.world.BlockEvent$BreakEvent**
- class **net.minecraftforge.event.world.BlockEvent$CreateFluidSourceEvent**
- class **net.minecraftforge.event.world.BlockEvent$CropGrowEvent$Post**
- class **net.minecraftforge.event.world.BlockEvent$CropGrowEvent$Pre**
- class **net.minecraftforge.event.world.BlockEvent$CropGrowEvent**
- class **net.minecraftforge.event.world.BlockEvent$HarvestDropsEvent**
- class **net.minecraftforge.event.world.BlockEvent$MultiPlaceEvent**
- class **net.minecraftforge.event.world.BlockEvent$NeighborNotifyEvent**
- class **net.minecraftforge.event.world.BlockEvent$PlaceEvent**
- class **net.minecraftforge.event.world.BlockEvent**
- class **net.minecraftforge.event.world.ChunkDataEvent$Load**
- class **net.minecraftforge.event.world.ChunkDataEvent$Save**
- class **net.minecraftforge.event.world.ChunkDataEvent**
- class **net.minecraftforge.event.world.ChunkEvent$Load**
- class **net.minecraftforge.event.world.ChunkEvent$Unload**
- class **net.minecraftforge.event.world.ChunkEvent**
- class **net.minecraftforge.event.world.ChunkWatchEvent$UnWatch**
- class **net.minecraftforge.event.world.ChunkWatchEvent$Watch**
- class **net.minecraftforge.event.world.ChunkWatchEvent**
- class **net.minecraftforge.event.world.ExplosionEvent$Detonate**
- class **net.minecraftforge.event.world.ExplosionEvent$Start**
- class **net.minecraftforge.event.world.ExplosionEvent**
- class **net.minecraftforge.event.world.GetCollisionBoxesEvent**
- class **net.minecraftforge.event.world.NoteBlockEvent$Change**
- enum **net.minecraftforge.event.world.NoteBlockEvent$Instrument**
- enum **net.minecraftforge.event.world.NoteBlockEvent$Note**
- enum **net.minecraftforge.event.world.NoteBlockEvent$Octave**
- class **net.minecraftforge.event.world.NoteBlockEvent$Play**
- class **net.minecraftforge.event.world.NoteBlockEvent**
- class **net.minecraftforge.event.world.WorldEvent$CreateSpawnPosition**
- class **net.minecraftforge.event.world.WorldEvent$Load**
- class **net.minecraftforge.event.world.WorldEvent$PotentialSpawns**
- class **net.minecraftforge.event.world.WorldEvent$Save**
- class **net.minecraftforge.event.world.WorldEvent$Unload**
- class **net.minecraftforge.event.world.WorldEvent**
- class **net.minecraftforge.fluids.BlockFluidBase**
- class **net.minecraftforge.fluids.BlockFluidClassic**
- class **net.minecraftforge.fluids.BlockFluidFinite**
- class **net.minecraftforge.fluids.DispenseFluidContainer**
- class **net.minecraftforge.fluids.Fluid**
- class **net.minecraftforge.fluids.FluidActionResult**
- class **net.minecraftforge.fluids.FluidEvent$FluidDrainingEvent**
- class **net.minecraftforge.fluids.FluidEvent$FluidFillingEvent**
- class **net.minecraftforge.fluids.FluidEvent$FluidMotionEvent**
- class **net.minecraftforge.fluids.FluidEvent$FluidSpilledEvent**
- class **net.minecraftforge.fluids.FluidEvent**
- class **net.minecraftforge.fluids.FluidRegistry$FluidRegisterEvent**
- class **net.minecraftforge.fluids.FluidRegistry**
- class **net.minecraftforge.fluids.FluidStack**
- class **net.minecraftforge.fluids.FluidTank**
- class **net.minecraftforge.fluids.FluidTankInfo**
- class **net.minecraftforge.fluids.FluidUtil**
- interface **net.minecraftforge.fluids.IFluidBlock**
- interface **net.minecraftforge.fluids.IFluidTank**
- class **net.minecraftforge.fluids.UniversalBucket**
- class **net.minecraftforge.fluids.capability.CapabilityFluidHandler**
- class **net.minecraftforge.fluids.capability.FluidTankProperties**
- class **net.minecraftforge.fluids.capability.FluidTankPropertiesWrapper**
- interface **net.minecraftforge.fluids.capability.IFluidHandler**
- interface **net.minecraftforge.fluids.capability.IFluidHandlerItem**
- interface **net.minecraftforge.fluids.capability.IFluidTankProperties**
- class **net.minecraftforge.fluids.capability.ItemFluidContainer**
- class **net.minecraftforge.fluids.capability.TileFluidHandler**
- class **net.minecraftforge.fluids.capability.templates.EmptyFluidHandler**
- class **net.minecraftforge.fluids.capability.templates.FluidHandlerConcatenate**
- class **net.minecraftforge.fluids.capability.templates.FluidHandlerFluidMap**
- class **net.minecraftforge.fluids.capability.templates.FluidHandlerItemStack$Consumable**
- class **net.minecraftforge.fluids.capability.templates.FluidHandlerItemStack$SwapEmpty**
- class **net.minecraftforge.fluids.capability.templates.FluidHandlerItemStack**
- class **net.minecraftforge.fluids.capability.templates.FluidHandlerItemStackSimple$Consumable**
- class **net.minecraftforge.fluids.capability.templates.FluidHandlerItemStackSimple$SwapEmpty**
- class **net.minecraftforge.fluids.capability.templates.FluidHandlerItemStackSimple**
- class **net.minecraftforge.fluids.capability.templates.VoidFluidHandler**
- class **net.minecraftforge.fluids.capability.wrappers.BlockLiquidWrapper**
- class **net.minecraftforge.fluids.capability.wrappers.BlockWrapper**
- class **net.minecraftforge.fluids.capability.wrappers.FluidBlockWrapper**
- class **net.minecraftforge.fluids.capability.wrappers.FluidBucketWrapper**
- class **net.minecraftforge.fml.client.CustomModLoadingErrorDisplayException**
- class **net.minecraftforge.fml.client.ExtendedServerListData**
- class **net.minecraftforge.fml.client.FMLClientHandler**
- class **net.minecraftforge.fml.client.FMLConfigGuiFactory$FMLConfigGuiScreen**
- class **net.minecraftforge.fml.client.FMLConfigGuiFactory**
- class **net.minecraftforge.fml.client.FMLFileResourcePack**
- class **net.minecraftforge.fml.client.FMLFolderResourcePack**
- class **net.minecraftforge.fml.client.GuiAccessDenied**
- class **net.minecraftforge.fml.client.GuiBackupFailed**
- class **net.minecraftforge.fml.client.GuiConfirmation**
- class **net.minecraftforge.fml.client.GuiCustomModLoadingErrorScreen**
- class **net.minecraftforge.fml.client.GuiDupesFound**
- class **net.minecraftforge.fml.client.GuiJava8Error**
- class **net.minecraftforge.fml.client.GuiModList**
- class **net.minecraftforge.fml.client.GuiModsMissing**
- class **net.minecraftforge.fml.client.GuiModsMissingForServer**
- class **net.minecraftforge.fml.client.GuiNotification**
- class **net.minecraftforge.fml.client.GuiOldSaveLoadConfirm**
- class **net.minecraftforge.fml.client.GuiScrollingList**
- class **net.minecraftforge.fml.client.GuiSlotModList**
- class **net.minecraftforge.fml.client.GuiSortingProblem**
- class **net.minecraftforge.fml.client.GuiWrongMinecraft**
- class **net.minecraftforge.fml.client.IModGuiFactory$RuntimeOptionCategoryElement**
- interface **net.minecraftforge.fml.client.IModGuiFactory$RuntimeOptionGuiHandler**
- interface **net.minecraftforge.fml.client.IModGuiFactory**
- class **net.minecraftforge.fml.client.SplashProgress**
- enum **net.minecraftforge.fml.client.config.ConfigGuiType**
- class **net.minecraftforge.fml.client.config.DummyConfigElement$DummyCategoryElement**
- class **net.minecraftforge.fml.client.config.DummyConfigElement$DummyListElement**
- class **net.minecraftforge.fml.client.config.DummyConfigElement**
- class **net.minecraftforge.fml.client.config.GuiButtonExt**
- class **net.minecraftforge.fml.client.config.GuiCheckBox**
- class **net.minecraftforge.fml.client.config.GuiConfig**
- class **net.minecraftforge.fml.client.config.GuiConfigEntries$ArrayEntry**
- class **net.minecraftforge.fml.client.config.GuiConfigEntries$BooleanEntry**
- class **net.minecraftforge.fml.client.config.GuiConfigEntries$ButtonEntry**
- class **net.minecraftforge.fml.client.config.GuiConfigEntries$CategoryEntry**
- class **net.minecraftforge.fml.client.config.GuiConfigEntries$ChatColorEntry**
- class **net.minecraftforge.fml.client.config.GuiConfigEntries$CycleValueEntry**
- class **net.minecraftforge.fml.client.config.GuiConfigEntries$DoubleEntry**
- interface **net.minecraftforge.fml.client.config.GuiConfigEntries$IConfigEntry**
- class **net.minecraftforge.fml.client.config.GuiConfigEntries$IntegerEntry**
- class **net.minecraftforge.fml.client.config.GuiConfigEntries$ListEntryBase**
- class **net.minecraftforge.fml.client.config.GuiConfigEntries$NumberSliderEntry**
- class **net.minecraftforge.fml.client.config.GuiConfigEntries$SelectValueEntry**
- class **net.minecraftforge.fml.client.config.GuiConfigEntries$StringEntry**
- class **net.minecraftforge.fml.client.config.GuiConfigEntries**
- class **net.minecraftforge.fml.client.config.GuiEditArray**
- class **net.minecraftforge.fml.client.config.GuiEditArrayEntries$BaseEntry**
- class **net.minecraftforge.fml.client.config.GuiEditArrayEntries$BooleanEntry**
- class **net.minecraftforge.fml.client.config.GuiEditArrayEntries$DoubleEntry**
- interface **net.minecraftforge.fml.client.config.GuiEditArrayEntries$IArrayEntry**
- class **net.minecraftforge.fml.client.config.GuiEditArrayEntries$IntegerEntry**
- class **net.minecraftforge.fml.client.config.GuiEditArrayEntries$StringEntry**
- class **net.minecraftforge.fml.client.config.GuiEditArrayEntries**
- class **net.minecraftforge.fml.client.config.GuiMessageDialog**
- class **net.minecraftforge.fml.client.config.GuiSelectString**
- class **net.minecraftforge.fml.client.config.GuiSelectStringEntries$EntryComparator**
- interface **net.minecraftforge.fml.client.config.GuiSelectStringEntries$IGuiSelectStringListEntry**
- class **net.minecraftforge.fml.client.config.GuiSelectStringEntries$ListEntry**
- class **net.minecraftforge.fml.client.config.GuiSelectStringEntries**
- interface **net.minecraftforge.fml.client.config.GuiSlider$ISlider**
- class **net.minecraftforge.fml.client.config.GuiSlider**
- class **net.minecraftforge.fml.client.config.GuiUnicodeGlyphButton**
- class **net.minecraftforge.fml.client.config.GuiUtils**
- class **net.minecraftforge.fml.client.config.HoverChecker**
- interface **net.minecraftforge.fml.client.config.IConfigElement**
- class **net.minecraftforge.fml.client.event.ConfigChangedEvent$OnConfigChangedEvent**
- class **net.minecraftforge.fml.client.event.ConfigChangedEvent$PostConfigChangedEvent**
- class **net.minecraftforge.fml.client.event.ConfigChangedEvent**
- class **net.minecraftforge.fml.client.registry.ClientRegistry**
- interface **net.minecraftforge.fml.client.registry.IRenderFactory**
- class **net.minecraftforge.fml.client.registry.RenderingRegistry**
- annotation **net.minecraftforge.fml.common.API**
- class **net.minecraftforge.fml.common.AutomaticEventSubscriber**
- class **net.minecraftforge.fml.common.CertificateHelper**
- class **net.minecraftforge.fml.common.ClassNameUtils**
- class **net.minecraftforge.fml.common.DummyModContainer**
- class **net.minecraftforge.fml.common.DuplicateModsFoundException**
- class **net.minecraftforge.fml.common.EnhancedRuntimeException$WrappedPrintStream**
- class **net.minecraftforge.fml.common.EnhancedRuntimeException**
- class **net.minecraftforge.fml.common.FMLCommonHandler**
- class **net.minecraftforge.fml.common.FMLContainer**
- interface **net.minecraftforge.fml.common.FMLContainerHolder**
- class **net.minecraftforge.fml.common.FMLLog**
- class **net.minecraftforge.fml.common.FMLModContainer**
- interface **net.minecraftforge.fml.common.ICrashCallable**
- interface **net.minecraftforge.fml.common.IFMLHandledException**
- interface **net.minecraftforge.fml.common.IFMLSidedHandler**
- interface **net.minecraftforge.fml.common.IFuelHandler**
- class **net.minecraftforge.fml.common.ILanguageAdapter$JavaAdapter**
- class **net.minecraftforge.fml.common.ILanguageAdapter$ScalaAdapter**
- interface **net.minecraftforge.fml.common.ILanguageAdapter**
- interface **net.minecraftforge.fml.common.IWorldGenerator**
- class **net.minecraftforge.fml.common.InjectedModContainer**
- class **net.minecraftforge.fml.common.Java8VersionException**
- class **net.minecraftforge.fml.common.LoadController**
- class **net.minecraftforge.fml.common.Loader**
- class **net.minecraftforge.fml.common.LoaderException**
- class **net.minecraftforge.fml.common.LoaderExceptionModCrash**
- enum **net.minecraftforge.fml.common.LoaderState$ModState**
- enum **net.minecraftforge.fml.common.LoaderState**
- class **net.minecraftforge.fml.common.MCPDummyContainer**
- class **net.minecraftforge.fml.common.MetadataCollection$ArtifactVersionAdapter**
- class **net.minecraftforge.fml.common.MetadataCollection**
- class **net.minecraftforge.fml.common.MinecraftDummyContainer**
- class **net.minecraftforge.fml.common.MissingModsException**
- annotation **net.minecraftforge.fml.common.Mod$CustomProperty**
- annotation **net.minecraftforge.fml.common.Mod$EventBusSubscriber**
- annotation **net.minecraftforge.fml.common.Mod$EventHandler**
- annotation **net.minecraftforge.fml.common.Mod$Instance**
- annotation **net.minecraftforge.fml.common.Mod$InstanceFactory**
- annotation **net.minecraftforge.fml.common.Mod$Metadata**
- annotation **net.minecraftforge.fml.common.Mod**
- class **net.minecraftforge.fml.common.ModAPIManager**
- class **net.minecraftforge.fml.common.ModClassLoader**
- enum **net.minecraftforge.fml.common.ModContainer$Disableable**
- interface **net.minecraftforge.fml.common.ModContainer**
- class **net.minecraftforge.fml.common.ModContainerFactory**
- class **net.minecraftforge.fml.common.ModMetadata**
- class **net.minecraftforge.fml.common.ObfuscationReflectionHelper**
- annotation **net.minecraftforge.fml.common.Optional$Interface**
- annotation **net.minecraftforge.fml.common.Optional$InterfaceList**
- annotation **net.minecraftforge.fml.common.Optional$Method**
- class **net.minecraftforge.fml.common.Optional**
- class **net.minecraftforge.fml.common.ProgressManager$ProgressBar**
- class **net.minecraftforge.fml.common.ProgressManager**
- class **net.minecraftforge.fml.common.ProxyInjector**
- annotation **net.minecraftforge.fml.common.SaveInspectionHandler**
- annotation **net.minecraftforge.fml.common.SidedProxy**
- class **net.minecraftforge.fml.common.StartupQuery$AbortedException**
- class **net.minecraftforge.fml.common.StartupQuery**
- class **net.minecraftforge.fml.common.TracingPrintStream**
- interface **net.minecraftforge.fml.common.WorldAccessContainer**
- class **net.minecraftforge.fml.common.WrongMinecraftVersionException**
- class **net.minecraftforge.fml.common.ZipperUtil**
- class **net.minecraftforge.fml.common.asm.ASMTransformerWrapper$TransformerWrapper**
- class **net.minecraftforge.fml.common.asm.ASMTransformerWrapper**
- class **net.minecraftforge.fml.common.asm.FMLSanityChecker**
- annotation **net.minecraftforge.fml.common.asm.ReobfuscationMarker**
- class **net.minecraftforge.fml.common.asm.transformers.AccessTransformer**
- class **net.minecraftforge.fml.common.asm.transformers.BlamingTransformer$VersionVisitor**
- class **net.minecraftforge.fml.common.asm.transformers.BlamingTransformer**
- class **net.minecraftforge.fml.common.asm.transformers.DeobfuscationTransformer**
- class **net.minecraftforge.fml.common.asm.transformers.EventSubscriberTransformer**
- class **net.minecraftforge.fml.common.asm.transformers.EventSubscriptionTransformer**
- class **net.minecraftforge.fml.common.asm.transformers.ItemStackTransformer**
- class **net.minecraftforge.fml.common.asm.transformers.MarkerTransformer**
- class **net.minecraftforge.fml.common.asm.transformers.ModAPITransformer**
- class **net.minecraftforge.fml.common.asm.transformers.ModAccessTransformer**
- class **net.minecraftforge.fml.common.asm.transformers.PatchingTransformer**
- class **net.minecraftforge.fml.common.asm.transformers.SideTransformer**
- class **net.minecraftforge.fml.common.asm.transformers.TerminalTransformer$ExitVisitor**
- class **net.minecraftforge.fml.common.asm.transformers.TerminalTransformer**
- class **net.minecraftforge.fml.common.asm.transformers.deobf.FMLDeobfuscatingRemapper**
- class **net.minecraftforge.fml.common.asm.transformers.deobf.FMLRemappingAdapter**
- class **net.minecraftforge.fml.common.asm.transformers.deobf.LZMAInputSupplier**
- class **net.minecraftforge.fml.common.discovery.ASMDataTable$ASMData**
- class **net.minecraftforge.fml.common.discovery.ASMDataTable**
- enum **net.minecraftforge.fml.common.discovery.ContainerType**
- class **net.minecraftforge.fml.common.discovery.DirectoryDiscoverer**
- interface **net.minecraftforge.fml.common.discovery.ITypeDiscoverer**
- class **net.minecraftforge.fml.common.discovery.JarDiscoverer**
- class **net.minecraftforge.fml.common.discovery.ModCandidate**
- class **net.minecraftforge.fml.common.discovery.ModDiscoverer**
- class **net.minecraftforge.fml.common.discovery.asm.ASMModParser**
- class **net.minecraftforge.fml.common.discovery.asm.ModAnnotation**
- class **net.minecraftforge.fml.common.discovery.asm.ModAnnotationVisitor**
- class **net.minecraftforge.fml.common.discovery.asm.ModClassVisitor**
- class **net.minecraftforge.fml.common.discovery.asm.ModFieldVisitor**
- class **net.minecraftforge.fml.common.discovery.asm.ModMethodVisitor**
- class **net.minecraftforge.fml.common.event.FMLConstructionEvent**
- class **net.minecraftforge.fml.common.event.FMLEvent**
- class **net.minecraftforge.fml.common.event.FMLFingerprintViolationEvent**
- class **net.minecraftforge.fml.common.event.FMLInitializationEvent**
- class **net.minecraftforge.fml.common.event.FMLInterModComms$IMCEvent**
- class **net.minecraftforge.fml.common.event.FMLInterModComms$IMCMessage**
- class **net.minecraftforge.fml.common.event.FMLInterModComms**
- class **net.minecraftforge.fml.common.event.FMLLoadCompleteEvent**
- class **net.minecraftforge.fml.common.event.FMLLoadEvent**
- enum **net.minecraftforge.fml.common.event.FMLMissingMappingsEvent$Action**
- class **net.minecraftforge.fml.common.event.FMLMissingMappingsEvent$MissingMapping**
- class **net.minecraftforge.fml.common.event.FMLMissingMappingsEvent**
- class **net.minecraftforge.fml.common.event.FMLModDisabledEvent**
- enum **net.minecraftforge.fml.common.event.FMLModIdMappingEvent$RemapTarget**
- class **net.minecraftforge.fml.common.event.FMLModIdMappingEvent**
- class **net.minecraftforge.fml.common.event.FMLPostInitializationEvent**
- class **net.minecraftforge.fml.common.event.FMLPreInitializationEvent**
- class **net.minecraftforge.fml.common.event.FMLServerAboutToStartEvent**
- class **net.minecraftforge.fml.common.event.FMLServerStartedEvent**
- class **net.minecraftforge.fml.common.event.FMLServerStartingEvent**
- class **net.minecraftforge.fml.common.event.FMLServerStoppedEvent**
- class **net.minecraftforge.fml.common.event.FMLServerStoppingEvent**
- class **net.minecraftforge.fml.common.event.FMLStateEvent**
- class **net.minecraftforge.fml.common.eventhandler.ASMEventHandler**
- annotation **net.minecraftforge.fml.common.eventhandler.Cancelable**
- annotation **net.minecraftforge.fml.common.eventhandler.Event$HasResult**
- enum **net.minecraftforge.fml.common.eventhandler.Event$Result**
- class **net.minecraftforge.fml.common.eventhandler.Event**
- class **net.minecraftforge.fml.common.eventhandler.EventBus**
- enum **net.minecraftforge.fml.common.eventhandler.EventPriority**
- class **net.minecraftforge.fml.common.eventhandler.GenericEvent**
- interface **net.minecraftforge.fml.common.eventhandler.IContextSetter**
- interface **net.minecraftforge.fml.common.eventhandler.IEventExceptionHandler**
- interface **net.minecraftforge.fml.common.eventhandler.IEventListener**
- interface **net.minecraftforge.fml.common.eventhandler.IGenericEvent**
- class **net.minecraftforge.fml.common.eventhandler.ListenerList**
- annotation **net.minecraftforge.fml.common.eventhandler.SubscribeEvent**
- class **net.minecraftforge.fml.common.functions.ArtifactVersionNameFunction**
- class **net.minecraftforge.fml.common.functions.GenericIterableFactory**
- class **net.minecraftforge.fml.common.functions.ModIdFunction**
- class **net.minecraftforge.fml.common.functions.ModNameFunction**
- class **net.minecraftforge.fml.common.functions.TypeCastFunction**
- class **net.minecraftforge.fml.common.gameevent.InputEvent$KeyInputEvent**
- class **net.minecraftforge.fml.common.gameevent.InputEvent$MouseInputEvent**
- class **net.minecraftforge.fml.common.gameevent.InputEvent**
- class **net.minecraftforge.fml.common.gameevent.PlayerEvent$ItemCraftedEvent**
- class **net.minecraftforge.fml.common.gameevent.PlayerEvent$ItemPickupEvent**
- class **net.minecraftforge.fml.common.gameevent.PlayerEvent$ItemSmeltedEvent**
- class **net.minecraftforge.fml.common.gameevent.PlayerEvent$PlayerChangedDimensionEvent**
- class **net.minecraftforge.fml.common.gameevent.PlayerEvent$PlayerLoggedInEvent**
- class **net.minecraftforge.fml.common.gameevent.PlayerEvent$PlayerLoggedOutEvent**
- class **net.minecraftforge.fml.common.gameevent.PlayerEvent$PlayerRespawnEvent**
- class **net.minecraftforge.fml.common.gameevent.PlayerEvent**
- class **net.minecraftforge.fml.common.gameevent.TickEvent$ClientTickEvent**
- enum **net.minecraftforge.fml.common.gameevent.TickEvent$Phase**
- class **net.minecraftforge.fml.common.gameevent.TickEvent$PlayerTickEvent**
- class **net.minecraftforge.fml.common.gameevent.TickEvent$RenderTickEvent**
- class **net.minecraftforge.fml.common.gameevent.TickEvent$ServerTickEvent**
- enum **net.minecraftforge.fml.common.gameevent.TickEvent$Type**
- class **net.minecraftforge.fml.common.gameevent.TickEvent$WorldTickEvent**
- class **net.minecraftforge.fml.common.gameevent.TickEvent**
- class **net.minecraftforge.fml.common.launcher.FMLDeobfTweaker**
- class **net.minecraftforge.fml.common.launcher.FMLInjectionAndSortingTweaker**
- class **net.minecraftforge.fml.common.launcher.FMLServerTweaker**
- class **net.minecraftforge.fml.common.launcher.FMLTweaker**
- class **net.minecraftforge.fml.common.launcher.TerminalTweaker**
- class **net.minecraftforge.fml.common.launcher.Yggdrasil**
- class **net.minecraftforge.fml.common.network.ByteBufUtils**
- class **net.minecraftforge.fml.common.network.FMLEmbeddedChannel**
- class **net.minecraftforge.fml.common.network.FMLEventChannel**
- class **net.minecraftforge.fml.common.network.FMLIndexedMessageToMessageCodec**
- class **net.minecraftforge.fml.common.network.FMLNetworkEvent$ClientConnectedToServerEvent**
- class **net.minecraftforge.fml.common.network.FMLNetworkEvent$ClientCustomPacketEvent**
- class **net.minecraftforge.fml.common.network.FMLNetworkEvent$ClientDisconnectionFromServerEvent**
- class **net.minecraftforge.fml.common.network.FMLNetworkEvent$CustomNetworkEvent**
- class **net.minecraftforge.fml.common.network.FMLNetworkEvent$CustomPacketEvent**
- class **net.minecraftforge.fml.common.network.FMLNetworkEvent$CustomPacketRegistrationEvent**
- class **net.minecraftforge.fml.common.network.FMLNetworkEvent$ServerConnectionFromClientEvent**
- class **net.minecraftforge.fml.common.network.FMLNetworkEvent$ServerCustomPacketEvent**
- class **net.minecraftforge.fml.common.network.FMLNetworkEvent$ServerDisconnectionFromClientEvent**
- class **net.minecraftforge.fml.common.network.FMLNetworkEvent**
- class **net.minecraftforge.fml.common.network.FMLNetworkException**
- enum **net.minecraftforge.fml.common.network.FMLOutboundHandler$OutboundTarget**
- class **net.minecraftforge.fml.common.network.FMLOutboundHandler**
- interface **net.minecraftforge.fml.common.network.IGuiHandler**
- annotation **net.minecraftforge.fml.common.network.NetworkCheckHandler**
- class **net.minecraftforge.fml.common.network.NetworkEventFiringHandler**
- class **net.minecraftforge.fml.common.network.NetworkHandshakeEstablished**
- class **net.minecraftforge.fml.common.network.NetworkRegistry$TargetPoint**
- enum **net.minecraftforge.fml.common.network.NetworkRegistry**
- class **net.minecraftforge.fml.common.network.PacketLoggingHandler**
- class **net.minecraftforge.fml.common.network.handshake.ChannelRegistrationHandler**
- class **net.minecraftforge.fml.common.network.handshake.FMLHandshakeCodec**
- class **net.minecraftforge.fml.common.network.handshake.FMLHandshakeMessage$ClientHello**
- class **net.minecraftforge.fml.common.network.handshake.FMLHandshakeMessage$HandshakeAck**
- class **net.minecraftforge.fml.common.network.handshake.FMLHandshakeMessage$HandshakeReset**
- class **net.minecraftforge.fml.common.network.handshake.FMLHandshakeMessage$ModList**
- class **net.minecraftforge.fml.common.network.handshake.FMLHandshakeMessage$RegistryData**
- class **net.minecraftforge.fml.common.network.handshake.FMLHandshakeMessage$ServerHello**
- class **net.minecraftforge.fml.common.network.handshake.FMLHandshakeMessage**
- class **net.minecraftforge.fml.common.network.handshake.HandshakeInjector**
- class **net.minecraftforge.fml.common.network.handshake.HandshakeMessageHandler**
- interface **net.minecraftforge.fml.common.network.handshake.IHandshakeState**
- class **net.minecraftforge.fml.common.network.handshake.NetworkDispatcher**
- class **net.minecraftforge.fml.common.network.internal.EntitySpawnHandler**
- class **net.minecraftforge.fml.common.network.internal.FMLMessage$CompleteHandshake**
- class **net.minecraftforge.fml.common.network.internal.FMLMessage$EntityMessage**
- class **net.minecraftforge.fml.common.network.internal.FMLMessage$EntitySpawnMessage**
- class **net.minecraftforge.fml.common.network.internal.FMLMessage$OpenGui**
- class **net.minecraftforge.fml.common.network.internal.FMLMessage**
- class **net.minecraftforge.fml.common.network.internal.FMLNetworkHandler**
- class **net.minecraftforge.fml.common.network.internal.FMLProxyPacket**
- class **net.minecraftforge.fml.common.network.internal.FMLRuntimeCodec**
- class **net.minecraftforge.fml.common.network.internal.HandshakeCompletionHandler**
- class **net.minecraftforge.fml.common.network.internal.NetworkModHolder**
- class **net.minecraftforge.fml.common.network.internal.OpenGuiHandler**
- interface **net.minecraftforge.fml.common.network.simpleimpl.IMessage**
- interface **net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler**
- class **net.minecraftforge.fml.common.network.simpleimpl.MessageContext**
- class **net.minecraftforge.fml.common.network.simpleimpl.SimpleChannelHandlerWrapper**
- class **net.minecraftforge.fml.common.network.simpleimpl.SimpleIndexedCodec**
- class **net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper**
- class **net.minecraftforge.fml.common.patcher.ClassPatch**
- class **net.minecraftforge.fml.common.patcher.ClassPatchManager**
- class **net.minecraftforge.fml.common.patcher.GenDiffSet**
- class **net.minecraftforge.fml.common.registry.EntityEntry**
- class **net.minecraftforge.fml.common.registry.EntityRegistry**
- class **net.minecraftforge.fml.common.registry.ExistingSubstitutionException**
- class **net.minecraftforge.fml.common.registry.FMLControlledNamespacedRegistry**
- class **net.minecraftforge.fml.common.registry.ForgeRegistries**
- class **net.minecraftforge.fml.common.registry.GameData**
- annotation **net.minecraftforge.fml.common.registry.GameRegistry$ItemStackHolder**
- annotation **net.minecraftforge.fml.common.registry.GameRegistry$ObjectHolder**
- enum **net.minecraftforge.fml.common.registry.GameRegistry$Type**
- class **net.minecraftforge.fml.common.registry.GameRegistry**
- interface **net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData**
- interface **net.minecraftforge.fml.common.registry.IForgeRegistry$AddCallback**
- interface **net.minecraftforge.fml.common.registry.IForgeRegistry$ClearCallback**
- interface **net.minecraftforge.fml.common.registry.IForgeRegistry$CreateCallback**
- interface **net.minecraftforge.fml.common.registry.IForgeRegistry$SubstitutionCallback**
- interface **net.minecraftforge.fml.common.registry.IForgeRegistry**
- class **net.minecraftforge.fml.common.registry.IForgeRegistryEntry$Impl**
- interface **net.minecraftforge.fml.common.registry.IForgeRegistryEntry**
- interface **net.minecraftforge.fml.common.registry.IThrowableEntity**
- class **net.minecraftforge.fml.common.registry.IncompatibleSubstitutionException**
- enum **net.minecraftforge.fml.common.registry.ItemStackHolderInjector**
- class **net.minecraftforge.fml.common.registry.LegacyNamespacedRegistry**
- enum **net.minecraftforge.fml.common.registry.ObjectHolderRegistry**
- class **net.minecraftforge.fml.common.registry.PersistentRegistryManager$GameDataSnapshot$Entry**
- class **net.minecraftforge.fml.common.registry.PersistentRegistryManager$GameDataSnapshot**
- class **net.minecraftforge.fml.common.registry.PersistentRegistryManager**
- class **net.minecraftforge.fml.common.registry.RegistryBuilder**
- class **net.minecraftforge.fml.common.registry.RegistryDelegate$Delegate**
- interface **net.minecraftforge.fml.common.registry.RegistryDelegate**
- interface **net.minecraftforge.fml.common.registry.VillagerRegistry$IVillageCreationHandler**
- class **net.minecraftforge.fml.common.registry.VillagerRegistry$VillagerCareer**
- class **net.minecraftforge.fml.common.registry.VillagerRegistry$VillagerProfession**
- class **net.minecraftforge.fml.common.registry.VillagerRegistry**
- class **net.minecraftforge.fml.common.toposort.ModSorter**
- class **net.minecraftforge.fml.common.toposort.ModSortingException**
- class **net.minecraftforge.fml.common.toposort.TopologicalSort$DirectedGraph**
- class **net.minecraftforge.fml.common.toposort.TopologicalSort**
- interface **net.minecraftforge.fml.common.versioning.ArtifactVersion**
- class **net.minecraftforge.fml.common.versioning.ComparableVersion**
- class **net.minecraftforge.fml.common.versioning.DefaultArtifactVersion**
- class **net.minecraftforge.fml.common.versioning.InvalidVersionSpecificationException**
- class **net.minecraftforge.fml.common.versioning.Restriction**
- class **net.minecraftforge.fml.common.versioning.VersionParser**
- class **net.minecraftforge.fml.common.versioning.VersionRange**
- class **net.minecraftforge.fml.relauncher.CoreModManager**
- class **net.minecraftforge.fml.relauncher.FMLCorePlugin**
- class **net.minecraftforge.fml.relauncher.FMLInjectionData**
- class **net.minecraftforge.fml.relauncher.FMLLaunchHandler**
- class **net.minecraftforge.fml.relauncher.FMLRelaunchLog**
- class **net.minecraftforge.fml.relauncher.FMLSecurityManager$ExitTrappedException**
- class **net.minecraftforge.fml.relauncher.FMLSecurityManager**
- class **net.minecraftforge.fml.relauncher.FileListHelper**
- interface **net.minecraftforge.fml.relauncher.IFMLCallHook**
- annotation **net.minecraftforge.fml.relauncher.IFMLLoadingPlugin$DependsOn**
- annotation **net.minecraftforge.fml.relauncher.IFMLLoadingPlugin$MCVersion**
- annotation **net.minecraftforge.fml.relauncher.IFMLLoadingPlugin$Name**
- annotation **net.minecraftforge.fml.relauncher.IFMLLoadingPlugin$SortingIndex**
- annotation **net.minecraftforge.fml.relauncher.IFMLLoadingPlugin$TransformerExclusions**
- interface **net.minecraftforge.fml.relauncher.IFMLLoadingPlugin**
- class **net.minecraftforge.fml.relauncher.ModListHelper$JsonModList**
- class **net.minecraftforge.fml.relauncher.ModListHelper**
- class **net.minecraftforge.fml.relauncher.ReflectionHelper$UnableToAccessFieldException**
- class **net.minecraftforge.fml.relauncher.ReflectionHelper$UnableToFindClassException**
- class **net.minecraftforge.fml.relauncher.ReflectionHelper$UnableToFindFieldException**
- class **net.minecraftforge.fml.relauncher.ReflectionHelper$UnableToFindMethodException**
- class **net.minecraftforge.fml.relauncher.ReflectionHelper**
- class **net.minecraftforge.fml.relauncher.ServerLaunchWrapper**
- enum **net.minecraftforge.fml.relauncher.Side**
- annotation **net.minecraftforge.fml.relauncher.SideOnly**
- class **net.minecraftforge.fml.repackage.com.nothome.delta.ByteBufferSeekableSource**
- class **net.minecraftforge.fml.repackage.com.nothome.delta.Checksum**
- class **net.minecraftforge.fml.repackage.com.nothome.delta.DebugDiffWriter**
- class **net.minecraftforge.fml.repackage.com.nothome.delta.Delta**
- interface **net.minecraftforge.fml.repackage.com.nothome.delta.DiffWriter**
- class **net.minecraftforge.fml.repackage.com.nothome.delta.GDiffPatcher**
- class **net.minecraftforge.fml.repackage.com.nothome.delta.GDiffWriter**
- class **net.minecraftforge.fml.repackage.com.nothome.delta.PatchException**
- class **net.minecraftforge.fml.repackage.com.nothome.delta.RandomAccessFileSeekableSource**
- interface **net.minecraftforge.fml.repackage.com.nothome.delta.SeekableSource**
- class **net.minecraftforge.fml.server.FMLServerHandler**
- class **net.minecraftforge.gradle.GradleForgeHacks$AccessTransformerTransformer**
- class **net.minecraftforge.gradle.GradleForgeHacks**
- class **net.minecraftforge.gradle.GradleStartCommon**
- class **net.minecraftforge.gradle.tweakers.AccessTransformerTweaker**
- class **net.minecraftforge.gradle.tweakers.CoremodTweaker**
- class **net.minecraftforge.items.CapabilityItemHandler**
- interface **net.minecraftforge.items.IItemHandler**
- interface **net.minecraftforge.items.IItemHandlerModifiable**
- class **net.minecraftforge.items.ItemHandlerHelper**
- class **net.minecraftforge.items.ItemStackHandler**
- class **net.minecraftforge.items.SlotItemHandler**
- class **net.minecraftforge.items.VanillaDoubleChestItemHandler**
- class **net.minecraftforge.items.VanillaHopperItemHandler**
- class **net.minecraftforge.items.VanillaInventoryCodeHooks**
- class **net.minecraftforge.items.wrapper.CombinedInvWrapper**
- class **net.minecraftforge.items.wrapper.EmptyHandler**
- class **net.minecraftforge.items.wrapper.InvWrapper**
- class **net.minecraftforge.items.wrapper.PlayerArmorInvWrapper**
- class **net.minecraftforge.items.wrapper.PlayerInvWrapper**
- class **net.minecraftforge.items.wrapper.PlayerMainInvWrapper**
- class **net.minecraftforge.items.wrapper.PlayerOffhandInvWrapper**
- class **net.minecraftforge.items.wrapper.RangedWrapper**
- class **net.minecraftforge.items.wrapper.SidedInvWrapper**
- class **net.minecraftforge.oredict.OreDictionary$OreRegisterEvent**
- class **net.minecraftforge.oredict.OreDictionary**
- enum **net.minecraftforge.oredict.RecipeSorter$Category**
- class **net.minecraftforge.oredict.RecipeSorter**
- class **net.minecraftforge.oredict.ShapedOreRecipe**
- class **net.minecraftforge.oredict.ShapelessOreRecipe**
- class **net.minecraftforge.server.ForgeTimeTracker**
- class **net.minecraftforge.server.command.CommandTreeBase**
- class **net.minecraftforge.server.command.ForgeCommand**
- class **net.minecraftforge.server.console.ConsoleCommandCompleter**
- class **net.minecraftforge.server.console.ConsoleFormatter**
- class **net.minecraftforge.server.console.TerminalConsoleAppender**
- class **net.minecraftforge.server.console.TerminalHandler**
- enum **net.minecraftforge.server.permission.DefaultPermissionHandler**
- enum **net.minecraftforge.server.permission.DefaultPermissionLevel**
- interface **net.minecraftforge.server.permission.IPermissionHandler**
- class **net.minecraftforge.server.permission.PermissionAPI**
- class **net.minecraftforge.server.permission.context.AreaContext**
- class **net.minecraftforge.server.permission.context.BlockPosContext**
- class **net.minecraftforge.server.permission.context.Context**
- class **net.minecraftforge.server.permission.context.ContextKey**
- class **net.minecraftforge.server.permission.context.ContextKeys**
- interface **net.minecraftforge.server.permission.context.IContext**
- class **net.minecraftforge.server.permission.context.PlayerContext**
- class **net.minecraftforge.server.permission.context.TargetContext**
- class **net.minecraftforge.server.permission.context.WorldContext**

## Contributors

[Eugene Potapenko](https://github.com/potapenko/)

## License

Distributed under the Eclipse Public License, the same as Clojure.
