(ns clojure.javafx.launcher
  (:require
   [clojure.stacktrace :as st]
   [clojure.javafx.launcher.application :as app]
   )
  (:import
   clojure.javafx.launcher.Launcher
   javafx.application.Application
   javafx.application.Platform
   ))


(defonce ^Thread thread
  (doto (Thread.
          (fn []
            ;; Keep JavaFX running even if no window is visible
            (try
              (Platform/setImplicitExit false)
              (Application/launch Launcher (make-array String 0))
              (catch Throwable e
                (st/print-stack-trace e))
              (finally
                (println "javafx.launcher.thread terminated:" (str @app/javafx-application-thread)))))
          "clojure.javafx.launcher.thread")
    (.start)))


(deref app/primary-stage)
