(ns clojure.javafx.launcher.application
  "Extended class javafx.application.Application for clojure.javafx"
  (:import
   javafx.application.Application
   javafx.application.Platform
   javafx.stage.Stage
   )
  (:gen-class
   :name clojure.javafx.launcher.Launcher
   :extends javafx.application.Application
   ))


(defonce primary-stage (promise))


(defonce javafx-application-thread (promise))


(defn -start
  [this ^Stage stage]
  (let [thread (Thread/currentThread)]
    (deliver primary-stage stage)
    (deliver javafx-application-thread thread)
    (println "clojure.javafx.launcher" (str thread) "- Started")))


(defn -stop
  [this]
  (println "clojure.javafx.launcher" (str (Thread/currentThread)) "- Stopped"))
