(defproject clojusc/friend-oauth2 "0.3.0-SNAPSHOT"
  :description "OAuth2 workflow for Friend"
  :url "https://github.com/clojusc/friend-oauth2"
  :license {
    :name "MIT License"
    :url "http://dd.mit-license.org"}
  :dependencies [
    [org.clojure/data.json "0.2.6"]
    [com.cemerick/friend "0.2.3"
      :exclusions [clj-time
                   commons-codec
                   commons-logging
                   org.apache.httpcomponents/httpclient
                   ring/ring-core
                   slingshot]]
    [com.cemerick/url "0.1.1"]
    [ring "1.6.0-beta6"]
    [ring/ring-defaults "0.3.0-beta1" :exclusions [ring/ring-core]]
    [ring/ring-codec "1.0.1" :exclusions [commons-codec]]
    [ring/ring-jetty-adapter "1.6.0-beta6"]
    [clj-http "3.4.1"]
    [clojusc/twig "0.3.0"]
    [crypto-random "1.2.0"]]
  :profiles {
    :uber {
      :aot :all}
    :test {
      :dependencies [
        [com.cemerick/url "0.1.1"]
        [compojure "1.6.0-beta1"]
        [midje "1.9.0-alpha6"]
        [ring/ring-mock "0.3.0"
          :exclusions [org.clojure/clojure
                       ring/ring-codec]]]
      :plugins [
        [jonase/eastwood "0.2.3" :exclusions [org.clojure/clojure]]
        [lein-kibit "0.1.3"]
        [lein-midje "3.2.1" :exclusions [midje]]]}
    ;; XXX Reader macros not supported in anything less than Clojure 1.7
    ;; :clj15 {
    ;;   :dependencies [
    ;;     [org.clojure/clojure "1.5.0"]
    ;;     [medley "0.6.0" :exclusions [org.clojure/clojure]]]}
    ;; :clj16 {
    ;;   :dependencies [
    ;;     [org.clojure/clojure "1.6.0"]
    ;;     [medley "0.6.0" :exclusions [org.clojure/clojure]]]}
    :clj17 {
      :dependencies [
        [org.clojure/clojure "1.7.0"]]}
    :clj18 {
      :dependencies [
        [org.clojure/clojure "1.8.0"]]}
    :clj19 {
      :dependencies [
        [org.clojure/clojure "1.9.0-alpha14"]]}
    :dev {
      :source-paths ["dev-resources/src"]
      :repl-options {:init-ns friend-oauth2.dev}
      :dependencies [
        [org.clojure/tools.namespace "0.2.11"
          :exclusions [org.clojure/clojure]]]}
    :docs {
      :dependencies [[codox-theme-rdash "0.1.1"]]
      :plugins [[lein-codox "0.10.2"]
                [lein-simpleton "1.3.0"]]
      :codox {
        :project {
          :name "friend-oauth2"
          :description "OAuth2 workflow for Friend"}
        :namespaces [#"^friend-oauth2\.(?!dev)"]
        :themes [:rdash]
        :output-path "docs/master/current"
        :doc-paths ["docs/source"]
        :metadata {
          :doc/format :markdown
          :doc "Documentation forthcoming"}}}
    :examples {
      :source-paths ["examples"]
      :dependencies [
        [compojure "1.6.0-beta1"]
        [http-kit "2.2.0"]
        [ring-logger "0.7.6"]
        [ring/ring-defaults "0.3.0-beta1"]]}
    :appdotnet {:main friend-oauth2.examples.appdotnet}
    :facebook {:main friend-oauth2.examples.facebook}
    :github {:main friend-oauth2.examples.github}
    :google {:main friend-oauth2.examples.google}
    :legacy-appdotnet {:main friend-oauth2.examples.legacy.appdotnet}
    :legacy-facebook {:main friend-oauth2.examples.legacy.facebook}
    :legacy-github {:main friend-oauth2.examples.legacy.github}
    :legacy-google {:main friend-oauth2.examples.legacy.google}}
    :aliases {
      "appdotnet" ["trampoline" "with-profile" "+clj18,+examples,+appdotnet" "run"]
      "facebook" ["trampoline" "with-profile" "+clj18,+examples,+facebook" "run"]
      "github" ["trampoline" "with-profile" "+clj18,+examples,+github" "run"]
      "google" ["trampoline" "with-profile" "+clj18,+examples,+google" "run"]
      "legacy-appdotnet" ["trampoline" "with-profile" "+clj18,+examples,+legacy-appdotnet" "run"]
      "legacy-facebook" ["trampoline" "with-profile" "+clj18,+examples,+legacy-facebook" "run"]
      "legacy-github" ["trampoline" "with-profile" "+clj18,+examples,+legacy-github" "run"]
      "legacy-google" ["trampoline" "with-profile" "+clj18,+examples,+legacy-google" "run"]})
