// Compiled by ClojureScript 1.9.293 {}
goog.provide('clojusc.twig');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('cljs.nodejs');
goog.require('cljs.pprint');
goog.require('taoensso.timbre');
if(typeof clojusc.twig.color !== 'undefined'){
} else {
clojusc.twig.color = cljs.nodejs.require.call(null,"colors");
}
clojusc.twig.__GT_level = (function clojusc$twig$__GT_level(level){
return clojure.string.upper_case.call(null,cljs.core.name.call(null,level));
});

clojusc.twig.highlight_level = (function clojusc$twig$highlight_level(level){
var level_upper = clojure.string.upper_case.call(null,cljs.core.name.call(null,level));
var G__11322 = (((level instanceof cljs.core.Keyword))?level.fqn:null);
switch (G__11322) {
case "trace":
return clojusc.twig.color.green(level_upper);

break;
case "debug":
return clojusc.twig.color.bold(clojusc.twig.color.green(level_upper));

break;
case "info":
return clojusc.twig.color.blue(level_upper);

break;
case "warn":
return clojusc.twig.color.bold(clojusc.twig.color.yellow(level_upper));

break;
case "error":
return clojusc.twig.color.red(level_upper);

break;
case "fatal":
return clojusc.twig.color.bold(clojusc.twig.color.red(level_upper));

break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(level)].join('')));

}
});

/**
 * Custom log output function.
 *    Use`(partial log-formatter <opts-map>)` to modify default opts.
 */
clojusc.twig.log_formatter = (function clojusc$twig$log_formatter(var_args){
var args11323 = [];
var len__8195__auto___11331 = arguments.length;
var i__8196__auto___11332 = (0);
while(true){
if((i__8196__auto___11332 < len__8195__auto___11331)){
args11323.push((arguments[i__8196__auto___11332]));

var G__11333 = (i__8196__auto___11332 + (1));
i__8196__auto___11332 = G__11333;
continue;
} else {
}
break;
}

var G__11325 = args11323.length;
switch (G__11325) {
case 1:
return clojusc.twig.log_formatter.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return clojusc.twig.log_formatter.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args11323.length)].join('')));

}
});

clojusc.twig.log_formatter.cljs$core$IFn$_invoke$arity$1 = (function (data){
return clojusc.twig.log_formatter.call(null,null,data);
});

clojusc.twig.log_formatter.cljs$core$IFn$_invoke$arity$2 = (function (opts,data){
var map__11326 = opts;
var map__11326__$1 = ((((!((map__11326 == null)))?((((map__11326.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__11326.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__11326):map__11326);
var no_stacktrace_QMARK_ = cljs.core.get.call(null,map__11326__$1,new cljs.core.Keyword(null,"no-stacktrace?","no-stacktrace?",1701072694));
var stacktrace_fonts = cljs.core.get.call(null,map__11326__$1,new cljs.core.Keyword(null,"stacktrace-fonts","stacktrace-fonts",830799382));
var map__11327 = data;
var map__11327__$1 = ((((!((map__11327 == null)))?((((map__11327.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__11327.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__11327):map__11327);
var level = cljs.core.get.call(null,map__11327__$1,new cljs.core.Keyword(null,"level","level",1290497552));
var _QMARK_err = cljs.core.get.call(null,map__11327__$1,new cljs.core.Keyword(null,"?err","?err",549653299));
var msg_ = cljs.core.get.call(null,map__11327__$1,new cljs.core.Keyword(null,"msg_","msg_",-1925147000));
var _QMARK_ns_str = cljs.core.get.call(null,map__11327__$1,new cljs.core.Keyword(null,"?ns-str","?ns-str",2012733966));
var hostname_ = cljs.core.get.call(null,map__11327__$1,new cljs.core.Keyword(null,"hostname_","hostname_",-2091647379));
var timestamp_ = cljs.core.get.call(null,map__11327__$1,new cljs.core.Keyword(null,"timestamp_","timestamp_",-954533417));
var _QMARK_line = cljs.core.get.call(null,map__11327__$1,new cljs.core.Keyword(null,"?line","?line",-631853385));
return [cljs.core.str(clojusc.twig.color.green(tools.now_iso.call(null))),cljs.core.str(" "),cljs.core.str(clojusc.twig.color.green("[pid:")),cljs.core.str(clojusc.twig.color.cyan([cljs.core.str((process["pid"]))].join(''))),cljs.core.str(clojusc.twig.color.green("]")),cljs.core.str(" "),cljs.core.str(clojusc.twig.color.bold(clojusc.twig.color.green("["))),cljs.core.str(clojusc.twig.highlight_level.call(null,level)),cljs.core.str(clojusc.twig.color.bold(clojusc.twig.color.green("]"))),cljs.core.str(" "),cljs.core.str(clojusc.twig.color.yellow([cljs.core.str((function (){var or__7087__auto__ = _QMARK_ns_str;
if(cljs.core.truth_(or__7087__auto__)){
return or__7087__auto__;
} else {
return "?";
}
})()),cljs.core.str(":"),cljs.core.str((function (){var or__7087__auto__ = _QMARK_line;
if(cljs.core.truth_(or__7087__auto__)){
return or__7087__auto__;
} else {
return "?";
}
})())].join(''))),cljs.core.str(" "),cljs.core.str(clojusc.twig.color.green([cljs.core.str(cljs.core.force.call(null,msg_)),cljs.core.str((cljs.core.truth_(no_stacktrace_QMARK_)?null:(function (){var temp__4657__auto__ = _QMARK_err;
if(cljs.core.truth_(temp__4657__auto__)){
var err = temp__4657__auto__;
return [cljs.core.str("\n"),cljs.core.str(taoensso.timbre.stacktrace.call(null,err,opts))].join('');
} else {
return null;
}
})()))].join('')))].join('');
});

clojusc.twig.log_formatter.cljs$lang$maxFixedArity = 2;

if(typeof clojusc.twig.set_level_BANG_ !== 'undefined'){
} else {
clojusc.twig.set_level_BANG_ = (function (){var method_table__8015__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__8016__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var method_cache__8017__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__8018__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__8019__auto__ = cljs.core.get.call(null,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),cljs.core.get_global_hierarchy.call(null));
return (new cljs.core.MultiFn(cljs.core.symbol.call(null,"clojusc.twig","set-level!"),((function (method_table__8015__auto__,prefer_table__8016__auto__,method_cache__8017__auto__,cached_hierarchy__8018__auto__,hierarchy__8019__auto__){
return (function (namesp,level){
return cljs.core.mapv.call(null,cljs.core.type,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [namesp,level], null));
});})(method_table__8015__auto__,prefer_table__8016__auto__,method_cache__8017__auto__,cached_hierarchy__8018__auto__,hierarchy__8019__auto__))
,new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__8019__auto__,method_table__8015__auto__,prefer_table__8016__auto__,method_cache__8017__auto__,cached_hierarchy__8018__auto__));
})();
}
cljs.core._add_method.call(null,clojusc.twig.set_level_BANG_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [clojure.lang.Symbol,clojure.lang.Keyword], null),(function (namesp,level){
return taoensso.timbre.merge_config_BANG_.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"level","level",1290497552),level,new cljs.core.Keyword(null,"ns-whitelist","ns-whitelist",-1717299774),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [namesp], null)], null));
}));
cljs.core._add_method.call(null,clojusc.twig.set_level_BANG_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [clojure.lang.PersistentVector,clojure.lang.Keyword], null),(function (namesps,level){
return taoensso.timbre.merge_config_BANG_.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"level","level",1290497552),level,new cljs.core.Keyword(null,"ns-whitelist","ns-whitelist",-1717299774),namesps,new cljs.core.Keyword(null,"output-fn","output-fn",1600951539),clojusc.twig.log_formatter], null));
}));
clojusc.twig.pprint = (function clojusc$twig$pprint(var_args){
var args__8202__auto__ = [];
var len__8195__auto___11338 = arguments.length;
var i__8196__auto___11339 = (0);
while(true){
if((i__8196__auto___11339 < len__8195__auto___11338)){
args__8202__auto__.push((arguments[i__8196__auto___11339]));

var G__11340 = (i__8196__auto___11339 + (1));
i__8196__auto___11339 = G__11340;
continue;
} else {
}
break;
}

var argseq__8203__auto__ = ((((0) < args__8202__auto__.length))?(new cljs.core.IndexedSeq(args__8202__auto__.slice((0)),(0),null)):null);
return clojusc.twig.pprint.cljs$core$IFn$_invoke$arity$variadic(argseq__8203__auto__);
});

clojusc.twig.pprint.cljs$core$IFn$_invoke$arity$variadic = (function (args){
return [cljs.core.str("\n"),cljs.core.str((function (){var sb__8076__auto__ = (new goog.string.StringBuffer());
var _STAR_print_newline_STAR_11336_11341 = cljs.core._STAR_print_newline_STAR_;
var _STAR_print_fn_STAR_11337_11342 = cljs.core._STAR_print_fn_STAR_;
cljs.core._STAR_print_newline_STAR_ = true;

cljs.core._STAR_print_fn_STAR_ = ((function (_STAR_print_newline_STAR_11336_11341,_STAR_print_fn_STAR_11337_11342,sb__8076__auto__){
return (function (x__8077__auto__){
return sb__8076__auto__.append(x__8077__auto__);
});})(_STAR_print_newline_STAR_11336_11341,_STAR_print_fn_STAR_11337_11342,sb__8076__auto__))
;

try{cljs.core.apply.call(null,cljs.pprint.pprint,args);
}finally {cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR_11337_11342;

cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR_11336_11341;
}
return [cljs.core.str(sb__8076__auto__)].join('');
})())].join('');
});

clojusc.twig.pprint.cljs$lang$maxFixedArity = (0);

clojusc.twig.pprint.cljs$lang$applyTo = (function (seq11335){
return clojusc.twig.pprint.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq11335));
});

clojusc.twig.convert_level = new cljs.core.Var(function(){return clojusc.twig.__GT_level;},new cljs.core.Symbol("clojusc.twig","->level","clojusc.twig/->level",1904610187,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"clojusc.twig","clojusc.twig",766889784,null),new cljs.core.Symbol(null,"->level","->level",1982136701,null),"/alt/home/oubiwann/lab/clojure/clojusc/twig/src/clojusc/twig.cljc",18,5,48,48,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"level","level",-1363938217,null)], null)),null,(cljs.core.truth_(clojusc.twig.__GT_level)?clojusc.twig.__GT_level.cljs$lang$test:null)]));

//# sourceMappingURL=twig.js.map