(ns clojush.zip
  (:gen-class)
  (:require [clojush] [clojure.zip :as zip])
  (:use [clojush]))

(in-ns 'clojush)

(def global-fair-range 0.1)

(defn rand-code-in-range
     [min-size max-size atom-generators]
     (random-code-with-size (+ min-size (rand-int (- max-size min-size))) atom-generators))

;; Redefine push-types to include :intvec2D and then redefine the push state structure.
(def push-types (cons :zip push-types))
(define-push-state-structure)

(in-ns 'clojush.zip)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; zip instructions

(define-registered zip_next
  (fn [state]
    (if (or (empty? (:zip state))
	    (nil? (zip/next (top-item :zip state))))
      state
      (push-item (zip/next (top-item :zip state)) :zip (pop-item :zip state)))))

(define-registered zip_prev
  (fn [state]
    (if (or (empty? (:zip state))
	    (nil? (zip/prev (top-item :zip state))))
      state
      (push-item (zip/prev (top-item :zip state)) :zip (pop-item :zip state)))))

(define-registered zip_down
  (fn [state]
    (if (or (empty? (:zip state))
	    (nil? (zip/down (top-item :zip state))))
      state
      (push-item (zip/down (top-item :zip state)) :zip (pop-item :zip state)))))

(define-registered zip_up
  (fn [state]
    (if (or (empty? (:zip state))
	    (nil? (zip/up (top-item :zip state))))
      state
      (push-item (zip/up (top-item :zip state)) :zip (pop-item :zip state)))))

(define-registered zip_left
  (fn [state]
    (if (or (empty? (:zip state))
	    (nil? (zip/left (top-item :zip state))))
      state
      (push-item (zip/left (top-item :zip state)) :zip (pop-item :zip state)))))

(define-registered zip_right
  (fn [state]
    (if (or (empty? (:zip state))
	    (nil? (zip/right (top-item :zip state))))
      state
      (push-item (zip/right (top-item :zip state)) :zip (pop-item :zip state)))))

(define-registered zip_end?
  (fn [state]
    (if (empty? (:zip state))
      state
      (push-item (zip/end? (top-item :zip state)) :boolean (pop-item :zip state)))))

(define-registered zip_replace
  (fn [state]
    (if (empty? (rest (:zip state)))
      state
      (let [zip1 (stack-ref :zip 0 state)
	    zip2 (stack-ref :zip 1 state)]
	(push-item (zip/replace zip1 (zip/node zip2)) 
		   :zip 
		   (pop-item :zip (pop-item :zip state)))))))

(define-registered zip_rand
  (fn [state]
    (if (empty? (:zip state))
      state
      (push-item (zip/replace (top-item :zip state) (random-code @global-max-points-in-program @global-atom-generators))
		 :zip 
		 (pop-item :zip state)))))

(define-registered zip_randfair
  (fn [state]
    (if (empty? (:zip state))
      state
      (let [top-zip (top-item :zip state)
	    tz-pts (count-points (zip/node top-zip))]	
	(push-item (zip/replace (top-item :zip state)
				(random-code-in-range (Math/floor (* (- 1 global-fair-range) tz-pts)) 				 
						    (Math/floor (* (inc global-fair-range) tz-pts))
						    global-atom-generators))
		   :zip 
		   (pop-item :zip state))))))

(define-registered code_fromzip
  (fn [state]
    (if (or (empty? (:zip state))
	    (nil? (zip/node (top-item :zip state))))
      state
      (push-item (zip/node (top-item :zip state)) :code (pop-item :zip state)))))

(define-registered code_fromziproot
  (fn [state]
    (if (empty? (:zip state))
      state
      (push-item (zip/root (top-item :zip state)) :code (pop-item :zip state)))))

(define-registered zip_fromcode
  (fn [state]
    (if (empty? (:code state))
      state
      (push-item (zip/seq-zip (top-item :code state)) :zip (pop-item :code state)))))


(define-registered exec_fromzip
  (fn [state]
    (if (or (empty? (:zip state))
	    (nil? (zip/node (top-item :zip state))))
      state
      (push-item (zip/node (top-item :zip state)) :code (pop-item :zip state)))))

(define-registered exec_fromziproot
  (fn [state]
    (if (or (empty? (:zip state))
	    (nil? (zip/root (top-item :zip state))))      
      state
      (push-item (zip/root (top-item :zip state)) :exec (pop-item :zip state)))))

(define-registered zip_fromexec
  (fn [state]
    (if (empty? (:code state))
      state
      (push-item (zip/seq-zip (top-item :exec state)) :zip (pop-item :exec state)))))

(define-registered zip_yankdup (yankduper :zip))
(define-registered zip_dup (duper :zip))
(define-registered zip_pop (popper :zip))
(define-registered zip_swap (swapper :zip))
(define-registered zip_rot (rotter :zip))
(define-registered zip_flush (flusher :zip))
(define-registered zip_eq (eqer :zip))
(define-registered zip_stackdepth (stackdepther :zip))
(define-registered zip_yank (yanker :zip))
(define-registered zip_shove (shover :zip))
