(ns donut.datapotato.generate-malli
  (:require
   [donut.datapotato.core :as sm]
   [malli.generator :as mg]))

(def visit-key :generate)

(def generate-visiting-fn
  (sm/wrap-generate-visiting-fn
   (fn [db {:keys [ent-name]}]
     (-> db
         (sm/ent-schema ent-name)
         visit-key
         :schema
         mg/generate))))

(defn generate
  "Convenience function to build a new db and generate values for each ent"
  [db query]
  (-> (sm/add-ents db query)
      (sm/visit-ents-once visit-key generate-visiting-fn)))

(defn generate-attr-map
  "Convenience function to return a map of `{ent-name gen-data}` using
  the db returned by `generate`"
  [db query]
  (-> (generate db query)
      (sm/attr-map visit-key)))
