/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud.diamond.client;

import cn.leancloud.diamond.mockserver.MockServer;
import java.io.File;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiamondConfigure {
    private volatile int pollingIntervalTime = 15;
    private volatile int onceTimeout = 2000;
    private volatile int receiveWaitTime = 10000;
    private volatile List<String> domainNameList = new LinkedList<String>();
    private volatile boolean useFlowControl = true;
    private boolean localFirst = false;
    private int maxHostConnections = 1;
    private boolean connectionStaleCheckingEnabled = true;
    private int maxTotalConnections = 20;
    private int connectionTimeout = 2000;
    private int port = 8080;
    private int scheduledThreadPoolSize = 1;
    private int retrieveDataRetryTimes = 0xCCCCCCC;
    private String configServerAddress = null;
    private int configServerPort = 8080;
    private String filePath = System.getProperty("user.home") + "/diamond";

    public DiamondConfigure() {
        File dir = new File(this.filePath);
        dir.mkdirs();
        if (!dir.exists()) {
            throw new RuntimeException("\u521b\u5efadiamond\u76ee\u5f55\u5931\u8d25\uff1a" + this.filePath);
        }
    }

    public int getMaxHostConnections() {
        return this.maxHostConnections;
    }

    public void setMaxHostConnections(int maxHostConnections) {
        this.maxHostConnections = maxHostConnections;
    }

    public boolean isConnectionStaleCheckingEnabled() {
        return this.connectionStaleCheckingEnabled;
    }

    public void setConnectionStaleCheckingEnabled(boolean connectionStaleCheckingEnabled) {
        this.connectionStaleCheckingEnabled = connectionStaleCheckingEnabled;
    }

    public int getMaxTotalConnections() {
        return this.maxTotalConnections;
    }

    public void setMaxTotalConnections(int maxTotalConnections) {
        this.maxTotalConnections = maxTotalConnections;
    }

    public int getPollingIntervalTime() {
        return this.pollingIntervalTime;
    }

    public void setPollingIntervalTime(int pollingIntervalTime) {
        if (pollingIntervalTime < 15 && !MockServer.isTestMode()) {
            return;
        }
        this.pollingIntervalTime = pollingIntervalTime;
    }

    public List<String> getDomainNameList() {
        return this.domainNameList;
    }

    public void setDomainNameList(List<String> domainNameList) {
        if (null == domainNameList) {
            throw new NullPointerException();
        }
        this.domainNameList = new LinkedList<String>(domainNameList);
    }

    public void addDomainName(String domainName) {
        if (null == domainName) {
            throw new NullPointerException();
        }
        this.domainNameList.add(domainName);
    }

    public void addDomainNames(Collection<String> domainNameList) {
        if (null == domainNameList) {
            throw new NullPointerException();
        }
        this.domainNameList.addAll(domainNameList);
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public int getOnceTimeout() {
        return this.onceTimeout;
    }

    public void setOnceTimeout(int onceTimeout) {
        this.onceTimeout = onceTimeout;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public int getReceiveWaitTime() {
        return this.receiveWaitTime;
    }

    public void setReceiveWaitTime(int receiveWaitTime) {
        this.receiveWaitTime = receiveWaitTime;
    }

    public int getScheduledThreadPoolSize() {
        return this.scheduledThreadPoolSize;
    }

    public void setScheduledThreadPoolSize(int scheduledThreadPoolSize) {
        this.scheduledThreadPoolSize = scheduledThreadPoolSize;
    }

    public boolean isUseFlowControl() {
        return this.useFlowControl;
    }

    public void setUseFlowControl(boolean useFlowControl) {
        this.useFlowControl = useFlowControl;
    }

    public String getConfigServerAddress() {
        return this.configServerAddress;
    }

    public void setConfigServerAddress(String configServerAddress) {
        this.configServerAddress = configServerAddress;
    }

    public int getConfigServerPort() {
        return this.configServerPort;
    }

    public void setConfigServerPort(int configServerPort) {
        this.configServerPort = configServerPort;
    }

    public int getRetrieveDataRetryTimes() {
        return this.retrieveDataRetryTimes;
    }

    public void setRetrieveDataRetryTimes(int retrieveDataRetryTimes) {
        this.retrieveDataRetryTimes = retrieveDataRetryTimes;
    }

    public boolean isLocalFirst() {
        return this.localFirst;
    }

    public void setLocalFirst(boolean localFirst) {
        this.localFirst = localFirst;
    }
}

