/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud.diamond.mockserver;

import cn.leancloud.diamond.client.impl.DiamondClientFactory;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockServer {
    private static ConcurrentHashMap<String, Map<String, Pair>> staticConfigInfos = new ConcurrentHashMap();
    private static volatile boolean testMode = false;

    public static void setUpMockServer() {
        testMode = true;
    }

    public static void tearDownMockServer() {
        staticConfigInfos.clear();
        DiamondClientFactory.getSingletonDiamondSubscriber().close();
        testMode = false;
    }

    public static String getConfigInfo(String dataId) {
        return MockServer.getConfigInfo(dataId, null);
    }

    public static String getConfigInfo(String dataId, String group) {
        Map<String, Pair> pairs;
        if (null == group) {
            group = "DEFAULT_GROUP";
        }
        if (null == (pairs = staticConfigInfos.get(dataId))) {
            return null;
        }
        Pair pair = pairs.get(group);
        if (null == pair) {
            return null;
        }
        pair.checkable = false;
        return pair.configInfo;
    }

    public static String getUpdateConfigInfo(String dataId) {
        return MockServer.getUpdateConfigInfo(dataId, null);
    }

    public static String getUpdateConfigInfo(String dataId, String group) {
        Map<String, Pair> pairs;
        if (null == group) {
            group = "DEFAULT_GROUP";
        }
        if (null == (pairs = staticConfigInfos.get(dataId))) {
            return null;
        }
        Pair pair = pairs.get(group);
        if (null != pair && pair.checkable.booleanValue()) {
            pair.checkable = false;
            return pair.configInfo;
        }
        return null;
    }

    public static void setConfigInfos(Map<String, String> configInfos) {
        if (null != configInfos) {
            for (Map.Entry<String, String> entry : configInfos.entrySet()) {
                MockServer.setConfigInfo(entry.getKey(), entry.getValue());
            }
        }
    }

    public static void setConfigInfo(String dataId, String configInfo) {
        MockServer.setConfigInfo(dataId, null, configInfo);
    }

    public static void setConfigInfo(String dataId, String group, String configInfo) {
        if (null == group) {
            group = "DEFAULT_GROUP";
        }
        Pair pair = new Pair(configInfo);
        ConcurrentHashMap<String, Pair> newPairs = new ConcurrentHashMap<String, Pair>();
        ConcurrentHashMap<String, Pair> pairs = staticConfigInfos.putIfAbsent(dataId, newPairs);
        if (null == pairs) {
            pairs = newPairs;
        }
        pairs.put(group, pair);
    }

    public static boolean isTestMode() {
        return testMode;
    }

    private static class Pair {
        String configInfo;
        Boolean checkable;

        public Pair(String configInfo) {
            this.configInfo = configInfo;
            this.checkable = true;
        }
    }
}

