/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud.diamond.client.processor;

import cn.leancloud.diamond.client.DiamondConfigure;
import cn.leancloud.diamond.mockserver.MockServer;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.SimpleHttpConnectionManager;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;
import org.apache.commons.httpclient.params.HttpMethodParams;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ServerAddressProcessor {
    private static final Log log = LogFactory.getLog(ServerAddressProcessor.class);
    private static final int SC_OK = 200;
    private volatile boolean isRun = false;
    private volatile DiamondConfigure diamondConfigure = null;
    private HttpClient configHttpClient = null;
    private ScheduledExecutorService scheduledExecutor = null;
    private int asynAcquireIntervalInSec = 300;

    public ServerAddressProcessor(DiamondConfigure diamondConfigure, ScheduledExecutorService scheduledExecutor) {
        this.diamondConfigure = diamondConfigure;
        this.scheduledExecutor = scheduledExecutor;
    }

    void setAsynAcquireIntervalInSec(int asynAcquireIntervalInSec) {
        this.asynAcquireIntervalInSec = asynAcquireIntervalInSec;
    }

    public synchronized void start() {
        if (this.isRun) {
            return;
        }
        this.isRun = true;
        this.initHttpClient();
        if (this.diamondConfigure.isLocalFirst()) {
            this.acquireServerAddressFromLocal();
        } else {
            this.synAcquireServerAddress();
            this.asynAcquireServerAddress();
        }
    }

    public synchronized void stop() {
        if (!this.isRun) {
            return;
        }
        this.scheduledExecutor.shutdown();
        this.isRun = false;
    }

    private void initHttpClient() {
        HostConfiguration hostConfiguration = new HostConfiguration();
        SimpleHttpConnectionManager connectionManager = new SimpleHttpConnectionManager();
        connectionManager.closeIdleConnections(5000L);
        HttpConnectionManagerParams params = new HttpConnectionManagerParams();
        params.setStaleCheckingEnabled(this.diamondConfigure.isConnectionStaleCheckingEnabled());
        params.setConnectionTimeout(this.diamondConfigure.getConnectionTimeout());
        connectionManager.setParams(params);
        this.configHttpClient = new HttpClient((HttpConnectionManager)connectionManager);
        this.configHttpClient.setHostConfiguration(hostConfiguration);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void acquireServerAddressFromLocal() {
        if (!this.isRun) {
            throw new RuntimeException("ServerAddressProcessor\u4e0d\u5728\u8fd0\u884c\u72b6\u6001\uff0c\u65e0\u6cd5\u540c\u6b65\u83b7\u53d6\u670d\u52a1\u5668\u5730\u5740\u5217\u8868");
        }
        if (MockServer.isTestMode()) {
            this.diamondConfigure.addDomainName("\u6d4b\u8bd5\u6a21\u5f0f\uff0c\u6ca1\u6709\u4f7f\u7528\u7684\u771f\u5b9e\u670d\u52a1\u5668");
            return;
        }
        int acquireCount = 0;
        if (this.diamondConfigure.getDomainNameList().size() != 0) return;
        this.reloadServerAddresses();
        if (this.diamondConfigure.getDomainNameList().size() == 0) {
            if (!this.acquireServerAddressOnce(acquireCount)) {
                if (!this.acquireServerAddressOnce(++acquireCount)) throw new RuntimeException("\u5f53\u524d\u6ca1\u6709\u53ef\u7528\u7684\u670d\u52a1\u5668\u5217\u8868");
                this.storeServerAddressesToLocal();
                log.info((Object)"\u5728\u540c\u6b65\u83b7\u53d6\u670d\u52a1\u5668\u5217\u8868\u65f6\uff0c\u5411\u65e5\u5e38ConfigServer\u670d\u52a1\u5668\u83b7\u53d6\u5230\u4e86\u670d\u52a1\u5668\u5217\u8868");
                return;
            } else {
                log.info((Object)"\u5728\u540c\u6b65\u83b7\u53d6\u670d\u52a1\u5668\u5217\u8868\u65f6\uff0c\u5411\u7ebf\u4e0aConfigServer\u670d\u52a1\u5668\u83b7\u53d6\u5230\u4e86\u670d\u52a1\u5668\u5217\u8868");
                this.storeServerAddressesToLocal();
            }
            return;
        } else {
            log.info((Object)"\u5728\u540c\u6b65\u83b7\u53d6\u670d\u52a1\u5668\u5217\u8868\u65f6\uff0c\u7531\u4e8e\u672c\u5730\u6307\u5b9a\u4e86\u670d\u52a1\u5668\u5217\u8868\uff0c\u4e0d\u5411ConfigServer\u670d\u52a1\u5668\u540c\u6b65\u83b7\u53d6\u670d\u52a1\u5668\u5217\u8868");
        }
    }

    protected void synAcquireServerAddress() {
        if (!this.isRun) {
            throw new RuntimeException("ServerAddressProcessor\u4e0d\u5728\u8fd0\u884c\u72b6\u6001\uff0c\u65e0\u6cd5\u540c\u6b65\u83b7\u53d6\u670d\u52a1\u5668\u5730\u5740\u5217\u8868");
        }
        if (MockServer.isTestMode()) {
            this.diamondConfigure.addDomainName("\u6d4b\u8bd5\u6a21\u5f0f\uff0c\u6ca1\u6709\u4f7f\u7528\u7684\u771f\u5b9e\u670d\u52a1\u5668");
            return;
        }
        int acquireCount = 0;
        if (this.diamondConfigure.getDomainNameList().size() == 0) {
            if (!this.acquireServerAddressOnce(acquireCount)) {
                if (this.acquireServerAddressOnce(++acquireCount)) {
                    this.storeServerAddressesToLocal();
                    log.info((Object)"\u5728\u540c\u6b65\u83b7\u53d6\u670d\u52a1\u5668\u5217\u8868\u65f6\uff0c\u5411\u65e5\u5e38ConfigServer\u670d\u52a1\u5668\u83b7\u53d6\u5230\u4e86\u670d\u52a1\u5668\u5217\u8868");
                } else {
                    log.info((Object)"\u4ece\u672c\u5730\u83b7\u53d6Diamond\u5730\u5740\u5217\u8868");
                    this.reloadServerAddresses();
                    if (this.diamondConfigure.getDomainNameList().size() == 0) {
                        throw new RuntimeException("\u5f53\u524d\u6ca1\u6709\u53ef\u7528\u7684\u670d\u52a1\u5668\u5217\u8868");
                    }
                }
            } else {
                log.info((Object)"\u5728\u540c\u6b65\u83b7\u53d6\u670d\u52a1\u5668\u5217\u8868\u65f6\uff0c\u5411\u7ebf\u4e0aConfigServer\u670d\u52a1\u5668\u83b7\u53d6\u5230\u4e86\u670d\u52a1\u5668\u5217\u8868");
                this.storeServerAddressesToLocal();
            }
        }
    }

    protected void asynAcquireServerAddress() {
        if (MockServer.isTestMode()) {
            return;
        }
        this.scheduledExecutor.schedule(new Runnable(){

            public void run() {
                if (!ServerAddressProcessor.this.isRun) {
                    log.warn((Object)"ServerAddressProcessor\u4e0d\u5728\u8fd0\u884c\u72b6\u6001\uff0c\u65e0\u6cd5\u5f02\u6b65\u83b7\u53d6\u670d\u52a1\u5668\u5730\u5740\u5217\u8868");
                    return;
                }
                int acquireCount = 0;
                if (!ServerAddressProcessor.this.acquireServerAddressOnce(acquireCount)) {
                    if (ServerAddressProcessor.this.acquireServerAddressOnce(++acquireCount)) {
                        ServerAddressProcessor.this.storeServerAddressesToLocal();
                    }
                } else {
                    ServerAddressProcessor.this.storeServerAddressesToLocal();
                }
                ServerAddressProcessor.this.asynAcquireServerAddress();
            }
        }, (long)this.asynAcquireIntervalInSec, TimeUnit.SECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void storeServerAddressesToLocal() {
        ArrayList<String> domainNameList = new ArrayList<String>(this.diamondConfigure.getDomainNameList());
        PrintWriter printWriter = null;
        BufferedWriter bufferedWriter = null;
        try {
            File serverAddressFile = new File(this.generateLocalFilePath(this.diamondConfigure.getFilePath(), "ServerAddress"));
            if (!serverAddressFile.exists()) {
                serverAddressFile.createNewFile();
            }
            printWriter = new PrintWriter(serverAddressFile);
            bufferedWriter = new BufferedWriter(printWriter);
            for (String serveraddress : domainNameList) {
                bufferedWriter.write(serveraddress);
                bufferedWriter.newLine();
            }
            bufferedWriter.flush();
        }
        catch (Exception e) {
            log.error((Object)"\u5b58\u50a8\u670d\u52a1\u5668\u5730\u5740\u5230\u672c\u5730\u6587\u4ef6\u5931\u8d25", (Throwable)e);
        }
        finally {
            if (bufferedWriter != null) {
                try {
                    bufferedWriter.close();
                }
                catch (IOException e) {}
            }
            if (printWriter != null) {
                printWriter.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reloadServerAddresses() {
        FileInputStream fis = null;
        InputStreamReader reader = null;
        BufferedReader bufferedReader = null;
        try {
            File serverAddressFile = new File(this.generateLocalFilePath(this.diamondConfigure.getFilePath(), "ServerAddress"));
            if (!serverAddressFile.exists()) {
                return;
            }
            fis = new FileInputStream(serverAddressFile);
            reader = new InputStreamReader(fis);
            bufferedReader = new BufferedReader(reader);
            String address = null;
            while ((address = bufferedReader.readLine()) != null) {
                if (!StringUtils.isNotBlank((String)(address = address.trim()))) continue;
                this.diamondConfigure.getDomainNameList().add(address);
            }
            bufferedReader.close();
            reader.close();
            fis.close();
        }
        catch (Exception e) {
            log.error((Object)"\u4ece\u672c\u5730\u6587\u4ef6\u53d6\u670d\u52a1\u5668\u5730\u5740\u5931\u8d25", (Throwable)e);
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (Exception e) {}
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception e) {}
            }
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Exception e) {}
            }
        }
    }

    String generateLocalFilePath(String directory, String fileName) {
        String sign = "";
        if (null == directory) {
            directory = System.getProperty("user.home");
        }
        sign = directory.endsWith("\\") || directory.endsWith("/") ? "" : "/";
        return directory + sign + fileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean acquireServerAddressOnce(int acquireCount) {
        int port;
        String configServerAddress;
        HostConfiguration hostConfiguration = this.configHttpClient.getHostConfiguration();
        if (null != this.diamondConfigure.getConfigServerAddress()) {
            configServerAddress = this.diamondConfigure.getConfigServerAddress();
            port = this.diamondConfigure.getConfigServerPort();
        } else if (acquireCount == 0) {
            configServerAddress = "code2.avoscloud.com";
            port = 8080;
        } else {
            configServerAddress = "code2.avoscloud.com";
            port = 8080;
        }
        hostConfiguration.setHost(configServerAddress, port);
        String serverAddressUrl = "/diamond/diamond";
        GetMethod httpMethod = new GetMethod(serverAddressUrl);
        HttpMethodParams params = new HttpMethodParams();
        params.setSoTimeout(this.diamondConfigure.getOnceTimeout());
        httpMethod.setParams(params);
        try {
            if (200 == this.configHttpClient.executeMethod((HttpMethod)httpMethod)) {
                InputStreamReader reader = new InputStreamReader(httpMethod.getResponseBodyAsStream());
                BufferedReader bufferedReader = new BufferedReader(reader);
                String address = null;
                LinkedList<String> newDomainNameList = new LinkedList<String>();
                while ((address = bufferedReader.readLine()) != null) {
                    if (!StringUtils.isNotBlank((String)(address = address.trim()))) continue;
                    newDomainNameList.add(address);
                }
                if (newDomainNameList.size() > 0) {
                    log.debug((Object)"\u66f4\u65b0\u4f7f\u7528\u7684\u670d\u52a1\u5668\u5217\u8868");
                    this.diamondConfigure.setDomainNameList(newDomainNameList);
                    boolean bl = true;
                    return bl;
                }
            } else {
                log.warn((Object)"\u6ca1\u6709\u53ef\u7528\u7684\u65b0\u670d\u52a1\u5668\u5217\u8868");
            }
        }
        catch (HttpException e) {
            log.error((Object)(this.getErrorMessage(configServerAddress) + ", " + (Object)((Object)e)));
        }
        catch (IOException e) {
            log.error((Object)(this.getErrorMessage(configServerAddress) + ", " + e));
        }
        catch (Exception e) {
            log.error((Object)(this.getErrorMessage(configServerAddress) + ", " + e));
        }
        finally {
            httpMethod.releaseConnection();
        }
        return false;
    }

    public String getErrorMessage(String configServerAddress) {
        if (configServerAddress.equals("code2.avoscloud.com")) {
            return "\u83b7\u53d6\u670d\u52a1\u5668\u5730\u5740\u5217\u8868\u4fe1\u606fHttp\u5f02\u5e38,\u5982\u679c\u4f60\u662f\u5728\u65e5\u5e38\u73af\u5883\uff0c\u8bf7\u5ffd\u7565\u8fd9\u4e2a\u5f02\u5e38,configServerAddress=" + configServerAddress + ",";
        }
        return "\u83b7\u53d6\u670d\u52a1\u5668\u5730\u5740\u5217\u8868\u4fe1\u606fHttp\u5f02\u5e38, configServerAddress=" + configServerAddress + ",";
    }
}

