/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud.diamond.sdkapi.impl;

import cn.leancloud.diamond.common.Constants;
import cn.leancloud.diamond.domain.BatchContextResult;
import cn.leancloud.diamond.domain.ConfigInfo;
import cn.leancloud.diamond.domain.ConfigInfoEx;
import cn.leancloud.diamond.domain.ContextResult;
import cn.leancloud.diamond.domain.DiamondConf;
import cn.leancloud.diamond.domain.DiamondSDKConf;
import cn.leancloud.diamond.domain.Page;
import cn.leancloud.diamond.domain.PageContextResult;
import cn.leancloud.diamond.sdkapi.DiamondSDKManager;
import cn.leancloud.diamond.util.PatternUtils;
import cn.leancloud.diamond.util.RandomDiamondUtils;
import cn.leancloud.diamond.utils.JSONUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.jackson.type.TypeReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiamondSDKManagerImpl
implements DiamondSDKManager {
    private static final Log log = LogFactory.getLog((String)"diamondSdkLog");
    private Map<String, DiamondSDKConf> diamondSDKConfMaps;
    private final int connection_timeout;
    private final int require_timeout;
    private final HttpClient client;
    static final String LIST_FORMAT_URL = "/diamond-server/admin.do?method=listConfig&group=%s&dataId=%s&pageNo=%d&pageSize=%d";
    static final String LIST_LIKE_FORMAT_URL = "/diamond-server/admin.do?method=listConfigLike&group=%s&dataId=%s&pageNo=%d&pageSize=%d";

    public DiamondSDKManagerImpl(int connection_timeout, int require_timeout) throws IllegalArgumentException {
        if (connection_timeout < 0) {
            throw new IllegalArgumentException("\u8fde\u63a5\u8d85\u65f6\u65f6\u95f4\u8bbe\u7f6e\u5fc5\u987b\u5927\u4e8e0[\u5355\u4f4d(\u6beb\u79d2)]!");
        }
        if (require_timeout < 0) {
            throw new IllegalArgumentException("\u8bf7\u6c42\u8d85\u65f6\u65f6\u95f4\u8bbe\u7f6e\u5fc5\u987b\u5927\u4e8e0[\u5355\u4f4d(\u6beb\u79d2)]!");
        }
        this.connection_timeout = connection_timeout;
        this.require_timeout = require_timeout;
        int maxHostConnections = 50;
        MultiThreadedHttpConnectionManager connectionManager = new MultiThreadedHttpConnectionManager();
        connectionManager.getParams().setDefaultMaxConnectionsPerHost(maxHostConnections);
        connectionManager.getParams().setStaleCheckingEnabled(true);
        this.client = new HttpClient((HttpConnectionManager)connectionManager);
        this.client.getHttpConnectionManager().getParams().setConnectionTimeout(this.connection_timeout);
        this.client.getHttpConnectionManager().getParams().setSoTimeout(60000);
        this.client.getParams().setContentCharset("UTF-8");
        log.info((Object)("\u8bbe\u7f6e\u8fde\u63a5\u8d85\u65f6\u65f6\u95f4\u4e3a: " + this.connection_timeout + "\u6beb\u79d2"));
    }

    @Override
    public synchronized ContextResult pulish(String dataId, String groupName, String context, String serverId) {
        ContextResult response = null;
        if (this.validate(dataId, groupName, context)) {
            response = this.processPulishByDefinedServerId(dataId, groupName, context, serverId);
            return response;
        }
        response = new ContextResult();
        response.setSuccess(false);
        response.setStatusMsg("\u8bf7\u786e\u4fdddataId,group,content\u4e0d\u4e3a\u7a7a");
        return response;
    }

    @Override
    public synchronized ContextResult pulishAfterModified(String dataId, String groupName, String context, String serverId) {
        ContextResult response = null;
        if (this.validate(dataId, groupName, context)) {
            response = this.processPulishAfterModifiedByDefinedServerId(dataId, groupName, context, serverId);
            return response;
        }
        response = new ContextResult();
        response.setSuccess(false);
        response.setStatusMsg("\u8bf7\u786e\u4fdddataId,group,content\u4e0d\u4e3a\u7a7a");
        return response;
    }

    @Override
    public synchronized PageContextResult<ConfigInfo> queryBy(String dataIdPattern, String groupNamePattern, String serverId, long currentPage, long sizeOfPerPage) {
        return this.processQuery(dataIdPattern, groupNamePattern, null, serverId, currentPage, sizeOfPerPage);
    }

    @Override
    public synchronized PageContextResult<ConfigInfo> queryBy(String dataIdPattern, String groupNamePattern, String contentPattern, String serverId, long currentPage, long sizeOfPerPage) {
        return this.processQuery(dataIdPattern, groupNamePattern, contentPattern, serverId, currentPage, sizeOfPerPage);
    }

    @Override
    public synchronized ContextResult queryByDataIdAndGroupName(String dataId, String groupName, String serverId) {
        List<ConfigInfo> list;
        ContextResult result = new ContextResult();
        PageContextResult<ConfigInfo> pageContextResult = this.processQuery(dataId, groupName, null, serverId, 1L, 1L);
        result.setStatusMsg(pageContextResult.getStatusMsg());
        result.setSuccess(pageContextResult.isSuccess());
        result.setStatusCode(pageContextResult.getStatusCode());
        if (pageContextResult.isSuccess() && (list = pageContextResult.getDiamondData()) != null && !list.isEmpty()) {
            ConfigInfo info = list.iterator().next();
            result.setConfigInfo(info);
            result.setReceiveResult(info.getContent());
            result.setStatusCode(pageContextResult.getStatusCode());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ContextResult processPulishByDefinedServerId(String dataId, String groupName, String context, String serverId) {
        ContextResult response = new ContextResult();
        if (!this.login(serverId)) {
            response.setSuccess(false);
            response.setStatusMsg("\u767b\u5f55\u5931\u8d25,\u9020\u6210\u9519\u8bef\u7684\u539f\u56e0\u53ef\u80fd\u662f\u6307\u5b9a\u7684serverId\u4e3a\u7a7a\u6216\u4e0d\u5b58\u5728");
            return response;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("\u4f7f\u7528processPulishByDefinedServerId(" + dataId + "," + groupName + "," + context + "," + serverId + ")\u8fdb\u884c\u63a8\u9001"));
        }
        String postUrl = "/diamond-server/admin.do?method=postConfig";
        PostMethod post = new PostMethod(postUrl);
        post.getParams().setParameter("http.socket.timeout", (Object)this.require_timeout);
        try {
            NameValuePair dataId_value = new NameValuePair("dataId", dataId);
            NameValuePair group_value = new NameValuePair("group", groupName);
            NameValuePair content_value = new NameValuePair("content", context);
            post.setRequestBody(new NameValuePair[]{dataId_value, group_value, content_value});
            ConfigInfo configInfo = new ConfigInfo();
            configInfo.setDataId(dataId);
            configInfo.setGroup(groupName);
            configInfo.setContent(context);
            if (log.isDebugEnabled()) {
                log.debug((Object)("\u5f85\u63a8\u9001\u7684ConfigInfo: " + configInfo));
            }
            response.setConfigInfo(configInfo);
            int status = this.client.executeMethod((HttpMethod)post);
            response.setReceiveResult(post.getResponseBodyAsString());
            response.setStatusCode(status);
            log.info((Object)("\u72b6\u6001\u7801\uff1a" + status + ",\u54cd\u5e94\u7ed3\u679c\uff1a" + post.getResponseBodyAsString()));
            if (status == 200) {
                response.setSuccess(true);
                response.setStatusMsg("\u63a8\u9001\u5904\u7406\u6210\u529f");
                log.info((Object)("\u63a8\u9001\u5904\u7406\u6210\u529f, dataId=" + dataId + ",group=" + groupName + ",content=" + context + ",serverId=" + serverId));
            } else if (status == 408) {
                response.setSuccess(false);
                response.setStatusMsg("\u63a8\u9001\u5904\u7406\u8d85\u65f6, \u9ed8\u8ba4\u8d85\u65f6\u65f6\u95f4\u4e3a:" + this.require_timeout + "\u6beb\u79d2");
                log.error((Object)("\u63a8\u9001\u5904\u7406\u8d85\u65f6\uff0c\u9ed8\u8ba4\u8d85\u65f6\u65f6\u95f4\u4e3a:" + this.require_timeout + "\u6beb\u79d2, dataId=" + dataId + ",group=" + groupName + ",content=" + context + ",serverId=" + serverId));
            } else {
                response.setSuccess(false);
                response.setStatusMsg("\u63a8\u9001\u5904\u7406\u5931\u8d25, \u72b6\u6001\u7801\u4e3a:" + status);
                log.error((Object)("\u63a8\u9001\u5904\u7406\u5931\u8d25:" + response.getReceiveResult() + ",dataId=" + dataId + ",group=" + groupName + ",content=" + context + ",serverId=" + serverId));
            }
        }
        catch (HttpException e) {
            response.setStatusMsg("\u63a8\u9001\u5904\u7406\u53d1\u751fHttpException\uff1a" + e.getMessage());
            log.error((Object)("\u63a8\u9001\u5904\u7406\u53d1\u751fHttpException: dataId=" + dataId + ",group=" + groupName + ",content=" + context + ",serverId=" + serverId), (Throwable)e);
        }
        catch (IOException e) {
            response.setStatusMsg("\u63a8\u9001\u5904\u7406\u53d1\u751fIOException\uff1a" + e.getMessage());
            log.error((Object)("\u63a8\u9001\u5904\u7406\u53d1\u751fIOException: dataId=" + dataId + ",group=" + groupName + ",content=" + context + ",serverId=" + serverId), (Throwable)e);
        }
        finally {
            post.releaseConnection();
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ContextResult processPulishAfterModifiedByDefinedServerId(String dataId, String groupName, String context, String serverId) {
        ContextResult response = new ContextResult();
        if (!this.login(serverId)) {
            response.setSuccess(false);
            response.setStatusMsg("\u767b\u5f55\u5931\u8d25,\u9020\u6210\u9519\u8bef\u7684\u539f\u56e0\u53ef\u80fd\u662f\u6307\u5b9a\u7684serverId\u4e3a\u7a7a");
            return response;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("\u4f7f\u7528processPulishAfterModifiedByDefinedServerId(" + dataId + "," + groupName + "," + context + "," + serverId + ")\u8fdb\u884c\u63a8\u9001\u4fee\u6539"));
        }
        ContextResult result = null;
        result = this.queryByDataIdAndGroupName(dataId, groupName, serverId);
        if (null == result || !result.isSuccess()) {
            response.setSuccess(false);
            response.setStatusMsg("\u627e\u4e0d\u5230\u9700\u8981\u4fee\u6539\u7684\u6570\u636e\u8bb0\u5f55\uff0c\u8bb0\u5f55\u4e0d\u5b58\u5728!");
            log.warn((Object)("\u627e\u4e0d\u5230\u9700\u8981\u4fee\u6539\u7684\u6570\u636e\u8bb0\u5f55\uff0c\u8bb0\u5f55\u4e0d\u5b58\u5728! dataId=" + dataId + ",group=" + groupName + ",serverId=" + serverId));
            return response;
        }
        String postUrl = "/diamond-server/admin.do?method=updateConfig";
        PostMethod post = new PostMethod(postUrl);
        post.getParams().setParameter("http.socket.timeout", (Object)this.require_timeout);
        try {
            NameValuePair dataId_value = new NameValuePair("dataId", dataId);
            NameValuePair group_value = new NameValuePair("group", groupName);
            NameValuePair content_value = new NameValuePair("content", context);
            post.setRequestBody(new NameValuePair[]{dataId_value, group_value, content_value});
            ConfigInfo configInfo = new ConfigInfo();
            configInfo.setDataId(dataId);
            configInfo.setGroup(groupName);
            configInfo.setContent(context);
            if (log.isDebugEnabled()) {
                log.debug((Object)("\u5f85\u63a8\u9001\u7684\u4fee\u6539ConfigInfo: " + configInfo));
            }
            response.setConfigInfo(configInfo);
            int status = this.client.executeMethod((HttpMethod)post);
            response.setReceiveResult(post.getResponseBodyAsString());
            response.setStatusCode(status);
            log.info((Object)("\u72b6\u6001\u7801\uff1a" + status + ",\u54cd\u5e94\u7ed3\u679c\uff1a" + post.getResponseBodyAsString()));
            if (status == 200) {
                response.setSuccess(true);
                response.setStatusMsg("\u63a8\u9001\u4fee\u6539\u5904\u7406\u6210\u529f");
                log.info((Object)"\u63a8\u9001\u4fee\u6539\u5904\u7406\u6210\u529f");
            } else if (status == 408) {
                response.setSuccess(false);
                response.setStatusMsg("\u63a8\u9001\u4fee\u6539\u5904\u7406\u8d85\u65f6\uff0c\u9ed8\u8ba4\u8d85\u65f6\u65f6\u95f4\u4e3a:" + this.require_timeout + "\u6beb\u79d2");
                log.error((Object)("\u63a8\u9001\u4fee\u6539\u5904\u7406\u8d85\u65f6\uff0c\u9ed8\u8ba4\u8d85\u65f6\u65f6\u95f4\u4e3a:" + this.require_timeout + "\u6beb\u79d2, dataId=" + dataId + ",group=" + groupName + ",content=" + context + ",serverId=" + serverId));
            } else {
                response.setSuccess(false);
                response.setStatusMsg("\u63a8\u9001\u4fee\u6539\u5904\u7406\u5931\u8d25,\u5931\u8d25\u539f\u56e0\u8bf7\u901a\u8fc7ContextResult\u7684getReceiveResult()\u65b9\u6cd5\u67e5\u770b");
                log.error((Object)("\u63a8\u9001\u4fee\u6539\u5904\u7406\u5931\u8d25:" + response.getReceiveResult() + ",dataId=" + dataId + ",group=" + groupName + ",content=" + context + ",serverId=" + serverId));
            }
        }
        catch (HttpException e) {
            response.setSuccess(false);
            response.setStatusMsg("\u63a8\u9001\u4fee\u6539\u65b9\u6cd5\u6267\u884c\u8fc7\u7a0b\u53d1\u751fHttpException\uff1a" + e.getMessage());
            log.error((Object)("\u5728\u63a8\u9001\u4fee\u6539\u65b9\u6cd5processPulishAfterModifiedByDefinedServerId(String dataId, String groupName, String context,String serverId)\u6267\u884c\u8fc7\u7a0b\u4e2d\u53d1\u751fHttpException\uff1adataId=" + dataId + ",group=" + groupName + ",content=" + context + ",serverId=" + serverId), (Throwable)e);
            ContextResult contextResult = response;
            return contextResult;
        }
        catch (IOException e) {
            response.setSuccess(false);
            response.setStatusMsg("\u63a8\u9001\u4fee\u6539\u65b9\u6cd5\u6267\u884c\u8fc7\u7a0b\u53d1\u751fIOException\uff1a" + e.getMessage());
            log.error((Object)("\u5728\u63a8\u9001\u4fee\u6539\u65b9\u6cd5processPulishAfterModifiedByDefinedServerId(String dataId, String groupName, String context,String serverId)\u6267\u884c\u8fc7\u7a0b\u4e2d\u53d1\u751fIOException\uff1adataId=" + dataId + ",group=" + groupName + ",content=" + context + ",serverId=" + serverId), (Throwable)e);
            ContextResult contextResult = response;
            return contextResult;
        }
        finally {
            post.releaseConnection();
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean login(String serverId) {
        if (StringUtils.isEmpty((String)serverId) || StringUtils.isBlank((String)serverId)) {
            return false;
        }
        DiamondSDKConf defaultConf = this.diamondSDKConfMaps.get(serverId);
        log.info((Object)("[login] \u767b\u5f55\u4f7f\u7528serverId:" + serverId + ",\u8be5\u73af\u5883\u5bf9\u8c61\u5c5e\u6027\uff1a" + defaultConf));
        if (null == defaultConf) {
            return false;
        }
        RandomDiamondUtils util = new RandomDiamondUtils();
        util.init(defaultConf.getDiamondConfs());
        if (defaultConf.getDiamondConfs().size() == 0) {
            return false;
        }
        boolean flag = false;
        log.info((Object)("[randomSequence] \u6b64\u6b21\u8bbf\u95ee\u5e8f\u5217\u4e3a: " + util.getSequenceToString()));
        while (util.getRetry_times() < util.getMax_times()) {
            DiamondConf diamondConf = util.generatorOneDiamondConf();
            log.info((Object)("\u7b2c" + util.getRetry_times() + "\u6b21\u5c1d\u8bd5:" + diamondConf));
            if (diamondConf == null) break;
            this.client.getHostConfiguration().setHost(diamondConf.getDiamondIp(), Integer.parseInt(diamondConf.getDiamondPort()), "http");
            PostMethod post = new PostMethod("/diamond-server/login.do?method=login");
            post.getParams().setParameter("http.socket.timeout", (Object)this.require_timeout);
            NameValuePair username_value = new NameValuePair("username", diamondConf.getDiamondUsername());
            NameValuePair password_value = new NameValuePair("password", diamondConf.getDiamondPassword());
            post.setRequestBody(new NameValuePair[]{username_value, password_value});
            log.info((Object)("\u4f7f\u7528diamondIp: " + diamondConf.getDiamondIp() + ",diamondPort: " + diamondConf.getDiamondPort() + ",diamondUsername: " + diamondConf.getDiamondUsername() + ",diamondPassword: " + diamondConf.getDiamondPassword() + "\u767b\u5f55diamondServerUrl: [" + diamondConf.getDiamondConUrl() + "]"));
            try {
                int state = this.client.executeMethod((HttpMethod)post);
                log.info((Object)("\u767b\u5f55\u8fd4\u56de\u72b6\u6001\u7801\uff1a" + state));
                if (state != 200) continue;
                log.info((Object)("\u7b2c" + util.getRetry_times() + "\u6b21\u5c1d\u8bd5\u6210\u529f"));
                flag = true;
                break;
            }
            catch (HttpException e) {
                log.error((Object)"\u767b\u5f55\u8fc7\u7a0b\u53d1\u751fHttpException", (Throwable)e);
            }
            catch (IOException e) {
                log.error((Object)"\u767b\u5f55\u8fc7\u7a0b\u53d1\u751fIOException", (Throwable)e);
            }
            finally {
                post.releaseConnection();
            }
        }
        if (!flag) {
            log.error((Object)("\u9020\u6210login\u5931\u8d25\u7684\u539f\u56e0\u53ef\u80fd\u662f\uff1a\u6240\u6709diamondServer\u7684\u914d\u7f6e\u73af\u5883\u76ee\u524d\u5747\u4e0d\u53ef\u7528\uff0eserverId=" + serverId));
        }
        return flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private PageContextResult<ConfigInfo> processQuery(String dataIdPattern, String groupNamePattern, String contentPattern, String serverId, long currentPage, long sizeOfPerPage) {
        PageContextResult<ConfigInfo> response = new PageContextResult<ConfigInfo>();
        if (!this.login(serverId)) {
            response.setSuccess(false);
            response.setStatusMsg("\u767b\u5f55\u5931\u8d25,\u9020\u6210\u9519\u8bef\u7684\u539f\u56e0\u53ef\u80fd\u662f\u6307\u5b9a\u7684serverId\u4e3a\u7a7a\u6216\u4e0d\u5b58\u5728");
            return response;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("\u4f7f\u7528processQuery(" + dataIdPattern + "," + groupNamePattern + "," + contentPattern + "," + serverId + ")\u8fdb\u884c\u67e5\u8be2"));
        }
        boolean hasPattern = PatternUtils.hasCharPattern(dataIdPattern) || PatternUtils.hasCharPattern(groupNamePattern) || PatternUtils.hasCharPattern(contentPattern);
        String url = null;
        if (hasPattern) {
            if (!StringUtils.isBlank((String)contentPattern)) {
                log.warn((Object)("\u6ce8\u610f, \u6b63\u5728\u6839\u636e\u5185\u5bb9\u6765\u8fdb\u884c\u6a21\u7cca\u67e5\u8be2, dataIdPattern=" + dataIdPattern + ",groupNamePattern=" + groupNamePattern + ",contentPattern=" + contentPattern));
                url = String.format(LIST_LIKE_FORMAT_URL, groupNamePattern, dataIdPattern, 1, Integer.MAX_VALUE);
            } else {
                url = String.format(LIST_LIKE_FORMAT_URL, groupNamePattern, dataIdPattern, currentPage, sizeOfPerPage);
            }
        } else {
            url = String.format(LIST_FORMAT_URL, groupNamePattern, dataIdPattern, currentPage, sizeOfPerPage);
        }
        GetMethod method = new GetMethod(url);
        this.configureGetMethod(method);
        try {
            int status = this.client.executeMethod((HttpMethod)method);
            response.setStatusCode(status);
            switch (status) {
                case 200: {
                    String json = "";
                    try {
                        void var16_20;
                        json = this.getContent((HttpMethod)method).trim();
                        Page page = null;
                        if (!json.equals("null")) {
                            page = (Page)JSONUtils.deserializeObject((String)json, (TypeReference)new TypeReference<Page<ConfigInfo>>(){});
                        }
                        if (page != null) {
                            List list = page.getPageItems();
                            if (!StringUtils.isBlank((String)contentPattern)) {
                                Pattern pattern = Pattern.compile(contentPattern.replaceAll("\\*", ".*"));
                                ArrayList<ConfigInfo> newList = new ArrayList<ConfigInfo>();
                                Collections.sort(list);
                                int totalCount = 0;
                                long begin = sizeOfPerPage * (currentPage - 1L);
                                long end = sizeOfPerPage * currentPage;
                                for (ConfigInfo configInfo : list) {
                                    Matcher m;
                                    if (configInfo.getContent() == null || !(m = pattern.matcher(configInfo.getContent())).find()) continue;
                                    if ((long)totalCount >= begin && (long)totalCount < end) {
                                        newList.add(configInfo);
                                    }
                                    ++totalCount;
                                }
                                page.setPageItems(newList);
                                page.setTotalCount(totalCount);
                            }
                            response.setOriginalDataSize(list.size());
                            response.setTotalCounts(page.getTotalCount());
                            response.setCurrentPage(currentPage);
                            response.setSizeOfPerPage(sizeOfPerPage);
                        } else {
                            response.setOriginalDataSize(0L);
                            response.setTotalCounts(0L);
                            response.setCurrentPage(currentPage);
                            response.setSizeOfPerPage(sizeOfPerPage);
                        }
                        response.operation();
                        ArrayList arrayList = new ArrayList();
                        if (page != null) {
                            List list = page.getPageItems();
                        }
                        response.setDiamondData((List<ConfigInfo>)var16_20);
                        response.setSuccess(true);
                        response.setStatusMsg("\u6307\u5b9adiamond\u7684\u67e5\u8be2\u5b8c\u6210");
                        log.info((Object)("\u6307\u5b9adiamond\u7684\u67e5\u8be2\u5b8c\u6210, url=" + url));
                        return response;
                    }
                    catch (Exception e) {
                        response.setSuccess(false);
                        response.setStatusMsg("\u53cd\u5e8f\u5217\u5316\u5931\u8d25,\u9519\u8bef\u4fe1\u606f\u4e3a\uff1a" + e.getLocalizedMessage());
                        log.error((Object)("\u53cd\u5e8f\u5217\u5316page\u5bf9\u8c61\u5931\u8d25, dataId=" + dataIdPattern + ",group=" + groupNamePattern + ",serverId=" + serverId + ",json=" + json), (Throwable)e);
                        return response;
                    }
                }
                case 408: {
                    response.setSuccess(false);
                    response.setStatusMsg("\u67e5\u8be2\u6570\u636e\u8d85\u65f6" + this.require_timeout + "\u6beb\u79d2");
                    log.error((Object)("\u67e5\u8be2\u6570\u636e\u8d85\u65f6\uff0c\u9ed8\u8ba4\u8d85\u65f6\u65f6\u95f4\u4e3a:" + this.require_timeout + "\u6beb\u79d2, dataId=" + dataIdPattern + ",group=" + groupNamePattern + ",serverId=" + serverId));
                    return response;
                }
                default: {
                    response.setSuccess(false);
                    response.setStatusMsg("\u67e5\u8be2\u6570\u636e\u51fa\u9519\uff0c\u670d\u52a1\u5668\u8fd4\u56de\u72b6\u6001\u7801\u4e3a" + status);
                    log.error((Object)("\u67e5\u8be2\u6570\u636e\u51fa\u9519\uff0c\u72b6\u6001\u7801\u4e3a\uff1a" + status + ",dataId=" + dataIdPattern + ",group=" + groupNamePattern + ",serverId=" + serverId));
                    return response;
                }
            }
        }
        catch (HttpException e) {
            response.setSuccess(false);
            response.setStatusMsg("\u67e5\u8be2\u6570\u636e\u51fa\u9519,\u9519\u8bef\u4fe1\u606f\u5982\u4e0b\uff1a" + e.getMessage());
            log.error((Object)("\u67e5\u8be2\u6570\u636e\u51fa\u9519, dataId=" + dataIdPattern + ",group=" + groupNamePattern + ",serverId=" + serverId), (Throwable)e);
            return response;
        }
        catch (IOException e) {
            response.setSuccess(false);
            response.setStatusMsg("\u67e5\u8be2\u6570\u636e\u51fa\u9519,\u9519\u8bef\u4fe1\u606f\u5982\u4e0b\uff1a" + e.getMessage());
            log.error((Object)("\u67e5\u8be2\u6570\u636e\u51fa\u9519, dataId=" + dataIdPattern + ",group=" + groupNamePattern + ",serverId=" + serverId), (Throwable)e);
            return response;
        }
        finally {
            method.releaseConnection();
        }
    }

    boolean isZipContent(HttpMethod httpMethod) {
        String acceptEncoding;
        return null != httpMethod.getResponseHeader("Content-Encoding") && (acceptEncoding = httpMethod.getResponseHeader("Content-Encoding").getValue()).toLowerCase().indexOf("gzip") > -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getContent(HttpMethod httpMethod) throws UnsupportedEncodingException {
        StringBuilder contentBuilder = new StringBuilder();
        if (this.isZipContent(httpMethod)) {
            InputStream is = null;
            GZIPInputStream gzin = null;
            InputStreamReader isr = null;
            BufferedReader br = null;
            try {
                is = httpMethod.getResponseBodyAsStream();
                gzin = new GZIPInputStream(is);
                isr = new InputStreamReader((InputStream)gzin, ((HttpMethodBase)httpMethod).getResponseCharSet());
                br = new BufferedReader(isr);
                char[] buffer = new char[4096];
                int readlen = -1;
                while ((readlen = br.read(buffer, 0, 4096)) != -1) {
                    contentBuilder.append(buffer, 0, readlen);
                }
            }
            catch (Exception e) {
                log.error((Object)"\u89e3\u538b\u7f29\u5931\u8d25", (Throwable)e);
            }
            finally {
                try {
                    br.close();
                }
                catch (Exception e1) {}
                try {
                    isr.close();
                }
                catch (Exception e1) {}
                try {
                    gzin.close();
                }
                catch (Exception e1) {}
                try {
                    is.close();
                }
                catch (Exception e1) {}
            }
        } else {
            String content = null;
            try {
                content = httpMethod.getResponseBodyAsString();
            }
            catch (Exception e) {
                log.error((Object)"\u83b7\u53d6\u914d\u7f6e\u4fe1\u606f\u5931\u8d25", (Throwable)e);
            }
            if (null == content) {
                return null;
            }
            contentBuilder.append(content);
        }
        return StringEscapeUtils.unescapeHtml((String)contentBuilder.toString());
    }

    private void configureGetMethod(GetMethod method) {
        method.addRequestHeader("Accept-Encoding", "gzip,deflate");
        method.addRequestHeader("Accept", "application/json");
        method.getParams().setParameter("http.socket.timeout", (Object)this.require_timeout);
    }

    private boolean validate(String dataId, String groupName, String context) {
        return !StringUtils.isEmpty((String)dataId) && !StringUtils.isEmpty((String)groupName) && !StringUtils.isEmpty((String)context) && !StringUtils.isBlank((String)dataId) && !StringUtils.isBlank((String)groupName) && !StringUtils.isBlank((String)context);
    }

    @Override
    public synchronized ContextResult unpublish(String serverId, long id) {
        return this.processDelete(serverId, id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ContextResult processDelete(String serverId, long id) {
        ContextResult response = new ContextResult();
        if (!this.login(serverId)) {
            response.setSuccess(false);
            response.setStatusMsg("\u767b\u5f55\u5931\u8d25,\u9020\u6210\u9519\u8bef\u7684\u539f\u56e0\u53ef\u80fd\u662f\u6307\u5b9a\u7684serverId\u4e3a\u7a7a\u6216\u4e0d\u5b58\u5728");
            return response;
        }
        log.info((Object)("\u4f7f\u7528processDelete(" + serverId + "," + id));
        String url = "/diamond-server/admin.do?method=deleteConfig&id=" + id;
        GetMethod method = new GetMethod(url);
        this.configureGetMethod(method);
        try {
            int status = this.client.executeMethod((HttpMethod)method);
            response.setStatusCode(status);
            switch (status) {
                case 200: {
                    response.setSuccess(true);
                    response.setReceiveResult(this.getContent((HttpMethod)method));
                    response.setStatusMsg("\u5220\u9664\u6210\u529f, url=" + url);
                    log.warn((Object)("\u5220\u9664\u914d\u7f6e\u6570\u636e\u6210\u529f, url=" + url));
                    return response;
                }
                case 408: {
                    response.setSuccess(false);
                    response.setStatusMsg("\u5220\u9664\u6570\u636e\u8d85\u65f6" + this.require_timeout + "\u6beb\u79d2");
                    log.error((Object)("\u5220\u9664\u6570\u636e\u8d85\u65f6\uff0c\u9ed8\u8ba4\u8d85\u65f6\u65f6\u95f4\u4e3a:" + this.require_timeout + "\u6beb\u79d2, id=" + id + ",serverId=" + serverId));
                    return response;
                }
                default: {
                    response.setSuccess(false);
                    response.setStatusMsg("\u5220\u9664\u6570\u636e\u51fa\u9519\uff0c\u670d\u52a1\u5668\u8fd4\u56de\u72b6\u6001\u7801\u4e3a" + status);
                    log.error((Object)("\u5220\u9664\u6570\u636e\u51fa\u9519\uff0c\u72b6\u6001\u7801\u4e3a\uff1a" + status + ", id=" + id + ",serverId=" + serverId));
                    return response;
                }
            }
        }
        catch (HttpException e) {
            response.setSuccess(false);
            response.setStatusMsg("\u5220\u9664\u6570\u636e\u51fa\u9519,\u9519\u8bef\u4fe1\u606f\u5982\u4e0b\uff1a" + e.getMessage());
            log.error((Object)("\u5220\u9664\u6570\u636e\u51fa\u9519, id=" + id + ",serverId=" + serverId), (Throwable)e);
            return response;
        }
        catch (IOException e) {
            response.setSuccess(false);
            response.setStatusMsg("\u5220\u9664\u6570\u636e\u51fa\u9519,\u9519\u8bef\u4fe1\u606f\u5982\u4e0b\uff1a" + e.getMessage());
            log.error((Object)("\u5220\u9664\u6570\u636e\u51fa\u9519, id=" + id + ",serverId=" + serverId), (Throwable)e);
            return response;
        }
        finally {
            method.releaseConnection();
        }
    }

    @Override
    public Map<String, DiamondSDKConf> getDiamondSDKConfMaps() {
        return this.diamondSDKConfMaps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BatchContextResult<ConfigInfoEx> batchQuery(String serverId, String groupName, List<String> dataIds) {
        BatchContextResult<ConfigInfoEx> response = new BatchContextResult<ConfigInfoEx>();
        if (dataIds == null) {
            log.error((Object)("dataId list cannot be null, serverId=" + serverId + ",group=" + groupName));
            response.setSuccess(false);
            response.setStatusMsg("dataId list cannot be null");
            return response;
        }
        StringBuilder dataIdBuilder = new StringBuilder();
        for (String dataId : dataIds) {
            dataIdBuilder.append(dataId).append(Constants.LINE_SEPARATOR);
        }
        String dataIdStr = dataIdBuilder.toString();
        if (!this.login(serverId)) {
            response.setSuccess(false);
            response.setStatusMsg("login fail, serverId=" + serverId);
            return response;
        }
        PostMethod post = new PostMethod("/diamond-server/admin.do?method=batchQuery");
        post.getParams().setParameter("http.socket.timeout", (Object)this.require_timeout);
        try {
            NameValuePair dataId_value = new NameValuePair("dataIds", dataIdStr);
            NameValuePair group_value = new NameValuePair("group", groupName);
            post.setRequestBody(new NameValuePair[]{dataId_value, group_value});
            int status = this.client.executeMethod((HttpMethod)post);
            response.setStatusCode(status);
            String responseMsg = post.getResponseBodyAsString();
            response.setResponseMsg(responseMsg);
            if (status == 200) {
                String json = null;
                try {
                    json = responseMsg;
                    LinkedList<ConfigInfoEx> configInfoExList = new LinkedList<ConfigInfoEx>();
                    Object resultObj = JSONUtils.deserializeObject((String)json, (TypeReference)new TypeReference<List<ConfigInfoEx>>(){});
                    if (!(resultObj instanceof List)) {
                        throw new RuntimeException("batch query deserialize type error, not list, json=" + json);
                    }
                    List resultList = (List)resultObj;
                    for (ConfigInfoEx configInfoEx : resultList) {
                        configInfoExList.add(configInfoEx);
                    }
                    response.getResult().addAll(configInfoExList);
                    response.setSuccess(true);
                    response.setStatusMsg("batch query success");
                    log.info((Object)("batch query success, serverId=" + serverId + ",dataIds=" + dataIdStr + ",group=" + groupName + ",json=" + json));
                }
                catch (Exception e) {
                    response.setSuccess(false);
                    response.setStatusMsg("batch query deserialize error");
                    log.error((Object)("batch query deserialize error, serverId=" + serverId + ",dataIdStr=" + dataIdStr + ",group=" + groupName + ",json=" + json), (Throwable)e);
                }
            } else if (status == 408) {
                response.setSuccess(false);
                response.setStatusMsg("batch query timeout, socket timeout(ms):" + this.require_timeout);
                log.error((Object)("batch query timeout, socket timeout(ms):" + this.require_timeout + ", serverId=" + serverId + ",dataIds=" + dataIdStr + ",group=" + groupName));
            } else {
                response.setSuccess(false);
                response.setStatusMsg("batch query fail, status:" + status);
                log.error((Object)("batch query fail, status:" + status + ", response:" + responseMsg + ",serverId=" + serverId + ",dataIds=" + dataIdStr + ",group=" + groupName));
            }
        }
        catch (HttpException e) {
            response.setSuccess(false);
            response.setStatusMsg("batch query http exception\uff1a" + e.getMessage());
            log.error((Object)("batch query http exception, serverId=" + serverId + ",dataIds=" + dataIdStr + ",group=" + groupName), (Throwable)e);
        }
        catch (IOException e) {
            response.setSuccess(false);
            response.setStatusMsg("batch query io exception\uff1a" + e.getMessage());
            log.error((Object)("batch query io exception, serverId=" + serverId + ",dataIds=" + dataIdStr + ",group=" + groupName), (Throwable)e);
        }
        finally {
            post.releaseConnection();
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BatchContextResult<ConfigInfoEx> batchAddOrUpdate(String serverId, String groupName, Map<String, String> dataId2ContentMap) {
        BatchContextResult<ConfigInfoEx> response = new BatchContextResult<ConfigInfoEx>();
        if (dataId2ContentMap == null) {
            log.error((Object)("dataId2ContentMap cannot be null, serverId=" + serverId + " ,group=" + groupName));
            response.setSuccess(false);
            response.setStatusMsg("dataId2ContentMap cannot be null");
            return response;
        }
        StringBuilder allDataIdAndContentBuilder = new StringBuilder();
        for (String dataId : dataId2ContentMap.keySet()) {
            String content = dataId2ContentMap.get(dataId);
            allDataIdAndContentBuilder.append(dataId + Constants.WORD_SEPARATOR + content).append(Constants.LINE_SEPARATOR);
        }
        String allDataIdAndContent = allDataIdAndContentBuilder.toString();
        if (!this.login(serverId)) {
            response.setSuccess(false);
            response.setStatusMsg("login fail, serverId=" + serverId);
            return response;
        }
        PostMethod post = new PostMethod("/diamond-server/admin.do?method=batchAddOrUpdate");
        post.getParams().setParameter("http.socket.timeout", (Object)this.require_timeout);
        try {
            NameValuePair dataId_value = new NameValuePair("allDataIdAndContent", allDataIdAndContent);
            NameValuePair group_value = new NameValuePair("group", groupName);
            post.setRequestBody(new NameValuePair[]{dataId_value, group_value});
            int status = this.client.executeMethod((HttpMethod)post);
            response.setStatusCode(status);
            String responseMsg = post.getResponseBodyAsString();
            response.setResponseMsg(responseMsg);
            if (status == 200) {
                String json = null;
                try {
                    json = responseMsg;
                    LinkedList<ConfigInfoEx> configInfoExList = new LinkedList<ConfigInfoEx>();
                    Object resultObj = JSONUtils.deserializeObject((String)json, (TypeReference)new TypeReference<List<ConfigInfoEx>>(){});
                    if (!(resultObj instanceof List)) {
                        throw new RuntimeException("batch write deserialize type error, not list, json=" + json);
                    }
                    List resultList = (List)resultObj;
                    for (ConfigInfoEx configInfoEx : resultList) {
                        configInfoExList.add(configInfoEx);
                    }
                    response.getResult().addAll(configInfoExList);
                    response.setStatusMsg("batch write success");
                    log.info((Object)("batch write success,serverId=" + serverId + ",allDataIdAndContent=" + allDataIdAndContent + ",group=" + groupName + ",json=" + json));
                }
                catch (Exception e) {
                    response.setSuccess(false);
                    response.setStatusMsg("batch write deserialize error");
                    log.error((Object)("batch write deserialize error, serverId=" + serverId + ",allDataIdAndContent=" + allDataIdAndContent + ",group=" + groupName + ",json=" + json), (Throwable)e);
                }
            } else if (status == 408) {
                response.setSuccess(false);
                response.setStatusMsg("batch write timeout, socket timeout(ms):" + this.require_timeout);
                log.error((Object)("batch write timeout, socket timeout(ms):" + this.require_timeout + ", serverId=" + serverId + ",allDataIdAndContent=" + allDataIdAndContent + ",group=" + groupName));
            } else {
                response.setSuccess(false);
                response.setStatusMsg("batch write fail, status:" + status);
                log.error((Object)("batch write fail, status:" + status + ", response:" + responseMsg + ",serverId=" + serverId + ",allDataIdAndContent=" + allDataIdAndContent + ",group=" + groupName));
            }
        }
        catch (HttpException e) {
            response.setSuccess(false);
            response.setStatusMsg("batch write http exception\uff1a" + e.getMessage());
            log.error((Object)("batch write http exception, serverId=" + serverId + ",allDataIdAndContent=" + allDataIdAndContent + ",group=" + groupName), (Throwable)e);
        }
        catch (IOException e) {
            response.setSuccess(false);
            response.setStatusMsg("batch write io exception\uff1a" + e.getMessage());
            log.error((Object)("batch write io exception, serverId=" + serverId + ",allDataIdAndContent=" + allDataIdAndContent + ",group=" + groupName), (Throwable)e);
        }
        finally {
            post.releaseConnection();
        }
        return response;
    }
}

