/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud.diamond.domain;

import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PageContextResult<T> {
    private long totalCounts = 0L;
    private long totalPages = 1L;
    private long currentPage = 1L;
    private long offset = 0L;
    private long length = 1L;
    private long sizeOfPerPage = 10L;
    private List<T> diamondData;
    private long originalDataSize = 0L;
    private int statusCode;
    private boolean isSuccess = false;
    private String statusMsg;

    public PageContextResult() {
    }

    public PageContextResult(long totalCounts, long sizeOfPerPage) {
        this.totalCounts = totalCounts;
        this.sizeOfPerPage = sizeOfPerPage;
    }

    public void operation() {
        if (this.totalCounts < 0L) {
            this.totalCounts = 0L;
        }
        if (this.sizeOfPerPage <= 0L) {
            this.sizeOfPerPage = 1L;
        }
        this.totalPages = this.totalCounts % this.sizeOfPerPage == 0L ? this.totalCounts / this.sizeOfPerPage : this.totalCounts / this.sizeOfPerPage + 1L;
        if (this.totalPages <= 1L) {
            this.totalPages = 1L;
        }
        if (this.currentPage <= 1L) {
            this.currentPage = 1L;
        } else if (this.currentPage > this.totalPages) {
            this.currentPage = this.totalPages;
        }
        this.offset = (this.currentPage - 1L) * this.sizeOfPerPage;
        if (this.offset < 0L) {
            this.offset = 0L;
        }
        this.length = this.currentPage < this.totalPages ? this.sizeOfPerPage : this.totalCounts - (this.currentPage - 1L) * this.sizeOfPerPage;
    }

    public long getTotalCounts() {
        return this.totalCounts;
    }

    public void setTotalCounts(long totalCounts) {
        this.totalCounts = totalCounts;
    }

    public long getTotalPages() {
        return this.totalPages;
    }

    public long getCurrentPage() {
        return this.currentPage;
    }

    public void setCurrentPage(long currentPage) {
        this.currentPage = currentPage;
    }

    public long getOffset() {
        return this.offset;
    }

    public long getLength() {
        return this.length;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public void setStatusCode(int statusCode) {
        this.statusCode = statusCode;
    }

    public long getSizeOfPerPage() {
        return this.sizeOfPerPage;
    }

    public void setTotalPages(long totalPages) {
        this.totalPages = totalPages;
    }

    public void setOffset(long offset) {
        this.offset = offset;
    }

    public void setLength(long length) {
        this.length = length;
    }

    public void setSizeOfPerPage(long sizeOfPerPage) {
        this.sizeOfPerPage = sizeOfPerPage;
    }

    public List<T> getDiamondData() {
        return this.diamondData;
    }

    public void setDiamondData(List<T> diamondData) {
        this.diamondData = diamondData;
    }

    public long getOriginalDataSize() {
        return this.originalDataSize;
    }

    public void setOriginalDataSize(long originalDataSize) {
        this.originalDataSize = originalDataSize;
    }

    public boolean isSuccess() {
        return this.isSuccess;
    }

    public void setSuccess(boolean isSuccess) {
        this.isSuccess = isSuccess;
    }

    public String getStatusMsg() {
        return this.statusMsg;
    }

    public void setStatusMsg(String statusMsg) {
        this.statusMsg = statusMsg;
    }

    public String toString() {
        return "[totalCounts=" + this.totalCounts + ",totalPages=" + this.totalPages + ",currentPage=" + this.currentPage + ",offset=" + this.offset + ",length=" + this.length + ",sizeOfPerPage=" + this.sizeOfPerPage + ",diamondData=" + this.diamondData + ",isSuccess=" + this.isSuccess + ",statusMsg=" + this.statusMsg + "]";
    }
}

