/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud.diamond.util;

import cn.leancloud.diamond.domain.DiamondConf;
import java.util.List;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RandomDiamondUtils {
    private List<DiamondConf> allDiamondConfs;
    private int retry_times;
    private int max_times;
    private int[] randomIndexSequence;
    private int currentIndex;

    public void init(List<DiamondConf> diamondConfs) {
        int len = diamondConfs.size();
        if (this.allDiamondConfs == null) {
            this.allDiamondConfs = diamondConfs;
        }
        this.max_times = len;
        this.retry_times = 0;
        this.currentIndex = 0;
        this.randomIndexSequence = new int[len];
        for (int i = 0; i < len; ++i) {
            this.randomIndexSequence[i] = i;
        }
        if (len == 1) {
            return;
        }
        Random random = new Random();
        if (len == 2 && random.nextInt(2) == 1) {
            int temp = this.randomIndexSequence[0];
            this.randomIndexSequence[0] = this.randomIndexSequence[1];
            this.randomIndexSequence[1] = temp;
            return;
        }
        int times = 2 * len;
        for (int j = 0; j < times; ++j) {
            int selectedIndex = random.nextInt(len - 1);
            int temp = this.randomIndexSequence[selectedIndex];
            this.randomIndexSequence[selectedIndex] = this.randomIndexSequence[len - 1];
            this.randomIndexSequence[len - 1] = temp;
        }
    }

    public int getRetry_times() {
        return this.retry_times;
    }

    public int getMax_times() {
        return this.max_times;
    }

    public DiamondConf generatorOneDiamondConf() {
        DiamondConf diamondConf = null;
        if (this.retry_times < this.max_times) {
            this.currentIndex = this.randomIndexSequence[this.retry_times];
            diamondConf = this.allDiamondConfs.get(this.currentIndex);
        } else {
            this.randomIndexSequence = null;
        }
        ++this.retry_times;
        return diamondConf;
    }

    public int[] getRandomIndexSequence() {
        return this.randomIndexSequence;
    }

    public String getSequenceToString() {
        StringBuilder sb = new StringBuilder();
        for (int i : this.randomIndexSequence) {
            sb.append(i + "");
        }
        return sb.toString();
    }
}

