/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud.diamond.io.watch;

import cn.leancloud.diamond.io.Path;
import cn.leancloud.diamond.io.watch.StandardWatchEventKind;
import cn.leancloud.diamond.io.watch.WatchEvent;
import cn.leancloud.diamond.io.watch.WatchService;
import cn.leancloud.diamond.io.watch.util.PathNode;
import java.io.File;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WatchKey {
    private volatile boolean valid = true;
    private final PathNode root;
    private List<WatchEvent<?>> changedEvents;
    private final Set<WatchEvent.Kind<?>> filterSet = new HashSet();
    private final WatchService watcher;

    public WatchKey(Path path, WatchService watcher, boolean fireCreatedEventOnIndex, WatchEvent.Kind<?> ... events) {
        this.watcher = watcher;
        this.root = new PathNode(path, true);
        if (events != null) {
            for (WatchEvent.Kind<?> event : events) {
                this.filterSet.add(event);
            }
        }
        LinkedList changedEvents = new LinkedList();
        this.index(this.root, fireCreatedEventOnIndex, changedEvents);
        this.changedEvents = changedEvents;
    }

    private void index(PathNode node, boolean fireCreatedEventOnIndex, LinkedList<WatchEvent<?>> changedEvents) {
        File file = node.getPath().getFile();
        if (!file.isDirectory()) {
            return;
        }
        File[] subFiles = file.listFiles();
        if (subFiles != null) {
            for (File subFile : subFiles) {
                PathNode subNode = new PathNode(new Path(subFile), false);
                if (fireCreatedEventOnIndex) {
                    changedEvents.add(new WatchEvent<Path>(StandardWatchEventKind.ENTRY_CREATE, 1, subNode.getPath()));
                }
                node.addChild(subNode);
                if (!subNode.getPath().isDirectory()) continue;
                this.index(subNode, fireCreatedEventOnIndex, changedEvents);
            }
        }
    }

    public void cancel() {
        this.valid = false;
    }

    public String toString() {
        return "WatchKey [root=" + this.root + ", valid=" + this.valid + "]";
    }

    public boolean isValid() {
        return this.valid && this.root != null;
    }

    public List<WatchEvent<?>> pollEvents() {
        if (this.changedEvents != null) {
            List<WatchEvent<?>> result = this.changedEvents;
            this.changedEvents = null;
            return result;
        }
        return null;
    }

    boolean check() {
        if (this.changedEvents != null && this.changedEvents.size() > 0) {
            return true;
        }
        if (!this.valid) {
            return false;
        }
        LinkedList list = new LinkedList();
        if (this.check(this.root, list)) {
            this.changedEvents = list;
            return true;
        }
        return false;
    }

    private boolean check(PathNode node, List<WatchEvent<?>> changedEvents) {
        Path nodePath = node.getPath();
        File nodeNewFile = new File(nodePath.getAbsolutePath());
        if (nodePath != null) {
            if (node.isRoot()) {
                if (!nodeNewFile.exists()) {
                    return this.fireOnRootDeleted(changedEvents, nodeNewFile);
                }
                return this.checkNodeChildren(node, changedEvents, nodeNewFile);
            }
            return this.checkNodeChildren(node, changedEvents, nodeNewFile);
        }
        throw new IllegalStateException("PathNode\u6ca1\u6709path");
    }

    private boolean checkNodeChildren(PathNode node, List<WatchEvent<?>> changedEvents, File nodeNewFile) {
        boolean changed = false;
        Iterator<PathNode> it = node.getChildren().iterator();
        HashSet<String> childNameSet = new HashSet<String>();
        while (it.hasNext()) {
            PathNode child = it.next();
            Path childPath = child.getPath();
            childNameSet.add(childPath.getName());
            File childNewFile = new File(childPath.getAbsolutePath());
            if (!childNewFile.exists() && this.filterSet.contains(StandardWatchEventKind.ENTRY_DELETE)) {
                changed = true;
                changedEvents.add(new WatchEvent<Path>(StandardWatchEventKind.ENTRY_DELETE, 1, childPath));
                it.remove();
            }
            if (childPath.isFile() && this.checkFile(changedEvents, child, childNewFile) && !changed) {
                changed = true;
            }
            if (!childPath.isDirectory() || !this.check(child, changedEvents) || changed) continue;
            changed = true;
        }
        File[] newChildFiles = nodeNewFile.listFiles();
        if (newChildFiles != null) {
            for (File newChildFile : newChildFiles) {
                if (childNameSet.contains(newChildFile.getName()) || !this.filterSet.contains(StandardWatchEventKind.ENTRY_CREATE)) continue;
                changed = true;
                Path newChildPath = new Path(newChildFile);
                changedEvents.add(new WatchEvent<Path>(StandardWatchEventKind.ENTRY_CREATE, 1, newChildPath));
                PathNode newSubNode = new PathNode(newChildPath, false);
                node.addChild(newSubNode);
                if (!newChildFile.isDirectory()) continue;
                this.checkNodeChildren(newSubNode, changedEvents, newChildFile);
            }
        }
        return changed;
    }

    private boolean checkFile(List<WatchEvent<?>> changedEvents, PathNode child, File childNewFile) {
        boolean changed = false;
        if (childNewFile.lastModified() != child.lastModified() && this.filterSet.contains(StandardWatchEventKind.ENTRY_MODIFY)) {
            changed = true;
            Path newChildPath = new Path(childNewFile);
            changedEvents.add(new WatchEvent<Path>(StandardWatchEventKind.ENTRY_MODIFY, 1, newChildPath));
            child.setPath(newChildPath);
        }
        return changed;
    }

    private boolean fireOnRootDeleted(List<WatchEvent<?>> changedEvents, File nodeNewFile) {
        this.valid = false;
        if (this.filterSet.contains(StandardWatchEventKind.ENTRY_DELETE)) {
            changedEvents.add(new WatchEvent<Path>(StandardWatchEventKind.ENTRY_DELETE, 1, new Path(nodeNewFile)));
            return true;
        }
        return false;
    }

    public boolean reset() {
        if (!this.valid) {
            return false;
        }
        if (this.root == null) {
            return false;
        }
        return this.watcher.resetKey(this);
    }
}

