/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud.diamond.io.watch;

import cn.leancloud.diamond.io.Path;
import cn.leancloud.diamond.io.watch.WatchEvent;
import cn.leancloud.diamond.io.watch.WatchKey;
import java.util.Iterator;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WatchService {
    private BlockingQueue<WatchKey> changedKeys = new LinkedBlockingQueue<WatchKey>();
    private BlockingQueue<WatchKey> watchedKeys = new LinkedBlockingQueue<WatchKey>();
    private static final Log log = LogFactory.getLog(WatchService.class);
    private ScheduledExecutorService service = Executors.newSingleThreadScheduledExecutor();

    public WatchService(long checkInterval) {
        this.service.scheduleAtFixedRate(new CheckThread(), checkInterval, checkInterval, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void check() {
        WatchService watchService = this;
        synchronized (watchService) {
            Iterator it = this.watchedKeys.iterator();
            while (it.hasNext()) {
                WatchKey key = (WatchKey)it.next();
                try {
                    if (!key.check()) continue;
                    this.changedKeys.add(key);
                    it.remove();
                }
                catch (Throwable t) {
                    log.error((Object)("\u68c0\u6d4bWatchKey\u5f02\u5e38,key=" + key), t);
                }
            }
        }
    }

    public WatchKey register(Path root, WatchEvent.Kind<?> ... events) {
        if (events == null || events.length == 0) {
            throw new UnsupportedOperationException("null events");
        }
        if (this.service.isShutdown()) {
            throw new IllegalStateException("\u670d\u52a1\u5df2\u7ecf\u5173\u95ed");
        }
        if (!root.exists()) {
            throw new IllegalArgumentException("\u76d1\u89c6\u7684\u76ee\u5f55\u4e0d\u5b58\u5728");
        }
        WatchKey key = new WatchKey(root, this, false, events);
        this.resetKey(key);
        return key;
    }

    public WatchKey register(Path root, boolean fireCreatedEventOnIndex, WatchEvent.Kind<?> ... events) {
        if (events == null || events.length == 0) {
            throw new UnsupportedOperationException("null events");
        }
        if (this.service.isShutdown()) {
            throw new IllegalStateException("\u670d\u52a1\u5df2\u7ecf\u5173\u95ed");
        }
        if (!root.exists()) {
            throw new IllegalArgumentException("\u76d1\u89c6\u7684\u76ee\u5f55\u4e0d\u5b58\u5728");
        }
        WatchKey key = new WatchKey(root, this, fireCreatedEventOnIndex, events);
        this.resetKey(key);
        return key;
    }

    boolean resetKey(WatchKey key) {
        return this.watchedKeys.add(key);
    }

    public void close() {
        this.service.shutdown();
    }

    public WatchKey poll() {
        return (WatchKey)this.changedKeys.poll();
    }

    public WatchKey poll(long timeout, TimeUnit unit) throws InterruptedException {
        return this.changedKeys.poll(timeout, unit);
    }

    public WatchKey take() throws InterruptedException {
        return this.changedKeys.take();
    }

    private final class CheckThread
    implements Runnable {
        private CheckThread() {
        }

        public void run() {
            WatchService.this.check();
        }
    }
}

