/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud.diamond.utils;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleCache<E> {
    private ConcurrentMap<String, CacheEntry<E>> cache = new ConcurrentHashMap<String, CacheEntry<E>>();
    private long cacheTTL;

    public SimpleCache() {
        this(15000L);
    }

    public SimpleCache(long cacheTTL) {
        this.cacheTTL = cacheTTL;
    }

    public void put(String key, E e) {
        if (key == null || e == null) {
            return;
        }
        CacheEntry<E> entry = new CacheEntry<E>(e, System.currentTimeMillis() + this.cacheTTL);
        this.cache.put(key, entry);
    }

    public E get(String key) {
        E result = null;
        CacheEntry entry = (CacheEntry)this.cache.get(key);
        if (entry != null && entry.timestamp > System.currentTimeMillis()) {
            result = entry.value;
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CacheEntry<E> {
        public final long timestamp;
        public final E value;

        public CacheEntry(E value, long timestamp) {
            this.timestamp = timestamp;
            this.value = value;
        }
    }
}

