/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud.play.collection;

import cn.leancloud.play.collection.GameArray;
import cn.leancloud.play.utils.CastTypeException;
import cn.leancloud.play.utils.CastTypeUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class GameMap
implements Map<String, Object>,
Cloneable,
Serializable {
    public static final GameMap EMPTY_MAP = new GameMap(Collections.emptyMap());
    private static final long serialVersionUID = 1L;
    private static final int DEFAULT_INITIAL_CAPACITY = 16;
    private final Map<String, Object> map;

    public GameMap() {
        this(16);
    }

    public GameMap(Map<Object, Object> map) {
        this.map = GameMap.toGameMap(map);
    }

    public GameMap(int initialCapacity) {
        this.map = new HashMap<String, Object>(initialCapacity);
    }

    public static GameMap toGameMap(Map<Object, Object> inputMap) {
        if (inputMap == null) {
            return EMPTY_MAP;
        }
        GameMap map = new GameMap(inputMap.size());
        for (Map.Entry<Object, Object> entry : inputMap.entrySet()) {
            Object key = entry.getKey();
            String keyInStr = CastTypeUtils.castToString(key);
            Object v = entry.getValue();
            map.put(keyInStr, v);
        }
        return map;
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public Object get(Object key) {
        return this.map.get(key);
    }

    @Override
    public Object put(String key, Object value) {
        return this.map.put(key, value);
    }

    public GameMap fluentPut(String key, Object value) {
        this.map.put(key, value);
        return this;
    }

    @Override
    public Object remove(Object key) {
        return this.map.remove(key);
    }

    public GameMap fluentRemove(Object key) {
        this.map.remove(key);
        return this;
    }

    @Override
    public void putAll(Map<? extends String, ?> m) {
        this.map.putAll(m);
    }

    public GameMap fluentPutAll(Map<? extends String, ?> m) {
        this.map.putAll(m);
        return this;
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    public GameMap fluentClear() {
        this.map.clear();
        return this;
    }

    @Override
    public Set<String> keySet() {
        return this.map.keySet();
    }

    @Override
    public Collection<Object> values() {
        return this.map.values();
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return this.map.entrySet();
    }

    public Object clone() {
        return new GameMap(new HashMap<Object, Object>(this.map));
    }

    @Override
    public boolean equals(Object obj) {
        return this.map.equals(obj);
    }

    @Override
    public int hashCode() {
        return this.map.hashCode();
    }

    public GameMap getGameMap(String key) {
        Object value = this.map.get(key);
        if (value == null) {
            return null;
        }
        if (value instanceof GameMap) {
            return (GameMap)value;
        }
        if (value instanceof Map) {
            return GameMap.toGameMap((Map)value);
        }
        throw new CastTypeException("can not cast to GameMap, value : '" + value + "'");
    }

    public GameArray getGameArray(String key) {
        Object value = this.map.get(key);
        if (value == null) {
            return null;
        }
        if (value instanceof GameArray) {
            return (GameArray)value;
        }
        if (value instanceof List) {
            return GameArray.toGameArray((List)value);
        }
        throw new CastTypeException("can not cast to GameArray, value : '" + value + "'");
    }

    public <T> T getObject(String key, Class<T> clazz) {
        Object obj = this.map.get(key);
        return CastTypeUtils.cast(obj, clazz);
    }

    public Boolean getBoolean(String key) {
        Object value = this.get(key);
        if (value == null) {
            return null;
        }
        return CastTypeUtils.castToBoolean(value);
    }

    public byte[] getBytes(String key) {
        Object value = this.get(key);
        if (value == null) {
            return null;
        }
        return CastTypeUtils.castToBytes(value);
    }

    public boolean getBooleanValue(String key) {
        Object value = this.get(key);
        Boolean booleanVal = CastTypeUtils.castToBoolean(value);
        if (booleanVal == null) {
            return false;
        }
        return booleanVal;
    }

    public Byte getByte(String key) {
        Object value = this.get(key);
        return CastTypeUtils.castToByte(value);
    }

    public byte getByteValue(String key) {
        Object value = this.get(key);
        Byte byteVal = CastTypeUtils.castToByte(value);
        if (byteVal == null) {
            return 0;
        }
        return byteVal;
    }

    public Short getShort(String key) {
        Object value = this.get(key);
        return CastTypeUtils.castToShort(value);
    }

    public short getShortValue(String key) {
        Object value = this.get(key);
        Short shortVal = CastTypeUtils.castToShort(value);
        if (shortVal == null) {
            return 0;
        }
        return shortVal;
    }

    public Integer getInteger(String key) {
        Object value = this.get(key);
        return CastTypeUtils.castToInt(value);
    }

    public int getIntValue(String key) {
        Object value = this.get(key);
        Integer intVal = CastTypeUtils.castToInt(value);
        if (intVal == null) {
            return 0;
        }
        return intVal;
    }

    public Long getLong(String key) {
        Object value = this.get(key);
        return CastTypeUtils.castToLong(value);
    }

    public long getLongValue(String key) {
        Object value = this.get(key);
        Long longVal = CastTypeUtils.castToLong(value);
        if (longVal == null) {
            return 0L;
        }
        return longVal;
    }

    public Float getFloat(String key) {
        Object value = this.get(key);
        return CastTypeUtils.castToFloat(value);
    }

    public float getFloatValue(String key) {
        Object value = this.get(key);
        Float floatValue = CastTypeUtils.castToFloat(value);
        if (floatValue == null) {
            return 0.0f;
        }
        return floatValue.floatValue();
    }

    public Double getDouble(String key) {
        Object value = this.get(key);
        return CastTypeUtils.castToDouble(value);
    }

    public double getDoubleValue(String key) {
        Object value = this.get(key);
        Double doubleValue = CastTypeUtils.castToDouble(value);
        if (doubleValue == null) {
            return 0.0;
        }
        return doubleValue;
    }

    public BigDecimal getBigDecimal(String key) {
        Object value = this.get(key);
        return CastTypeUtils.castToBigDecimal(value);
    }

    public BigInteger getBigInteger(String key) {
        Object value = this.get(key);
        return CastTypeUtils.castToBigInteger(value);
    }

    public String getString(String key) {
        Object value = this.get(key);
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    public Map<String, Object> getInnerMap() {
        return this.map;
    }

    public String toString() {
        return "GameMap{" + this.map + '}';
    }
}

