/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud.play.plugin.request;

import clojure.lang.Keyword;
import clojure.lang.PersistentHashMap;
import clojure.lang.RT;
import cn.leancloud.play.plugin.request.AbstractRequest;
import cn.leancloud.play.utils.Log;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;

public final class SetPlayerPropertiesRequest
extends AbstractRequest {
    private static final Keyword targetActorIdK = RT.keyword(null, (String)"target-actor-id");
    private static final Keyword expectAttrK = RT.keyword(null, (String)"expect-attr");
    private static final Keyword attrK = RT.keyword(null, (String)"attr");

    public SetPlayerPropertiesRequest(Map<Keyword, Object> requestParams) {
        super(requestParams);
    }

    public Map<String, Object> getProperties() {
        return this.getParameter(attrK, Collections.emptyMap());
    }

    public SetPlayerPropertiesRequest setProperties(Map<String, Object> attr) {
        Objects.requireNonNull(attr);
        if (attr.isEmpty()) {
            throw new IllegalArgumentException();
        }
        this.setParameter(attrK, PersistentHashMap.create(attr));
        return this;
    }

    public Map<String, Object> getExpectedValues() {
        return this.getParameter(expectAttrK, Collections.emptyMap());
    }

    public SetPlayerPropertiesRequest setExpectedValues(Map<String, Object> casAttr) {
        Objects.requireNonNull(casAttr);
        if (casAttr.isEmpty()) {
            throw new IllegalArgumentException();
        }
        this.setParameter(expectAttrK, PersistentHashMap.create(casAttr));
        return this;
    }

    public int getTargetActorId() {
        Number id = (Number)this.getParameter(targetActorIdK);
        if (id != null) {
            return id.intValue();
        }
        Log.error("No target actor id in {}. current params={}", (Object)SetPlayerPropertiesRequest.class.getSimpleName(), this.getAllParameters());
        return -1;
    }

    public SetPlayerPropertiesRequest setTargetActorId(int actorId) {
        this.setParameter(targetActorIdK, actorId);
        return this;
    }
}

