/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud.play.plugin.request;

import clojure.lang.Keyword;
import clojure.lang.RT;
import cn.leancloud.play.plugin.Reason;
import cn.leancloud.play.plugin.request.AbstractRequest;
import cn.leancloud.play.utils.Log;
import java.util.Map;

public final class LeaveRoomRequest
extends AbstractRequest {
    private static final Keyword isByMasterK = RT.keyword(null, (String)"by-master?");
    private static final Keyword fromActorIdK = RT.keyword(null, (String)"init-by-actor");
    private static final Keyword targetActorIdK = RT.keyword(null, (String)"target-actor-id");
    private static final Keyword appCodeK = RT.keyword(null, (String)"app-code");
    private static final Keyword appMsgK = RT.keyword(null, (String)"app-msg");

    public LeaveRoomRequest(Map<Keyword, Object> requestParams) {
        super(requestParams);
    }

    public int getFromActorId() {
        Number id = (Number)this.getParameter(fromActorIdK);
        if (id != null) {
            return id.intValue();
        }
        Log.error("No from actor id in LeaveRoomRequest. current params={}", this.getAllInternalParameters());
        return -1;
    }

    public int getTargetActorId() {
        Number id = (Number)this.getParameter(targetActorIdK);
        if (id != null) {
            return id.intValue();
        }
        Log.error("No target actor id in {}. current params={}", (Object)LeaveRoomRequest.class.getSimpleName(), this.getAllInternalParameters());
        return -1;
    }

    public Reason getLeaveRoomReason() {
        Number appCode = (Number)this.getParameter(appCodeK);
        if (appCode != null) {
            String appMsg = (String)this.getParameter(appMsgK);
            return Reason.of(appCode.intValue(), appMsg);
        }
        return Reason.EMPTY_REASON;
    }

    public boolean byMaster() {
        Boolean byMaster = (Boolean)this.getParameter(isByMasterK);
        return byMaster != null && byMaster != false;
    }

    public String toString() {
        return "LeaveRoomRequest{roomName=" + this.getRoomName() + ", userId=" + this.getUserId() + ", fromActorId=" + this.getFromActorId() + ", targetActorId=" + this.getTargetActorId() + ", leaveRoomReason=" + this.getLeaveRoomReason() + ", kickByMaster=" + this.byMaster() + "}";
    }
}

