/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud.play.plugin.request;

import clojure.lang.Keyword;
import clojure.lang.PersistentVector;
import clojure.lang.RT;
import cn.leancloud.play.collection.PlayObject;
import cn.leancloud.play.plugin.request.AbstractRequest;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class JoinRoomRequest
extends AbstractRequest {
    private static final Keyword expectMK = RT.keyword(null, "expect-m");
    private static final Keyword isRejoinK = RT.keyword(null, "rejoin?");
    private static final Keyword expectAttrK = RT.keyword(null, "expect-attr");
    private static final Keyword attrK = RT.keyword(null, "attr");

    public JoinRoomRequest(Map<Keyword, Object> requestParams) {
        super(requestParams);
    }

    public List<String> getExpectUsers() {
        return this.getParameter(expectMK, Collections.emptyList());
    }

    public JoinRoomRequest setExpectUsers(List<String> expectUsers) {
        Objects.requireNonNull(expectUsers);
        if (expectUsers.isEmpty()) {
            throw new IllegalArgumentException();
        }
        this.setParameter(expectMK, PersistentVector.create(expectUsers));
        return this;
    }

    public boolean isRejoin() {
        return this.getParameter(isRejoinK, false);
    }

    public PlayObject getMatchProperties() {
        return this.getParameter(expectAttrK, PlayObject.EMPTY_OBJECT);
    }

    public JoinRoomRequest setMatchProperties(PlayObject attr) {
        Objects.requireNonNull(attr);
        if (attr.isEmpty()) {
            throw new IllegalArgumentException();
        }
        this.setParameter(expectAttrK, attr.clone());
        return this;
    }

    public PlayObject getActorProperties() {
        return this.getParameter(attrK, PlayObject.EMPTY_OBJECT);
    }

    public JoinRoomRequest setActorProperties(PlayObject attr) {
        Objects.requireNonNull(attr);
        if (attr.isEmpty()) {
            throw new IllegalArgumentException();
        }
        this.setParameter(attrK, attr.clone());
        return this;
    }
}

