/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf;

import com.google.protobuf.AbstractProtobufList;
import com.google.protobuf.Internal;
import com.google.protobuf.PrimitiveNonBoxingCollection;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class DoubleArrayList
extends AbstractProtobufList<Double>
implements Internal.DoubleList,
RandomAccess,
PrimitiveNonBoxingCollection {
    private static final DoubleArrayList EMPTY_LIST = new DoubleArrayList(new double[0], 0);
    private double[] array;
    private int size;

    public static DoubleArrayList emptyList() {
        return EMPTY_LIST;
    }

    DoubleArrayList() {
        this(new double[10], 0);
    }

    private DoubleArrayList(double[] other, int size) {
        this.array = other;
        this.size = size;
    }

    @Override
    protected void removeRange(int fromIndex, int toIndex) {
        this.ensureIsMutable();
        if (toIndex < fromIndex) {
            throw new IndexOutOfBoundsException("toIndex < fromIndex");
        }
        System.arraycopy(this.array, toIndex, this.array, fromIndex, this.size - toIndex);
        this.size -= toIndex - fromIndex;
        ++this.modCount;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DoubleArrayList)) {
            return super.equals(o);
        }
        DoubleArrayList other = (DoubleArrayList)o;
        if (this.size != other.size) {
            return false;
        }
        double[] arr = other.array;
        for (int i = 0; i < this.size; ++i) {
            if (Double.doubleToLongBits(this.array[i]) == Double.doubleToLongBits(arr[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int result = 1;
        for (int i = 0; i < this.size; ++i) {
            long bits = Double.doubleToLongBits(this.array[i]);
            result = 31 * result + Internal.hashLong(bits);
        }
        return result;
    }

    @Override
    public Internal.DoubleList mutableCopyWithCapacity(int capacity) {
        if (capacity < this.size) {
            throw new IllegalArgumentException();
        }
        return new DoubleArrayList(Arrays.copyOf(this.array, capacity), this.size);
    }

    @Override
    public Double get(int index2) {
        return this.getDouble(index2);
    }

    @Override
    public double getDouble(int index2) {
        this.ensureIndexInRange(index2);
        return this.array[index2];
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public Double set(int index2, Double element) {
        return this.setDouble(index2, element);
    }

    @Override
    public double setDouble(int index2, double element) {
        this.ensureIsMutable();
        this.ensureIndexInRange(index2);
        double previousValue = this.array[index2];
        this.array[index2] = element;
        return previousValue;
    }

    @Override
    public void add(int index2, Double element) {
        this.addDouble(index2, element);
    }

    @Override
    public void addDouble(double element) {
        this.addDouble(this.size, element);
    }

    private void addDouble(int index2, double element) {
        this.ensureIsMutable();
        if (index2 < 0 || index2 > this.size) {
            throw new IndexOutOfBoundsException(this.makeOutOfBoundsExceptionMessage(index2));
        }
        if (this.size < this.array.length) {
            System.arraycopy(this.array, index2, this.array, index2 + 1, this.size - index2);
        } else {
            int length = this.size * 3 / 2 + 1;
            double[] newArray = new double[length];
            System.arraycopy(this.array, 0, newArray, 0, index2);
            System.arraycopy(this.array, index2, newArray, index2 + 1, this.size - index2);
            this.array = newArray;
        }
        this.array[index2] = element;
        ++this.size;
        ++this.modCount;
    }

    @Override
    public boolean addAll(Collection<? extends Double> collection) {
        this.ensureIsMutable();
        Internal.checkNotNull(collection);
        if (!(collection instanceof DoubleArrayList)) {
            return super.addAll(collection);
        }
        DoubleArrayList list = (DoubleArrayList)collection;
        if (list.size == 0) {
            return false;
        }
        int overflow = Integer.MAX_VALUE - this.size;
        if (overflow < list.size) {
            throw new OutOfMemoryError();
        }
        int newSize = this.size + list.size;
        if (newSize > this.array.length) {
            this.array = Arrays.copyOf(this.array, newSize);
        }
        System.arraycopy(list.array, 0, this.array, this.size, list.size);
        this.size = newSize;
        ++this.modCount;
        return true;
    }

    @Override
    public boolean remove(Object o) {
        this.ensureIsMutable();
        for (int i = 0; i < this.size; ++i) {
            if (!o.equals(this.array[i])) continue;
            System.arraycopy(this.array, i + 1, this.array, i, this.size - i - 1);
            --this.size;
            ++this.modCount;
            return true;
        }
        return false;
    }

    @Override
    public Double remove(int index2) {
        this.ensureIsMutable();
        this.ensureIndexInRange(index2);
        double value = this.array[index2];
        if (index2 < this.size - 1) {
            System.arraycopy(this.array, index2 + 1, this.array, index2, this.size - index2 - 1);
        }
        --this.size;
        ++this.modCount;
        return value;
    }

    private void ensureIndexInRange(int index2) {
        if (index2 < 0 || index2 >= this.size) {
            throw new IndexOutOfBoundsException(this.makeOutOfBoundsExceptionMessage(index2));
        }
    }

    private String makeOutOfBoundsExceptionMessage(int index2) {
        return "Index:" + index2 + ", Size:" + this.size;
    }

    static {
        EMPTY_LIST.makeImmutable();
    }
}

