/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud.play.codec;

import cn.leancloud.play.codec.Codec;
import cn.leancloud.play.codec.CodecsManager;
import com.google.protobuf.ByteString;
import java.util.Objects;

final class ObjectThunk {
    private final byte objectTypeId;
    private final ByteString originalObjectInByteString;
    private Object resolvedObject;

    ObjectThunk(byte objectTypeId, ByteString originalObjectInByteString) {
        this.objectTypeId = objectTypeId;
        this.originalObjectInByteString = originalObjectInByteString;
    }

    byte getObjectTypeId() {
        return this.objectTypeId;
    }

    ByteString getObjectInByteString() {
        if (this.resolvedObject == null) {
            return this.originalObjectInByteString;
        }
        return ByteString.copyFrom((byte[])CodecsManager.getInstance().serialize(this.resolvedObject));
    }

    <T> T resolve(Codec codec) {
        if (this.resolvedObject == null) {
            this.resolvedObject = codec.deserialize(this.originalObjectInByteString.toByteArray());
        }
        return (T)this.resolvedObject;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ObjectThunk that = (ObjectThunk)o;
        if (this.resolvedObject != null && that.resolvedObject != null) {
            return this.resolvedObject.equals(that.resolvedObject);
        }
        return this.getObjectTypeId() == that.getObjectTypeId() && Objects.equals(this.originalObjectInByteString, that.originalObjectInByteString);
    }

    public int hashCode() {
        if (this.resolvedObject != null) {
            return this.resolvedObject.hashCode();
        }
        return Objects.hash(this.getObjectTypeId(), this.originalObjectInByteString);
    }
}

