/*
 * Decompiled with CFR 0.152.
 */
package tech.v3.datatype;

import tech.v3.datatype.Buffer;

public class ByteConversions {
    public static byte byteFromBytes(byte by) {
        return by;
    }

    public static byte byteFromReader(Buffer buffer, long l) {
        return buffer.readByte(0L + l);
    }

    public static void byteToWriter(byte by, Buffer buffer, long l) {
        buffer.writeByte(0L + l, by);
    }

    public static short shortFromBytesLE(byte by, byte by2) {
        return (short)(by & 0xFF | (by2 & 0xFF) << 8);
    }

    public static short shortFromBytesBE(byte by, byte by2) {
        return ByteConversions.shortFromBytesLE(by2, by);
    }

    public static short shortFromReaderLE(Buffer buffer, long l) {
        return ByteConversions.shortFromBytesLE(buffer.readByte(0L + l), buffer.readByte(1L + l));
    }

    public static short shortFromReaderBE(Buffer buffer, long l) {
        return ByteConversions.shortFromBytesLE(buffer.readByte(1L + l), buffer.readByte(0L + l));
    }

    public static void shortToWriterLE(short s, Buffer buffer, long l) {
        buffer.writeByte(0L + l, (byte)(s & 0xFF));
        buffer.writeByte(1L + l, (byte)(s >> 8 & 0xFF));
    }

    public static void shortToWriterBE(short s, Buffer buffer, long l) {
        buffer.writeByte(1L + l, (byte)(s & 0xFF));
        buffer.writeByte(0L + l, (byte)(s >> 8 & 0xFF));
    }

    public static int intFromBytesLE(byte by, byte by2, byte by3, byte by4) {
        return by & 0xFF | (by2 & 0xFF) << 8 | (by3 & 0xFF) << 16 | (by4 & 0xFF) << 24;
    }

    public static int intFromBytesBE(byte by, byte by2, byte by3, byte by4) {
        return ByteConversions.intFromBytesLE(by4, by3, by2, by);
    }

    public static int intFromReaderLE(Buffer buffer, long l) {
        return ByteConversions.intFromBytesLE(buffer.readByte(0L + l), buffer.readByte(1L + l), buffer.readByte(2L + l), buffer.readByte(3L + l));
    }

    public static int intFromReaderBE(Buffer buffer, long l) {
        return ByteConversions.intFromBytesLE(buffer.readByte(3L + l), buffer.readByte(2L + l), buffer.readByte(1L + l), buffer.readByte(0L + l));
    }

    public static void intToWriterLE(int n, Buffer buffer, long l) {
        buffer.writeByte(0L + l, (byte)(n & 0xFF));
        buffer.writeByte(1L + l, (byte)(n >> 8 & 0xFF));
        buffer.writeByte(2L + l, (byte)(n >> 16 & 0xFF));
        buffer.writeByte(3L + l, (byte)(n >> 24 & 0xFF));
    }

    public static void intToWriterBE(int n, Buffer buffer, long l) {
        buffer.writeByte(3L + l, (byte)(n & 0xFF));
        buffer.writeByte(2L + l, (byte)(n >> 8 & 0xFF));
        buffer.writeByte(1L + l, (byte)(n >> 16 & 0xFF));
        buffer.writeByte(0L + l, (byte)(n >> 24 & 0xFF));
    }

    public static long longFromBytesLE(byte by, byte by2, byte by3, byte by4, byte by5, byte by6, byte by7, byte by8) {
        return (long)(by & 0xFF) | (long)(by2 & 0xFF) << 8 | (long)(by3 & 0xFF) << 16 | (long)(by4 & 0xFF) << 24 | (long)(by5 & 0xFF) << 32 | (long)(by6 & 0xFF) << 40 | (long)(by7 & 0xFF) << 48 | (long)(by8 & 0xFF) << 56;
    }

    public static long longFromBytesBE(byte by, byte by2, byte by3, byte by4, byte by5, byte by6, byte by7, byte by8) {
        return ByteConversions.longFromBytesLE(by8, by7, by6, by5, by4, by3, by2, by);
    }

    public static long longFromReaderLE(Buffer buffer, long l) {
        return ByteConversions.longFromBytesLE(buffer.readByte(0L + l), buffer.readByte(1L + l), buffer.readByte(2L + l), buffer.readByte(3L + l), buffer.readByte(4L + l), buffer.readByte(5L + l), buffer.readByte(6L + l), buffer.readByte(7L + l));
    }

    public static long longFromReaderBE(Buffer buffer, long l) {
        return ByteConversions.longFromBytesLE(buffer.readByte(7L + l), buffer.readByte(6L + l), buffer.readByte(5L + l), buffer.readByte(4L + l), buffer.readByte(3L + l), buffer.readByte(2L + l), buffer.readByte(1L + l), buffer.readByte(0L + l));
    }

    public static void longToWriterLE(long l, Buffer buffer, long l2) {
        buffer.writeByte(0L + l2, (byte)(l & 0xFFL));
        buffer.writeByte(1L + l2, (byte)(l >> 8 & 0xFFL));
        buffer.writeByte(2L + l2, (byte)(l >> 16 & 0xFFL));
        buffer.writeByte(3L + l2, (byte)(l >> 24 & 0xFFL));
        buffer.writeByte(4L + l2, (byte)(l >> 32 & 0xFFL));
        buffer.writeByte(5L + l2, (byte)(l >> 40 & 0xFFL));
        buffer.writeByte(6L + l2, (byte)(l >> 48 & 0xFFL));
        buffer.writeByte(7L + l2, (byte)(l >> 56 & 0xFFL));
    }

    public static void longToWriterBE(long l, Buffer buffer, long l2) {
        buffer.writeByte(7L + l2, (byte)(l & 0xFFL));
        buffer.writeByte(6L + l2, (byte)(l >> 8 & 0xFFL));
        buffer.writeByte(5L + l2, (byte)(l >> 16 & 0xFFL));
        buffer.writeByte(4L + l2, (byte)(l >> 24 & 0xFFL));
        buffer.writeByte(3L + l2, (byte)(l >> 32 & 0xFFL));
        buffer.writeByte(2L + l2, (byte)(l >> 40 & 0xFFL));
        buffer.writeByte(1L + l2, (byte)(l >> 48 & 0xFFL));
        buffer.writeByte(0L + l2, (byte)(l >> 56 & 0xFFL));
    }

    public static float floatFromBytesLE(byte by, byte by2, byte by3, byte by4) {
        return Float.intBitsToFloat(ByteConversions.intFromBytesLE(by, by2, by3, by4));
    }

    public static float floatFromBytesBE(byte by, byte by2, byte by3, byte by4) {
        return Float.intBitsToFloat(ByteConversions.intFromBytesBE(by, by2, by3, by4));
    }

    public static float floatFromReaderLE(Buffer buffer, long l) {
        return Float.intBitsToFloat(ByteConversions.intFromReaderLE(buffer, l));
    }

    public static float floatFromReaderBE(Buffer buffer, long l) {
        return Float.intBitsToFloat(ByteConversions.intFromReaderBE(buffer, l));
    }

    public static void floatToWriterLE(float f, Buffer buffer, long l) {
        ByteConversions.intToWriterLE(Float.floatToRawIntBits(f), buffer, l);
    }

    public static void floatToWriterBE(float f, Buffer buffer, long l) {
        ByteConversions.intToWriterBE(Float.floatToRawIntBits(f), buffer, l);
    }

    public static double doubleFromBytesLE(byte by, byte by2, byte by3, byte by4, byte by5, byte by6, byte by7, byte by8) {
        return Double.longBitsToDouble(ByteConversions.longFromBytesLE(by, by2, by3, by4, by5, by6, by7, by8));
    }

    public static double doubleFromBytesBE(byte by, byte by2, byte by3, byte by4, byte by5, byte by6, byte by7, byte by8) {
        return Double.longBitsToDouble(ByteConversions.longFromBytesBE(by, by2, by3, by4, by5, by6, by7, by8));
    }

    public static double doubleFromReaderLE(Buffer buffer, long l) {
        return Double.longBitsToDouble(ByteConversions.longFromReaderLE(buffer, l));
    }

    public static double doubleFromReaderBE(Buffer buffer, long l) {
        return Double.longBitsToDouble(ByteConversions.longFromReaderBE(buffer, l));
    }

    public static void doubleToWriterLE(double d, Buffer buffer, long l) {
        ByteConversions.longToWriterLE(Double.doubleToRawLongBits(d), buffer, l);
    }

    public static void doubleToWriterBE(double d, Buffer buffer, long l) {
        ByteConversions.longToWriterBE(Double.doubleToRawLongBits(d), buffer, l);
    }
}

