/*
 * Decompiled with CFR 0.152.
 */
package tech.v3.datatype;

import clojure.lang.RT;
import java.util.Arrays;
import java.util.function.BiFunction;

public final class Convolve1D {
    public static double[] correlate(BiFunction<Long, BiFunction<Long, Long, Object>, Object> biFunction, double[] dArray, final double[] dArray2, final int n, Mode mode, Edging edging) {
        int n2;
        int n3 = dArray.length;
        final int n4 = dArray2.length;
        int n5 = n4 - 1;
        switch (mode) {
            case Full: {
                n2 = (n3 + n5) / n;
                break;
            }
            case Same: {
                n2 = n3 / n;
                break;
            }
            case Valid: {
                n2 = (n3 - n4 + 1) / n;
                break;
            }
            default: {
                throw new RuntimeException("Unrecognized mode.");
            }
        }
        final double[] dArray3 = edging.apply(dArray, n4, mode);
        final double[] dArray4 = new double[n2];
        biFunction.apply(new Long(n2), new BiFunction<Long, Long, Object>(){

            @Override
            public Object apply(Long l, Long l2) {
                int n6 = RT.intCast((Object)l);
                int n2 = RT.intCast((Object)l2);
                int n3 = n6 + n2;
                for (int i = n6; i < n3; ++i) {
                    int n42 = i * n;
                    double d = 0.0;
                    for (int j = 0; j < n4; ++j) {
                        int n5 = n42 + j;
                        d += dArray3[n5] * dArray2[j];
                    }
                    dArray4[i] = d;
                }
                return null;
            }
        });
        return dArray4;
    }

    public static class Edging {
        public final EdgeMode mode;
        public final double constant;

        public Edging(EdgeMode edgeMode) {
            this(edgeMode, 0.0);
        }

        public Edging(EdgeMode edgeMode, double d) {
            this.mode = edgeMode;
            this.constant = d;
        }

        public double[] apply(double[] dArray, int n, Mode mode) {
            int n2;
            int n3 = n - 1;
            switch (mode) {
                case Full: {
                    n2 = n3 * 2;
                    break;
                }
                case Same: {
                    n2 = n % 2 == 0 ? n3 : n;
                    break;
                }
                case Valid: {
                    n2 = 0;
                    break;
                }
                default: {
                    throw new RuntimeException("Unrecognized mode.");
                }
            }
            return this.apply(dArray, dArray.length + n2);
        }

        public double[] apply(double[] dArray, int n) {
            int n2 = dArray.length;
            if (n2 == n) {
                return dArray;
            }
            int n3 = (n - n2) / 2;
            int n4 = n - n3 - n2;
            int n5 = Math.max(n3, n4);
            int n6 = n2 + n3;
            double[] dArray2 = new double[n];
            System.arraycopy(dArray, 0, dArray2, n3, n2);
            switch (this.mode) {
                case Constant: 
                case Zero: {
                    if (this.constant == 0.0) break;
                    Arrays.fill(dArray2, 0, n3, this.constant);
                    Arrays.fill(dArray2, n3 + n2, n - 1, this.constant);
                    break;
                }
                case Nearest: 
                case Clamp: {
                    double d = dArray[0];
                    double d2 = dArray[n2 - 1];
                    Arrays.fill(dArray2, 0, n3, d);
                    Arrays.fill(dArray2, n3 + n2, n - 1, d2);
                    break;
                }
                case Reflect: {
                    for (int i = 0; i < n5; ++i) {
                        int n7;
                        boolean bl = i / n2 % 2 == 0;
                        int n8 = i % n2;
                        if (!bl) {
                            n8 = n2 - n8 - 1;
                        }
                        if (i < n3) {
                            dArray2[n3 - i - 1] = dArray[n8];
                        }
                        if ((n7 = n6 + i) >= n) continue;
                        dArray2[n7] = dArray[n2 - n8 - 1];
                    }
                    break;
                }
                case Wrap: {
                    for (int i = 0; i < n5; ++i) {
                        int n9;
                        int n10 = i % n2;
                        if (i < n3) {
                            dArray2[n3 - i - 1] = dArray[n2 - n10 - 1];
                        }
                        if ((n9 = n6 + i) >= n) continue;
                        dArray2[n9] = dArray[n10];
                    }
                    break;
                }
            }
            return dArray2;
        }
    }

    public static enum EdgeMode {
        Clamp,
        Nearest,
        Reflect,
        Constant,
        Wrap,
        Zero;

    }

    public static enum Mode {
        Full,
        Same,
        Valid;

    }
}

