/*
 * Decompiled with CFR 0.152.
 */
package tech.v3.datatype;

import clojure.lang.RT;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import sun.misc.Unsafe;

public class UnsafeUtil {
    public static Unsafe unsafe = UnsafeUtil.getUnsafe();
    public static final long addressFieldOffset = UnsafeUtil.addressField();
    public static final Constructor<?> directBufferConstructor = UnsafeUtil.findDirectBufferConstructor();

    public static Unsafe getUnsafe() {
        try {
            Field field = Unsafe.class.getDeclaredField("theUnsafe");
            field.setAccessible(true);
            return (Unsafe)Unsafe.class.cast(field.get(null));
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new IllegalStateException("sun.misc.Unsafe is not available in this JVM");
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalStateException("sun.misc.Unsafe is not available in this JVM");
        }
    }

    public static String addrToString(long l, int n) {
        Unsafe unsafe = UnsafeUtil.getUnsafe();
        if (l == 0L || n == 0) {
            return "";
        }
        byte[] byArray = new byte[n];
        for (int i = 0; i < n; ++i) {
            byArray[i] = unsafe.getByte(l + (long)i);
        }
        return new String(byArray);
    }

    public static long addressField() {
        try {
            return UnsafeUtil.getUnsafe().objectFieldOffset(Buffer.class.getDeclaredField("address"));
        }
        catch (Throwable throwable) {
            return -1L;
        }
    }

    public static Constructor<?> findDirectBufferConstructor() {
        try {
            ByteBuffer byteBuffer = ByteBuffer.allocateDirect(1);
            Constructor<?> constructor = byteBuffer.getClass().getDeclaredConstructor(Long.TYPE, Integer.TYPE);
            constructor.setAccessible(true);
            return constructor;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static Object constructByteBufferFromAddress(long l, long l2) throws Exception {
        return directBufferConstructor.newInstance(l, RT.intCast((long)l2));
    }
}

