/*
 * Decompiled with CFR 0.152.
 */
package tech.v3.datatype;

import clojure.lang.IFn;
import clojure.lang.Keyword;
import clojure.lang.RT;
import ham_fisted.Casts;
import ham_fisted.ChunkedList;
import ham_fisted.IFnDef;
import ham_fisted.Reductions;
import ham_fisted.Transformables;
import java.util.List;
import tech.v3.datatype.Buffer;

public interface DoubleBuffer
extends Buffer {
    @Override
    default public Object elemwiseDatatype() {
        return Keyword.intern(null, (String)"float64");
    }

    default public boolean add(Object object) {
        this.addDouble(Casts.doubleCast((Object)object));
        return true;
    }

    @Override
    default public long readLong(long l) {
        return Casts.longCast((double)this.readDouble(l));
    }

    @Override
    default public Object readObject(long l) {
        return this.readDouble(l);
    }

    @Override
    default public void writeLong(long l, long l2) {
        this.writeDouble(l, l2);
    }

    @Override
    default public void writeObject(long l, Object object) {
        this.writeDouble(l, RT.doubleCast((Object)object));
    }

    @Override
    default public Buffer subBuffer(long l, long l2) {
        ChunkedList.sublistCheck((long)l, (long)l2, (long)this.lsize());
        if (l == 0L && l2 == this.lsize()) {
            return this;
        }
        return new DoubleSubBuffer(this, l, l2);
    }

    @Override
    default public void fillRange(final long l, List list) {
        if (list.isEmpty()) {
            return;
        }
        ChunkedList.checkIndexRange((long)0L, (long)this.lsize(), (long)l, (long)(l + (long)list.size()));
        Reductions.serialReduction((IFn)new Reductions.IndexedDoubleAccum((IFn.OLDO)new IFnDef.OLDO(){

            public Object invokePrim(Object object, long l2, double d) {
                ((Buffer)object).writeDouble(l2 + l, d);
                return object;
            }
        }), (Object)this, (Object)list);
    }

    @Override
    default public Object reduce(IFn iFn, Object object) {
        IFn.ODO oDO = Transformables.toDoubleReductionFn((Object)iFn);
        long l = this.lsize();
        for (long i = 0L; i < l && !RT.isReduced((Object)object); ++i) {
            object = oDO.invokePrim(object, this.readDouble(i));
        }
        return Reductions.unreduce((Object)object);
    }

    public static class DoubleSubBuffer
    extends Buffer.SubBuffer
    implements DoubleBuffer {
        public DoubleSubBuffer(DoubleBuffer doubleBuffer, long l, long l2) {
            super(doubleBuffer, l, l2);
        }

        @Override
        public void fillRange(long l, List list) {
            DoubleBuffer.super.fillRange(l + this.sidx, list);
        }

        @Override
        public Object reduce(IFn iFn, Object object) {
            return DoubleBuffer.super.reduce(iFn, object);
        }
    }
}

