/*
 * Decompiled with CFR 0.152.
 */
package tech.v3.datatype;

import clojure.lang.IDeref;
import clojure.lang.IFn;
import clojure.lang.IPersistentMap;
import clojure.lang.Keyword;
import clojure.lang.RT;
import clojure.lang.Util;
import ham_fisted.Casts;
import ham_fisted.ChunkedList;
import ham_fisted.IFnDef;
import ham_fisted.IMutList;
import ham_fisted.ParallelOptions;
import ham_fisted.Reductions;
import java.util.Iterator;
import java.util.List;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.DoubleConsumer;
import java.util.function.LongConsumer;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import tech.v3.datatype.BufferIter;
import tech.v3.datatype.DatatypeBase;

public interface Buffer
extends DatatypeBase,
IMutList<Object> {
    default public byte readByte(long l) {
        return RT.byteCast((long)this.readLong(l));
    }

    default public long readLong(long l) {
        return Casts.longCast((Object)this.readObject(l));
    }

    default public double readDouble(long l) {
        return Casts.doubleCast((Object)this.readObject(l));
    }

    public Object readObject(long var1);

    default public void writeByte(long l, byte by) {
        this.writeLong(l, by);
    }

    default public void writeLong(long l, long l2) {
        this.writeObject(l, l2);
    }

    default public void writeDouble(long l, double d) {
        this.writeDouble(l, d);
    }

    default public void writeObject(long l, Object object) {
        throw new RuntimeException("Unimplemented");
    }

    default public Buffer subBuffer(long l, long l2) {
        ChunkedList.sublistCheck((long)l, (long)l2, (long)this.lsize());
        if (l == 0L && l2 == this.lsize()) {
            return this;
        }
        return new SubBuffer(this, l, l2);
    }

    default public void accumPlusLong(long l, long l2) {
        this.writeLong(l, this.readLong(l) + l2);
    }

    default public void accumPlusDouble(long l, double d) {
        this.writeDouble(l, this.readDouble(l) + d);
    }

    default public void accPlusLong(int n, long l) {
        this.accumPlusLong(n, l);
    }

    default public void accPlusDouble(int n, double d) {
        this.accumPlusDouble(n, d);
    }

    default public boolean allowsRead() {
        return true;
    }

    default public boolean allowsWrite() {
        return false;
    }

    @Override
    default public Object elemwiseDatatype() {
        return Keyword.intern(null, (String)"object");
    }

    default public int size() {
        return RT.intCast((long)this.lsize());
    }

    @Override
    default public int count() {
        return this.size();
    }

    default public Object get(int n) {
        return this.readObject(n);
    }

    default public Object set(int n, Object object) {
        Object object2 = this.get(n);
        this.writeObject(n, object);
        return object2;
    }

    default public long getLong(int n) {
        return this.readLong(n);
    }

    default public double getDouble(int n) {
        return this.readDouble(n);
    }

    default public void setLong(int n, long l) {
        this.writeLong(n, l);
    }

    default public void setDouble(int n, double d) {
        this.writeDouble(n, d);
    }

    default public Iterator<Object> iterator() {
        return new BufferIter(this);
    }

    default public Object reduce(IFn iFn) {
        long l = this.lsize();
        if (l == 0L) {
            return iFn.invoke();
        }
        Object object = this.get(0);
        for (long i = 1L; i < l && !RT.isReduced((Object)object); ++i) {
            object = iFn.invoke(object, this.readObject(i));
        }
        if (RT.isReduced((Object)object)) {
            return ((IDeref)object).deref();
        }
        return object;
    }

    default public Object reduce(IFn iFn, Object object) {
        long l = this.lsize();
        if (iFn instanceof IFn.OLO) {
            IFn.OLO oLO = (IFn.OLO)iFn;
            for (long i = 0L; i < l && !RT.isReduced((Object)object); ++i) {
                object = oLO.invokePrim(object, this.readLong(i));
            }
        } else if (iFn instanceof IFn.ODO) {
            IFn.ODO oDO = (IFn.ODO)iFn;
            for (long i = 0L; i < l && !RT.isReduced((Object)object); ++i) {
                object = oDO.invokePrim(object, this.readDouble(i));
            }
        } else {
            for (long i = 0L; i < l && !RT.isReduced((Object)object); ++i) {
                object = iFn.invoke(object, this.readObject(i));
            }
        }
        return object;
    }

    default public Object kvreduce(IFn iFn, Object object) {
        long l = this.lsize();
        for (long i = 0L; i < l && !RT.isReduced((Object)object); ++i) {
            object = iFn.invoke(object, (Object)i, this.readObject(i));
        }
        if (RT.isReduced((Object)object)) {
            return ((IDeref)object).deref();
        }
        return object;
    }

    default public void fillRange(long l, long l2, Object object) {
        ChunkedList.checkIndexRange((long)0L, (long)this.lsize(), (long)l, (long)l2);
        while (l < l2) {
            this.writeObject(l, object);
            ++l;
        }
    }

    default public void fillRange(final long l, List list) {
        if (list.isEmpty()) {
            return;
        }
        ChunkedList.checkIndexRange((long)0L, (long)this.lsize(), (long)l, (long)(l + (long)list.size()));
        Reductions.serialReduction((IFn)new Reductions.IndexedAccum((IFn.OLOO)new IFnDef.OLOO(){

            public Object invokePrim(Object object, long l2, Object object2) {
                ((Buffer)object).writeObject(l2 + l, object2);
                return object;
            }
        }), (Object)this, (Object)list);
    }

    default public Object parallelReduction(final IFn iFn, final IFn iFn2, IFn iFn3, ParallelOptions parallelOptions) {
        return Reductions.parallelIndexGroupReduce((IFn)new IFnDef.LLO(){

            public Object invokePrim(long l, long l2) {
                return Reductions.serialReduction((IFn)iFn2, (Object)iFn.invoke(), (Object)Buffer.this.subBuffer(l, l2));
            }
        }, (long)this.lsize(), (IFn)iFn3, (ParallelOptions)parallelOptions);
    }

    default public Object nth(int n) {
        long l = n;
        if (l < 0L) {
            l += this.lsize();
        }
        return this.readObject(l);
    }

    default public Object nth(int n, Object object) {
        long l = n;
        long l2 = this.lsize();
        if (l < 0L) {
            l += l2;
        }
        if (l >= 0L && l < l2) {
            return this.readObject(l);
        }
        return object;
    }

    default public Object invoke(Object object) {
        long l = Casts.longCast((Object)object);
        if (l < 0L) {
            l += this.lsize();
        }
        return this.readObject(l);
    }

    default public Object invoke(Object object, Object object2) {
        if (Util.isInteger((Object)object)) {
            long l = Casts.longCast((Object)object);
            long l2 = this.lsize();
            if (l < 0L) {
                l += l2;
            }
            if (l >= 0L && l < l2) {
                return this.readObject(l);
            }
        }
        return object2;
    }

    default public Spliterator<Object> spliterator() {
        return new BufferSpliterator(this);
    }

    default public LongStream indexStream(boolean bl) {
        LongStream longStream = LongStream.range(0L, this.lsize());
        return bl ? longStream.parallel() : longStream;
    }

    default public Stream objStream(boolean bl) {
        return this.indexStream(bl).mapToObj(l -> this.readObject(l));
    }

    default public DoubleStream doubleStream(boolean bl) {
        return this.indexStream(bl).mapToDouble(l -> this.readDouble(l));
    }

    default public LongStream longStream(boolean bl) {
        return this.indexStream(bl).map(l -> this.readLong(l));
    }

    default public IntStream intStream(boolean bl) {
        return this.indexStream(bl).mapToInt(l -> RT.intCast((long)this.readLong(l)));
    }

    public static class SubBuffer
    implements Buffer {
        public final Buffer list;
        public final long sidx;
        public final long eidx;
        public final long nElems;

        public SubBuffer(Buffer buffer, long l, long l2) {
            this.list = buffer;
            this.sidx = l;
            this.eidx = l2;
            this.nElems = l2 - l;
        }

        @Override
        public boolean allowsRead() {
            return this.list.allowsRead();
        }

        @Override
        public boolean allowsWrite() {
            return this.list.allowsWrite();
        }

        @Override
        public Object elemwiseDatatype() {
            return this.list.elemwiseDatatype();
        }

        @Override
        public long lsize() {
            return this.nElems;
        }

        @Override
        public byte readByte(long l) {
            return this.list.readByte(l + this.sidx);
        }

        @Override
        public long readLong(long l) {
            return this.list.readLong(l + this.sidx);
        }

        @Override
        public double readDouble(long l) {
            return this.list.readDouble(l + this.sidx);
        }

        @Override
        public Object readObject(long l) {
            return this.list.readObject(l + this.sidx);
        }

        @Override
        public void writeByte(long l, byte by) {
            this.list.writeByte(l + this.sidx, by);
        }

        @Override
        public void writeLong(long l, long l2) {
            this.list.writeLong(l + this.sidx, l2);
        }

        @Override
        public void writeDouble(long l, double d) {
            this.list.writeDouble(l + this.sidx, d);
        }

        @Override
        public void writeObject(long l, Object object) {
            this.list.writeObject(l + this.sidx, object);
        }

        @Override
        public void accumPlusLong(long l, long l2) {
            this.list.accumPlusLong(l + this.sidx, l2);
        }

        @Override
        public void accumPlusDouble(long l, double d) {
            this.list.accumPlusDouble(l + this.sidx, d);
        }

        @Override
        public Buffer subBuffer(long l, long l2) {
            ChunkedList.sublistCheck((long)l, (long)l2, (long)this.lsize());
            if (l == 0L && l2 == this.lsize()) {
                return this;
            }
            return this.list.subBuffer(this.sidx + l, this.sidx + l2);
        }

        public IMutList<Object> subList(int n, int n2) {
            return this.subBuffer(n, n2);
        }

        @Override
        public Object reduce(IFn iFn, Object object) {
            Buffer buffer = this.list;
            long l = this.eidx;
            if (iFn instanceof IFn.OLO) {
                IFn.OLO oLO = (IFn.OLO)iFn;
                for (long i = this.sidx; i < l && !RT.isReduced((Object)object); ++i) {
                    object = oLO.invokePrim(object, buffer.readLong(i));
                }
            } else if (iFn instanceof IFn.ODO) {
                IFn.ODO oDO = (IFn.ODO)iFn;
                for (long i = this.sidx; i < l && !RT.isReduced((Object)object); ++i) {
                    object = oDO.invokePrim(object, buffer.readDouble(i));
                }
            } else {
                for (long i = this.sidx; i < l && !RT.isReduced((Object)object); ++i) {
                    object = iFn.invoke(object, buffer.readObject(i));
                }
            }
            return Reductions.unreduce((Object)object);
        }

        public Buffer withMeta(IPersistentMap iPersistentMap) {
            return ((Buffer)this.list.withMeta(iPersistentMap)).subBuffer(this.sidx, this.eidx);
        }

        public IPersistentMap meta() {
            return this.list.meta();
        }
    }

    public static class BufferSpliterator
    implements Spliterator<Object> {
        private final Buffer list;
        private final long sidx;
        private long eidx;
        long curIdx;

        BufferSpliterator(Buffer buffer, long l, long l2) {
            this.list = buffer;
            this.sidx = l;
            this.eidx = l2;
            this.curIdx = l;
        }

        BufferSpliterator(Buffer buffer) {
            this(buffer, 0L, buffer.lsize());
        }

        @Override
        public Spliterator<Object> trySplit() {
            long l = (this.eidx - this.sidx) / 2L;
            BufferSpliterator bufferSpliterator = new BufferSpliterator(this.list, l, this.eidx);
            this.eidx = l;
            return bufferSpliterator;
        }

        @Override
        public long estimateSize() {
            return this.eidx - this.sidx;
        }

        @Override
        public boolean tryAdvance(Consumer consumer) {
            boolean bl;
            if (consumer == null) {
                throw new NullPointerException();
            }
            boolean bl2 = bl = this.curIdx < this.eidx;
            if (bl) {
                consumer.accept(this.list.readObject(this.curIdx));
                ++this.curIdx;
            }
            return bl;
        }

        @Override
        public void forEachRemaining(Consumer consumer) {
            long l = this.eidx;
            Buffer buffer = this.list;
            if (consumer instanceof DoubleConsumer) {
                DoubleConsumer doubleConsumer = (DoubleConsumer)((Object)consumer);
                for (long i = this.curIdx; i < l; ++i) {
                    doubleConsumer.accept(buffer.readDouble(i));
                }
                this.curIdx = this.eidx;
                return;
            }
            if (consumer instanceof LongConsumer) {
                LongConsumer longConsumer = (LongConsumer)((Object)consumer);
                for (long i = this.curIdx; i < l; ++i) {
                    longConsumer.accept(buffer.readLong(i));
                }
                this.curIdx = this.eidx;
                return;
            }
            for (long i = this.curIdx; i < l; ++i) {
                consumer.accept(buffer.readObject(i));
            }
            this.curIdx = this.eidx;
        }

        @Override
        public int characteristics() {
            return 17488;
        }
    }

    public static class CopyingReducer
    implements Buffer {
        public final Buffer src;
        public final Buffer dst;

        public CopyingReducer(Buffer buffer, Buffer buffer2) {
            this.src = buffer;
            this.dst = buffer2;
        }

        @Override
        public Object readObject(long l) {
            return this.src.readObject(l);
        }

        @Override
        public long lsize() {
            return this.src.lsize();
        }

        @Override
        public Buffer subBuffer(long l, long l2) {
            return new CopyingReducer(this.src.subBuffer(l, l2), this.dst.subBuffer(l, l2));
        }

        @Override
        public Object parallelReduction(final IFn iFn, IFn iFn2, IFn iFn3, ParallelOptions parallelOptions) {
            return Reductions.parallelIndexGroupReduce((IFn)new IFnDef.LLO(){

                public Object invokePrim(long l, long l2) {
                    dst.fillRange(l, (List)((Object)src.subBuffer(l, l2)));
                    return iFn.invoke();
                }
            }, (long)this.lsize(), (IFn)iFn3, (ParallelOptions)parallelOptions);
        }

        @Override
        public Object reduce(IFn iFn, Object object) {
            this.dst.fillRange(0L, (List)((Object)this.src));
            return object;
        }
    }
}

