/*
 * Decompiled with CFR 0.152.
 */
package tech.v3.datatype;

import clojure.lang.IFn;
import clojure.lang.IPersistentMap;
import clojure.lang.Keyword;
import clojure.lang.RT;
import ham_fisted.ArrayLists;
import ham_fisted.ArraySection;
import ham_fisted.Casts;
import ham_fisted.ChunkedList;
import java.util.Arrays;
import tech.v3.datatype.Buffer;
import tech.v3.datatype.LongBuffer;
import tech.v3.datatype.NumericConversions;

public class UByteSubBuffer
implements LongBuffer,
ArrayLists.ArrayOwner {
    final byte[] data;
    final int sidx;
    final int eidx;
    final int nElems;
    final IPersistentMap meta;

    public UByteSubBuffer(byte[] byArray, int n, int n2, IPersistentMap iPersistentMap) {
        this.data = byArray;
        this.sidx = n;
        this.eidx = n2;
        this.nElems = n2 - n;
        this.meta = iPersistentMap;
    }

    public Keyword elemwiseDatatype() {
        return Keyword.intern(null, (String)"uint8");
    }

    public Buffer cloneList() {
        return new UByteSubBuffer((byte[])this.copyOf(this.nElems), 0, this.nElems, this.meta);
    }

    public IPersistentMap meta() {
        return this.meta;
    }

    public Buffer withMeta(IPersistentMap iPersistentMap) {
        return new UByteSubBuffer(this.data, this.sidx, this.eidx, iPersistentMap);
    }

    @Override
    public boolean allowsRead() {
        return true;
    }

    @Override
    public boolean allowsWrite() {
        return true;
    }

    @Override
    public long lsize() {
        return this.nElems;
    }

    public boolean equals(Object object) {
        return this.equiv(object);
    }

    public int hashCode() {
        return this.hasheq();
    }

    @Override
    public Buffer subBuffer(long l, long l2) {
        ChunkedList.sublistCheck((long)l, (long)l2, (long)this.nElems);
        return new UByteSubBuffer(this.data, this.sidx + (int)l, this.sidx + (int)l2, this.meta);
    }

    public ArraySection getArraySection() {
        return new ArraySection((Object)this.data, this.sidx, this.eidx);
    }

    @Override
    public long readLong(long l) {
        return Byte.toUnsignedInt(this.data[ChunkedList.indexCheck((int)this.sidx, (int)this.nElems, (int)((int)l))]);
    }

    @Override
    public void writeLong(long l, long l2) {
        this.data[ChunkedList.indexCheck((int)this.sidx, (int)this.nElems, (int)((int)l))] = NumericConversions.ubyteHostCast(l2);
    }

    public Object longReduction(IFn.OLO oLO, Object object) {
        int n = this.nElems;
        for (int i = 0; i < n && !RT.isReduced((Object)object); ++i) {
            object = oLO.invokePrim(object, (long)Byte.toUnsignedInt(this.data[i + this.sidx]));
        }
        return object;
    }

    public Object copyOf(int n) {
        return Arrays.copyOfRange(this.data, this.sidx, this.sidx + n);
    }

    public Object copyOfRange(int n, int n2) {
        return Arrays.copyOfRange(this.data, this.sidx + n, this.sidx + n2);
    }

    public void fill(int n, int n2, Object object) {
        byte by = NumericConversions.ubyteHostCast(Casts.longCast((Object)object));
        Arrays.fill(this.data, this.sidx + n, this.sidx + n2, by);
    }
}

