/*
 * Decompiled with CFR 0.152.
 */
package tech.v3.datatype;

import clojure.lang.IDeref;
import clojure.lang.Keyword;
import clojure.lang.PersistentArrayMap;
import ham_fisted.Reducible;
import ham_fisted.Sum;
import java.util.function.DoubleConsumer;

public class DoubleConsumers {

    public static class Moments
    implements Reducible,
    DoubleConsumer,
    IDeref {
        public static final Keyword m2Kwd = Keyword.intern(null, (String)"moment-2");
        public static final Keyword m3Kwd = Keyword.intern(null, (String)"moment-3");
        public static final Keyword m4Kwd = Keyword.intern(null, (String)"moment-4");
        public final double mean;
        public double m2;
        public double m3;
        public double m4;
        public long nElems;

        public Moments(double d) {
            this.mean = d;
            this.m2 = 0.0;
            this.m3 = 0.0;
            this.m4 = 0.0;
            this.nElems = 0L;
        }

        @Override
        public void accept(double d) {
            double d2 = d - this.mean;
            double d3 = d2 * d2;
            this.m2 += d3;
            double d4 = d3 * d2;
            this.m3 += d4;
            double d5 = d4 * d2;
            this.m4 += d5;
            ++this.nElems;
        }

        public Reducible reduce(Reducible reducible) {
            Moments moments = (Moments)reducible;
            Moments moments2 = new Moments(this.mean);
            moments2.m2 = this.m2 + moments.m2;
            moments2.m3 = this.m3 + moments.m3;
            moments2.m4 = this.m4 + moments.m4;
            moments2.nElems = this.nElems + moments.nElems;
            return moments2;
        }

        public Object deref() {
            return new PersistentArrayMap(new Object[]{m2Kwd, this.m2, m3Kwd, this.m3, m4Kwd, this.m4, Sum.nElemsKwd, this.nElems});
        }
    }

    public static final class MinMaxSum
    implements Reducible,
    DoubleConsumer,
    IDeref {
        public static final Keyword minKwd = Keyword.intern(null, (String)"min");
        public static final Keyword maxKwd = Keyword.intern(null, (String)"max");
        public Sum sum;
        public double min;
        public double max;

        public MinMaxSum(Sum sum, double d, double d2) {
            this.sum = sum;
            this.max = d2;
            this.min = d;
        }

        public MinMaxSum() {
            this(new Sum(), Double.MAX_VALUE, -1.7976931348623157E308);
        }

        @Override
        public void accept(double d) {
            this.sum.accept(d);
            this.min = Math.min(d, this.min);
            this.max = Math.max(d, this.max);
        }

        double getMin() {
            if (this.sum.nElems == 0L) {
                return Double.NaN;
            }
            return this.min;
        }

        double getMax() {
            if (this.sum.nElems == 0L) {
                return Double.NaN;
            }
            return this.max;
        }

        public Reducible reduce(Reducible reducible) {
            MinMaxSum minMaxSum = (MinMaxSum)reducible;
            if (this.sum.nElems == 0L) {
                return reducible;
            }
            if (minMaxSum.sum.nElems == 0L) {
                return this;
            }
            return new MinMaxSum(this.sum.reduce((Reducible)minMaxSum.sum), Math.min(this.getMin(), minMaxSum.getMin()), Math.max(this.getMax(), minMaxSum.getMax()));
        }

        public Object deref() {
            Object[] objectArray = new Object[8];
            objectArray[0] = Sum.sumKwd;
            objectArray[1] = this.sum.computeFinalSum();
            objectArray[2] = Sum.nElemsKwd;
            objectArray[3] = this.sum.nElems;
            objectArray[4] = minKwd;
            objectArray[5] = this.getMin();
            objectArray[6] = maxKwd;
            objectArray[7] = this.getMax();
            return new PersistentArrayMap(objectArray);
        }
    }
}

