/*
 * Decompiled with CFR 0.152.
 */
package tech.v3.datatype;

import clojure.lang.IFn;
import clojure.lang.RT;
import tech.v3.datatype.Buffer;

public class VariableRollingIterBase {
    long startIdx = 0L;
    long targetIdx = 0L;
    long endIdx = 0L;
    public final Buffer data;
    public final long nElems;
    public final double stepsize;
    public final double window;
    public final IFn compFn;

    public VariableRollingIterBase(Buffer buffer, double d, double d2, IFn iFn) {
        this.data = buffer;
        this.nElems = buffer.lsize();
        this.stepsize = d;
        this.window = d2;
        this.compFn = iFn;
    }

    public long getStartIdx() {
        return this.startIdx;
    }

    public long getTargetIdx() {
        return this.targetIdx;
    }

    public long getEndIdx() {
        return this.endIdx;
    }

    public long getRangeLength() {
        return this.endIdx - this.startIdx;
    }

    public void setEndToTarget() {
        this.endIdx = this.targetIdx + 1L;
    }

    public void setStartToTarget() {
        this.startIdx = this.targetIdx;
    }

    public void incrementStart() {
        Object object = this.data.readObject(this.targetIdx);
        while (this.startIdx < this.targetIdx && RT.uncheckedDoubleCast((Object)this.compFn.invoke(object, this.data.readObject(this.startIdx))) >= this.window) {
            ++this.startIdx;
        }
    }

    public void incrementEnd() {
        Object object = this.data.readObject(this.targetIdx);
        while (this.endIdx < this.nElems && RT.uncheckedDoubleCast((Object)this.compFn.invoke(this.data.readObject(this.endIdx), object)) < this.window) {
            ++this.endIdx;
        }
    }

    public void incrementTarget() {
        if (this.stepsize == 0.0) {
            ++this.targetIdx;
        } else {
            Object object = this.data.readObject(this.targetIdx);
            while (this.targetIdx < this.nElems && RT.uncheckedDoubleCast((Object)this.compFn.invoke(this.data.readObject(this.targetIdx), object)) < this.stepsize) {
                ++this.targetIdx;
            }
        }
    }

    public boolean hasNext() {
        return this.targetIdx < this.nElems;
    }
}

