/*
 * Decompiled with CFR 0.152.
 */
package tech.v3.datatype;

import clojure.lang.IFn;
import tech.v3.Clj;
import tech.v3.DType;
import tech.v3.datatype.Buffer;
import tech.v3.datatype.ObjectReader;

public class VecMath {
    static final IFn booleansToIndexesFn = Clj.requiringResolve("tech.v3.datatype.unary-pred", "bool-reader->indexes");
    static final IFn addFn = Clj.requiringResolve("tech.v3.datatype.functional", "+");
    static final IFn subFn = Clj.requiringResolve("tech.v3.datatype.functional", "-");
    static final IFn mulFn = Clj.requiringResolve("tech.v3.datatype.functional", "*");
    static final IFn divFn = Clj.requiringResolve("tech.v3.datatype.functional", "/");
    static final IFn sqFn = Clj.requiringResolve("tech.v3.datatype.functional", "sq");
    static final IFn sqrtFn = Clj.requiringResolve("tech.v3.datatype.functional", "sqrt");
    static final IFn cbrtFn = Clj.requiringResolve("tech.v3.datatype.functional", "cbrt");
    static final IFn absFn = Clj.requiringResolve("tech.v3.datatype.functional", "abs");
    static final IFn powFn = Clj.requiringResolve("tech.v3.datatype.functional", "pow");
    static final IFn quotFn = Clj.requiringResolve("tech.v3.datatype.functional", "quot");
    static final IFn remFn = Clj.requiringResolve("tech.v3.datatype.functional", "rem");
    static final IFn cosFn = Clj.requiringResolve("tech.v3.datatype.functional", "cos");
    static final IFn coshFn = Clj.requiringResolve("tech.v3.datatype.functional", "cosh");
    static final IFn acosFn = Clj.requiringResolve("tech.v3.datatype.functional", "acos");
    static final IFn sinFn = Clj.requiringResolve("tech.v3.datatype.functional", "sin");
    static final IFn sinhFn = Clj.requiringResolve("tech.v3.datatype.functional", "sinh");
    static final IFn asinFn = Clj.requiringResolve("tech.v3.datatype.functional", "asin");
    static final IFn tanFn = Clj.requiringResolve("tech.v3.datatype.functional", "tan");
    static final IFn tanhFn = Clj.requiringResolve("tech.v3.datatype.functional", "tanh");
    static final IFn atanFn = Clj.requiringResolve("tech.v3.datatype.functional", "atan");
    static final IFn hypotFn = Clj.requiringResolve("tech.v3.datatype.functional", "hypot");
    static final IFn toRadFn = Clj.requiringResolve("tech.v3.datatype.functional", "to-radians");
    static final IFn toDegFn = Clj.requiringResolve("tech.v3.datatype.functional", "to-degrees");
    static final IFn finiteFn = Clj.requiringResolve("tech.v3.datatype.functional", "finite?");
    static final IFn infiniteFn = Clj.requiringResolve("tech.v3.datatype.functional", "infinite?");
    static final IFn nanFn = Clj.requiringResolve("tech.v3.datatype.functional", "nan?");
    static final IFn ceilFn = Clj.requiringResolve("tech.v3.datatype.functional", "ceil");
    static final IFn floorFn = Clj.requiringResolve("tech.v3.datatype.functional", "floor");
    static final IFn significandFn = Clj.requiringResolve("tech.v3.datatype.functional", "get-significand");
    static final IFn ieeeRemainderFn = Clj.requiringResolve("tech.v3.datatype.functional", "ieee-remainder");
    static final IFn mathematicalIntegerFn = Clj.requiringResolve("tech.v3.datatype.functional", "mathematical-integer?");
    static final IFn roundFn = Clj.requiringResolve("tech.v3.datatype.functional", "round");
    static final IFn ltFn = Clj.requiringResolve("tech.v3.datatype.functional", "<");
    static final IFn lteFn = Clj.requiringResolve("tech.v3.datatype.functional", "<=");
    static final IFn gtFn = Clj.requiringResolve("tech.v3.datatype.functional", ">");
    static final IFn gteFn = Clj.requiringResolve("tech.v3.datatype.functional", ">=");
    static final IFn eqFn = Clj.requiringResolve("tech.v3.datatype.functional", "eq");
    static final IFn notEqFn = Clj.requiringResolve("tech.v3.datatype.functional", "not-eq");
    static final IFn notFn = Clj.requiringResolve("tech.v3.datatype.functional", "not");
    static final IFn maxFn = Clj.requiringResolve("tech.v3.datatype.functional", "max");
    static final IFn reduceMaxFn = Clj.requiringResolve("tech.v3.datatype.functional", "reduce-max");
    static final IFn minFn = Clj.requiringResolve("tech.v3.datatype.functional", "min");
    static final IFn reduceMinFn = Clj.requiringResolve("tech.v3.datatype.functional", "reduce-min");
    static final IFn expFn = Clj.requiringResolve("tech.v3.datatype.functional", "exp");
    static final IFn expm1Fn = Clj.requiringResolve("tech.v3.datatype.functional", "expm1");
    static final IFn logFn = Clj.requiringResolve("tech.v3.datatype.functional", "log");
    static final IFn log1pFn = Clj.requiringResolve("tech.v3.datatype.functional", "log1p");
    static final IFn logisticFn = Clj.requiringResolve("tech.v3.datatype.functional", "logistic");
    static final IFn sumFn = Clj.requiringResolve("tech.v3.datatype.functional", "sum");
    static final IFn sumFastFn = Clj.requiringResolve("tech.v3.datatype.functional", "sum-fast");
    static final IFn meanFn = Clj.requiringResolve("tech.v3.datatype.functional", "sum");
    static final IFn meanFastFn = Clj.requiringResolve("tech.v3.datatype.functional", "mean-fast");
    static final IFn distanceFn = Clj.requiringResolve("tech.v3.datatype.functional", "distance");
    static final IFn distanceSqFn = Clj.requiringResolve("tech.v3.datatype.functional", "distance-squared");
    static final IFn magnitudeFn = Clj.requiringResolve("tech.v3.datatype.functional", "magnitude");
    static final IFn magnitudeSqFn = Clj.requiringResolve("tech.v3.datatype.functional", "magnitude-squared");
    static final IFn dotProdFn = Clj.requiringResolve("tech.v3.datatype.functional", "dot-product");
    static final IFn cumminFn = Clj.requiringResolve("tech.v3.datatype.functional", "cummin");
    static final IFn cummaxFn = Clj.requiringResolve("tech.v3.datatype.functional", "cummax");
    static final IFn cumsumFn = Clj.requiringResolve("tech.v3.datatype.functional", "cumsum");
    static final IFn cumprodFn = Clj.requiringResolve("tech.v3.datatype.functional", "cumprod");
    static final IFn equalsFn = Clj.requiringResolve("tech.v3.datatype.functional", "equals");

    private VecMath() {
    }

    public static Object booleansToIndexes(Object object) {
        return Clj.call(booleansToIndexesFn, object);
    }

    public static Object indexesWhere(Object object, Object object2) {
        final Buffer buffer = DType.toBuffer(object);
        Buffer buffer2 = null;
        if (object2 instanceof IFn) {
            final IFn iFn = (IFn)object2;
            buffer2 = new ObjectReader(){

                @Override
                public long lsize() {
                    return buffer.lsize();
                }

                @Override
                public Object readObject(long l) {
                    return DType.boolCast(iFn.invoke(buffer.readObject(l)));
                }
            };
        } else {
            buffer2 = DType.toBuffer(object2);
            if (buffer.lsize() != buffer2.lsize()) {
                throw new RuntimeException("Input/booleanvec size mismatch: expected " + String.valueOf(buffer.lsize()) + ", got " + String.valueOf(buffer2.lsize()));
            }
        }
        return VecMath.booleansToIndexes(buffer2);
    }

    public static Buffer where(Object object, Object object2) {
        return DType.indexedBuffer(VecMath.indexesWhere(object, object2), object);
    }

    public static Object add(Object object, Object object2) {
        return Clj.call(addFn, object, object2);
    }

    public static Object neg(Object object) {
        return Clj.call(subFn, object);
    }

    public static Object sub(Object object, Object object2) {
        return Clj.call(subFn, object, object2);
    }

    public static Object mul(Object object, Object object2) {
        return Clj.call(mulFn, object, object2);
    }

    public static Object div(Object object, Object object2) {
        return Clj.call(divFn, object, object2);
    }

    public static Object sq(Object object) {
        return Clj.call(sqFn, object);
    }

    public static Object sqrt(Object object) {
        return Clj.call(sqrtFn, object);
    }

    public static Object cbrt(Object object) {
        return Clj.call(cbrtFn, object);
    }

    public static Object abs(Object object) {
        return Clj.call(absFn, object);
    }

    public static Object pow(Object object) {
        return Clj.call(powFn, object);
    }

    public static Object quot(Object object) {
        return Clj.call(quotFn, object);
    }

    public static Object rem(Object object) {
        return Clj.call(remFn, object);
    }

    public static Object cos(Object object) {
        return Clj.call(cosFn, object);
    }

    public static Object acos(Object object) {
        return Clj.call(acosFn, object);
    }

    public static Object cosh(Object object) {
        return Clj.call(coshFn, object);
    }

    public static Object sin(Object object) {
        return Clj.call(sinFn, object);
    }

    public static Object asin(Object object) {
        return Clj.call(asinFn, object);
    }

    public static Object sinh(Object object) {
        return Clj.call(sinhFn, object);
    }

    public static Object tan(Object object) {
        return Clj.call(tanFn, object);
    }

    public static Object atan(Object object) {
        return Clj.call(atanFn, object);
    }

    public static Object tanh(Object object) {
        return Clj.call(tanhFn, object);
    }

    public static Object toRadians(Object object) {
        return Clj.call(toRadFn, object);
    }

    public static Object toDegrees(Object object) {
        return Clj.call(toDegFn, object);
    }

    public static Object isFinite(Object object) {
        return Clj.call(finiteFn, object);
    }

    public static Object isInfinite(Object object) {
        return Clj.call(infiniteFn, object);
    }

    public static Object isNan(Object object) {
        return Clj.call(nanFn, object);
    }

    public static Object ceil(Object object) {
        return Clj.call(ceilFn, object);
    }

    public static Object floor(Object object) {
        return Clj.call(floorFn, object);
    }

    public static Object round(Object object) {
        return Clj.call(roundFn, object);
    }

    public static Object significand(Object object) {
        return Clj.call(significandFn, object);
    }

    public static Object IEEERemainder(Object object) {
        return Clj.call(ieeeRemainderFn, object);
    }

    public static Object isMathematicalInteger(Object object) {
        return Clj.call(mathematicalIntegerFn, object);
    }

    public static Object lessThan(Object object, Object object2) {
        return Clj.call(ltFn, object, object2);
    }

    public static Object lessThan(Object object, Object object2, Object object3) {
        return Clj.call(ltFn, object, object2, object3);
    }

    public static Object lessThanOrEq(Object object, Object object2) {
        return Clj.call(lteFn, object, object2);
    }

    public static Object lessThanOrEq(Object object, Object object2, Object object3) {
        return Clj.call(lteFn, object, object2, object3);
    }

    public static Object greaterThan(Object object, Object object2) {
        return Clj.call(ltFn, object, object2);
    }

    public static Object greaterThan(Object object, Object object2, Object object3) {
        return Clj.call(ltFn, object, object2, object3);
    }

    public static Object greaterThanOrEq(Object object, Object object2) {
        return Clj.call(lteFn, object, object2);
    }

    public static Object greaterThanOrEq(Object object, Object object2, Object object3) {
        return Clj.call(lteFn, object, object2, object3);
    }

    public static Object eq(Object object, Object object2) {
        return Clj.call(eqFn, object, object2);
    }

    public static Object notEq(Object object, Object object2) {
        return Clj.call(notEqFn, object, object2);
    }

    public static Object not(Object object) {
        return Clj.call(notFn, object);
    }

    public static Object max(Object object, Object object2) {
        return Clj.call(maxFn, object, object2);
    }

    public static Object reduceMax(Object object) {
        return Clj.call(reduceMaxFn, object);
    }

    public static Object min(Object object, Object object2) {
        return Clj.call(minFn, object, object2);
    }

    public static Object reduceMin(Object object) {
        return Clj.call(reduceMinFn, object);
    }

    public static Object exp(Object object) {
        return Clj.call(expFn, object);
    }

    public static Object expm1(Object object) {
        return Clj.call(expm1Fn, object);
    }

    public static Object log(Object object) {
        return Clj.call(logFn, object);
    }

    public static Object log1p(Object object) {
        return Clj.call(log1pFn, object);
    }

    public static Object logistic(Object object) {
        return Clj.call(logisticFn, object);
    }

    public static double sum(Object object) {
        return (Double)Clj.call(sumFn, object);
    }

    public static double sumFast(Object object) {
        return (Double)Clj.call(sumFastFn, object);
    }

    public static double mean(Object object) {
        return (Double)Clj.call(meanFn, object);
    }

    public static double meanFast(Object object) {
        return (Double)Clj.call(meanFastFn, object);
    }

    public static double distance(Object object, Object object2) {
        return (Double)Clj.call(distanceFn, object, object2);
    }

    public static double distanceSquared(Object object, Object object2) {
        return (Double)Clj.call(distanceSqFn, object, object2);
    }

    public static double magnitude(Object object) {
        return (Double)Clj.call(magnitudeFn, object);
    }

    public static double magnitudeSquared(Object object) {
        return (Double)Clj.call(magnitudeSqFn, object);
    }

    public static double dotProduct(Object object, Object object2) {
        return (Double)Clj.call(dotProdFn, object, object2);
    }

    public static Object cummin(Object object) {
        return Clj.call(cumminFn, object);
    }

    public static Object cummax(Object object) {
        return Clj.call(cummaxFn, object);
    }

    public static Object cumsum(Object object) {
        return Clj.call(cumsumFn, object);
    }

    public static Object cumprod(Object object) {
        return Clj.call(cumprodFn, object);
    }

    public static boolean isEqual(Object object, Object object2, double d) {
        return (Boolean)Clj.call(equalsFn, object, object2, d);
    }

    public static boolean isEqual(Object object, Object object2) {
        return VecMath.isEqual(object, object2, 0.001);
    }
}

