/*
 * Decompiled with CFR 0.152.
 */
package co.zensight.naturallog;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.AppenderBase;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.LogbackException;
import com.aphyr.riemann.client.RiemannClient;
import java.io.IOException;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RiemannAppender
extends AppenderBase<ILoggingEvent> {
    private RiemannClient riemannClient;
    private String riemannHost;
    private int riemannPort = -1;
    private String service;

    public static void sendEverythingToRiemann(RiemannClient client, String level) {
        LoggerContext context = (LoggerContext)LoggerFactory.getILoggerFactory();
        context.reset();
        RiemannAppender appender = new RiemannAppender();
        appender.setContext((Context)context);
        appender.setRiemannClient(client);
        appender.start();
        Logger logger = (Logger)LoggerFactory.getLogger((String)"ROOT");
        logger.setLevel(Level.valueOf((String)level));
        logger.addAppender((Appender)appender);
    }

    protected void append(ILoggingEvent e) {
        this.lazyClient().event().description(e.getMessage()).service(this.getService()).time(e.getTimeStamp()).attribute("thread", e.getThreadName()).attribute("logger", e.getLoggerName()).attribute("level", e.getLevel().toString()).tag("log").send();
    }

    public RiemannClient getRiemannClient() {
        return this.riemannClient;
    }

    public void setRiemannClient(RiemannClient riemannClient) {
        this.riemannClient = riemannClient;
    }

    public String getRiemannServer() {
        return this.riemannHost;
    }

    public void setRiemannServer(String riemannServer) {
        this.riemannHost = riemannServer;
    }

    public int getRiemannPort() {
        return this.riemannPort;
    }

    public void setRiemannPort(int riemannPort) {
        this.riemannPort = riemannPort;
    }

    public String getService() {
        return this.service;
    }

    public void setService(String service) {
        this.service = service;
    }

    private RiemannClient lazyClient() {
        if (this.getRiemannClient() == null) {
            if (this.riemannHost == null) {
                throw new LogbackException("riemannHost must be set");
            }
            if (this.riemannPort <= 0) {
                throw new LogbackException("riemannPort must be set");
            }
            try {
                this.setRiemannClient(RiemannClient.tcp((String)this.riemannHost, (int)this.riemannPort));
            }
            catch (IOException ex) {
                throw new LogbackException("Can't connect to " + this.riemannHost + ":" + this.riemannPort, (Throwable)ex);
            }
        }
        return this.getRiemannClient();
    }
}

