// Compiled by ClojureScript 1.9.293 {}
goog.provide('reagent.dom');
goog.require('cljs.core');
goog.require('reagent.impl.util');
goog.require('reagent.interop');
goog.require('reagent.ratom');
goog.require('reagent.impl.template');
goog.require('reagent.impl.batching');
goog.require('cljsjs.react.dom');
goog.require('reagent.debug');
if(typeof reagent.dom.imported !== 'undefined'){
} else {
reagent.dom.imported = null;
}
reagent.dom.module = (function reagent$dom$module(){
if(cljs.core.some_QMARK_.call(null,reagent.dom.imported)){
return reagent.dom.imported;
} else {
if(typeof ReactDOM !== 'undefined'){
return reagent.dom.imported = ReactDOM;
} else {
if(typeof require !== 'undefined'){
var or__20285__auto__ = reagent.dom.imported = require("react-dom");
if(cljs.core.truth_(or__20285__auto__)){
return or__20285__auto__;
} else {
throw (new Error("require('react-dom') failed"));
}
} else {
throw (new Error("js/ReactDOM is missing"));

}
}
}
});
if(typeof reagent.dom.roots !== 'undefined'){
} else {
reagent.dom.roots = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
}
reagent.dom.unmount_comp = (function reagent$dom$unmount_comp(container){
cljs.core.swap_BANG_.call(null,reagent.dom.roots,cljs.core.dissoc,container);

return (reagent.dom.module.call(null)["unmountComponentAtNode"])(container);
});
reagent.dom.render_comp = (function reagent$dom$render_comp(comp,container,callback){
var _STAR_always_update_STAR_21874 = reagent.impl.util._STAR_always_update_STAR_;
reagent.impl.util._STAR_always_update_STAR_ = true;

try{return (reagent.dom.module.call(null)["render"])(comp.call(null),container,((function (_STAR_always_update_STAR_21874){
return (function (){
var _STAR_always_update_STAR_21875 = reagent.impl.util._STAR_always_update_STAR_;
reagent.impl.util._STAR_always_update_STAR_ = false;

try{cljs.core.swap_BANG_.call(null,reagent.dom.roots,cljs.core.assoc,container,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [comp,container], null));

reagent.impl.batching.flush_after_render.call(null);

if(cljs.core.some_QMARK_.call(null,callback)){
return callback.call(null);
} else {
return null;
}
}finally {reagent.impl.util._STAR_always_update_STAR_ = _STAR_always_update_STAR_21875;
}});})(_STAR_always_update_STAR_21874))
);
}finally {reagent.impl.util._STAR_always_update_STAR_ = _STAR_always_update_STAR_21874;
}});
reagent.dom.re_render_component = (function reagent$dom$re_render_component(comp,container){
return reagent.dom.render_comp.call(null,comp,container,null);
});
/**
 * Render a Reagent component into the DOM. The first argument may be
 *   either a vector (using Reagent's Hiccup syntax), or a React element. The second argument should be a DOM node.
 * 
 *   Optionally takes a callback that is called when the component is in place.
 * 
 *   Returns the mounted component instance.
 */
reagent.dom.render = (function reagent$dom$render(var_args){
var args21876 = [];
var len__21393__auto___21879 = arguments.length;
var i__21394__auto___21880 = (0);
while(true){
if((i__21394__auto___21880 < len__21393__auto___21879)){
args21876.push((arguments[i__21394__auto___21880]));

var G__21881 = (i__21394__auto___21880 + (1));
i__21394__auto___21880 = G__21881;
continue;
} else {
}
break;
}

var G__21878 = args21876.length;
switch (G__21878) {
case 2:
return reagent.dom.render.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return reagent.dom.render.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args21876.length)].join('')));

}
});

reagent.dom.render.cljs$core$IFn$_invoke$arity$2 = (function (comp,container){
return reagent.dom.render.call(null,comp,container,null);
});

reagent.dom.render.cljs$core$IFn$_invoke$arity$3 = (function (comp,container,callback){
reagent.ratom.flush_BANG_.call(null);

var f = (function (){
return reagent.impl.template.as_element.call(null,((cljs.core.fn_QMARK_.call(null,comp))?comp.call(null):comp));
});
return reagent.dom.render_comp.call(null,f,container,callback);
});

reagent.dom.render.cljs$lang$maxFixedArity = 3;

reagent.dom.unmount_component_at_node = (function reagent$dom$unmount_component_at_node(container){
return reagent.dom.unmount_comp.call(null,container);
});
/**
 * Returns the root DOM node of a mounted component.
 */
reagent.dom.dom_node = (function reagent$dom$dom_node(this$){
return (reagent.dom.module.call(null)["findDOMNode"])(this$);
});
/**
 * Force re-rendering of all mounted Reagent components. This is
 *   probably only useful in a development environment, when you want to
 *   update components in response to some dynamic changes to code.
 * 
 *   Note that force-update-all may not update root components. This
 *   happens if a component 'foo' is mounted with `(render [foo])` (since
 *   functions are passed by value, and not by reference, in
 *   ClojureScript). To get around this you'll have to introduce a layer
 *   of indirection, for example by using `(render [#'foo])` instead.
 */
reagent.dom.force_update_all = (function reagent$dom$force_update_all(){
reagent.ratom.flush_BANG_.call(null);

var seq__21887_21891 = cljs.core.seq.call(null,cljs.core.vals.call(null,cljs.core.deref.call(null,reagent.dom.roots)));
var chunk__21888_21892 = null;
var count__21889_21893 = (0);
var i__21890_21894 = (0);
while(true){
if((i__21890_21894 < count__21889_21893)){
var v_21895 = cljs.core._nth.call(null,chunk__21888_21892,i__21890_21894);
cljs.core.apply.call(null,reagent.dom.re_render_component,v_21895);

var G__21896 = seq__21887_21891;
var G__21897 = chunk__21888_21892;
var G__21898 = count__21889_21893;
var G__21899 = (i__21890_21894 + (1));
seq__21887_21891 = G__21896;
chunk__21888_21892 = G__21897;
count__21889_21893 = G__21898;
i__21890_21894 = G__21899;
continue;
} else {
var temp__4657__auto___21900 = cljs.core.seq.call(null,seq__21887_21891);
if(temp__4657__auto___21900){
var seq__21887_21901__$1 = temp__4657__auto___21900;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__21887_21901__$1)){
var c__21099__auto___21902 = cljs.core.chunk_first.call(null,seq__21887_21901__$1);
var G__21903 = cljs.core.chunk_rest.call(null,seq__21887_21901__$1);
var G__21904 = c__21099__auto___21902;
var G__21905 = cljs.core.count.call(null,c__21099__auto___21902);
var G__21906 = (0);
seq__21887_21891 = G__21903;
chunk__21888_21892 = G__21904;
count__21889_21893 = G__21905;
i__21890_21894 = G__21906;
continue;
} else {
var v_21907 = cljs.core.first.call(null,seq__21887_21901__$1);
cljs.core.apply.call(null,reagent.dom.re_render_component,v_21907);

var G__21908 = cljs.core.next.call(null,seq__21887_21901__$1);
var G__21909 = null;
var G__21910 = (0);
var G__21911 = (0);
seq__21887_21891 = G__21908;
chunk__21888_21892 = G__21909;
count__21889_21893 = G__21910;
i__21890_21894 = G__21911;
continue;
}
} else {
}
}
break;
}

return "Updated";
});

//# sourceMappingURL=dom.js.map?rel=1481915998639