// Compiled by ClojureScript 1.9.293 {}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var args23194 = [];
var len__21363__auto___23200 = arguments.length;
var i__21364__auto___23201 = (0);
while(true){
if((i__21364__auto___23201 < len__21363__auto___23200)){
args23194.push((arguments[i__21364__auto___23201]));

var G__23202 = (i__21364__auto___23201 + (1));
i__21364__auto___23201 = G__23202;
continue;
} else {
}
break;
}

var G__23196 = args23194.length;
switch (G__23196) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23194.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.call(null,f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if(typeof cljs.core.async.t_cljs$core$async23197 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async23197 = (function (f,blockable,meta23198){
this.f = f;
this.blockable = blockable;
this.meta23198 = meta23198;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async23197.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_23199,meta23198__$1){
var self__ = this;
var _23199__$1 = this;
return (new cljs.core.async.t_cljs$core$async23197(self__.f,self__.blockable,meta23198__$1));
});

cljs.core.async.t_cljs$core$async23197.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_23199){
var self__ = this;
var _23199__$1 = this;
return self__.meta23198;
});

cljs.core.async.t_cljs$core$async23197.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async23197.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async23197.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});

cljs.core.async.t_cljs$core$async23197.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async23197.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta23198","meta23198",-228924952,null)], null);
});

cljs.core.async.t_cljs$core$async23197.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async23197.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async23197";

cljs.core.async.t_cljs$core$async23197.cljs$lang$ctorPrWriter = (function (this__20861__auto__,writer__20862__auto__,opt__20863__auto__){
return cljs.core._write.call(null,writer__20862__auto__,"cljs.core.async/t_cljs$core$async23197");
});

cljs.core.async.__GT_t_cljs$core$async23197 = (function cljs$core$async$__GT_t_cljs$core$async23197(f__$1,blockable__$1,meta23198){
return (new cljs.core.async.t_cljs$core$async23197(f__$1,blockable__$1,meta23198));
});

}

return (new cljs.core.async.t_cljs$core$async23197(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var args23206 = [];
var len__21363__auto___23209 = arguments.length;
var i__21364__auto___23210 = (0);
while(true){
if((i__21364__auto___23210 < len__21363__auto___23209)){
args23206.push((arguments[i__21364__auto___23210]));

var G__23211 = (i__21364__auto___23210 + (1));
i__21364__auto___23210 = G__23211;
continue;
} else {
}
break;
}

var G__23208 = args23206.length;
switch (G__23208) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23206.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("buffer must be supplied when transducer is"),cljs.core.str("\n"),cljs.core.str("buf-or-n")].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var args23213 = [];
var len__21363__auto___23216 = arguments.length;
var i__21364__auto___23217 = (0);
while(true){
if((i__21364__auto___23217 < len__21363__auto___23216)){
args23213.push((arguments[i__21364__auto___23217]));

var G__23218 = (i__21364__auto___23217 + (1));
i__21364__auto___23217 = G__23218;
continue;
} else {
}
break;
}

var G__23215 = args23213.length;
switch (G__23215) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23213.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.call(null,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.call(null,xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.call(null,cljs.core.async.impl.buffers.promise_buffer.call(null),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var args23220 = [];
var len__21363__auto___23223 = arguments.length;
var i__21364__auto___23224 = (0);
while(true){
if((i__21364__auto___23224 < len__21363__auto___23223)){
args23220.push((arguments[i__21364__auto___23224]));

var G__23225 = (i__21364__auto___23224 + (1));
i__21364__auto___23224 = G__23225;
continue;
} else {
}
break;
}

var G__23222 = args23220.length;
switch (G__23222) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23220.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_23227 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_23227);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (val_23227,ret){
return (function (){
return fn1.call(null,val_23227);
});})(val_23227,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var args23228 = [];
var len__21363__auto___23231 = arguments.length;
var i__21364__auto___23232 = (0);
while(true){
if((i__21364__auto___23232 < len__21363__auto___23231)){
args23228.push((arguments[i__21364__auto___23232]));

var G__23233 = (i__21364__auto___23232 + (1));
i__21364__auto___23232 = G__23233;
continue;
} else {
}
break;
}

var G__23230 = args23228.length;
switch (G__23230) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23228.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__4655__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__4655__auto__)){
var ret = temp__4655__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__4655__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__4655__auto__)){
var retb = temp__4655__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (ret,retb,temp__4655__auto__){
return (function (){
return fn1.call(null,ret);
});})(ret,retb,temp__4655__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__21173__auto___23235 = n;
var x_23236 = (0);
while(true){
if((x_23236 < n__21173__auto___23235)){
(a[x_23236] = (0));

var G__23237 = (x_23236 + (1));
x_23236 = G__23237;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.call(null,i,n)){
return a;
} else {
var j = cljs.core.rand_int.call(null,i);
(a[i] = (a[j]));

(a[j] = i);

var G__23238 = (i + (1));
i = G__23238;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if(typeof cljs.core.async.t_cljs$core$async23242 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async23242 = (function (flag,meta23243){
this.flag = flag;
this.meta23243 = meta23243;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async23242.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_23244,meta23243__$1){
var self__ = this;
var _23244__$1 = this;
return (new cljs.core.async.t_cljs$core$async23242(self__.flag,meta23243__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async23242.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_23244){
var self__ = this;
var _23244__$1 = this;
return self__.meta23243;
});})(flag))
;

cljs.core.async.t_cljs$core$async23242.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async23242.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
});})(flag))
;

cljs.core.async.t_cljs$core$async23242.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async23242.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async23242.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta23243","meta23243",-1189860777,null)], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async23242.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async23242.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async23242";

cljs.core.async.t_cljs$core$async23242.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__20861__auto__,writer__20862__auto__,opt__20863__auto__){
return cljs.core._write.call(null,writer__20862__auto__,"cljs.core.async/t_cljs$core$async23242");
});})(flag))
;

cljs.core.async.__GT_t_cljs$core$async23242 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async23242(flag__$1,meta23243){
return (new cljs.core.async.t_cljs$core$async23242(flag__$1,meta23243));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async23242(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t_cljs$core$async23248 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async23248 = (function (flag,cb,meta23249){
this.flag = flag;
this.cb = cb;
this.meta23249 = meta23249;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async23248.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_23250,meta23249__$1){
var self__ = this;
var _23250__$1 = this;
return (new cljs.core.async.t_cljs$core$async23248(self__.flag,self__.cb,meta23249__$1));
});

cljs.core.async.t_cljs$core$async23248.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_23250){
var self__ = this;
var _23250__$1 = this;
return self__.meta23249;
});

cljs.core.async.t_cljs$core$async23248.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async23248.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
});

cljs.core.async.t_cljs$core$async23248.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async23248.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit.call(null,self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async23248.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta23249","meta23249",143533977,null)], null);
});

cljs.core.async.t_cljs$core$async23248.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async23248.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async23248";

cljs.core.async.t_cljs$core$async23248.cljs$lang$ctorPrWriter = (function (this__20861__auto__,writer__20862__auto__,opt__20863__auto__){
return cljs.core._write.call(null,writer__20862__auto__,"cljs.core.async/t_cljs$core$async23248");
});

cljs.core.async.__GT_t_cljs$core$async23248 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async23248(flag__$1,cb__$1,meta23249){
return (new cljs.core.async.t_cljs$core$async23248(flag__$1,cb__$1,meta23249));
});

}

return (new cljs.core.async.t_cljs$core$async23248(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__23251_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__23251_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__23252_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__23252_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__20255__auto__ = wport;
if(cljs.core.truth_(or__20255__auto__)){
return or__20255__auto__;
} else {
return port;
}
})()], null));
} else {
var G__23253 = (i + (1));
i = G__23253;
continue;
}
} else {
return null;
}
break;
}
})();
var or__20255__auto__ = ret;
if(cljs.core.truth_(or__20255__auto__)){
return or__20255__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__4657__auto__ = (function (){var and__20243__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);
if(cljs.core.truth_(and__20243__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,flag);
} else {
return and__20243__auto__;
}
})();
if(cljs.core.truth_(temp__4657__auto__)){
var got = temp__4657__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__21370__auto__ = [];
var len__21363__auto___23259 = arguments.length;
var i__21364__auto___23260 = (0);
while(true){
if((i__21364__auto___23260 < len__21363__auto___23259)){
args__21370__auto__.push((arguments[i__21364__auto___23260]));

var G__23261 = (i__21364__auto___23260 + (1));
i__21364__auto___23260 = G__23261;
continue;
} else {
}
break;
}

var argseq__21371__auto__ = ((((1) < args__21370__auto__.length))?(new cljs.core.IndexedSeq(args__21370__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__21371__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__23256){
var map__23257 = p__23256;
var map__23257__$1 = ((((!((map__23257 == null)))?((((map__23257.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__23257.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__23257):map__23257);
var opts = map__23257__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq23254){
var G__23255 = cljs.core.first.call(null,seq23254);
var seq23254__$1 = cljs.core.next.call(null,seq23254);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__23255,seq23254__$1);
});

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var args23262 = [];
var len__21363__auto___23312 = arguments.length;
var i__21364__auto___23313 = (0);
while(true){
if((i__21364__auto___23313 < len__21363__auto___23312)){
args23262.push((arguments[i__21364__auto___23313]));

var G__23314 = (i__21364__auto___23313 + (1));
i__21364__auto___23313 = G__23314;
continue;
} else {
}
break;
}

var G__23264 = args23262.length;
switch (G__23264) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23262.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__23149__auto___23316 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__23149__auto___23316){
return (function (){
var f__23150__auto__ = (function (){var switch__23037__auto__ = ((function (c__23149__auto___23316){
return (function (state_23288){
var state_val_23289 = (state_23288[(1)]);
if((state_val_23289 === (7))){
var inst_23284 = (state_23288[(2)]);
var state_23288__$1 = state_23288;
var statearr_23290_23317 = state_23288__$1;
(statearr_23290_23317[(2)] = inst_23284);

(statearr_23290_23317[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23289 === (1))){
var state_23288__$1 = state_23288;
var statearr_23291_23318 = state_23288__$1;
(statearr_23291_23318[(2)] = null);

(statearr_23291_23318[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23289 === (4))){
var inst_23267 = (state_23288[(7)]);
var inst_23267__$1 = (state_23288[(2)]);
var inst_23268 = (inst_23267__$1 == null);
var state_23288__$1 = (function (){var statearr_23292 = state_23288;
(statearr_23292[(7)] = inst_23267__$1);

return statearr_23292;
})();
if(cljs.core.truth_(inst_23268)){
var statearr_23293_23319 = state_23288__$1;
(statearr_23293_23319[(1)] = (5));

} else {
var statearr_23294_23320 = state_23288__$1;
(statearr_23294_23320[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23289 === (13))){
var state_23288__$1 = state_23288;
var statearr_23295_23321 = state_23288__$1;
(statearr_23295_23321[(2)] = null);

(statearr_23295_23321[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23289 === (6))){
var inst_23267 = (state_23288[(7)]);
var state_23288__$1 = state_23288;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_23288__$1,(11),to,inst_23267);
} else {
if((state_val_23289 === (3))){
var inst_23286 = (state_23288[(2)]);
var state_23288__$1 = state_23288;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_23288__$1,inst_23286);
} else {
if((state_val_23289 === (12))){
var state_23288__$1 = state_23288;
var statearr_23296_23322 = state_23288__$1;
(statearr_23296_23322[(2)] = null);

(statearr_23296_23322[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23289 === (2))){
var state_23288__$1 = state_23288;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23288__$1,(4),from);
} else {
if((state_val_23289 === (11))){
var inst_23277 = (state_23288[(2)]);
var state_23288__$1 = state_23288;
if(cljs.core.truth_(inst_23277)){
var statearr_23297_23323 = state_23288__$1;
(statearr_23297_23323[(1)] = (12));

} else {
var statearr_23298_23324 = state_23288__$1;
(statearr_23298_23324[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23289 === (9))){
var state_23288__$1 = state_23288;
var statearr_23299_23325 = state_23288__$1;
(statearr_23299_23325[(2)] = null);

(statearr_23299_23325[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23289 === (5))){
var state_23288__$1 = state_23288;
if(cljs.core.truth_(close_QMARK_)){
var statearr_23300_23326 = state_23288__$1;
(statearr_23300_23326[(1)] = (8));

} else {
var statearr_23301_23327 = state_23288__$1;
(statearr_23301_23327[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23289 === (14))){
var inst_23282 = (state_23288[(2)]);
var state_23288__$1 = state_23288;
var statearr_23302_23328 = state_23288__$1;
(statearr_23302_23328[(2)] = inst_23282);

(statearr_23302_23328[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23289 === (10))){
var inst_23274 = (state_23288[(2)]);
var state_23288__$1 = state_23288;
var statearr_23303_23329 = state_23288__$1;
(statearr_23303_23329[(2)] = inst_23274);

(statearr_23303_23329[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23289 === (8))){
var inst_23271 = cljs.core.async.close_BANG_.call(null,to);
var state_23288__$1 = state_23288;
var statearr_23304_23330 = state_23288__$1;
(statearr_23304_23330[(2)] = inst_23271);

(statearr_23304_23330[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__23149__auto___23316))
;
return ((function (switch__23037__auto__,c__23149__auto___23316){
return (function() {
var cljs$core$async$state_machine__23038__auto__ = null;
var cljs$core$async$state_machine__23038__auto____0 = (function (){
var statearr_23308 = [null,null,null,null,null,null,null,null];
(statearr_23308[(0)] = cljs$core$async$state_machine__23038__auto__);

(statearr_23308[(1)] = (1));

return statearr_23308;
});
var cljs$core$async$state_machine__23038__auto____1 = (function (state_23288){
while(true){
var ret_value__23039__auto__ = (function (){try{while(true){
var result__23040__auto__ = switch__23037__auto__.call(null,state_23288);
if(cljs.core.keyword_identical_QMARK_.call(null,result__23040__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__23040__auto__;
}
break;
}
}catch (e23309){if((e23309 instanceof Object)){
var ex__23041__auto__ = e23309;
var statearr_23310_23331 = state_23288;
(statearr_23310_23331[(5)] = ex__23041__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_23288);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e23309;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__23039__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23332 = state_23288;
state_23288 = G__23332;
continue;
} else {
return ret_value__23039__auto__;
}
break;
}
});
cljs$core$async$state_machine__23038__auto__ = function(state_23288){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__23038__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__23038__auto____1.call(this,state_23288);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__23038__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__23038__auto____0;
cljs$core$async$state_machine__23038__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__23038__auto____1;
return cljs$core$async$state_machine__23038__auto__;
})()
;})(switch__23037__auto__,c__23149__auto___23316))
})();
var state__23151__auto__ = (function (){var statearr_23311 = f__23150__auto__.call(null);
(statearr_23311[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__23149__auto___23316);

return statearr_23311;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__23151__auto__);
});})(c__23149__auto___23316))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process = ((function (jobs,results){
return (function (p__23520){
var vec__23521 = p__23520;
var v = cljs.core.nth.call(null,vec__23521,(0),null);
var p = cljs.core.nth.call(null,vec__23521,(1),null);
var job = vec__23521;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__23149__auto___23707 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__23149__auto___23707,res,vec__23521,v,p,job,jobs,results){
return (function (){
var f__23150__auto__ = (function (){var switch__23037__auto__ = ((function (c__23149__auto___23707,res,vec__23521,v,p,job,jobs,results){
return (function (state_23528){
var state_val_23529 = (state_23528[(1)]);
if((state_val_23529 === (1))){
var state_23528__$1 = state_23528;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_23528__$1,(2),res,v);
} else {
if((state_val_23529 === (2))){
var inst_23525 = (state_23528[(2)]);
var inst_23526 = cljs.core.async.close_BANG_.call(null,res);
var state_23528__$1 = (function (){var statearr_23530 = state_23528;
(statearr_23530[(7)] = inst_23525);

return statearr_23530;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_23528__$1,inst_23526);
} else {
return null;
}
}
});})(c__23149__auto___23707,res,vec__23521,v,p,job,jobs,results))
;
return ((function (switch__23037__auto__,c__23149__auto___23707,res,vec__23521,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__23038__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__23038__auto____0 = (function (){
var statearr_23534 = [null,null,null,null,null,null,null,null];
(statearr_23534[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__23038__auto__);

(statearr_23534[(1)] = (1));

return statearr_23534;
});
var cljs$core$async$pipeline_STAR__$_state_machine__23038__auto____1 = (function (state_23528){
while(true){
var ret_value__23039__auto__ = (function (){try{while(true){
var result__23040__auto__ = switch__23037__auto__.call(null,state_23528);
if(cljs.core.keyword_identical_QMARK_.call(null,result__23040__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__23040__auto__;
}
break;
}
}catch (e23535){if((e23535 instanceof Object)){
var ex__23041__auto__ = e23535;
var statearr_23536_23708 = state_23528;
(statearr_23536_23708[(5)] = ex__23041__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_23528);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e23535;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__23039__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23709 = state_23528;
state_23528 = G__23709;
continue;
} else {
return ret_value__23039__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__23038__auto__ = function(state_23528){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__23038__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__23038__auto____1.call(this,state_23528);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__23038__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__23038__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__23038__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__23038__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__23038__auto__;
})()
;})(switch__23037__auto__,c__23149__auto___23707,res,vec__23521,v,p,job,jobs,results))
})();
var state__23151__auto__ = (function (){var statearr_23537 = f__23150__auto__.call(null);
(statearr_23537[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__23149__auto___23707);

return statearr_23537;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__23151__auto__);
});})(c__23149__auto___23707,res,vec__23521,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__23538){
var vec__23539 = p__23538;
var v = cljs.core.nth.call(null,vec__23539,(0),null);
var p = cljs.core.nth.call(null,vec__23539,(1),null);
var job = vec__23539;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results,process))
;
var n__21173__auto___23710 = n;
var __23711 = (0);
while(true){
if((__23711 < n__21173__auto___23710)){
var G__23542_23712 = (((type instanceof cljs.core.Keyword))?type.fqn:null);
switch (G__23542_23712) {
case "compute":
var c__23149__auto___23714 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__23711,c__23149__auto___23714,G__23542_23712,n__21173__auto___23710,jobs,results,process,async){
return (function (){
var f__23150__auto__ = (function (){var switch__23037__auto__ = ((function (__23711,c__23149__auto___23714,G__23542_23712,n__21173__auto___23710,jobs,results,process,async){
return (function (state_23555){
var state_val_23556 = (state_23555[(1)]);
if((state_val_23556 === (1))){
var state_23555__$1 = state_23555;
var statearr_23557_23715 = state_23555__$1;
(statearr_23557_23715[(2)] = null);

(statearr_23557_23715[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23556 === (2))){
var state_23555__$1 = state_23555;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23555__$1,(4),jobs);
} else {
if((state_val_23556 === (3))){
var inst_23553 = (state_23555[(2)]);
var state_23555__$1 = state_23555;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_23555__$1,inst_23553);
} else {
if((state_val_23556 === (4))){
var inst_23545 = (state_23555[(2)]);
var inst_23546 = process.call(null,inst_23545);
var state_23555__$1 = state_23555;
if(cljs.core.truth_(inst_23546)){
var statearr_23558_23716 = state_23555__$1;
(statearr_23558_23716[(1)] = (5));

} else {
var statearr_23559_23717 = state_23555__$1;
(statearr_23559_23717[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23556 === (5))){
var state_23555__$1 = state_23555;
var statearr_23560_23718 = state_23555__$1;
(statearr_23560_23718[(2)] = null);

(statearr_23560_23718[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23556 === (6))){
var state_23555__$1 = state_23555;
var statearr_23561_23719 = state_23555__$1;
(statearr_23561_23719[(2)] = null);

(statearr_23561_23719[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23556 === (7))){
var inst_23551 = (state_23555[(2)]);
var state_23555__$1 = state_23555;
var statearr_23562_23720 = state_23555__$1;
(statearr_23562_23720[(2)] = inst_23551);

(statearr_23562_23720[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__23711,c__23149__auto___23714,G__23542_23712,n__21173__auto___23710,jobs,results,process,async))
;
return ((function (__23711,switch__23037__auto__,c__23149__auto___23714,G__23542_23712,n__21173__auto___23710,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__23038__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__23038__auto____0 = (function (){
var statearr_23566 = [null,null,null,null,null,null,null];
(statearr_23566[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__23038__auto__);

(statearr_23566[(1)] = (1));

return statearr_23566;
});
var cljs$core$async$pipeline_STAR__$_state_machine__23038__auto____1 = (function (state_23555){
while(true){
var ret_value__23039__auto__ = (function (){try{while(true){
var result__23040__auto__ = switch__23037__auto__.call(null,state_23555);
if(cljs.core.keyword_identical_QMARK_.call(null,result__23040__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__23040__auto__;
}
break;
}
}catch (e23567){if((e23567 instanceof Object)){
var ex__23041__auto__ = e23567;
var statearr_23568_23721 = state_23555;
(statearr_23568_23721[(5)] = ex__23041__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_23555);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e23567;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__23039__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23722 = state_23555;
state_23555 = G__23722;
continue;
} else {
return ret_value__23039__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__23038__auto__ = function(state_23555){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__23038__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__23038__auto____1.call(this,state_23555);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__23038__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__23038__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__23038__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__23038__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__23038__auto__;
})()
;})(__23711,switch__23037__auto__,c__23149__auto___23714,G__23542_23712,n__21173__auto___23710,jobs,results,process,async))
})();
var state__23151__auto__ = (function (){var statearr_23569 = f__23150__auto__.call(null);
(statearr_23569[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__23149__auto___23714);

return statearr_23569;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__23151__auto__);
});})(__23711,c__23149__auto___23714,G__23542_23712,n__21173__auto___23710,jobs,results,process,async))
);


break;
case "async":
var c__23149__auto___23723 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__23711,c__23149__auto___23723,G__23542_23712,n__21173__auto___23710,jobs,results,process,async){
return (function (){
var f__23150__auto__ = (function (){var switch__23037__auto__ = ((function (__23711,c__23149__auto___23723,G__23542_23712,n__21173__auto___23710,jobs,results,process,async){
return (function (state_23582){
var state_val_23583 = (state_23582[(1)]);
if((state_val_23583 === (1))){
var state_23582__$1 = state_23582;
var statearr_23584_23724 = state_23582__$1;
(statearr_23584_23724[(2)] = null);

(statearr_23584_23724[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23583 === (2))){
var state_23582__$1 = state_23582;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23582__$1,(4),jobs);
} else {
if((state_val_23583 === (3))){
var inst_23580 = (state_23582[(2)]);
var state_23582__$1 = state_23582;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_23582__$1,inst_23580);
} else {
if((state_val_23583 === (4))){
var inst_23572 = (state_23582[(2)]);
var inst_23573 = async.call(null,inst_23572);
var state_23582__$1 = state_23582;
if(cljs.core.truth_(inst_23573)){
var statearr_23585_23725 = state_23582__$1;
(statearr_23585_23725[(1)] = (5));

} else {
var statearr_23586_23726 = state_23582__$1;
(statearr_23586_23726[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23583 === (5))){
var state_23582__$1 = state_23582;
var statearr_23587_23727 = state_23582__$1;
(statearr_23587_23727[(2)] = null);

(statearr_23587_23727[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23583 === (6))){
var state_23582__$1 = state_23582;
var statearr_23588_23728 = state_23582__$1;
(statearr_23588_23728[(2)] = null);

(statearr_23588_23728[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23583 === (7))){
var inst_23578 = (state_23582[(2)]);
var state_23582__$1 = state_23582;
var statearr_23589_23729 = state_23582__$1;
(statearr_23589_23729[(2)] = inst_23578);

(statearr_23589_23729[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__23711,c__23149__auto___23723,G__23542_23712,n__21173__auto___23710,jobs,results,process,async))
;
return ((function (__23711,switch__23037__auto__,c__23149__auto___23723,G__23542_23712,n__21173__auto___23710,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__23038__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__23038__auto____0 = (function (){
var statearr_23593 = [null,null,null,null,null,null,null];
(statearr_23593[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__23038__auto__);

(statearr_23593[(1)] = (1));

return statearr_23593;
});
var cljs$core$async$pipeline_STAR__$_state_machine__23038__auto____1 = (function (state_23582){
while(true){
var ret_value__23039__auto__ = (function (){try{while(true){
var result__23040__auto__ = switch__23037__auto__.call(null,state_23582);
if(cljs.core.keyword_identical_QMARK_.call(null,result__23040__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__23040__auto__;
}
break;
}
}catch (e23594){if((e23594 instanceof Object)){
var ex__23041__auto__ = e23594;
var statearr_23595_23730 = state_23582;
(statearr_23595_23730[(5)] = ex__23041__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_23582);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e23594;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__23039__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23731 = state_23582;
state_23582 = G__23731;
continue;
} else {
return ret_value__23039__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__23038__auto__ = function(state_23582){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__23038__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__23038__auto____1.call(this,state_23582);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__23038__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__23038__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__23038__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__23038__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__23038__auto__;
})()
;})(__23711,switch__23037__auto__,c__23149__auto___23723,G__23542_23712,n__21173__auto___23710,jobs,results,process,async))
})();
var state__23151__auto__ = (function (){var statearr_23596 = f__23150__auto__.call(null);
(statearr_23596[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__23149__auto___23723);

return statearr_23596;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__23151__auto__);
});})(__23711,c__23149__auto___23723,G__23542_23712,n__21173__auto___23710,jobs,results,process,async))
);


break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(type)].join('')));

}

var G__23732 = (__23711 + (1));
__23711 = G__23732;
continue;
} else {
}
break;
}

var c__23149__auto___23733 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__23149__auto___23733,jobs,results,process,async){
return (function (){
var f__23150__auto__ = (function (){var switch__23037__auto__ = ((function (c__23149__auto___23733,jobs,results,process,async){
return (function (state_23618){
var state_val_23619 = (state_23618[(1)]);
if((state_val_23619 === (1))){
var state_23618__$1 = state_23618;
var statearr_23620_23734 = state_23618__$1;
(statearr_23620_23734[(2)] = null);

(statearr_23620_23734[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23619 === (2))){
var state_23618__$1 = state_23618;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23618__$1,(4),from);
} else {
if((state_val_23619 === (3))){
var inst_23616 = (state_23618[(2)]);
var state_23618__$1 = state_23618;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_23618__$1,inst_23616);
} else {
if((state_val_23619 === (4))){
var inst_23599 = (state_23618[(7)]);
var inst_23599__$1 = (state_23618[(2)]);
var inst_23600 = (inst_23599__$1 == null);
var state_23618__$1 = (function (){var statearr_23621 = state_23618;
(statearr_23621[(7)] = inst_23599__$1);

return statearr_23621;
})();
if(cljs.core.truth_(inst_23600)){
var statearr_23622_23735 = state_23618__$1;
(statearr_23622_23735[(1)] = (5));

} else {
var statearr_23623_23736 = state_23618__$1;
(statearr_23623_23736[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23619 === (5))){
var inst_23602 = cljs.core.async.close_BANG_.call(null,jobs);
var state_23618__$1 = state_23618;
var statearr_23624_23737 = state_23618__$1;
(statearr_23624_23737[(2)] = inst_23602);

(statearr_23624_23737[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23619 === (6))){
var inst_23604 = (state_23618[(8)]);
var inst_23599 = (state_23618[(7)]);
var inst_23604__$1 = cljs.core.async.chan.call(null,(1));
var inst_23605 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23606 = [inst_23599,inst_23604__$1];
var inst_23607 = (new cljs.core.PersistentVector(null,2,(5),inst_23605,inst_23606,null));
var state_23618__$1 = (function (){var statearr_23625 = state_23618;
(statearr_23625[(8)] = inst_23604__$1);

return statearr_23625;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_23618__$1,(8),jobs,inst_23607);
} else {
if((state_val_23619 === (7))){
var inst_23614 = (state_23618[(2)]);
var state_23618__$1 = state_23618;
var statearr_23626_23738 = state_23618__$1;
(statearr_23626_23738[(2)] = inst_23614);

(statearr_23626_23738[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23619 === (8))){
var inst_23604 = (state_23618[(8)]);
var inst_23609 = (state_23618[(2)]);
var state_23618__$1 = (function (){var statearr_23627 = state_23618;
(statearr_23627[(9)] = inst_23609);

return statearr_23627;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_23618__$1,(9),results,inst_23604);
} else {
if((state_val_23619 === (9))){
var inst_23611 = (state_23618[(2)]);
var state_23618__$1 = (function (){var statearr_23628 = state_23618;
(statearr_23628[(10)] = inst_23611);

return statearr_23628;
})();
var statearr_23629_23739 = state_23618__$1;
(statearr_23629_23739[(2)] = null);

(statearr_23629_23739[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__23149__auto___23733,jobs,results,process,async))
;
return ((function (switch__23037__auto__,c__23149__auto___23733,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__23038__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__23038__auto____0 = (function (){
var statearr_23633 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_23633[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__23038__auto__);

(statearr_23633[(1)] = (1));

return statearr_23633;
});
var cljs$core$async$pipeline_STAR__$_state_machine__23038__auto____1 = (function (state_23618){
while(true){
var ret_value__23039__auto__ = (function (){try{while(true){
var result__23040__auto__ = switch__23037__auto__.call(null,state_23618);
if(cljs.core.keyword_identical_QMARK_.call(null,result__23040__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__23040__auto__;
}
break;
}
}catch (e23634){if((e23634 instanceof Object)){
var ex__23041__auto__ = e23634;
var statearr_23635_23740 = state_23618;
(statearr_23635_23740[(5)] = ex__23041__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_23618);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e23634;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__23039__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23741 = state_23618;
state_23618 = G__23741;
continue;
} else {
return ret_value__23039__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__23038__auto__ = function(state_23618){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__23038__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__23038__auto____1.call(this,state_23618);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__23038__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__23038__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__23038__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__23038__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__23038__auto__;
})()
;})(switch__23037__auto__,c__23149__auto___23733,jobs,results,process,async))
})();
var state__23151__auto__ = (function (){var statearr_23636 = f__23150__auto__.call(null);
(statearr_23636[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__23149__auto___23733);

return statearr_23636;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__23151__auto__);
});})(c__23149__auto___23733,jobs,results,process,async))
);


var c__23149__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__23149__auto__,jobs,results,process,async){
return (function (){
var f__23150__auto__ = (function (){var switch__23037__auto__ = ((function (c__23149__auto__,jobs,results,process,async){
return (function (state_23674){
var state_val_23675 = (state_23674[(1)]);
if((state_val_23675 === (7))){
var inst_23670 = (state_23674[(2)]);
var state_23674__$1 = state_23674;
var statearr_23676_23742 = state_23674__$1;
(statearr_23676_23742[(2)] = inst_23670);

(statearr_23676_23742[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23675 === (20))){
var state_23674__$1 = state_23674;
var statearr_23677_23743 = state_23674__$1;
(statearr_23677_23743[(2)] = null);

(statearr_23677_23743[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23675 === (1))){
var state_23674__$1 = state_23674;
var statearr_23678_23744 = state_23674__$1;
(statearr_23678_23744[(2)] = null);

(statearr_23678_23744[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23675 === (4))){
var inst_23639 = (state_23674[(7)]);
var inst_23639__$1 = (state_23674[(2)]);
var inst_23640 = (inst_23639__$1 == null);
var state_23674__$1 = (function (){var statearr_23679 = state_23674;
(statearr_23679[(7)] = inst_23639__$1);

return statearr_23679;
})();
if(cljs.core.truth_(inst_23640)){
var statearr_23680_23745 = state_23674__$1;
(statearr_23680_23745[(1)] = (5));

} else {
var statearr_23681_23746 = state_23674__$1;
(statearr_23681_23746[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23675 === (15))){
var inst_23652 = (state_23674[(8)]);
var state_23674__$1 = state_23674;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_23674__$1,(18),to,inst_23652);
} else {
if((state_val_23675 === (21))){
var inst_23665 = (state_23674[(2)]);
var state_23674__$1 = state_23674;
var statearr_23682_23747 = state_23674__$1;
(statearr_23682_23747[(2)] = inst_23665);

(statearr_23682_23747[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23675 === (13))){
var inst_23667 = (state_23674[(2)]);
var state_23674__$1 = (function (){var statearr_23683 = state_23674;
(statearr_23683[(9)] = inst_23667);

return statearr_23683;
})();
var statearr_23684_23748 = state_23674__$1;
(statearr_23684_23748[(2)] = null);

(statearr_23684_23748[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23675 === (6))){
var inst_23639 = (state_23674[(7)]);
var state_23674__$1 = state_23674;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23674__$1,(11),inst_23639);
} else {
if((state_val_23675 === (17))){
var inst_23660 = (state_23674[(2)]);
var state_23674__$1 = state_23674;
if(cljs.core.truth_(inst_23660)){
var statearr_23685_23749 = state_23674__$1;
(statearr_23685_23749[(1)] = (19));

} else {
var statearr_23686_23750 = state_23674__$1;
(statearr_23686_23750[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23675 === (3))){
var inst_23672 = (state_23674[(2)]);
var state_23674__$1 = state_23674;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_23674__$1,inst_23672);
} else {
if((state_val_23675 === (12))){
var inst_23649 = (state_23674[(10)]);
var state_23674__$1 = state_23674;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23674__$1,(14),inst_23649);
} else {
if((state_val_23675 === (2))){
var state_23674__$1 = state_23674;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23674__$1,(4),results);
} else {
if((state_val_23675 === (19))){
var state_23674__$1 = state_23674;
var statearr_23687_23751 = state_23674__$1;
(statearr_23687_23751[(2)] = null);

(statearr_23687_23751[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23675 === (11))){
var inst_23649 = (state_23674[(2)]);
var state_23674__$1 = (function (){var statearr_23688 = state_23674;
(statearr_23688[(10)] = inst_23649);

return statearr_23688;
})();
var statearr_23689_23752 = state_23674__$1;
(statearr_23689_23752[(2)] = null);

(statearr_23689_23752[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23675 === (9))){
var state_23674__$1 = state_23674;
var statearr_23690_23753 = state_23674__$1;
(statearr_23690_23753[(2)] = null);

(statearr_23690_23753[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23675 === (5))){
var state_23674__$1 = state_23674;
if(cljs.core.truth_(close_QMARK_)){
var statearr_23691_23754 = state_23674__$1;
(statearr_23691_23754[(1)] = (8));

} else {
var statearr_23692_23755 = state_23674__$1;
(statearr_23692_23755[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23675 === (14))){
var inst_23652 = (state_23674[(8)]);
var inst_23654 = (state_23674[(11)]);
var inst_23652__$1 = (state_23674[(2)]);
var inst_23653 = (inst_23652__$1 == null);
var inst_23654__$1 = cljs.core.not.call(null,inst_23653);
var state_23674__$1 = (function (){var statearr_23693 = state_23674;
(statearr_23693[(8)] = inst_23652__$1);

(statearr_23693[(11)] = inst_23654__$1);

return statearr_23693;
})();
if(inst_23654__$1){
var statearr_23694_23756 = state_23674__$1;
(statearr_23694_23756[(1)] = (15));

} else {
var statearr_23695_23757 = state_23674__$1;
(statearr_23695_23757[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23675 === (16))){
var inst_23654 = (state_23674[(11)]);
var state_23674__$1 = state_23674;
var statearr_23696_23758 = state_23674__$1;
(statearr_23696_23758[(2)] = inst_23654);

(statearr_23696_23758[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23675 === (10))){
var inst_23646 = (state_23674[(2)]);
var state_23674__$1 = state_23674;
var statearr_23697_23759 = state_23674__$1;
(statearr_23697_23759[(2)] = inst_23646);

(statearr_23697_23759[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23675 === (18))){
var inst_23657 = (state_23674[(2)]);
var state_23674__$1 = state_23674;
var statearr_23698_23760 = state_23674__$1;
(statearr_23698_23760[(2)] = inst_23657);

(statearr_23698_23760[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23675 === (8))){
var inst_23643 = cljs.core.async.close_BANG_.call(null,to);
var state_23674__$1 = state_23674;
var statearr_23699_23761 = state_23674__$1;
(statearr_23699_23761[(2)] = inst_23643);

(statearr_23699_23761[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__23149__auto__,jobs,results,process,async))
;
return ((function (switch__23037__auto__,c__23149__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__23038__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__23038__auto____0 = (function (){
var statearr_23703 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_23703[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__23038__auto__);

(statearr_23703[(1)] = (1));

return statearr_23703;
});
var cljs$core$async$pipeline_STAR__$_state_machine__23038__auto____1 = (function (state_23674){
while(true){
var ret_value__23039__auto__ = (function (){try{while(true){
var result__23040__auto__ = switch__23037__auto__.call(null,state_23674);
if(cljs.core.keyword_identical_QMARK_.call(null,result__23040__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__23040__auto__;
}
break;
}
}catch (e23704){if((e23704 instanceof Object)){
var ex__23041__auto__ = e23704;
var statearr_23705_23762 = state_23674;
(statearr_23705_23762[(5)] = ex__23041__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_23674);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e23704;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__23039__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23763 = state_23674;
state_23674 = G__23763;
continue;
} else {
return ret_value__23039__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__23038__auto__ = function(state_23674){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__23038__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__23038__auto____1.call(this,state_23674);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__23038__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__23038__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__23038__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__23038__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__23038__auto__;
})()
;})(switch__23037__auto__,c__23149__auto__,jobs,results,process,async))
})();
var state__23151__auto__ = (function (){var statearr_23706 = f__23150__auto__.call(null);
(statearr_23706[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__23149__auto__);

return statearr_23706;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__23151__auto__);
});})(c__23149__auto__,jobs,results,process,async))
);

return c__23149__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var args23764 = [];
var len__21363__auto___23767 = arguments.length;
var i__21364__auto___23768 = (0);
while(true){
if((i__21364__auto___23768 < len__21363__auto___23767)){
args23764.push((arguments[i__21364__auto___23768]));

var G__23769 = (i__21364__auto___23768 + (1));
i__21364__auto___23768 = G__23769;
continue;
} else {
}
break;
}

var G__23766 = args23764.length;
switch (G__23766) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23764.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var args23771 = [];
var len__21363__auto___23774 = arguments.length;
var i__21364__auto___23775 = (0);
while(true){
if((i__21364__auto___23775 < len__21363__auto___23774)){
args23771.push((arguments[i__21364__auto___23775]));

var G__23776 = (i__21364__auto___23775 + (1));
i__21364__auto___23775 = G__23776;
continue;
} else {
}
break;
}

var G__23773 = args23771.length;
switch (G__23773) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23771.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var args23778 = [];
var len__21363__auto___23831 = arguments.length;
var i__21364__auto___23832 = (0);
while(true){
if((i__21364__auto___23832 < len__21363__auto___23831)){
args23778.push((arguments[i__21364__auto___23832]));

var G__23833 = (i__21364__auto___23832 + (1));
i__21364__auto___23832 = G__23833;
continue;
} else {
}
break;
}

var G__23780 = args23778.length;
switch (G__23780) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23778.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__23149__auto___23835 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__23149__auto___23835,tc,fc){
return (function (){
var f__23150__auto__ = (function (){var switch__23037__auto__ = ((function (c__23149__auto___23835,tc,fc){
return (function (state_23806){
var state_val_23807 = (state_23806[(1)]);
if((state_val_23807 === (7))){
var inst_23802 = (state_23806[(2)]);
var state_23806__$1 = state_23806;
var statearr_23808_23836 = state_23806__$1;
(statearr_23808_23836[(2)] = inst_23802);

(statearr_23808_23836[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23807 === (1))){
var state_23806__$1 = state_23806;
var statearr_23809_23837 = state_23806__$1;
(statearr_23809_23837[(2)] = null);

(statearr_23809_23837[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23807 === (4))){
var inst_23783 = (state_23806[(7)]);
var inst_23783__$1 = (state_23806[(2)]);
var inst_23784 = (inst_23783__$1 == null);
var state_23806__$1 = (function (){var statearr_23810 = state_23806;
(statearr_23810[(7)] = inst_23783__$1);

return statearr_23810;
})();
if(cljs.core.truth_(inst_23784)){
var statearr_23811_23838 = state_23806__$1;
(statearr_23811_23838[(1)] = (5));

} else {
var statearr_23812_23839 = state_23806__$1;
(statearr_23812_23839[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23807 === (13))){
var state_23806__$1 = state_23806;
var statearr_23813_23840 = state_23806__$1;
(statearr_23813_23840[(2)] = null);

(statearr_23813_23840[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23807 === (6))){
var inst_23783 = (state_23806[(7)]);
var inst_23789 = p.call(null,inst_23783);
var state_23806__$1 = state_23806;
if(cljs.core.truth_(inst_23789)){
var statearr_23814_23841 = state_23806__$1;
(statearr_23814_23841[(1)] = (9));

} else {
var statearr_23815_23842 = state_23806__$1;
(statearr_23815_23842[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23807 === (3))){
var inst_23804 = (state_23806[(2)]);
var state_23806__$1 = state_23806;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_23806__$1,inst_23804);
} else {
if((state_val_23807 === (12))){
var state_23806__$1 = state_23806;
var statearr_23816_23843 = state_23806__$1;
(statearr_23816_23843[(2)] = null);

(statearr_23816_23843[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23807 === (2))){
var state_23806__$1 = state_23806;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23806__$1,(4),ch);
} else {
if((state_val_23807 === (11))){
var inst_23783 = (state_23806[(7)]);
var inst_23793 = (state_23806[(2)]);
var state_23806__$1 = state_23806;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_23806__$1,(8),inst_23793,inst_23783);
} else {
if((state_val_23807 === (9))){
var state_23806__$1 = state_23806;
var statearr_23817_23844 = state_23806__$1;
(statearr_23817_23844[(2)] = tc);

(statearr_23817_23844[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23807 === (5))){
var inst_23786 = cljs.core.async.close_BANG_.call(null,tc);
var inst_23787 = cljs.core.async.close_BANG_.call(null,fc);
var state_23806__$1 = (function (){var statearr_23818 = state_23806;
(statearr_23818[(8)] = inst_23786);

return statearr_23818;
})();
var statearr_23819_23845 = state_23806__$1;
(statearr_23819_23845[(2)] = inst_23787);

(statearr_23819_23845[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23807 === (14))){
var inst_23800 = (state_23806[(2)]);
var state_23806__$1 = state_23806;
var statearr_23820_23846 = state_23806__$1;
(statearr_23820_23846[(2)] = inst_23800);

(statearr_23820_23846[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23807 === (10))){
var state_23806__$1 = state_23806;
var statearr_23821_23847 = state_23806__$1;
(statearr_23821_23847[(2)] = fc);

(statearr_23821_23847[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23807 === (8))){
var inst_23795 = (state_23806[(2)]);
var state_23806__$1 = state_23806;
if(cljs.core.truth_(inst_23795)){
var statearr_23822_23848 = state_23806__$1;
(statearr_23822_23848[(1)] = (12));

} else {
var statearr_23823_23849 = state_23806__$1;
(statearr_23823_23849[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__23149__auto___23835,tc,fc))
;
return ((function (switch__23037__auto__,c__23149__auto___23835,tc,fc){
return (function() {
var cljs$core$async$state_machine__23038__auto__ = null;
var cljs$core$async$state_machine__23038__auto____0 = (function (){
var statearr_23827 = [null,null,null,null,null,null,null,null,null];
(statearr_23827[(0)] = cljs$core$async$state_machine__23038__auto__);

(statearr_23827[(1)] = (1));

return statearr_23827;
});
var cljs$core$async$state_machine__23038__auto____1 = (function (state_23806){
while(true){
var ret_value__23039__auto__ = (function (){try{while(true){
var result__23040__auto__ = switch__23037__auto__.call(null,state_23806);
if(cljs.core.keyword_identical_QMARK_.call(null,result__23040__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__23040__auto__;
}
break;
}
}catch (e23828){if((e23828 instanceof Object)){
var ex__23041__auto__ = e23828;
var statearr_23829_23850 = state_23806;
(statearr_23829_23850[(5)] = ex__23041__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_23806);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e23828;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__23039__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23851 = state_23806;
state_23806 = G__23851;
continue;
} else {
return ret_value__23039__auto__;
}
break;
}
});
cljs$core$async$state_machine__23038__auto__ = function(state_23806){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__23038__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__23038__auto____1.call(this,state_23806);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__23038__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__23038__auto____0;
cljs$core$async$state_machine__23038__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__23038__auto____1;
return cljs$core$async$state_machine__23038__auto__;
})()
;})(switch__23037__auto__,c__23149__auto___23835,tc,fc))
})();
var state__23151__auto__ = (function (){var statearr_23830 = f__23150__auto__.call(null);
(statearr_23830[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__23149__auto___23835);

return statearr_23830;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__23151__auto__);
});})(c__23149__auto___23835,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__23149__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__23149__auto__){
return (function (){
var f__23150__auto__ = (function (){var switch__23037__auto__ = ((function (c__23149__auto__){
return (function (state_23915){
var state_val_23916 = (state_23915[(1)]);
if((state_val_23916 === (7))){
var inst_23911 = (state_23915[(2)]);
var state_23915__$1 = state_23915;
var statearr_23917_23938 = state_23915__$1;
(statearr_23917_23938[(2)] = inst_23911);

(statearr_23917_23938[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23916 === (1))){
var inst_23895 = init;
var state_23915__$1 = (function (){var statearr_23918 = state_23915;
(statearr_23918[(7)] = inst_23895);

return statearr_23918;
})();
var statearr_23919_23939 = state_23915__$1;
(statearr_23919_23939[(2)] = null);

(statearr_23919_23939[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23916 === (4))){
var inst_23898 = (state_23915[(8)]);
var inst_23898__$1 = (state_23915[(2)]);
var inst_23899 = (inst_23898__$1 == null);
var state_23915__$1 = (function (){var statearr_23920 = state_23915;
(statearr_23920[(8)] = inst_23898__$1);

return statearr_23920;
})();
if(cljs.core.truth_(inst_23899)){
var statearr_23921_23940 = state_23915__$1;
(statearr_23921_23940[(1)] = (5));

} else {
var statearr_23922_23941 = state_23915__$1;
(statearr_23922_23941[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23916 === (6))){
var inst_23898 = (state_23915[(8)]);
var inst_23895 = (state_23915[(7)]);
var inst_23902 = (state_23915[(9)]);
var inst_23902__$1 = f.call(null,inst_23895,inst_23898);
var inst_23903 = cljs.core.reduced_QMARK_.call(null,inst_23902__$1);
var state_23915__$1 = (function (){var statearr_23923 = state_23915;
(statearr_23923[(9)] = inst_23902__$1);

return statearr_23923;
})();
if(inst_23903){
var statearr_23924_23942 = state_23915__$1;
(statearr_23924_23942[(1)] = (8));

} else {
var statearr_23925_23943 = state_23915__$1;
(statearr_23925_23943[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23916 === (3))){
var inst_23913 = (state_23915[(2)]);
var state_23915__$1 = state_23915;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_23915__$1,inst_23913);
} else {
if((state_val_23916 === (2))){
var state_23915__$1 = state_23915;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23915__$1,(4),ch);
} else {
if((state_val_23916 === (9))){
var inst_23902 = (state_23915[(9)]);
var inst_23895 = inst_23902;
var state_23915__$1 = (function (){var statearr_23926 = state_23915;
(statearr_23926[(7)] = inst_23895);

return statearr_23926;
})();
var statearr_23927_23944 = state_23915__$1;
(statearr_23927_23944[(2)] = null);

(statearr_23927_23944[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23916 === (5))){
var inst_23895 = (state_23915[(7)]);
var state_23915__$1 = state_23915;
var statearr_23928_23945 = state_23915__$1;
(statearr_23928_23945[(2)] = inst_23895);

(statearr_23928_23945[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23916 === (10))){
var inst_23909 = (state_23915[(2)]);
var state_23915__$1 = state_23915;
var statearr_23929_23946 = state_23915__$1;
(statearr_23929_23946[(2)] = inst_23909);

(statearr_23929_23946[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23916 === (8))){
var inst_23902 = (state_23915[(9)]);
var inst_23905 = cljs.core.deref.call(null,inst_23902);
var state_23915__$1 = state_23915;
var statearr_23930_23947 = state_23915__$1;
(statearr_23930_23947[(2)] = inst_23905);

(statearr_23930_23947[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__23149__auto__))
;
return ((function (switch__23037__auto__,c__23149__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__23038__auto__ = null;
var cljs$core$async$reduce_$_state_machine__23038__auto____0 = (function (){
var statearr_23934 = [null,null,null,null,null,null,null,null,null,null];
(statearr_23934[(0)] = cljs$core$async$reduce_$_state_machine__23038__auto__);

(statearr_23934[(1)] = (1));

return statearr_23934;
});
var cljs$core$async$reduce_$_state_machine__23038__auto____1 = (function (state_23915){
while(true){
var ret_value__23039__auto__ = (function (){try{while(true){
var result__23040__auto__ = switch__23037__auto__.call(null,state_23915);
if(cljs.core.keyword_identical_QMARK_.call(null,result__23040__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__23040__auto__;
}
break;
}
}catch (e23935){if((e23935 instanceof Object)){
var ex__23041__auto__ = e23935;
var statearr_23936_23948 = state_23915;
(statearr_23936_23948[(5)] = ex__23041__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_23915);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e23935;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__23039__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23949 = state_23915;
state_23915 = G__23949;
continue;
} else {
return ret_value__23039__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__23038__auto__ = function(state_23915){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__23038__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__23038__auto____1.call(this,state_23915);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__23038__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__23038__auto____0;
cljs$core$async$reduce_$_state_machine__23038__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__23038__auto____1;
return cljs$core$async$reduce_$_state_machine__23038__auto__;
})()
;})(switch__23037__auto__,c__23149__auto__))
})();
var state__23151__auto__ = (function (){var statearr_23937 = f__23150__auto__.call(null);
(statearr_23937[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__23149__auto__);

return statearr_23937;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__23151__auto__);
});})(c__23149__auto__))
);

return c__23149__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var args23950 = [];
var len__21363__auto___24002 = arguments.length;
var i__21364__auto___24003 = (0);
while(true){
if((i__21364__auto___24003 < len__21363__auto___24002)){
args23950.push((arguments[i__21364__auto___24003]));

var G__24004 = (i__21364__auto___24003 + (1));
i__21364__auto___24003 = G__24004;
continue;
} else {
}
break;
}

var G__23952 = args23950.length;
switch (G__23952) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23950.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.call(null,ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__23149__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__23149__auto__){
return (function (){
var f__23150__auto__ = (function (){var switch__23037__auto__ = ((function (c__23149__auto__){
return (function (state_23977){
var state_val_23978 = (state_23977[(1)]);
if((state_val_23978 === (7))){
var inst_23959 = (state_23977[(2)]);
var state_23977__$1 = state_23977;
var statearr_23979_24006 = state_23977__$1;
(statearr_23979_24006[(2)] = inst_23959);

(statearr_23979_24006[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23978 === (1))){
var inst_23953 = cljs.core.seq.call(null,coll);
var inst_23954 = inst_23953;
var state_23977__$1 = (function (){var statearr_23980 = state_23977;
(statearr_23980[(7)] = inst_23954);

return statearr_23980;
})();
var statearr_23981_24007 = state_23977__$1;
(statearr_23981_24007[(2)] = null);

(statearr_23981_24007[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23978 === (4))){
var inst_23954 = (state_23977[(7)]);
var inst_23957 = cljs.core.first.call(null,inst_23954);
var state_23977__$1 = state_23977;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_23977__$1,(7),ch,inst_23957);
} else {
if((state_val_23978 === (13))){
var inst_23971 = (state_23977[(2)]);
var state_23977__$1 = state_23977;
var statearr_23982_24008 = state_23977__$1;
(statearr_23982_24008[(2)] = inst_23971);

(statearr_23982_24008[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23978 === (6))){
var inst_23962 = (state_23977[(2)]);
var state_23977__$1 = state_23977;
if(cljs.core.truth_(inst_23962)){
var statearr_23983_24009 = state_23977__$1;
(statearr_23983_24009[(1)] = (8));

} else {
var statearr_23984_24010 = state_23977__$1;
(statearr_23984_24010[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23978 === (3))){
var inst_23975 = (state_23977[(2)]);
var state_23977__$1 = state_23977;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_23977__$1,inst_23975);
} else {
if((state_val_23978 === (12))){
var state_23977__$1 = state_23977;
var statearr_23985_24011 = state_23977__$1;
(statearr_23985_24011[(2)] = null);

(statearr_23985_24011[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23978 === (2))){
var inst_23954 = (state_23977[(7)]);
var state_23977__$1 = state_23977;
if(cljs.core.truth_(inst_23954)){
var statearr_23986_24012 = state_23977__$1;
(statearr_23986_24012[(1)] = (4));

} else {
var statearr_23987_24013 = state_23977__$1;
(statearr_23987_24013[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23978 === (11))){
var inst_23968 = cljs.core.async.close_BANG_.call(null,ch);
var state_23977__$1 = state_23977;
var statearr_23988_24014 = state_23977__$1;
(statearr_23988_24014[(2)] = inst_23968);

(statearr_23988_24014[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23978 === (9))){
var state_23977__$1 = state_23977;
if(cljs.core.truth_(close_QMARK_)){
var statearr_23989_24015 = state_23977__$1;
(statearr_23989_24015[(1)] = (11));

} else {
var statearr_23990_24016 = state_23977__$1;
(statearr_23990_24016[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23978 === (5))){
var inst_23954 = (state_23977[(7)]);
var state_23977__$1 = state_23977;
var statearr_23991_24017 = state_23977__$1;
(statearr_23991_24017[(2)] = inst_23954);

(statearr_23991_24017[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23978 === (10))){
var inst_23973 = (state_23977[(2)]);
var state_23977__$1 = state_23977;
var statearr_23992_24018 = state_23977__$1;
(statearr_23992_24018[(2)] = inst_23973);

(statearr_23992_24018[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23978 === (8))){
var inst_23954 = (state_23977[(7)]);
var inst_23964 = cljs.core.next.call(null,inst_23954);
var inst_23954__$1 = inst_23964;
var state_23977__$1 = (function (){var statearr_23993 = state_23977;
(statearr_23993[(7)] = inst_23954__$1);

return statearr_23993;
})();
var statearr_23994_24019 = state_23977__$1;
(statearr_23994_24019[(2)] = null);

(statearr_23994_24019[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__23149__auto__))
;
return ((function (switch__23037__auto__,c__23149__auto__){
return (function() {
var cljs$core$async$state_machine__23038__auto__ = null;
var cljs$core$async$state_machine__23038__auto____0 = (function (){
var statearr_23998 = [null,null,null,null,null,null,null,null];
(statearr_23998[(0)] = cljs$core$async$state_machine__23038__auto__);

(statearr_23998[(1)] = (1));

return statearr_23998;
});
var cljs$core$async$state_machine__23038__auto____1 = (function (state_23977){
while(true){
var ret_value__23039__auto__ = (function (){try{while(true){
var result__23040__auto__ = switch__23037__auto__.call(null,state_23977);
if(cljs.core.keyword_identical_QMARK_.call(null,result__23040__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__23040__auto__;
}
break;
}
}catch (e23999){if((e23999 instanceof Object)){
var ex__23041__auto__ = e23999;
var statearr_24000_24020 = state_23977;
(statearr_24000_24020[(5)] = ex__23041__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_23977);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e23999;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__23039__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24021 = state_23977;
state_23977 = G__24021;
continue;
} else {
return ret_value__23039__auto__;
}
break;
}
});
cljs$core$async$state_machine__23038__auto__ = function(state_23977){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__23038__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__23038__auto____1.call(this,state_23977);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__23038__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__23038__auto____0;
cljs$core$async$state_machine__23038__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__23038__auto____1;
return cljs$core$async$state_machine__23038__auto__;
})()
;})(switch__23037__auto__,c__23149__auto__))
})();
var state__23151__auto__ = (function (){var statearr_24001 = f__23150__auto__.call(null);
(statearr_24001[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__23149__auto__);

return statearr_24001;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__23151__auto__);
});})(c__23149__auto__))
);

return c__23149__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan.call(null,ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__20918__auto__ = (((_ == null))?null:_);
var m__20919__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__20918__auto__)]);
if(!((m__20919__auto__ == null))){
return m__20919__auto__.call(null,_);
} else {
var m__20919__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__20919__auto____$1 == null))){
return m__20919__auto____$1.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__20918__auto__ = (((m == null))?null:m);
var m__20919__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__20918__auto__)]);
if(!((m__20919__auto__ == null))){
return m__20919__auto__.call(null,m,ch,close_QMARK_);
} else {
var m__20919__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__20919__auto____$1 == null))){
return m__20919__auto____$1.call(null,m,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__20918__auto__ = (((m == null))?null:m);
var m__20919__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__20918__auto__)]);
if(!((m__20919__auto__ == null))){
return m__20919__auto__.call(null,m,ch);
} else {
var m__20919__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__20919__auto____$1 == null))){
return m__20919__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__20918__auto__ = (((m == null))?null:m);
var m__20919__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__20918__auto__)]);
if(!((m__20919__auto__ == null))){
return m__20919__auto__.call(null,m);
} else {
var m__20919__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__20919__auto____$1 == null))){
return m__20919__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async24247 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async24247 = (function (ch,cs,meta24248){
this.ch = ch;
this.cs = cs;
this.meta24248 = meta24248;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async24247.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_24249,meta24248__$1){
var self__ = this;
var _24249__$1 = this;
return (new cljs.core.async.t_cljs$core$async24247(self__.ch,self__.cs,meta24248__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async24247.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_24249){
var self__ = this;
var _24249__$1 = this;
return self__.meta24248;
});})(cs))
;

cljs.core.async.t_cljs$core$async24247.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async24247.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async24247.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async24247.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async24247.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async24247.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async24247.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta24248","meta24248",-805896432,null)], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async24247.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async24247.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async24247";

cljs.core.async.t_cljs$core$async24247.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__20861__auto__,writer__20862__auto__,opt__20863__auto__){
return cljs.core._write.call(null,writer__20862__auto__,"cljs.core.async/t_cljs$core$async24247");
});})(cs))
;

cljs.core.async.__GT_t_cljs$core$async24247 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async24247(ch__$1,cs__$1,meta24248){
return (new cljs.core.async.t_cljs$core$async24247(ch__$1,cs__$1,meta24248));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async24247(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__23149__auto___24472 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__23149__auto___24472,cs,m,dchan,dctr,done){
return (function (){
var f__23150__auto__ = (function (){var switch__23037__auto__ = ((function (c__23149__auto___24472,cs,m,dchan,dctr,done){
return (function (state_24384){
var state_val_24385 = (state_24384[(1)]);
if((state_val_24385 === (7))){
var inst_24380 = (state_24384[(2)]);
var state_24384__$1 = state_24384;
var statearr_24386_24473 = state_24384__$1;
(statearr_24386_24473[(2)] = inst_24380);

(statearr_24386_24473[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24385 === (20))){
var inst_24283 = (state_24384[(7)]);
var inst_24295 = cljs.core.first.call(null,inst_24283);
var inst_24296 = cljs.core.nth.call(null,inst_24295,(0),null);
var inst_24297 = cljs.core.nth.call(null,inst_24295,(1),null);
var state_24384__$1 = (function (){var statearr_24387 = state_24384;
(statearr_24387[(8)] = inst_24296);

return statearr_24387;
})();
if(cljs.core.truth_(inst_24297)){
var statearr_24388_24474 = state_24384__$1;
(statearr_24388_24474[(1)] = (22));

} else {
var statearr_24389_24475 = state_24384__$1;
(statearr_24389_24475[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24385 === (27))){
var inst_24327 = (state_24384[(9)]);
var inst_24252 = (state_24384[(10)]);
var inst_24325 = (state_24384[(11)]);
var inst_24332 = (state_24384[(12)]);
var inst_24332__$1 = cljs.core._nth.call(null,inst_24325,inst_24327);
var inst_24333 = cljs.core.async.put_BANG_.call(null,inst_24332__$1,inst_24252,done);
var state_24384__$1 = (function (){var statearr_24390 = state_24384;
(statearr_24390[(12)] = inst_24332__$1);

return statearr_24390;
})();
if(cljs.core.truth_(inst_24333)){
var statearr_24391_24476 = state_24384__$1;
(statearr_24391_24476[(1)] = (30));

} else {
var statearr_24392_24477 = state_24384__$1;
(statearr_24392_24477[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24385 === (1))){
var state_24384__$1 = state_24384;
var statearr_24393_24478 = state_24384__$1;
(statearr_24393_24478[(2)] = null);

(statearr_24393_24478[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24385 === (24))){
var inst_24283 = (state_24384[(7)]);
var inst_24302 = (state_24384[(2)]);
var inst_24303 = cljs.core.next.call(null,inst_24283);
var inst_24261 = inst_24303;
var inst_24262 = null;
var inst_24263 = (0);
var inst_24264 = (0);
var state_24384__$1 = (function (){var statearr_24394 = state_24384;
(statearr_24394[(13)] = inst_24264);

(statearr_24394[(14)] = inst_24262);

(statearr_24394[(15)] = inst_24261);

(statearr_24394[(16)] = inst_24302);

(statearr_24394[(17)] = inst_24263);

return statearr_24394;
})();
var statearr_24395_24479 = state_24384__$1;
(statearr_24395_24479[(2)] = null);

(statearr_24395_24479[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24385 === (39))){
var state_24384__$1 = state_24384;
var statearr_24399_24480 = state_24384__$1;
(statearr_24399_24480[(2)] = null);

(statearr_24399_24480[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24385 === (4))){
var inst_24252 = (state_24384[(10)]);
var inst_24252__$1 = (state_24384[(2)]);
var inst_24253 = (inst_24252__$1 == null);
var state_24384__$1 = (function (){var statearr_24400 = state_24384;
(statearr_24400[(10)] = inst_24252__$1);

return statearr_24400;
})();
if(cljs.core.truth_(inst_24253)){
var statearr_24401_24481 = state_24384__$1;
(statearr_24401_24481[(1)] = (5));

} else {
var statearr_24402_24482 = state_24384__$1;
(statearr_24402_24482[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24385 === (15))){
var inst_24264 = (state_24384[(13)]);
var inst_24262 = (state_24384[(14)]);
var inst_24261 = (state_24384[(15)]);
var inst_24263 = (state_24384[(17)]);
var inst_24279 = (state_24384[(2)]);
var inst_24280 = (inst_24264 + (1));
var tmp24396 = inst_24262;
var tmp24397 = inst_24261;
var tmp24398 = inst_24263;
var inst_24261__$1 = tmp24397;
var inst_24262__$1 = tmp24396;
var inst_24263__$1 = tmp24398;
var inst_24264__$1 = inst_24280;
var state_24384__$1 = (function (){var statearr_24403 = state_24384;
(statearr_24403[(13)] = inst_24264__$1);

(statearr_24403[(14)] = inst_24262__$1);

(statearr_24403[(15)] = inst_24261__$1);

(statearr_24403[(17)] = inst_24263__$1);

(statearr_24403[(18)] = inst_24279);

return statearr_24403;
})();
var statearr_24404_24483 = state_24384__$1;
(statearr_24404_24483[(2)] = null);

(statearr_24404_24483[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24385 === (21))){
var inst_24306 = (state_24384[(2)]);
var state_24384__$1 = state_24384;
var statearr_24408_24484 = state_24384__$1;
(statearr_24408_24484[(2)] = inst_24306);

(statearr_24408_24484[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24385 === (31))){
var inst_24332 = (state_24384[(12)]);
var inst_24336 = done.call(null,null);
var inst_24337 = cljs.core.async.untap_STAR_.call(null,m,inst_24332);
var state_24384__$1 = (function (){var statearr_24409 = state_24384;
(statearr_24409[(19)] = inst_24336);

return statearr_24409;
})();
var statearr_24410_24485 = state_24384__$1;
(statearr_24410_24485[(2)] = inst_24337);

(statearr_24410_24485[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24385 === (32))){
var inst_24327 = (state_24384[(9)]);
var inst_24324 = (state_24384[(20)]);
var inst_24325 = (state_24384[(11)]);
var inst_24326 = (state_24384[(21)]);
var inst_24339 = (state_24384[(2)]);
var inst_24340 = (inst_24327 + (1));
var tmp24405 = inst_24324;
var tmp24406 = inst_24325;
var tmp24407 = inst_24326;
var inst_24324__$1 = tmp24405;
var inst_24325__$1 = tmp24406;
var inst_24326__$1 = tmp24407;
var inst_24327__$1 = inst_24340;
var state_24384__$1 = (function (){var statearr_24411 = state_24384;
(statearr_24411[(9)] = inst_24327__$1);

(statearr_24411[(20)] = inst_24324__$1);

(statearr_24411[(11)] = inst_24325__$1);

(statearr_24411[(22)] = inst_24339);

(statearr_24411[(21)] = inst_24326__$1);

return statearr_24411;
})();
var statearr_24412_24486 = state_24384__$1;
(statearr_24412_24486[(2)] = null);

(statearr_24412_24486[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24385 === (40))){
var inst_24352 = (state_24384[(23)]);
var inst_24356 = done.call(null,null);
var inst_24357 = cljs.core.async.untap_STAR_.call(null,m,inst_24352);
var state_24384__$1 = (function (){var statearr_24413 = state_24384;
(statearr_24413[(24)] = inst_24356);

return statearr_24413;
})();
var statearr_24414_24487 = state_24384__$1;
(statearr_24414_24487[(2)] = inst_24357);

(statearr_24414_24487[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24385 === (33))){
var inst_24343 = (state_24384[(25)]);
var inst_24345 = cljs.core.chunked_seq_QMARK_.call(null,inst_24343);
var state_24384__$1 = state_24384;
if(inst_24345){
var statearr_24415_24488 = state_24384__$1;
(statearr_24415_24488[(1)] = (36));

} else {
var statearr_24416_24489 = state_24384__$1;
(statearr_24416_24489[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24385 === (13))){
var inst_24273 = (state_24384[(26)]);
var inst_24276 = cljs.core.async.close_BANG_.call(null,inst_24273);
var state_24384__$1 = state_24384;
var statearr_24417_24490 = state_24384__$1;
(statearr_24417_24490[(2)] = inst_24276);

(statearr_24417_24490[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24385 === (22))){
var inst_24296 = (state_24384[(8)]);
var inst_24299 = cljs.core.async.close_BANG_.call(null,inst_24296);
var state_24384__$1 = state_24384;
var statearr_24418_24491 = state_24384__$1;
(statearr_24418_24491[(2)] = inst_24299);

(statearr_24418_24491[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24385 === (36))){
var inst_24343 = (state_24384[(25)]);
var inst_24347 = cljs.core.chunk_first.call(null,inst_24343);
var inst_24348 = cljs.core.chunk_rest.call(null,inst_24343);
var inst_24349 = cljs.core.count.call(null,inst_24347);
var inst_24324 = inst_24348;
var inst_24325 = inst_24347;
var inst_24326 = inst_24349;
var inst_24327 = (0);
var state_24384__$1 = (function (){var statearr_24419 = state_24384;
(statearr_24419[(9)] = inst_24327);

(statearr_24419[(20)] = inst_24324);

(statearr_24419[(11)] = inst_24325);

(statearr_24419[(21)] = inst_24326);

return statearr_24419;
})();
var statearr_24420_24492 = state_24384__$1;
(statearr_24420_24492[(2)] = null);

(statearr_24420_24492[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24385 === (41))){
var inst_24343 = (state_24384[(25)]);
var inst_24359 = (state_24384[(2)]);
var inst_24360 = cljs.core.next.call(null,inst_24343);
var inst_24324 = inst_24360;
var inst_24325 = null;
var inst_24326 = (0);
var inst_24327 = (0);
var state_24384__$1 = (function (){var statearr_24421 = state_24384;
(statearr_24421[(9)] = inst_24327);

(statearr_24421[(20)] = inst_24324);

(statearr_24421[(11)] = inst_24325);

(statearr_24421[(21)] = inst_24326);

(statearr_24421[(27)] = inst_24359);

return statearr_24421;
})();
var statearr_24422_24493 = state_24384__$1;
(statearr_24422_24493[(2)] = null);

(statearr_24422_24493[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24385 === (43))){
var state_24384__$1 = state_24384;
var statearr_24423_24494 = state_24384__$1;
(statearr_24423_24494[(2)] = null);

(statearr_24423_24494[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24385 === (29))){
var inst_24368 = (state_24384[(2)]);
var state_24384__$1 = state_24384;
var statearr_24424_24495 = state_24384__$1;
(statearr_24424_24495[(2)] = inst_24368);

(statearr_24424_24495[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24385 === (44))){
var inst_24377 = (state_24384[(2)]);
var state_24384__$1 = (function (){var statearr_24425 = state_24384;
(statearr_24425[(28)] = inst_24377);

return statearr_24425;
})();
var statearr_24426_24496 = state_24384__$1;
(statearr_24426_24496[(2)] = null);

(statearr_24426_24496[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24385 === (6))){
var inst_24316 = (state_24384[(29)]);
var inst_24315 = cljs.core.deref.call(null,cs);
var inst_24316__$1 = cljs.core.keys.call(null,inst_24315);
var inst_24317 = cljs.core.count.call(null,inst_24316__$1);
var inst_24318 = cljs.core.reset_BANG_.call(null,dctr,inst_24317);
var inst_24323 = cljs.core.seq.call(null,inst_24316__$1);
var inst_24324 = inst_24323;
var inst_24325 = null;
var inst_24326 = (0);
var inst_24327 = (0);
var state_24384__$1 = (function (){var statearr_24427 = state_24384;
(statearr_24427[(9)] = inst_24327);

(statearr_24427[(30)] = inst_24318);

(statearr_24427[(20)] = inst_24324);

(statearr_24427[(11)] = inst_24325);

(statearr_24427[(21)] = inst_24326);

(statearr_24427[(29)] = inst_24316__$1);

return statearr_24427;
})();
var statearr_24428_24497 = state_24384__$1;
(statearr_24428_24497[(2)] = null);

(statearr_24428_24497[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24385 === (28))){
var inst_24343 = (state_24384[(25)]);
var inst_24324 = (state_24384[(20)]);
var inst_24343__$1 = cljs.core.seq.call(null,inst_24324);
var state_24384__$1 = (function (){var statearr_24429 = state_24384;
(statearr_24429[(25)] = inst_24343__$1);

return statearr_24429;
})();
if(inst_24343__$1){
var statearr_24430_24498 = state_24384__$1;
(statearr_24430_24498[(1)] = (33));

} else {
var statearr_24431_24499 = state_24384__$1;
(statearr_24431_24499[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24385 === (25))){
var inst_24327 = (state_24384[(9)]);
var inst_24326 = (state_24384[(21)]);
var inst_24329 = (inst_24327 < inst_24326);
var inst_24330 = inst_24329;
var state_24384__$1 = state_24384;
if(cljs.core.truth_(inst_24330)){
var statearr_24432_24500 = state_24384__$1;
(statearr_24432_24500[(1)] = (27));

} else {
var statearr_24433_24501 = state_24384__$1;
(statearr_24433_24501[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24385 === (34))){
var state_24384__$1 = state_24384;
var statearr_24434_24502 = state_24384__$1;
(statearr_24434_24502[(2)] = null);

(statearr_24434_24502[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24385 === (17))){
var state_24384__$1 = state_24384;
var statearr_24435_24503 = state_24384__$1;
(statearr_24435_24503[(2)] = null);

(statearr_24435_24503[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24385 === (3))){
var inst_24382 = (state_24384[(2)]);
var state_24384__$1 = state_24384;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24384__$1,inst_24382);
} else {
if((state_val_24385 === (12))){
var inst_24311 = (state_24384[(2)]);
var state_24384__$1 = state_24384;
var statearr_24436_24504 = state_24384__$1;
(statearr_24436_24504[(2)] = inst_24311);

(statearr_24436_24504[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24385 === (2))){
var state_24384__$1 = state_24384;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24384__$1,(4),ch);
} else {
if((state_val_24385 === (23))){
var state_24384__$1 = state_24384;
var statearr_24437_24505 = state_24384__$1;
(statearr_24437_24505[(2)] = null);

(statearr_24437_24505[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24385 === (35))){
var inst_24366 = (state_24384[(2)]);
var state_24384__$1 = state_24384;
var statearr_24438_24506 = state_24384__$1;
(statearr_24438_24506[(2)] = inst_24366);

(statearr_24438_24506[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24385 === (19))){
var inst_24283 = (state_24384[(7)]);
var inst_24287 = cljs.core.chunk_first.call(null,inst_24283);
var inst_24288 = cljs.core.chunk_rest.call(null,inst_24283);
var inst_24289 = cljs.core.count.call(null,inst_24287);
var inst_24261 = inst_24288;
var inst_24262 = inst_24287;
var inst_24263 = inst_24289;
var inst_24264 = (0);
var state_24384__$1 = (function (){var statearr_24439 = state_24384;
(statearr_24439[(13)] = inst_24264);

(statearr_24439[(14)] = inst_24262);

(statearr_24439[(15)] = inst_24261);

(statearr_24439[(17)] = inst_24263);

return statearr_24439;
})();
var statearr_24440_24507 = state_24384__$1;
(statearr_24440_24507[(2)] = null);

(statearr_24440_24507[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24385 === (11))){
var inst_24261 = (state_24384[(15)]);
var inst_24283 = (state_24384[(7)]);
var inst_24283__$1 = cljs.core.seq.call(null,inst_24261);
var state_24384__$1 = (function (){var statearr_24441 = state_24384;
(statearr_24441[(7)] = inst_24283__$1);

return statearr_24441;
})();
if(inst_24283__$1){
var statearr_24442_24508 = state_24384__$1;
(statearr_24442_24508[(1)] = (16));

} else {
var statearr_24443_24509 = state_24384__$1;
(statearr_24443_24509[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24385 === (9))){
var inst_24313 = (state_24384[(2)]);
var state_24384__$1 = state_24384;
var statearr_24444_24510 = state_24384__$1;
(statearr_24444_24510[(2)] = inst_24313);

(statearr_24444_24510[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24385 === (5))){
var inst_24259 = cljs.core.deref.call(null,cs);
var inst_24260 = cljs.core.seq.call(null,inst_24259);
var inst_24261 = inst_24260;
var inst_24262 = null;
var inst_24263 = (0);
var inst_24264 = (0);
var state_24384__$1 = (function (){var statearr_24445 = state_24384;
(statearr_24445[(13)] = inst_24264);

(statearr_24445[(14)] = inst_24262);

(statearr_24445[(15)] = inst_24261);

(statearr_24445[(17)] = inst_24263);

return statearr_24445;
})();
var statearr_24446_24511 = state_24384__$1;
(statearr_24446_24511[(2)] = null);

(statearr_24446_24511[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24385 === (14))){
var state_24384__$1 = state_24384;
var statearr_24447_24512 = state_24384__$1;
(statearr_24447_24512[(2)] = null);

(statearr_24447_24512[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24385 === (45))){
var inst_24374 = (state_24384[(2)]);
var state_24384__$1 = state_24384;
var statearr_24448_24513 = state_24384__$1;
(statearr_24448_24513[(2)] = inst_24374);

(statearr_24448_24513[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24385 === (26))){
var inst_24316 = (state_24384[(29)]);
var inst_24370 = (state_24384[(2)]);
var inst_24371 = cljs.core.seq.call(null,inst_24316);
var state_24384__$1 = (function (){var statearr_24449 = state_24384;
(statearr_24449[(31)] = inst_24370);

return statearr_24449;
})();
if(inst_24371){
var statearr_24450_24514 = state_24384__$1;
(statearr_24450_24514[(1)] = (42));

} else {
var statearr_24451_24515 = state_24384__$1;
(statearr_24451_24515[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24385 === (16))){
var inst_24283 = (state_24384[(7)]);
var inst_24285 = cljs.core.chunked_seq_QMARK_.call(null,inst_24283);
var state_24384__$1 = state_24384;
if(inst_24285){
var statearr_24452_24516 = state_24384__$1;
(statearr_24452_24516[(1)] = (19));

} else {
var statearr_24453_24517 = state_24384__$1;
(statearr_24453_24517[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24385 === (38))){
var inst_24363 = (state_24384[(2)]);
var state_24384__$1 = state_24384;
var statearr_24454_24518 = state_24384__$1;
(statearr_24454_24518[(2)] = inst_24363);

(statearr_24454_24518[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24385 === (30))){
var state_24384__$1 = state_24384;
var statearr_24455_24519 = state_24384__$1;
(statearr_24455_24519[(2)] = null);

(statearr_24455_24519[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24385 === (10))){
var inst_24264 = (state_24384[(13)]);
var inst_24262 = (state_24384[(14)]);
var inst_24272 = cljs.core._nth.call(null,inst_24262,inst_24264);
var inst_24273 = cljs.core.nth.call(null,inst_24272,(0),null);
var inst_24274 = cljs.core.nth.call(null,inst_24272,(1),null);
var state_24384__$1 = (function (){var statearr_24456 = state_24384;
(statearr_24456[(26)] = inst_24273);

return statearr_24456;
})();
if(cljs.core.truth_(inst_24274)){
var statearr_24457_24520 = state_24384__$1;
(statearr_24457_24520[(1)] = (13));

} else {
var statearr_24458_24521 = state_24384__$1;
(statearr_24458_24521[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24385 === (18))){
var inst_24309 = (state_24384[(2)]);
var state_24384__$1 = state_24384;
var statearr_24459_24522 = state_24384__$1;
(statearr_24459_24522[(2)] = inst_24309);

(statearr_24459_24522[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24385 === (42))){
var state_24384__$1 = state_24384;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24384__$1,(45),dchan);
} else {
if((state_val_24385 === (37))){
var inst_24252 = (state_24384[(10)]);
var inst_24343 = (state_24384[(25)]);
var inst_24352 = (state_24384[(23)]);
var inst_24352__$1 = cljs.core.first.call(null,inst_24343);
var inst_24353 = cljs.core.async.put_BANG_.call(null,inst_24352__$1,inst_24252,done);
var state_24384__$1 = (function (){var statearr_24460 = state_24384;
(statearr_24460[(23)] = inst_24352__$1);

return statearr_24460;
})();
if(cljs.core.truth_(inst_24353)){
var statearr_24461_24523 = state_24384__$1;
(statearr_24461_24523[(1)] = (39));

} else {
var statearr_24462_24524 = state_24384__$1;
(statearr_24462_24524[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24385 === (8))){
var inst_24264 = (state_24384[(13)]);
var inst_24263 = (state_24384[(17)]);
var inst_24266 = (inst_24264 < inst_24263);
var inst_24267 = inst_24266;
var state_24384__$1 = state_24384;
if(cljs.core.truth_(inst_24267)){
var statearr_24463_24525 = state_24384__$1;
(statearr_24463_24525[(1)] = (10));

} else {
var statearr_24464_24526 = state_24384__$1;
(statearr_24464_24526[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__23149__auto___24472,cs,m,dchan,dctr,done))
;
return ((function (switch__23037__auto__,c__23149__auto___24472,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__23038__auto__ = null;
var cljs$core$async$mult_$_state_machine__23038__auto____0 = (function (){
var statearr_24468 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_24468[(0)] = cljs$core$async$mult_$_state_machine__23038__auto__);

(statearr_24468[(1)] = (1));

return statearr_24468;
});
var cljs$core$async$mult_$_state_machine__23038__auto____1 = (function (state_24384){
while(true){
var ret_value__23039__auto__ = (function (){try{while(true){
var result__23040__auto__ = switch__23037__auto__.call(null,state_24384);
if(cljs.core.keyword_identical_QMARK_.call(null,result__23040__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__23040__auto__;
}
break;
}
}catch (e24469){if((e24469 instanceof Object)){
var ex__23041__auto__ = e24469;
var statearr_24470_24527 = state_24384;
(statearr_24470_24527[(5)] = ex__23041__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_24384);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e24469;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__23039__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24528 = state_24384;
state_24384 = G__24528;
continue;
} else {
return ret_value__23039__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__23038__auto__ = function(state_24384){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__23038__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__23038__auto____1.call(this,state_24384);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__23038__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__23038__auto____0;
cljs$core$async$mult_$_state_machine__23038__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__23038__auto____1;
return cljs$core$async$mult_$_state_machine__23038__auto__;
})()
;})(switch__23037__auto__,c__23149__auto___24472,cs,m,dchan,dctr,done))
})();
var state__23151__auto__ = (function (){var statearr_24471 = f__23150__auto__.call(null);
(statearr_24471[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__23149__auto___24472);

return statearr_24471;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__23151__auto__);
});})(c__23149__auto___24472,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var args24529 = [];
var len__21363__auto___24532 = arguments.length;
var i__21364__auto___24533 = (0);
while(true){
if((i__21364__auto___24533 < len__21363__auto___24532)){
args24529.push((arguments[i__21364__auto___24533]));

var G__24534 = (i__21364__auto___24533 + (1));
i__21364__auto___24533 = G__24534;
continue;
} else {
}
break;
}

var G__24531 = args24529.length;
switch (G__24531) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args24529.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_.call(null,mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__20918__auto__ = (((m == null))?null:m);
var m__20919__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__20918__auto__)]);
if(!((m__20919__auto__ == null))){
return m__20919__auto__.call(null,m,ch);
} else {
var m__20919__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__20919__auto____$1 == null))){
return m__20919__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__20918__auto__ = (((m == null))?null:m);
var m__20919__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__20918__auto__)]);
if(!((m__20919__auto__ == null))){
return m__20919__auto__.call(null,m,ch);
} else {
var m__20919__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__20919__auto____$1 == null))){
return m__20919__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__20918__auto__ = (((m == null))?null:m);
var m__20919__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__20918__auto__)]);
if(!((m__20919__auto__ == null))){
return m__20919__auto__.call(null,m);
} else {
var m__20919__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__20919__auto____$1 == null))){
return m__20919__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__20918__auto__ = (((m == null))?null:m);
var m__20919__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__20918__auto__)]);
if(!((m__20919__auto__ == null))){
return m__20919__auto__.call(null,m,state_map);
} else {
var m__20919__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__20919__auto____$1 == null))){
return m__20919__auto____$1.call(null,m,state_map);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__20918__auto__ = (((m == null))?null:m);
var m__20919__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__20918__auto__)]);
if(!((m__20919__auto__ == null))){
return m__20919__auto__.call(null,m,mode);
} else {
var m__20919__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__20919__auto____$1 == null))){
return m__20919__auto____$1.call(null,m,mode);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__21370__auto__ = [];
var len__21363__auto___24546 = arguments.length;
var i__21364__auto___24547 = (0);
while(true){
if((i__21364__auto___24547 < len__21363__auto___24546)){
args__21370__auto__.push((arguments[i__21364__auto___24547]));

var G__24548 = (i__21364__auto___24547 + (1));
i__21364__auto___24547 = G__24548;
continue;
} else {
}
break;
}

var argseq__21371__auto__ = ((((3) < args__21370__auto__.length))?(new cljs.core.IndexedSeq(args__21370__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__21371__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__24540){
var map__24541 = p__24540;
var map__24541__$1 = ((((!((map__24541 == null)))?((((map__24541.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__24541.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__24541):map__24541);
var opts = map__24541__$1;
var statearr_24543_24549 = state;
(statearr_24543_24549[cljs.core.async.impl.ioc_helpers.STATE_IDX] = cont_block);


var temp__4657__auto__ = cljs.core.async.do_alts.call(null,((function (map__24541,map__24541__$1,opts){
return (function (val){
var statearr_24544_24550 = state;
(statearr_24544_24550[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
});})(map__24541,map__24541__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__4657__auto__)){
var cb = temp__4657__auto__;
var statearr_24545_24551 = state;
(statearr_24545_24551[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq24536){
var G__24537 = cljs.core.first.call(null,seq24536);
var seq24536__$1 = cljs.core.next.call(null,seq24536);
var G__24538 = cljs.core.first.call(null,seq24536__$1);
var seq24536__$2 = cljs.core.next.call(null,seq24536__$1);
var G__24539 = cljs.core.first.call(null,seq24536__$2);
var seq24536__$3 = cljs.core.next.call(null,seq24536__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__24537,G__24538,G__24539,seq24536__$3);
});

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null);
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv.call(null,((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,(((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && (!(cljs.core.empty_QMARK_.call(null,solos))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async24719 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async24719 = (function (out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,meta24720){
this.out = out;
this.cs = cs;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.solo_mode = solo_mode;
this.change = change;
this.changed = changed;
this.pick = pick;
this.calc_state = calc_state;
this.meta24720 = meta24720;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async24719.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_24721,meta24720__$1){
var self__ = this;
var _24721__$1 = this;
return (new cljs.core.async.t_cljs$core$async24719(self__.out,self__.cs,self__.solo_modes,self__.attrs,self__.solo_mode,self__.change,self__.changed,self__.pick,self__.calc_state,meta24720__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async24719.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_24721){
var self__ = this;
var _24721__$1 = this;
return self__.meta24720;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async24719.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async24719.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async24719.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async24719.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async24719.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async24719.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async24719.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async24719.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str([cljs.core.str("mode must be one of: "),cljs.core.str(self__.solo_modes)].join('')),cljs.core.str("\n"),cljs.core.str("(solo-modes mode)")].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async24719.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"meta24720","meta24720",-1999851908,null)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async24719.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async24719.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async24719";

cljs.core.async.t_cljs$core$async24719.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__20861__auto__,writer__20862__auto__,opt__20863__auto__){
return cljs.core._write.call(null,writer__20862__auto__,"cljs.core.async/t_cljs$core$async24719");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t_cljs$core$async24719 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async24719(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta24720){
return (new cljs.core.async.t_cljs$core$async24719(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta24720));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async24719(out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__23149__auto___24886 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__23149__auto___24886,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__23150__auto__ = (function (){var switch__23037__auto__ = ((function (c__23149__auto___24886,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_24823){
var state_val_24824 = (state_24823[(1)]);
if((state_val_24824 === (7))){
var inst_24738 = (state_24823[(2)]);
var state_24823__$1 = state_24823;
var statearr_24825_24887 = state_24823__$1;
(statearr_24825_24887[(2)] = inst_24738);

(statearr_24825_24887[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24824 === (20))){
var inst_24750 = (state_24823[(7)]);
var state_24823__$1 = state_24823;
var statearr_24826_24888 = state_24823__$1;
(statearr_24826_24888[(2)] = inst_24750);

(statearr_24826_24888[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24824 === (27))){
var state_24823__$1 = state_24823;
var statearr_24827_24889 = state_24823__$1;
(statearr_24827_24889[(2)] = null);

(statearr_24827_24889[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24824 === (1))){
var inst_24725 = (state_24823[(8)]);
var inst_24725__$1 = calc_state.call(null);
var inst_24727 = (inst_24725__$1 == null);
var inst_24728 = cljs.core.not.call(null,inst_24727);
var state_24823__$1 = (function (){var statearr_24828 = state_24823;
(statearr_24828[(8)] = inst_24725__$1);

return statearr_24828;
})();
if(inst_24728){
var statearr_24829_24890 = state_24823__$1;
(statearr_24829_24890[(1)] = (2));

} else {
var statearr_24830_24891 = state_24823__$1;
(statearr_24830_24891[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24824 === (24))){
var inst_24783 = (state_24823[(9)]);
var inst_24797 = (state_24823[(10)]);
var inst_24774 = (state_24823[(11)]);
var inst_24797__$1 = inst_24774.call(null,inst_24783);
var state_24823__$1 = (function (){var statearr_24831 = state_24823;
(statearr_24831[(10)] = inst_24797__$1);

return statearr_24831;
})();
if(cljs.core.truth_(inst_24797__$1)){
var statearr_24832_24892 = state_24823__$1;
(statearr_24832_24892[(1)] = (29));

} else {
var statearr_24833_24893 = state_24823__$1;
(statearr_24833_24893[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24824 === (4))){
var inst_24741 = (state_24823[(2)]);
var state_24823__$1 = state_24823;
if(cljs.core.truth_(inst_24741)){
var statearr_24834_24894 = state_24823__$1;
(statearr_24834_24894[(1)] = (8));

} else {
var statearr_24835_24895 = state_24823__$1;
(statearr_24835_24895[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24824 === (15))){
var inst_24768 = (state_24823[(2)]);
var state_24823__$1 = state_24823;
if(cljs.core.truth_(inst_24768)){
var statearr_24836_24896 = state_24823__$1;
(statearr_24836_24896[(1)] = (19));

} else {
var statearr_24837_24897 = state_24823__$1;
(statearr_24837_24897[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24824 === (21))){
var inst_24773 = (state_24823[(12)]);
var inst_24773__$1 = (state_24823[(2)]);
var inst_24774 = cljs.core.get.call(null,inst_24773__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_24775 = cljs.core.get.call(null,inst_24773__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_24776 = cljs.core.get.call(null,inst_24773__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_24823__$1 = (function (){var statearr_24838 = state_24823;
(statearr_24838[(13)] = inst_24775);

(statearr_24838[(11)] = inst_24774);

(statearr_24838[(12)] = inst_24773__$1);

return statearr_24838;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_24823__$1,(22),inst_24776);
} else {
if((state_val_24824 === (31))){
var inst_24805 = (state_24823[(2)]);
var state_24823__$1 = state_24823;
if(cljs.core.truth_(inst_24805)){
var statearr_24839_24898 = state_24823__$1;
(statearr_24839_24898[(1)] = (32));

} else {
var statearr_24840_24899 = state_24823__$1;
(statearr_24840_24899[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24824 === (32))){
var inst_24782 = (state_24823[(14)]);
var state_24823__$1 = state_24823;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_24823__$1,(35),out,inst_24782);
} else {
if((state_val_24824 === (33))){
var inst_24773 = (state_24823[(12)]);
var inst_24750 = inst_24773;
var state_24823__$1 = (function (){var statearr_24841 = state_24823;
(statearr_24841[(7)] = inst_24750);

return statearr_24841;
})();
var statearr_24842_24900 = state_24823__$1;
(statearr_24842_24900[(2)] = null);

(statearr_24842_24900[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24824 === (13))){
var inst_24750 = (state_24823[(7)]);
var inst_24757 = inst_24750.cljs$lang$protocol_mask$partition0$;
var inst_24758 = (inst_24757 & (64));
var inst_24759 = inst_24750.cljs$core$ISeq$;
var inst_24760 = (cljs.core.PROTOCOL_SENTINEL === inst_24759);
var inst_24761 = (inst_24758) || (inst_24760);
var state_24823__$1 = state_24823;
if(cljs.core.truth_(inst_24761)){
var statearr_24843_24901 = state_24823__$1;
(statearr_24843_24901[(1)] = (16));

} else {
var statearr_24844_24902 = state_24823__$1;
(statearr_24844_24902[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24824 === (22))){
var inst_24782 = (state_24823[(14)]);
var inst_24783 = (state_24823[(9)]);
var inst_24781 = (state_24823[(2)]);
var inst_24782__$1 = cljs.core.nth.call(null,inst_24781,(0),null);
var inst_24783__$1 = cljs.core.nth.call(null,inst_24781,(1),null);
var inst_24784 = (inst_24782__$1 == null);
var inst_24785 = cljs.core._EQ_.call(null,inst_24783__$1,change);
var inst_24786 = (inst_24784) || (inst_24785);
var state_24823__$1 = (function (){var statearr_24845 = state_24823;
(statearr_24845[(14)] = inst_24782__$1);

(statearr_24845[(9)] = inst_24783__$1);

return statearr_24845;
})();
if(cljs.core.truth_(inst_24786)){
var statearr_24846_24903 = state_24823__$1;
(statearr_24846_24903[(1)] = (23));

} else {
var statearr_24847_24904 = state_24823__$1;
(statearr_24847_24904[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24824 === (36))){
var inst_24773 = (state_24823[(12)]);
var inst_24750 = inst_24773;
var state_24823__$1 = (function (){var statearr_24848 = state_24823;
(statearr_24848[(7)] = inst_24750);

return statearr_24848;
})();
var statearr_24849_24905 = state_24823__$1;
(statearr_24849_24905[(2)] = null);

(statearr_24849_24905[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24824 === (29))){
var inst_24797 = (state_24823[(10)]);
var state_24823__$1 = state_24823;
var statearr_24850_24906 = state_24823__$1;
(statearr_24850_24906[(2)] = inst_24797);

(statearr_24850_24906[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24824 === (6))){
var state_24823__$1 = state_24823;
var statearr_24851_24907 = state_24823__$1;
(statearr_24851_24907[(2)] = false);

(statearr_24851_24907[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24824 === (28))){
var inst_24793 = (state_24823[(2)]);
var inst_24794 = calc_state.call(null);
var inst_24750 = inst_24794;
var state_24823__$1 = (function (){var statearr_24852 = state_24823;
(statearr_24852[(7)] = inst_24750);

(statearr_24852[(15)] = inst_24793);

return statearr_24852;
})();
var statearr_24853_24908 = state_24823__$1;
(statearr_24853_24908[(2)] = null);

(statearr_24853_24908[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24824 === (25))){
var inst_24819 = (state_24823[(2)]);
var state_24823__$1 = state_24823;
var statearr_24854_24909 = state_24823__$1;
(statearr_24854_24909[(2)] = inst_24819);

(statearr_24854_24909[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24824 === (34))){
var inst_24817 = (state_24823[(2)]);
var state_24823__$1 = state_24823;
var statearr_24855_24910 = state_24823__$1;
(statearr_24855_24910[(2)] = inst_24817);

(statearr_24855_24910[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24824 === (17))){
var state_24823__$1 = state_24823;
var statearr_24856_24911 = state_24823__$1;
(statearr_24856_24911[(2)] = false);

(statearr_24856_24911[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24824 === (3))){
var state_24823__$1 = state_24823;
var statearr_24857_24912 = state_24823__$1;
(statearr_24857_24912[(2)] = false);

(statearr_24857_24912[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24824 === (12))){
var inst_24821 = (state_24823[(2)]);
var state_24823__$1 = state_24823;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24823__$1,inst_24821);
} else {
if((state_val_24824 === (2))){
var inst_24725 = (state_24823[(8)]);
var inst_24730 = inst_24725.cljs$lang$protocol_mask$partition0$;
var inst_24731 = (inst_24730 & (64));
var inst_24732 = inst_24725.cljs$core$ISeq$;
var inst_24733 = (cljs.core.PROTOCOL_SENTINEL === inst_24732);
var inst_24734 = (inst_24731) || (inst_24733);
var state_24823__$1 = state_24823;
if(cljs.core.truth_(inst_24734)){
var statearr_24858_24913 = state_24823__$1;
(statearr_24858_24913[(1)] = (5));

} else {
var statearr_24859_24914 = state_24823__$1;
(statearr_24859_24914[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24824 === (23))){
var inst_24782 = (state_24823[(14)]);
var inst_24788 = (inst_24782 == null);
var state_24823__$1 = state_24823;
if(cljs.core.truth_(inst_24788)){
var statearr_24860_24915 = state_24823__$1;
(statearr_24860_24915[(1)] = (26));

} else {
var statearr_24861_24916 = state_24823__$1;
(statearr_24861_24916[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24824 === (35))){
var inst_24808 = (state_24823[(2)]);
var state_24823__$1 = state_24823;
if(cljs.core.truth_(inst_24808)){
var statearr_24862_24917 = state_24823__$1;
(statearr_24862_24917[(1)] = (36));

} else {
var statearr_24863_24918 = state_24823__$1;
(statearr_24863_24918[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24824 === (19))){
var inst_24750 = (state_24823[(7)]);
var inst_24770 = cljs.core.apply.call(null,cljs.core.hash_map,inst_24750);
var state_24823__$1 = state_24823;
var statearr_24864_24919 = state_24823__$1;
(statearr_24864_24919[(2)] = inst_24770);

(statearr_24864_24919[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24824 === (11))){
var inst_24750 = (state_24823[(7)]);
var inst_24754 = (inst_24750 == null);
var inst_24755 = cljs.core.not.call(null,inst_24754);
var state_24823__$1 = state_24823;
if(inst_24755){
var statearr_24865_24920 = state_24823__$1;
(statearr_24865_24920[(1)] = (13));

} else {
var statearr_24866_24921 = state_24823__$1;
(statearr_24866_24921[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24824 === (9))){
var inst_24725 = (state_24823[(8)]);
var state_24823__$1 = state_24823;
var statearr_24867_24922 = state_24823__$1;
(statearr_24867_24922[(2)] = inst_24725);

(statearr_24867_24922[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24824 === (5))){
var state_24823__$1 = state_24823;
var statearr_24868_24923 = state_24823__$1;
(statearr_24868_24923[(2)] = true);

(statearr_24868_24923[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24824 === (14))){
var state_24823__$1 = state_24823;
var statearr_24869_24924 = state_24823__$1;
(statearr_24869_24924[(2)] = false);

(statearr_24869_24924[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24824 === (26))){
var inst_24783 = (state_24823[(9)]);
var inst_24790 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_24783);
var state_24823__$1 = state_24823;
var statearr_24870_24925 = state_24823__$1;
(statearr_24870_24925[(2)] = inst_24790);

(statearr_24870_24925[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24824 === (16))){
var state_24823__$1 = state_24823;
var statearr_24871_24926 = state_24823__$1;
(statearr_24871_24926[(2)] = true);

(statearr_24871_24926[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24824 === (38))){
var inst_24813 = (state_24823[(2)]);
var state_24823__$1 = state_24823;
var statearr_24872_24927 = state_24823__$1;
(statearr_24872_24927[(2)] = inst_24813);

(statearr_24872_24927[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24824 === (30))){
var inst_24783 = (state_24823[(9)]);
var inst_24775 = (state_24823[(13)]);
var inst_24774 = (state_24823[(11)]);
var inst_24800 = cljs.core.empty_QMARK_.call(null,inst_24774);
var inst_24801 = inst_24775.call(null,inst_24783);
var inst_24802 = cljs.core.not.call(null,inst_24801);
var inst_24803 = (inst_24800) && (inst_24802);
var state_24823__$1 = state_24823;
var statearr_24873_24928 = state_24823__$1;
(statearr_24873_24928[(2)] = inst_24803);

(statearr_24873_24928[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24824 === (10))){
var inst_24725 = (state_24823[(8)]);
var inst_24746 = (state_24823[(2)]);
var inst_24747 = cljs.core.get.call(null,inst_24746,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_24748 = cljs.core.get.call(null,inst_24746,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_24749 = cljs.core.get.call(null,inst_24746,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_24750 = inst_24725;
var state_24823__$1 = (function (){var statearr_24874 = state_24823;
(statearr_24874[(16)] = inst_24747);

(statearr_24874[(7)] = inst_24750);

(statearr_24874[(17)] = inst_24748);

(statearr_24874[(18)] = inst_24749);

return statearr_24874;
})();
var statearr_24875_24929 = state_24823__$1;
(statearr_24875_24929[(2)] = null);

(statearr_24875_24929[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24824 === (18))){
var inst_24765 = (state_24823[(2)]);
var state_24823__$1 = state_24823;
var statearr_24876_24930 = state_24823__$1;
(statearr_24876_24930[(2)] = inst_24765);

(statearr_24876_24930[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24824 === (37))){
var state_24823__$1 = state_24823;
var statearr_24877_24931 = state_24823__$1;
(statearr_24877_24931[(2)] = null);

(statearr_24877_24931[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24824 === (8))){
var inst_24725 = (state_24823[(8)]);
var inst_24743 = cljs.core.apply.call(null,cljs.core.hash_map,inst_24725);
var state_24823__$1 = state_24823;
var statearr_24878_24932 = state_24823__$1;
(statearr_24878_24932[(2)] = inst_24743);

(statearr_24878_24932[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__23149__auto___24886,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__23037__auto__,c__23149__auto___24886,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__23038__auto__ = null;
var cljs$core$async$mix_$_state_machine__23038__auto____0 = (function (){
var statearr_24882 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_24882[(0)] = cljs$core$async$mix_$_state_machine__23038__auto__);

(statearr_24882[(1)] = (1));

return statearr_24882;
});
var cljs$core$async$mix_$_state_machine__23038__auto____1 = (function (state_24823){
while(true){
var ret_value__23039__auto__ = (function (){try{while(true){
var result__23040__auto__ = switch__23037__auto__.call(null,state_24823);
if(cljs.core.keyword_identical_QMARK_.call(null,result__23040__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__23040__auto__;
}
break;
}
}catch (e24883){if((e24883 instanceof Object)){
var ex__23041__auto__ = e24883;
var statearr_24884_24933 = state_24823;
(statearr_24884_24933[(5)] = ex__23041__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_24823);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e24883;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__23039__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24934 = state_24823;
state_24823 = G__24934;
continue;
} else {
return ret_value__23039__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__23038__auto__ = function(state_24823){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__23038__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__23038__auto____1.call(this,state_24823);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__23038__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__23038__auto____0;
cljs$core$async$mix_$_state_machine__23038__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__23038__auto____1;
return cljs$core$async$mix_$_state_machine__23038__auto__;
})()
;})(switch__23037__auto__,c__23149__auto___24886,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__23151__auto__ = (function (){var statearr_24885 = f__23150__auto__.call(null);
(statearr_24885[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__23149__auto___24886);

return statearr_24885;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__23151__auto__);
});})(c__23149__auto___24886,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__20918__auto__ = (((p == null))?null:p);
var m__20919__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__20918__auto__)]);
if(!((m__20919__auto__ == null))){
return m__20919__auto__.call(null,p,v,ch,close_QMARK_);
} else {
var m__20919__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__20919__auto____$1 == null))){
return m__20919__auto____$1.call(null,p,v,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__20918__auto__ = (((p == null))?null:p);
var m__20919__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__20918__auto__)]);
if(!((m__20919__auto__ == null))){
return m__20919__auto__.call(null,p,v,ch);
} else {
var m__20919__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__20919__auto____$1 == null))){
return m__20919__auto____$1.call(null,p,v,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var args24935 = [];
var len__21363__auto___24938 = arguments.length;
var i__21364__auto___24939 = (0);
while(true){
if((i__21364__auto___24939 < len__21363__auto___24938)){
args24935.push((arguments[i__21364__auto___24939]));

var G__24940 = (i__21364__auto___24939 + (1));
i__21364__auto___24939 = G__24940;
continue;
} else {
}
break;
}

var G__24937 = args24935.length;
switch (G__24937) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args24935.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__20918__auto__ = (((p == null))?null:p);
var m__20919__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__20918__auto__)]);
if(!((m__20919__auto__ == null))){
return m__20919__auto__.call(null,p);
} else {
var m__20919__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__20919__auto____$1 == null))){
return m__20919__auto____$1.call(null,p);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__20918__auto__ = (((p == null))?null:p);
var m__20919__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__20918__auto__)]);
if(!((m__20919__auto__ == null))){
return m__20919__auto__.call(null,p,v);
} else {
var m__20919__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__20919__auto____$1 == null))){
return m__20919__auto____$1.call(null,p,v);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var args24943 = [];
var len__21363__auto___25068 = arguments.length;
var i__21364__auto___25069 = (0);
while(true){
if((i__21364__auto___25069 < len__21363__auto___25068)){
args24943.push((arguments[i__21364__auto___25069]));

var G__25070 = (i__21364__auto___25069 + (1));
i__21364__auto___25069 = G__25070;
continue;
} else {
}
break;
}

var G__24945 = args24943.length;
switch (G__24945) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args24943.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__20255__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__20255__auto__)){
return or__20255__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,((function (or__20255__auto__,mults){
return (function (p1__24942_SHARP_){
if(cljs.core.truth_(p1__24942_SHARP_.call(null,topic))){
return p1__24942_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__24942_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
});})(or__20255__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t_cljs$core$async24946 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async24946 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta24947){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta24947 = meta24947;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async24946.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_24948,meta24947__$1){
var self__ = this;
var _24948__$1 = this;
return (new cljs.core.async.t_cljs$core$async24946(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta24947__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async24946.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_24948){
var self__ = this;
var _24948__$1 = this;
return self__.meta24947;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async24946.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async24946.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async24946.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async24946.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async24946.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__4657__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__4657__auto__)){
var m = temp__4657__auto__;
return cljs.core.async.untap.call(null,m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async24946.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async24946.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async24946.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta24947","meta24947",-1940816570,null)], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async24946.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async24946.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async24946";

cljs.core.async.t_cljs$core$async24946.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__20861__auto__,writer__20862__auto__,opt__20863__auto__){
return cljs.core._write.call(null,writer__20862__auto__,"cljs.core.async/t_cljs$core$async24946");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t_cljs$core$async24946 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async24946(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta24947){
return (new cljs.core.async.t_cljs$core$async24946(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta24947));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async24946(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__23149__auto___25072 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__23149__auto___25072,mults,ensure_mult,p){
return (function (){
var f__23150__auto__ = (function (){var switch__23037__auto__ = ((function (c__23149__auto___25072,mults,ensure_mult,p){
return (function (state_25020){
var state_val_25021 = (state_25020[(1)]);
if((state_val_25021 === (7))){
var inst_25016 = (state_25020[(2)]);
var state_25020__$1 = state_25020;
var statearr_25022_25073 = state_25020__$1;
(statearr_25022_25073[(2)] = inst_25016);

(statearr_25022_25073[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25021 === (20))){
var state_25020__$1 = state_25020;
var statearr_25023_25074 = state_25020__$1;
(statearr_25023_25074[(2)] = null);

(statearr_25023_25074[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25021 === (1))){
var state_25020__$1 = state_25020;
var statearr_25024_25075 = state_25020__$1;
(statearr_25024_25075[(2)] = null);

(statearr_25024_25075[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25021 === (24))){
var inst_24999 = (state_25020[(7)]);
var inst_25008 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_24999);
var state_25020__$1 = state_25020;
var statearr_25025_25076 = state_25020__$1;
(statearr_25025_25076[(2)] = inst_25008);

(statearr_25025_25076[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25021 === (4))){
var inst_24951 = (state_25020[(8)]);
var inst_24951__$1 = (state_25020[(2)]);
var inst_24952 = (inst_24951__$1 == null);
var state_25020__$1 = (function (){var statearr_25026 = state_25020;
(statearr_25026[(8)] = inst_24951__$1);

return statearr_25026;
})();
if(cljs.core.truth_(inst_24952)){
var statearr_25027_25077 = state_25020__$1;
(statearr_25027_25077[(1)] = (5));

} else {
var statearr_25028_25078 = state_25020__$1;
(statearr_25028_25078[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25021 === (15))){
var inst_24993 = (state_25020[(2)]);
var state_25020__$1 = state_25020;
var statearr_25029_25079 = state_25020__$1;
(statearr_25029_25079[(2)] = inst_24993);

(statearr_25029_25079[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25021 === (21))){
var inst_25013 = (state_25020[(2)]);
var state_25020__$1 = (function (){var statearr_25030 = state_25020;
(statearr_25030[(9)] = inst_25013);

return statearr_25030;
})();
var statearr_25031_25080 = state_25020__$1;
(statearr_25031_25080[(2)] = null);

(statearr_25031_25080[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25021 === (13))){
var inst_24975 = (state_25020[(10)]);
var inst_24977 = cljs.core.chunked_seq_QMARK_.call(null,inst_24975);
var state_25020__$1 = state_25020;
if(inst_24977){
var statearr_25032_25081 = state_25020__$1;
(statearr_25032_25081[(1)] = (16));

} else {
var statearr_25033_25082 = state_25020__$1;
(statearr_25033_25082[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25021 === (22))){
var inst_25005 = (state_25020[(2)]);
var state_25020__$1 = state_25020;
if(cljs.core.truth_(inst_25005)){
var statearr_25034_25083 = state_25020__$1;
(statearr_25034_25083[(1)] = (23));

} else {
var statearr_25035_25084 = state_25020__$1;
(statearr_25035_25084[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25021 === (6))){
var inst_24999 = (state_25020[(7)]);
var inst_24951 = (state_25020[(8)]);
var inst_25001 = (state_25020[(11)]);
var inst_24999__$1 = topic_fn.call(null,inst_24951);
var inst_25000 = cljs.core.deref.call(null,mults);
var inst_25001__$1 = cljs.core.get.call(null,inst_25000,inst_24999__$1);
var state_25020__$1 = (function (){var statearr_25036 = state_25020;
(statearr_25036[(7)] = inst_24999__$1);

(statearr_25036[(11)] = inst_25001__$1);

return statearr_25036;
})();
if(cljs.core.truth_(inst_25001__$1)){
var statearr_25037_25085 = state_25020__$1;
(statearr_25037_25085[(1)] = (19));

} else {
var statearr_25038_25086 = state_25020__$1;
(statearr_25038_25086[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25021 === (25))){
var inst_25010 = (state_25020[(2)]);
var state_25020__$1 = state_25020;
var statearr_25039_25087 = state_25020__$1;
(statearr_25039_25087[(2)] = inst_25010);

(statearr_25039_25087[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25021 === (17))){
var inst_24975 = (state_25020[(10)]);
var inst_24984 = cljs.core.first.call(null,inst_24975);
var inst_24985 = cljs.core.async.muxch_STAR_.call(null,inst_24984);
var inst_24986 = cljs.core.async.close_BANG_.call(null,inst_24985);
var inst_24987 = cljs.core.next.call(null,inst_24975);
var inst_24961 = inst_24987;
var inst_24962 = null;
var inst_24963 = (0);
var inst_24964 = (0);
var state_25020__$1 = (function (){var statearr_25040 = state_25020;
(statearr_25040[(12)] = inst_24963);

(statearr_25040[(13)] = inst_24962);

(statearr_25040[(14)] = inst_24961);

(statearr_25040[(15)] = inst_24986);

(statearr_25040[(16)] = inst_24964);

return statearr_25040;
})();
var statearr_25041_25088 = state_25020__$1;
(statearr_25041_25088[(2)] = null);

(statearr_25041_25088[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25021 === (3))){
var inst_25018 = (state_25020[(2)]);
var state_25020__$1 = state_25020;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25020__$1,inst_25018);
} else {
if((state_val_25021 === (12))){
var inst_24995 = (state_25020[(2)]);
var state_25020__$1 = state_25020;
var statearr_25042_25089 = state_25020__$1;
(statearr_25042_25089[(2)] = inst_24995);

(statearr_25042_25089[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25021 === (2))){
var state_25020__$1 = state_25020;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25020__$1,(4),ch);
} else {
if((state_val_25021 === (23))){
var state_25020__$1 = state_25020;
var statearr_25043_25090 = state_25020__$1;
(statearr_25043_25090[(2)] = null);

(statearr_25043_25090[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25021 === (19))){
var inst_24951 = (state_25020[(8)]);
var inst_25001 = (state_25020[(11)]);
var inst_25003 = cljs.core.async.muxch_STAR_.call(null,inst_25001);
var state_25020__$1 = state_25020;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_25020__$1,(22),inst_25003,inst_24951);
} else {
if((state_val_25021 === (11))){
var inst_24961 = (state_25020[(14)]);
var inst_24975 = (state_25020[(10)]);
var inst_24975__$1 = cljs.core.seq.call(null,inst_24961);
var state_25020__$1 = (function (){var statearr_25044 = state_25020;
(statearr_25044[(10)] = inst_24975__$1);

return statearr_25044;
})();
if(inst_24975__$1){
var statearr_25045_25091 = state_25020__$1;
(statearr_25045_25091[(1)] = (13));

} else {
var statearr_25046_25092 = state_25020__$1;
(statearr_25046_25092[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25021 === (9))){
var inst_24997 = (state_25020[(2)]);
var state_25020__$1 = state_25020;
var statearr_25047_25093 = state_25020__$1;
(statearr_25047_25093[(2)] = inst_24997);

(statearr_25047_25093[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25021 === (5))){
var inst_24958 = cljs.core.deref.call(null,mults);
var inst_24959 = cljs.core.vals.call(null,inst_24958);
var inst_24960 = cljs.core.seq.call(null,inst_24959);
var inst_24961 = inst_24960;
var inst_24962 = null;
var inst_24963 = (0);
var inst_24964 = (0);
var state_25020__$1 = (function (){var statearr_25048 = state_25020;
(statearr_25048[(12)] = inst_24963);

(statearr_25048[(13)] = inst_24962);

(statearr_25048[(14)] = inst_24961);

(statearr_25048[(16)] = inst_24964);

return statearr_25048;
})();
var statearr_25049_25094 = state_25020__$1;
(statearr_25049_25094[(2)] = null);

(statearr_25049_25094[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25021 === (14))){
var state_25020__$1 = state_25020;
var statearr_25053_25095 = state_25020__$1;
(statearr_25053_25095[(2)] = null);

(statearr_25053_25095[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25021 === (16))){
var inst_24975 = (state_25020[(10)]);
var inst_24979 = cljs.core.chunk_first.call(null,inst_24975);
var inst_24980 = cljs.core.chunk_rest.call(null,inst_24975);
var inst_24981 = cljs.core.count.call(null,inst_24979);
var inst_24961 = inst_24980;
var inst_24962 = inst_24979;
var inst_24963 = inst_24981;
var inst_24964 = (0);
var state_25020__$1 = (function (){var statearr_25054 = state_25020;
(statearr_25054[(12)] = inst_24963);

(statearr_25054[(13)] = inst_24962);

(statearr_25054[(14)] = inst_24961);

(statearr_25054[(16)] = inst_24964);

return statearr_25054;
})();
var statearr_25055_25096 = state_25020__$1;
(statearr_25055_25096[(2)] = null);

(statearr_25055_25096[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25021 === (10))){
var inst_24963 = (state_25020[(12)]);
var inst_24962 = (state_25020[(13)]);
var inst_24961 = (state_25020[(14)]);
var inst_24964 = (state_25020[(16)]);
var inst_24969 = cljs.core._nth.call(null,inst_24962,inst_24964);
var inst_24970 = cljs.core.async.muxch_STAR_.call(null,inst_24969);
var inst_24971 = cljs.core.async.close_BANG_.call(null,inst_24970);
var inst_24972 = (inst_24964 + (1));
var tmp25050 = inst_24963;
var tmp25051 = inst_24962;
var tmp25052 = inst_24961;
var inst_24961__$1 = tmp25052;
var inst_24962__$1 = tmp25051;
var inst_24963__$1 = tmp25050;
var inst_24964__$1 = inst_24972;
var state_25020__$1 = (function (){var statearr_25056 = state_25020;
(statearr_25056[(12)] = inst_24963__$1);

(statearr_25056[(13)] = inst_24962__$1);

(statearr_25056[(14)] = inst_24961__$1);

(statearr_25056[(16)] = inst_24964__$1);

(statearr_25056[(17)] = inst_24971);

return statearr_25056;
})();
var statearr_25057_25097 = state_25020__$1;
(statearr_25057_25097[(2)] = null);

(statearr_25057_25097[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25021 === (18))){
var inst_24990 = (state_25020[(2)]);
var state_25020__$1 = state_25020;
var statearr_25058_25098 = state_25020__$1;
(statearr_25058_25098[(2)] = inst_24990);

(statearr_25058_25098[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25021 === (8))){
var inst_24963 = (state_25020[(12)]);
var inst_24964 = (state_25020[(16)]);
var inst_24966 = (inst_24964 < inst_24963);
var inst_24967 = inst_24966;
var state_25020__$1 = state_25020;
if(cljs.core.truth_(inst_24967)){
var statearr_25059_25099 = state_25020__$1;
(statearr_25059_25099[(1)] = (10));

} else {
var statearr_25060_25100 = state_25020__$1;
(statearr_25060_25100[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__23149__auto___25072,mults,ensure_mult,p))
;
return ((function (switch__23037__auto__,c__23149__auto___25072,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__23038__auto__ = null;
var cljs$core$async$state_machine__23038__auto____0 = (function (){
var statearr_25064 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25064[(0)] = cljs$core$async$state_machine__23038__auto__);

(statearr_25064[(1)] = (1));

return statearr_25064;
});
var cljs$core$async$state_machine__23038__auto____1 = (function (state_25020){
while(true){
var ret_value__23039__auto__ = (function (){try{while(true){
var result__23040__auto__ = switch__23037__auto__.call(null,state_25020);
if(cljs.core.keyword_identical_QMARK_.call(null,result__23040__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__23040__auto__;
}
break;
}
}catch (e25065){if((e25065 instanceof Object)){
var ex__23041__auto__ = e25065;
var statearr_25066_25101 = state_25020;
(statearr_25066_25101[(5)] = ex__23041__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_25020);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e25065;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__23039__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25102 = state_25020;
state_25020 = G__25102;
continue;
} else {
return ret_value__23039__auto__;
}
break;
}
});
cljs$core$async$state_machine__23038__auto__ = function(state_25020){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__23038__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__23038__auto____1.call(this,state_25020);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__23038__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__23038__auto____0;
cljs$core$async$state_machine__23038__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__23038__auto____1;
return cljs$core$async$state_machine__23038__auto__;
})()
;})(switch__23037__auto__,c__23149__auto___25072,mults,ensure_mult,p))
})();
var state__23151__auto__ = (function (){var statearr_25067 = f__23150__auto__.call(null);
(statearr_25067[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__23149__auto___25072);

return statearr_25067;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__23151__auto__);
});})(c__23149__auto___25072,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var args25103 = [];
var len__21363__auto___25106 = arguments.length;
var i__21364__auto___25107 = (0);
while(true){
if((i__21364__auto___25107 < len__21363__auto___25106)){
args25103.push((arguments[i__21364__auto___25107]));

var G__25108 = (i__21364__auto___25107 + (1));
i__21364__auto___25107 = G__25108;
continue;
} else {
}
break;
}

var G__25105 = args25103.length;
switch (G__25105) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args25103.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var args25110 = [];
var len__21363__auto___25113 = arguments.length;
var i__21364__auto___25114 = (0);
while(true){
if((i__21364__auto___25114 < len__21363__auto___25113)){
args25110.push((arguments[i__21364__auto___25114]));

var G__25115 = (i__21364__auto___25114 + (1));
i__21364__auto___25114 = G__25115;
continue;
} else {
}
break;
}

var G__25112 = args25110.length;
switch (G__25112) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args25110.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.call(null,p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var args25117 = [];
var len__21363__auto___25188 = arguments.length;
var i__21364__auto___25189 = (0);
while(true){
if((i__21364__auto___25189 < len__21363__auto___25188)){
args25117.push((arguments[i__21364__auto___25189]));

var G__25190 = (i__21364__auto___25189 + (1));
i__21364__auto___25189 = G__25190;
continue;
} else {
}
break;
}

var G__25119 = args25117.length;
switch (G__25119) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args25117.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.call(null,cnt));
var c__23149__auto___25192 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__23149__auto___25192,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__23150__auto__ = (function (){var switch__23037__auto__ = ((function (c__23149__auto___25192,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_25158){
var state_val_25159 = (state_25158[(1)]);
if((state_val_25159 === (7))){
var state_25158__$1 = state_25158;
var statearr_25160_25193 = state_25158__$1;
(statearr_25160_25193[(2)] = null);

(statearr_25160_25193[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25159 === (1))){
var state_25158__$1 = state_25158;
var statearr_25161_25194 = state_25158__$1;
(statearr_25161_25194[(2)] = null);

(statearr_25161_25194[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25159 === (4))){
var inst_25122 = (state_25158[(7)]);
var inst_25124 = (inst_25122 < cnt);
var state_25158__$1 = state_25158;
if(cljs.core.truth_(inst_25124)){
var statearr_25162_25195 = state_25158__$1;
(statearr_25162_25195[(1)] = (6));

} else {
var statearr_25163_25196 = state_25158__$1;
(statearr_25163_25196[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25159 === (15))){
var inst_25154 = (state_25158[(2)]);
var state_25158__$1 = state_25158;
var statearr_25164_25197 = state_25158__$1;
(statearr_25164_25197[(2)] = inst_25154);

(statearr_25164_25197[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25159 === (13))){
var inst_25147 = cljs.core.async.close_BANG_.call(null,out);
var state_25158__$1 = state_25158;
var statearr_25165_25198 = state_25158__$1;
(statearr_25165_25198[(2)] = inst_25147);

(statearr_25165_25198[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25159 === (6))){
var state_25158__$1 = state_25158;
var statearr_25166_25199 = state_25158__$1;
(statearr_25166_25199[(2)] = null);

(statearr_25166_25199[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25159 === (3))){
var inst_25156 = (state_25158[(2)]);
var state_25158__$1 = state_25158;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25158__$1,inst_25156);
} else {
if((state_val_25159 === (12))){
var inst_25144 = (state_25158[(8)]);
var inst_25144__$1 = (state_25158[(2)]);
var inst_25145 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_25144__$1);
var state_25158__$1 = (function (){var statearr_25167 = state_25158;
(statearr_25167[(8)] = inst_25144__$1);

return statearr_25167;
})();
if(cljs.core.truth_(inst_25145)){
var statearr_25168_25200 = state_25158__$1;
(statearr_25168_25200[(1)] = (13));

} else {
var statearr_25169_25201 = state_25158__$1;
(statearr_25169_25201[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25159 === (2))){
var inst_25121 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_25122 = (0);
var state_25158__$1 = (function (){var statearr_25170 = state_25158;
(statearr_25170[(9)] = inst_25121);

(statearr_25170[(7)] = inst_25122);

return statearr_25170;
})();
var statearr_25171_25202 = state_25158__$1;
(statearr_25171_25202[(2)] = null);

(statearr_25171_25202[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25159 === (11))){
var inst_25122 = (state_25158[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_25158,(10),Object,null,(9));
var inst_25131 = chs__$1.call(null,inst_25122);
var inst_25132 = done.call(null,inst_25122);
var inst_25133 = cljs.core.async.take_BANG_.call(null,inst_25131,inst_25132);
var state_25158__$1 = state_25158;
var statearr_25172_25203 = state_25158__$1;
(statearr_25172_25203[(2)] = inst_25133);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_25158__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25159 === (9))){
var inst_25122 = (state_25158[(7)]);
var inst_25135 = (state_25158[(2)]);
var inst_25136 = (inst_25122 + (1));
var inst_25122__$1 = inst_25136;
var state_25158__$1 = (function (){var statearr_25173 = state_25158;
(statearr_25173[(10)] = inst_25135);

(statearr_25173[(7)] = inst_25122__$1);

return statearr_25173;
})();
var statearr_25174_25204 = state_25158__$1;
(statearr_25174_25204[(2)] = null);

(statearr_25174_25204[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25159 === (5))){
var inst_25142 = (state_25158[(2)]);
var state_25158__$1 = (function (){var statearr_25175 = state_25158;
(statearr_25175[(11)] = inst_25142);

return statearr_25175;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25158__$1,(12),dchan);
} else {
if((state_val_25159 === (14))){
var inst_25144 = (state_25158[(8)]);
var inst_25149 = cljs.core.apply.call(null,f,inst_25144);
var state_25158__$1 = state_25158;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_25158__$1,(16),out,inst_25149);
} else {
if((state_val_25159 === (16))){
var inst_25151 = (state_25158[(2)]);
var state_25158__$1 = (function (){var statearr_25176 = state_25158;
(statearr_25176[(12)] = inst_25151);

return statearr_25176;
})();
var statearr_25177_25205 = state_25158__$1;
(statearr_25177_25205[(2)] = null);

(statearr_25177_25205[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25159 === (10))){
var inst_25126 = (state_25158[(2)]);
var inst_25127 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_25158__$1 = (function (){var statearr_25178 = state_25158;
(statearr_25178[(13)] = inst_25126);

return statearr_25178;
})();
var statearr_25179_25206 = state_25158__$1;
(statearr_25179_25206[(2)] = inst_25127);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_25158__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25159 === (8))){
var inst_25140 = (state_25158[(2)]);
var state_25158__$1 = state_25158;
var statearr_25180_25207 = state_25158__$1;
(statearr_25180_25207[(2)] = inst_25140);

(statearr_25180_25207[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__23149__auto___25192,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__23037__auto__,c__23149__auto___25192,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__23038__auto__ = null;
var cljs$core$async$state_machine__23038__auto____0 = (function (){
var statearr_25184 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25184[(0)] = cljs$core$async$state_machine__23038__auto__);

(statearr_25184[(1)] = (1));

return statearr_25184;
});
var cljs$core$async$state_machine__23038__auto____1 = (function (state_25158){
while(true){
var ret_value__23039__auto__ = (function (){try{while(true){
var result__23040__auto__ = switch__23037__auto__.call(null,state_25158);
if(cljs.core.keyword_identical_QMARK_.call(null,result__23040__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__23040__auto__;
}
break;
}
}catch (e25185){if((e25185 instanceof Object)){
var ex__23041__auto__ = e25185;
var statearr_25186_25208 = state_25158;
(statearr_25186_25208[(5)] = ex__23041__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_25158);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e25185;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__23039__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25209 = state_25158;
state_25158 = G__25209;
continue;
} else {
return ret_value__23039__auto__;
}
break;
}
});
cljs$core$async$state_machine__23038__auto__ = function(state_25158){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__23038__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__23038__auto____1.call(this,state_25158);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__23038__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__23038__auto____0;
cljs$core$async$state_machine__23038__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__23038__auto____1;
return cljs$core$async$state_machine__23038__auto__;
})()
;})(switch__23037__auto__,c__23149__auto___25192,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__23151__auto__ = (function (){var statearr_25187 = f__23150__auto__.call(null);
(statearr_25187[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__23149__auto___25192);

return statearr_25187;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__23151__auto__);
});})(c__23149__auto___25192,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var args25211 = [];
var len__21363__auto___25269 = arguments.length;
var i__21364__auto___25270 = (0);
while(true){
if((i__21364__auto___25270 < len__21363__auto___25269)){
args25211.push((arguments[i__21364__auto___25270]));

var G__25271 = (i__21364__auto___25270 + (1));
i__21364__auto___25270 = G__25271;
continue;
} else {
}
break;
}

var G__25213 = args25211.length;
switch (G__25213) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args25211.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__23149__auto___25273 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__23149__auto___25273,out){
return (function (){
var f__23150__auto__ = (function (){var switch__23037__auto__ = ((function (c__23149__auto___25273,out){
return (function (state_25245){
var state_val_25246 = (state_25245[(1)]);
if((state_val_25246 === (7))){
var inst_25225 = (state_25245[(7)]);
var inst_25224 = (state_25245[(8)]);
var inst_25224__$1 = (state_25245[(2)]);
var inst_25225__$1 = cljs.core.nth.call(null,inst_25224__$1,(0),null);
var inst_25226 = cljs.core.nth.call(null,inst_25224__$1,(1),null);
var inst_25227 = (inst_25225__$1 == null);
var state_25245__$1 = (function (){var statearr_25247 = state_25245;
(statearr_25247[(7)] = inst_25225__$1);

(statearr_25247[(8)] = inst_25224__$1);

(statearr_25247[(9)] = inst_25226);

return statearr_25247;
})();
if(cljs.core.truth_(inst_25227)){
var statearr_25248_25274 = state_25245__$1;
(statearr_25248_25274[(1)] = (8));

} else {
var statearr_25249_25275 = state_25245__$1;
(statearr_25249_25275[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25246 === (1))){
var inst_25214 = cljs.core.vec.call(null,chs);
var inst_25215 = inst_25214;
var state_25245__$1 = (function (){var statearr_25250 = state_25245;
(statearr_25250[(10)] = inst_25215);

return statearr_25250;
})();
var statearr_25251_25276 = state_25245__$1;
(statearr_25251_25276[(2)] = null);

(statearr_25251_25276[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25246 === (4))){
var inst_25215 = (state_25245[(10)]);
var state_25245__$1 = state_25245;
return cljs.core.async.ioc_alts_BANG_.call(null,state_25245__$1,(7),inst_25215);
} else {
if((state_val_25246 === (6))){
var inst_25241 = (state_25245[(2)]);
var state_25245__$1 = state_25245;
var statearr_25252_25277 = state_25245__$1;
(statearr_25252_25277[(2)] = inst_25241);

(statearr_25252_25277[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25246 === (3))){
var inst_25243 = (state_25245[(2)]);
var state_25245__$1 = state_25245;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25245__$1,inst_25243);
} else {
if((state_val_25246 === (2))){
var inst_25215 = (state_25245[(10)]);
var inst_25217 = cljs.core.count.call(null,inst_25215);
var inst_25218 = (inst_25217 > (0));
var state_25245__$1 = state_25245;
if(cljs.core.truth_(inst_25218)){
var statearr_25254_25278 = state_25245__$1;
(statearr_25254_25278[(1)] = (4));

} else {
var statearr_25255_25279 = state_25245__$1;
(statearr_25255_25279[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25246 === (11))){
var inst_25215 = (state_25245[(10)]);
var inst_25234 = (state_25245[(2)]);
var tmp25253 = inst_25215;
var inst_25215__$1 = tmp25253;
var state_25245__$1 = (function (){var statearr_25256 = state_25245;
(statearr_25256[(11)] = inst_25234);

(statearr_25256[(10)] = inst_25215__$1);

return statearr_25256;
})();
var statearr_25257_25280 = state_25245__$1;
(statearr_25257_25280[(2)] = null);

(statearr_25257_25280[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25246 === (9))){
var inst_25225 = (state_25245[(7)]);
var state_25245__$1 = state_25245;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_25245__$1,(11),out,inst_25225);
} else {
if((state_val_25246 === (5))){
var inst_25239 = cljs.core.async.close_BANG_.call(null,out);
var state_25245__$1 = state_25245;
var statearr_25258_25281 = state_25245__$1;
(statearr_25258_25281[(2)] = inst_25239);

(statearr_25258_25281[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25246 === (10))){
var inst_25237 = (state_25245[(2)]);
var state_25245__$1 = state_25245;
var statearr_25259_25282 = state_25245__$1;
(statearr_25259_25282[(2)] = inst_25237);

(statearr_25259_25282[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25246 === (8))){
var inst_25225 = (state_25245[(7)]);
var inst_25224 = (state_25245[(8)]);
var inst_25226 = (state_25245[(9)]);
var inst_25215 = (state_25245[(10)]);
var inst_25229 = (function (){var cs = inst_25215;
var vec__25220 = inst_25224;
var v = inst_25225;
var c = inst_25226;
return ((function (cs,vec__25220,v,c,inst_25225,inst_25224,inst_25226,inst_25215,state_val_25246,c__23149__auto___25273,out){
return (function (p1__25210_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__25210_SHARP_);
});
;})(cs,vec__25220,v,c,inst_25225,inst_25224,inst_25226,inst_25215,state_val_25246,c__23149__auto___25273,out))
})();
var inst_25230 = cljs.core.filterv.call(null,inst_25229,inst_25215);
var inst_25215__$1 = inst_25230;
var state_25245__$1 = (function (){var statearr_25260 = state_25245;
(statearr_25260[(10)] = inst_25215__$1);

return statearr_25260;
})();
var statearr_25261_25283 = state_25245__$1;
(statearr_25261_25283[(2)] = null);

(statearr_25261_25283[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__23149__auto___25273,out))
;
return ((function (switch__23037__auto__,c__23149__auto___25273,out){
return (function() {
var cljs$core$async$state_machine__23038__auto__ = null;
var cljs$core$async$state_machine__23038__auto____0 = (function (){
var statearr_25265 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25265[(0)] = cljs$core$async$state_machine__23038__auto__);

(statearr_25265[(1)] = (1));

return statearr_25265;
});
var cljs$core$async$state_machine__23038__auto____1 = (function (state_25245){
while(true){
var ret_value__23039__auto__ = (function (){try{while(true){
var result__23040__auto__ = switch__23037__auto__.call(null,state_25245);
if(cljs.core.keyword_identical_QMARK_.call(null,result__23040__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__23040__auto__;
}
break;
}
}catch (e25266){if((e25266 instanceof Object)){
var ex__23041__auto__ = e25266;
var statearr_25267_25284 = state_25245;
(statearr_25267_25284[(5)] = ex__23041__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_25245);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e25266;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__23039__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25285 = state_25245;
state_25245 = G__25285;
continue;
} else {
return ret_value__23039__auto__;
}
break;
}
});
cljs$core$async$state_machine__23038__auto__ = function(state_25245){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__23038__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__23038__auto____1.call(this,state_25245);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__23038__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__23038__auto____0;
cljs$core$async$state_machine__23038__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__23038__auto____1;
return cljs$core$async$state_machine__23038__auto__;
})()
;})(switch__23037__auto__,c__23149__auto___25273,out))
})();
var state__23151__auto__ = (function (){var statearr_25268 = f__23150__auto__.call(null);
(statearr_25268[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__23149__auto___25273);

return statearr_25268;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__23151__auto__);
});})(c__23149__auto___25273,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var args25286 = [];
var len__21363__auto___25335 = arguments.length;
var i__21364__auto___25336 = (0);
while(true){
if((i__21364__auto___25336 < len__21363__auto___25335)){
args25286.push((arguments[i__21364__auto___25336]));

var G__25337 = (i__21364__auto___25336 + (1));
i__21364__auto___25336 = G__25337;
continue;
} else {
}
break;
}

var G__25288 = args25286.length;
switch (G__25288) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args25286.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__23149__auto___25339 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__23149__auto___25339,out){
return (function (){
var f__23150__auto__ = (function (){var switch__23037__auto__ = ((function (c__23149__auto___25339,out){
return (function (state_25312){
var state_val_25313 = (state_25312[(1)]);
if((state_val_25313 === (7))){
var inst_25294 = (state_25312[(7)]);
var inst_25294__$1 = (state_25312[(2)]);
var inst_25295 = (inst_25294__$1 == null);
var inst_25296 = cljs.core.not.call(null,inst_25295);
var state_25312__$1 = (function (){var statearr_25314 = state_25312;
(statearr_25314[(7)] = inst_25294__$1);

return statearr_25314;
})();
if(inst_25296){
var statearr_25315_25340 = state_25312__$1;
(statearr_25315_25340[(1)] = (8));

} else {
var statearr_25316_25341 = state_25312__$1;
(statearr_25316_25341[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25313 === (1))){
var inst_25289 = (0);
var state_25312__$1 = (function (){var statearr_25317 = state_25312;
(statearr_25317[(8)] = inst_25289);

return statearr_25317;
})();
var statearr_25318_25342 = state_25312__$1;
(statearr_25318_25342[(2)] = null);

(statearr_25318_25342[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25313 === (4))){
var state_25312__$1 = state_25312;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25312__$1,(7),ch);
} else {
if((state_val_25313 === (6))){
var inst_25307 = (state_25312[(2)]);
var state_25312__$1 = state_25312;
var statearr_25319_25343 = state_25312__$1;
(statearr_25319_25343[(2)] = inst_25307);

(statearr_25319_25343[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25313 === (3))){
var inst_25309 = (state_25312[(2)]);
var inst_25310 = cljs.core.async.close_BANG_.call(null,out);
var state_25312__$1 = (function (){var statearr_25320 = state_25312;
(statearr_25320[(9)] = inst_25309);

return statearr_25320;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25312__$1,inst_25310);
} else {
if((state_val_25313 === (2))){
var inst_25289 = (state_25312[(8)]);
var inst_25291 = (inst_25289 < n);
var state_25312__$1 = state_25312;
if(cljs.core.truth_(inst_25291)){
var statearr_25321_25344 = state_25312__$1;
(statearr_25321_25344[(1)] = (4));

} else {
var statearr_25322_25345 = state_25312__$1;
(statearr_25322_25345[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25313 === (11))){
var inst_25289 = (state_25312[(8)]);
var inst_25299 = (state_25312[(2)]);
var inst_25300 = (inst_25289 + (1));
var inst_25289__$1 = inst_25300;
var state_25312__$1 = (function (){var statearr_25323 = state_25312;
(statearr_25323[(8)] = inst_25289__$1);

(statearr_25323[(10)] = inst_25299);

return statearr_25323;
})();
var statearr_25324_25346 = state_25312__$1;
(statearr_25324_25346[(2)] = null);

(statearr_25324_25346[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25313 === (9))){
var state_25312__$1 = state_25312;
var statearr_25325_25347 = state_25312__$1;
(statearr_25325_25347[(2)] = null);

(statearr_25325_25347[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25313 === (5))){
var state_25312__$1 = state_25312;
var statearr_25326_25348 = state_25312__$1;
(statearr_25326_25348[(2)] = null);

(statearr_25326_25348[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25313 === (10))){
var inst_25304 = (state_25312[(2)]);
var state_25312__$1 = state_25312;
var statearr_25327_25349 = state_25312__$1;
(statearr_25327_25349[(2)] = inst_25304);

(statearr_25327_25349[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25313 === (8))){
var inst_25294 = (state_25312[(7)]);
var state_25312__$1 = state_25312;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_25312__$1,(11),out,inst_25294);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__23149__auto___25339,out))
;
return ((function (switch__23037__auto__,c__23149__auto___25339,out){
return (function() {
var cljs$core$async$state_machine__23038__auto__ = null;
var cljs$core$async$state_machine__23038__auto____0 = (function (){
var statearr_25331 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_25331[(0)] = cljs$core$async$state_machine__23038__auto__);

(statearr_25331[(1)] = (1));

return statearr_25331;
});
var cljs$core$async$state_machine__23038__auto____1 = (function (state_25312){
while(true){
var ret_value__23039__auto__ = (function (){try{while(true){
var result__23040__auto__ = switch__23037__auto__.call(null,state_25312);
if(cljs.core.keyword_identical_QMARK_.call(null,result__23040__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__23040__auto__;
}
break;
}
}catch (e25332){if((e25332 instanceof Object)){
var ex__23041__auto__ = e25332;
var statearr_25333_25350 = state_25312;
(statearr_25333_25350[(5)] = ex__23041__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_25312);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e25332;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__23039__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25351 = state_25312;
state_25312 = G__25351;
continue;
} else {
return ret_value__23039__auto__;
}
break;
}
});
cljs$core$async$state_machine__23038__auto__ = function(state_25312){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__23038__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__23038__auto____1.call(this,state_25312);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__23038__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__23038__auto____0;
cljs$core$async$state_machine__23038__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__23038__auto____1;
return cljs$core$async$state_machine__23038__auto__;
})()
;})(switch__23037__auto__,c__23149__auto___25339,out))
})();
var state__23151__auto__ = (function (){var statearr_25334 = f__23150__auto__.call(null);
(statearr_25334[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__23149__auto___25339);

return statearr_25334;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__23151__auto__);
});})(c__23149__auto___25339,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async25359 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async25359 = (function (f,ch,meta25360){
this.f = f;
this.ch = ch;
this.meta25360 = meta25360;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async25359.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_25361,meta25360__$1){
var self__ = this;
var _25361__$1 = this;
return (new cljs.core.async.t_cljs$core$async25359(self__.f,self__.ch,meta25360__$1));
});

cljs.core.async.t_cljs$core$async25359.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_25361){
var self__ = this;
var _25361__$1 = this;
return self__.meta25360;
});

cljs.core.async.t_cljs$core$async25359.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async25359.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async25359.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async25359.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async25359.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){
if(typeof cljs.core.async.t_cljs$core$async25362 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async25362 = (function (f,ch,meta25360,_,fn1,meta25363){
this.f = f;
this.ch = ch;
this.meta25360 = meta25360;
this._ = _;
this.fn1 = fn1;
this.meta25363 = meta25363;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async25362.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_25364,meta25363__$1){
var self__ = this;
var _25364__$1 = this;
return (new cljs.core.async.t_cljs$core$async25362(self__.f,self__.ch,self__.meta25360,self__._,self__.fn1,meta25363__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async25362.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_25364){
var self__ = this;
var _25364__$1 = this;
return self__.meta25363;
});})(___$1))
;

cljs.core.async.t_cljs$core$async25362.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async25362.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async25362.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;

cljs.core.async.t_cljs$core$async25362.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__25352_SHARP_){
return f1.call(null,(((p1__25352_SHARP_ == null))?null:self__.f.call(null,p1__25352_SHARP_)));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async25362.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta25360","meta25360",294511137,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async25359","cljs.core.async/t_cljs$core$async25359",1878733926,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta25363","meta25363",356881096,null)], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async25362.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async25362.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async25362";

cljs.core.async.t_cljs$core$async25362.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__20861__auto__,writer__20862__auto__,opt__20863__auto__){
return cljs.core._write.call(null,writer__20862__auto__,"cljs.core.async/t_cljs$core$async25362");
});})(___$1))
;

cljs.core.async.__GT_t_cljs$core$async25362 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async25362(f__$1,ch__$1,meta25360__$1,___$2,fn1__$1,meta25363){
return (new cljs.core.async.t_cljs$core$async25362(f__$1,ch__$1,meta25360__$1,___$2,fn1__$1,meta25363));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async25362(self__.f,self__.ch,self__.meta25360,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__20243__auto__ = ret;
if(cljs.core.truth_(and__20243__auto__)){
return !((cljs.core.deref.call(null,ret) == null));
} else {
return and__20243__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async25359.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async25359.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async25359.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta25360","meta25360",294511137,null)], null);
});

cljs.core.async.t_cljs$core$async25359.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async25359.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async25359";

cljs.core.async.t_cljs$core$async25359.cljs$lang$ctorPrWriter = (function (this__20861__auto__,writer__20862__auto__,opt__20863__auto__){
return cljs.core._write.call(null,writer__20862__auto__,"cljs.core.async/t_cljs$core$async25359");
});

cljs.core.async.__GT_t_cljs$core$async25359 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async25359(f__$1,ch__$1,meta25360){
return (new cljs.core.async.t_cljs$core$async25359(f__$1,ch__$1,meta25360));
});

}

return (new cljs.core.async.t_cljs$core$async25359(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async25368 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async25368 = (function (f,ch,meta25369){
this.f = f;
this.ch = ch;
this.meta25369 = meta25369;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async25368.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_25370,meta25369__$1){
var self__ = this;
var _25370__$1 = this;
return (new cljs.core.async.t_cljs$core$async25368(self__.f,self__.ch,meta25369__$1));
});

cljs.core.async.t_cljs$core$async25368.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_25370){
var self__ = this;
var _25370__$1 = this;
return self__.meta25369;
});

cljs.core.async.t_cljs$core$async25368.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async25368.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async25368.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async25368.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async25368.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async25368.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
});

cljs.core.async.t_cljs$core$async25368.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta25369","meta25369",-559861901,null)], null);
});

cljs.core.async.t_cljs$core$async25368.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async25368.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async25368";

cljs.core.async.t_cljs$core$async25368.cljs$lang$ctorPrWriter = (function (this__20861__auto__,writer__20862__auto__,opt__20863__auto__){
return cljs.core._write.call(null,writer__20862__auto__,"cljs.core.async/t_cljs$core$async25368");
});

cljs.core.async.__GT_t_cljs$core$async25368 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async25368(f__$1,ch__$1,meta25369){
return (new cljs.core.async.t_cljs$core$async25368(f__$1,ch__$1,meta25369));
});

}

return (new cljs.core.async.t_cljs$core$async25368(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t_cljs$core$async25374 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async25374 = (function (p,ch,meta25375){
this.p = p;
this.ch = ch;
this.meta25375 = meta25375;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async25374.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_25376,meta25375__$1){
var self__ = this;
var _25376__$1 = this;
return (new cljs.core.async.t_cljs$core$async25374(self__.p,self__.ch,meta25375__$1));
});

cljs.core.async.t_cljs$core$async25374.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_25376){
var self__ = this;
var _25376__$1 = this;
return self__.meta25375;
});

cljs.core.async.t_cljs$core$async25374.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async25374.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async25374.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async25374.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async25374.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async25374.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async25374.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
});

cljs.core.async.t_cljs$core$async25374.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta25375","meta25375",485912227,null)], null);
});

cljs.core.async.t_cljs$core$async25374.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async25374.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async25374";

cljs.core.async.t_cljs$core$async25374.cljs$lang$ctorPrWriter = (function (this__20861__auto__,writer__20862__auto__,opt__20863__auto__){
return cljs.core._write.call(null,writer__20862__auto__,"cljs.core.async/t_cljs$core$async25374");
});

cljs.core.async.__GT_t_cljs$core$async25374 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async25374(p__$1,ch__$1,meta25375){
return (new cljs.core.async.t_cljs$core$async25374(p__$1,ch__$1,meta25375));
});

}

return (new cljs.core.async.t_cljs$core$async25374(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var args25377 = [];
var len__21363__auto___25421 = arguments.length;
var i__21364__auto___25422 = (0);
while(true){
if((i__21364__auto___25422 < len__21363__auto___25421)){
args25377.push((arguments[i__21364__auto___25422]));

var G__25423 = (i__21364__auto___25422 + (1));
i__21364__auto___25422 = G__25423;
continue;
} else {
}
break;
}

var G__25379 = args25377.length;
switch (G__25379) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args25377.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__23149__auto___25425 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__23149__auto___25425,out){
return (function (){
var f__23150__auto__ = (function (){var switch__23037__auto__ = ((function (c__23149__auto___25425,out){
return (function (state_25400){
var state_val_25401 = (state_25400[(1)]);
if((state_val_25401 === (7))){
var inst_25396 = (state_25400[(2)]);
var state_25400__$1 = state_25400;
var statearr_25402_25426 = state_25400__$1;
(statearr_25402_25426[(2)] = inst_25396);

(statearr_25402_25426[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25401 === (1))){
var state_25400__$1 = state_25400;
var statearr_25403_25427 = state_25400__$1;
(statearr_25403_25427[(2)] = null);

(statearr_25403_25427[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25401 === (4))){
var inst_25382 = (state_25400[(7)]);
var inst_25382__$1 = (state_25400[(2)]);
var inst_25383 = (inst_25382__$1 == null);
var state_25400__$1 = (function (){var statearr_25404 = state_25400;
(statearr_25404[(7)] = inst_25382__$1);

return statearr_25404;
})();
if(cljs.core.truth_(inst_25383)){
var statearr_25405_25428 = state_25400__$1;
(statearr_25405_25428[(1)] = (5));

} else {
var statearr_25406_25429 = state_25400__$1;
(statearr_25406_25429[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25401 === (6))){
var inst_25382 = (state_25400[(7)]);
var inst_25387 = p.call(null,inst_25382);
var state_25400__$1 = state_25400;
if(cljs.core.truth_(inst_25387)){
var statearr_25407_25430 = state_25400__$1;
(statearr_25407_25430[(1)] = (8));

} else {
var statearr_25408_25431 = state_25400__$1;
(statearr_25408_25431[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25401 === (3))){
var inst_25398 = (state_25400[(2)]);
var state_25400__$1 = state_25400;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25400__$1,inst_25398);
} else {
if((state_val_25401 === (2))){
var state_25400__$1 = state_25400;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25400__$1,(4),ch);
} else {
if((state_val_25401 === (11))){
var inst_25390 = (state_25400[(2)]);
var state_25400__$1 = state_25400;
var statearr_25409_25432 = state_25400__$1;
(statearr_25409_25432[(2)] = inst_25390);

(statearr_25409_25432[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25401 === (9))){
var state_25400__$1 = state_25400;
var statearr_25410_25433 = state_25400__$1;
(statearr_25410_25433[(2)] = null);

(statearr_25410_25433[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25401 === (5))){
var inst_25385 = cljs.core.async.close_BANG_.call(null,out);
var state_25400__$1 = state_25400;
var statearr_25411_25434 = state_25400__$1;
(statearr_25411_25434[(2)] = inst_25385);

(statearr_25411_25434[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25401 === (10))){
var inst_25393 = (state_25400[(2)]);
var state_25400__$1 = (function (){var statearr_25412 = state_25400;
(statearr_25412[(8)] = inst_25393);

return statearr_25412;
})();
var statearr_25413_25435 = state_25400__$1;
(statearr_25413_25435[(2)] = null);

(statearr_25413_25435[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25401 === (8))){
var inst_25382 = (state_25400[(7)]);
var state_25400__$1 = state_25400;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_25400__$1,(11),out,inst_25382);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__23149__auto___25425,out))
;
return ((function (switch__23037__auto__,c__23149__auto___25425,out){
return (function() {
var cljs$core$async$state_machine__23038__auto__ = null;
var cljs$core$async$state_machine__23038__auto____0 = (function (){
var statearr_25417 = [null,null,null,null,null,null,null,null,null];
(statearr_25417[(0)] = cljs$core$async$state_machine__23038__auto__);

(statearr_25417[(1)] = (1));

return statearr_25417;
});
var cljs$core$async$state_machine__23038__auto____1 = (function (state_25400){
while(true){
var ret_value__23039__auto__ = (function (){try{while(true){
var result__23040__auto__ = switch__23037__auto__.call(null,state_25400);
if(cljs.core.keyword_identical_QMARK_.call(null,result__23040__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__23040__auto__;
}
break;
}
}catch (e25418){if((e25418 instanceof Object)){
var ex__23041__auto__ = e25418;
var statearr_25419_25436 = state_25400;
(statearr_25419_25436[(5)] = ex__23041__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_25400);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e25418;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__23039__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25437 = state_25400;
state_25400 = G__25437;
continue;
} else {
return ret_value__23039__auto__;
}
break;
}
});
cljs$core$async$state_machine__23038__auto__ = function(state_25400){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__23038__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__23038__auto____1.call(this,state_25400);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__23038__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__23038__auto____0;
cljs$core$async$state_machine__23038__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__23038__auto____1;
return cljs$core$async$state_machine__23038__auto__;
})()
;})(switch__23037__auto__,c__23149__auto___25425,out))
})();
var state__23151__auto__ = (function (){var statearr_25420 = f__23150__auto__.call(null);
(statearr_25420[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__23149__auto___25425);

return statearr_25420;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__23151__auto__);
});})(c__23149__auto___25425,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var args25438 = [];
var len__21363__auto___25441 = arguments.length;
var i__21364__auto___25442 = (0);
while(true){
if((i__21364__auto___25442 < len__21363__auto___25441)){
args25438.push((arguments[i__21364__auto___25442]));

var G__25443 = (i__21364__auto___25442 + (1));
i__21364__auto___25442 = G__25443;
continue;
} else {
}
break;
}

var G__25440 = args25438.length;
switch (G__25440) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args25438.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__23149__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__23149__auto__){
return (function (){
var f__23150__auto__ = (function (){var switch__23037__auto__ = ((function (c__23149__auto__){
return (function (state_25610){
var state_val_25611 = (state_25610[(1)]);
if((state_val_25611 === (7))){
var inst_25606 = (state_25610[(2)]);
var state_25610__$1 = state_25610;
var statearr_25612_25653 = state_25610__$1;
(statearr_25612_25653[(2)] = inst_25606);

(statearr_25612_25653[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25611 === (20))){
var inst_25576 = (state_25610[(7)]);
var inst_25587 = (state_25610[(2)]);
var inst_25588 = cljs.core.next.call(null,inst_25576);
var inst_25562 = inst_25588;
var inst_25563 = null;
var inst_25564 = (0);
var inst_25565 = (0);
var state_25610__$1 = (function (){var statearr_25613 = state_25610;
(statearr_25613[(8)] = inst_25587);

(statearr_25613[(9)] = inst_25562);

(statearr_25613[(10)] = inst_25564);

(statearr_25613[(11)] = inst_25565);

(statearr_25613[(12)] = inst_25563);

return statearr_25613;
})();
var statearr_25614_25654 = state_25610__$1;
(statearr_25614_25654[(2)] = null);

(statearr_25614_25654[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25611 === (1))){
var state_25610__$1 = state_25610;
var statearr_25615_25655 = state_25610__$1;
(statearr_25615_25655[(2)] = null);

(statearr_25615_25655[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25611 === (4))){
var inst_25551 = (state_25610[(13)]);
var inst_25551__$1 = (state_25610[(2)]);
var inst_25552 = (inst_25551__$1 == null);
var state_25610__$1 = (function (){var statearr_25616 = state_25610;
(statearr_25616[(13)] = inst_25551__$1);

return statearr_25616;
})();
if(cljs.core.truth_(inst_25552)){
var statearr_25617_25656 = state_25610__$1;
(statearr_25617_25656[(1)] = (5));

} else {
var statearr_25618_25657 = state_25610__$1;
(statearr_25618_25657[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25611 === (15))){
var state_25610__$1 = state_25610;
var statearr_25622_25658 = state_25610__$1;
(statearr_25622_25658[(2)] = null);

(statearr_25622_25658[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25611 === (21))){
var state_25610__$1 = state_25610;
var statearr_25623_25659 = state_25610__$1;
(statearr_25623_25659[(2)] = null);

(statearr_25623_25659[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25611 === (13))){
var inst_25562 = (state_25610[(9)]);
var inst_25564 = (state_25610[(10)]);
var inst_25565 = (state_25610[(11)]);
var inst_25563 = (state_25610[(12)]);
var inst_25572 = (state_25610[(2)]);
var inst_25573 = (inst_25565 + (1));
var tmp25619 = inst_25562;
var tmp25620 = inst_25564;
var tmp25621 = inst_25563;
var inst_25562__$1 = tmp25619;
var inst_25563__$1 = tmp25621;
var inst_25564__$1 = tmp25620;
var inst_25565__$1 = inst_25573;
var state_25610__$1 = (function (){var statearr_25624 = state_25610;
(statearr_25624[(9)] = inst_25562__$1);

(statearr_25624[(10)] = inst_25564__$1);

(statearr_25624[(14)] = inst_25572);

(statearr_25624[(11)] = inst_25565__$1);

(statearr_25624[(12)] = inst_25563__$1);

return statearr_25624;
})();
var statearr_25625_25660 = state_25610__$1;
(statearr_25625_25660[(2)] = null);

(statearr_25625_25660[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25611 === (22))){
var state_25610__$1 = state_25610;
var statearr_25626_25661 = state_25610__$1;
(statearr_25626_25661[(2)] = null);

(statearr_25626_25661[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25611 === (6))){
var inst_25551 = (state_25610[(13)]);
var inst_25560 = f.call(null,inst_25551);
var inst_25561 = cljs.core.seq.call(null,inst_25560);
var inst_25562 = inst_25561;
var inst_25563 = null;
var inst_25564 = (0);
var inst_25565 = (0);
var state_25610__$1 = (function (){var statearr_25627 = state_25610;
(statearr_25627[(9)] = inst_25562);

(statearr_25627[(10)] = inst_25564);

(statearr_25627[(11)] = inst_25565);

(statearr_25627[(12)] = inst_25563);

return statearr_25627;
})();
var statearr_25628_25662 = state_25610__$1;
(statearr_25628_25662[(2)] = null);

(statearr_25628_25662[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25611 === (17))){
var inst_25576 = (state_25610[(7)]);
var inst_25580 = cljs.core.chunk_first.call(null,inst_25576);
var inst_25581 = cljs.core.chunk_rest.call(null,inst_25576);
var inst_25582 = cljs.core.count.call(null,inst_25580);
var inst_25562 = inst_25581;
var inst_25563 = inst_25580;
var inst_25564 = inst_25582;
var inst_25565 = (0);
var state_25610__$1 = (function (){var statearr_25629 = state_25610;
(statearr_25629[(9)] = inst_25562);

(statearr_25629[(10)] = inst_25564);

(statearr_25629[(11)] = inst_25565);

(statearr_25629[(12)] = inst_25563);

return statearr_25629;
})();
var statearr_25630_25663 = state_25610__$1;
(statearr_25630_25663[(2)] = null);

(statearr_25630_25663[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25611 === (3))){
var inst_25608 = (state_25610[(2)]);
var state_25610__$1 = state_25610;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25610__$1,inst_25608);
} else {
if((state_val_25611 === (12))){
var inst_25596 = (state_25610[(2)]);
var state_25610__$1 = state_25610;
var statearr_25631_25664 = state_25610__$1;
(statearr_25631_25664[(2)] = inst_25596);

(statearr_25631_25664[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25611 === (2))){
var state_25610__$1 = state_25610;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25610__$1,(4),in$);
} else {
if((state_val_25611 === (23))){
var inst_25604 = (state_25610[(2)]);
var state_25610__$1 = state_25610;
var statearr_25632_25665 = state_25610__$1;
(statearr_25632_25665[(2)] = inst_25604);

(statearr_25632_25665[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25611 === (19))){
var inst_25591 = (state_25610[(2)]);
var state_25610__$1 = state_25610;
var statearr_25633_25666 = state_25610__$1;
(statearr_25633_25666[(2)] = inst_25591);

(statearr_25633_25666[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25611 === (11))){
var inst_25562 = (state_25610[(9)]);
var inst_25576 = (state_25610[(7)]);
var inst_25576__$1 = cljs.core.seq.call(null,inst_25562);
var state_25610__$1 = (function (){var statearr_25634 = state_25610;
(statearr_25634[(7)] = inst_25576__$1);

return statearr_25634;
})();
if(inst_25576__$1){
var statearr_25635_25667 = state_25610__$1;
(statearr_25635_25667[(1)] = (14));

} else {
var statearr_25636_25668 = state_25610__$1;
(statearr_25636_25668[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25611 === (9))){
var inst_25598 = (state_25610[(2)]);
var inst_25599 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);
var state_25610__$1 = (function (){var statearr_25637 = state_25610;
(statearr_25637[(15)] = inst_25598);

return statearr_25637;
})();
if(cljs.core.truth_(inst_25599)){
var statearr_25638_25669 = state_25610__$1;
(statearr_25638_25669[(1)] = (21));

} else {
var statearr_25639_25670 = state_25610__$1;
(statearr_25639_25670[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25611 === (5))){
var inst_25554 = cljs.core.async.close_BANG_.call(null,out);
var state_25610__$1 = state_25610;
var statearr_25640_25671 = state_25610__$1;
(statearr_25640_25671[(2)] = inst_25554);

(statearr_25640_25671[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25611 === (14))){
var inst_25576 = (state_25610[(7)]);
var inst_25578 = cljs.core.chunked_seq_QMARK_.call(null,inst_25576);
var state_25610__$1 = state_25610;
if(inst_25578){
var statearr_25641_25672 = state_25610__$1;
(statearr_25641_25672[(1)] = (17));

} else {
var statearr_25642_25673 = state_25610__$1;
(statearr_25642_25673[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25611 === (16))){
var inst_25594 = (state_25610[(2)]);
var state_25610__$1 = state_25610;
var statearr_25643_25674 = state_25610__$1;
(statearr_25643_25674[(2)] = inst_25594);

(statearr_25643_25674[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25611 === (10))){
var inst_25565 = (state_25610[(11)]);
var inst_25563 = (state_25610[(12)]);
var inst_25570 = cljs.core._nth.call(null,inst_25563,inst_25565);
var state_25610__$1 = state_25610;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_25610__$1,(13),out,inst_25570);
} else {
if((state_val_25611 === (18))){
var inst_25576 = (state_25610[(7)]);
var inst_25585 = cljs.core.first.call(null,inst_25576);
var state_25610__$1 = state_25610;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_25610__$1,(20),out,inst_25585);
} else {
if((state_val_25611 === (8))){
var inst_25564 = (state_25610[(10)]);
var inst_25565 = (state_25610[(11)]);
var inst_25567 = (inst_25565 < inst_25564);
var inst_25568 = inst_25567;
var state_25610__$1 = state_25610;
if(cljs.core.truth_(inst_25568)){
var statearr_25644_25675 = state_25610__$1;
(statearr_25644_25675[(1)] = (10));

} else {
var statearr_25645_25676 = state_25610__$1;
(statearr_25645_25676[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__23149__auto__))
;
return ((function (switch__23037__auto__,c__23149__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__23038__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__23038__auto____0 = (function (){
var statearr_25649 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25649[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__23038__auto__);

(statearr_25649[(1)] = (1));

return statearr_25649;
});
var cljs$core$async$mapcat_STAR__$_state_machine__23038__auto____1 = (function (state_25610){
while(true){
var ret_value__23039__auto__ = (function (){try{while(true){
var result__23040__auto__ = switch__23037__auto__.call(null,state_25610);
if(cljs.core.keyword_identical_QMARK_.call(null,result__23040__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__23040__auto__;
}
break;
}
}catch (e25650){if((e25650 instanceof Object)){
var ex__23041__auto__ = e25650;
var statearr_25651_25677 = state_25610;
(statearr_25651_25677[(5)] = ex__23041__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_25610);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e25650;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__23039__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25678 = state_25610;
state_25610 = G__25678;
continue;
} else {
return ret_value__23039__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__23038__auto__ = function(state_25610){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__23038__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__23038__auto____1.call(this,state_25610);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__23038__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__23038__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__23038__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__23038__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__23038__auto__;
})()
;})(switch__23037__auto__,c__23149__auto__))
})();
var state__23151__auto__ = (function (){var statearr_25652 = f__23150__auto__.call(null);
(statearr_25652[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__23149__auto__);

return statearr_25652;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__23151__auto__);
});})(c__23149__auto__))
);

return c__23149__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var args25679 = [];
var len__21363__auto___25682 = arguments.length;
var i__21364__auto___25683 = (0);
while(true){
if((i__21364__auto___25683 < len__21363__auto___25682)){
args25679.push((arguments[i__21364__auto___25683]));

var G__25684 = (i__21364__auto___25683 + (1));
i__21364__auto___25683 = G__25684;
continue;
} else {
}
break;
}

var G__25681 = args25679.length;
switch (G__25681) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args25679.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var args25686 = [];
var len__21363__auto___25689 = arguments.length;
var i__21364__auto___25690 = (0);
while(true){
if((i__21364__auto___25690 < len__21363__auto___25689)){
args25686.push((arguments[i__21364__auto___25690]));

var G__25691 = (i__21364__auto___25690 + (1));
i__21364__auto___25690 = G__25691;
continue;
} else {
}
break;
}

var G__25688 = args25686.length;
switch (G__25688) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args25686.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var args25693 = [];
var len__21363__auto___25744 = arguments.length;
var i__21364__auto___25745 = (0);
while(true){
if((i__21364__auto___25745 < len__21363__auto___25744)){
args25693.push((arguments[i__21364__auto___25745]));

var G__25746 = (i__21364__auto___25745 + (1));
i__21364__auto___25745 = G__25746;
continue;
} else {
}
break;
}

var G__25695 = args25693.length;
switch (G__25695) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args25693.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__23149__auto___25748 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__23149__auto___25748,out){
return (function (){
var f__23150__auto__ = (function (){var switch__23037__auto__ = ((function (c__23149__auto___25748,out){
return (function (state_25719){
var state_val_25720 = (state_25719[(1)]);
if((state_val_25720 === (7))){
var inst_25714 = (state_25719[(2)]);
var state_25719__$1 = state_25719;
var statearr_25721_25749 = state_25719__$1;
(statearr_25721_25749[(2)] = inst_25714);

(statearr_25721_25749[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25720 === (1))){
var inst_25696 = null;
var state_25719__$1 = (function (){var statearr_25722 = state_25719;
(statearr_25722[(7)] = inst_25696);

return statearr_25722;
})();
var statearr_25723_25750 = state_25719__$1;
(statearr_25723_25750[(2)] = null);

(statearr_25723_25750[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25720 === (4))){
var inst_25699 = (state_25719[(8)]);
var inst_25699__$1 = (state_25719[(2)]);
var inst_25700 = (inst_25699__$1 == null);
var inst_25701 = cljs.core.not.call(null,inst_25700);
var state_25719__$1 = (function (){var statearr_25724 = state_25719;
(statearr_25724[(8)] = inst_25699__$1);

return statearr_25724;
})();
if(inst_25701){
var statearr_25725_25751 = state_25719__$1;
(statearr_25725_25751[(1)] = (5));

} else {
var statearr_25726_25752 = state_25719__$1;
(statearr_25726_25752[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25720 === (6))){
var state_25719__$1 = state_25719;
var statearr_25727_25753 = state_25719__$1;
(statearr_25727_25753[(2)] = null);

(statearr_25727_25753[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25720 === (3))){
var inst_25716 = (state_25719[(2)]);
var inst_25717 = cljs.core.async.close_BANG_.call(null,out);
var state_25719__$1 = (function (){var statearr_25728 = state_25719;
(statearr_25728[(9)] = inst_25716);

return statearr_25728;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25719__$1,inst_25717);
} else {
if((state_val_25720 === (2))){
var state_25719__$1 = state_25719;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25719__$1,(4),ch);
} else {
if((state_val_25720 === (11))){
var inst_25699 = (state_25719[(8)]);
var inst_25708 = (state_25719[(2)]);
var inst_25696 = inst_25699;
var state_25719__$1 = (function (){var statearr_25729 = state_25719;
(statearr_25729[(10)] = inst_25708);

(statearr_25729[(7)] = inst_25696);

return statearr_25729;
})();
var statearr_25730_25754 = state_25719__$1;
(statearr_25730_25754[(2)] = null);

(statearr_25730_25754[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25720 === (9))){
var inst_25699 = (state_25719[(8)]);
var state_25719__$1 = state_25719;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_25719__$1,(11),out,inst_25699);
} else {
if((state_val_25720 === (5))){
var inst_25699 = (state_25719[(8)]);
var inst_25696 = (state_25719[(7)]);
var inst_25703 = cljs.core._EQ_.call(null,inst_25699,inst_25696);
var state_25719__$1 = state_25719;
if(inst_25703){
var statearr_25732_25755 = state_25719__$1;
(statearr_25732_25755[(1)] = (8));

} else {
var statearr_25733_25756 = state_25719__$1;
(statearr_25733_25756[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25720 === (10))){
var inst_25711 = (state_25719[(2)]);
var state_25719__$1 = state_25719;
var statearr_25734_25757 = state_25719__$1;
(statearr_25734_25757[(2)] = inst_25711);

(statearr_25734_25757[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25720 === (8))){
var inst_25696 = (state_25719[(7)]);
var tmp25731 = inst_25696;
var inst_25696__$1 = tmp25731;
var state_25719__$1 = (function (){var statearr_25735 = state_25719;
(statearr_25735[(7)] = inst_25696__$1);

return statearr_25735;
})();
var statearr_25736_25758 = state_25719__$1;
(statearr_25736_25758[(2)] = null);

(statearr_25736_25758[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__23149__auto___25748,out))
;
return ((function (switch__23037__auto__,c__23149__auto___25748,out){
return (function() {
var cljs$core$async$state_machine__23038__auto__ = null;
var cljs$core$async$state_machine__23038__auto____0 = (function (){
var statearr_25740 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_25740[(0)] = cljs$core$async$state_machine__23038__auto__);

(statearr_25740[(1)] = (1));

return statearr_25740;
});
var cljs$core$async$state_machine__23038__auto____1 = (function (state_25719){
while(true){
var ret_value__23039__auto__ = (function (){try{while(true){
var result__23040__auto__ = switch__23037__auto__.call(null,state_25719);
if(cljs.core.keyword_identical_QMARK_.call(null,result__23040__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__23040__auto__;
}
break;
}
}catch (e25741){if((e25741 instanceof Object)){
var ex__23041__auto__ = e25741;
var statearr_25742_25759 = state_25719;
(statearr_25742_25759[(5)] = ex__23041__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_25719);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e25741;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__23039__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25760 = state_25719;
state_25719 = G__25760;
continue;
} else {
return ret_value__23039__auto__;
}
break;
}
});
cljs$core$async$state_machine__23038__auto__ = function(state_25719){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__23038__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__23038__auto____1.call(this,state_25719);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__23038__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__23038__auto____0;
cljs$core$async$state_machine__23038__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__23038__auto____1;
return cljs$core$async$state_machine__23038__auto__;
})()
;})(switch__23037__auto__,c__23149__auto___25748,out))
})();
var state__23151__auto__ = (function (){var statearr_25743 = f__23150__auto__.call(null);
(statearr_25743[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__23149__auto___25748);

return statearr_25743;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__23151__auto__);
});})(c__23149__auto___25748,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var args25761 = [];
var len__21363__auto___25831 = arguments.length;
var i__21364__auto___25832 = (0);
while(true){
if((i__21364__auto___25832 < len__21363__auto___25831)){
args25761.push((arguments[i__21364__auto___25832]));

var G__25833 = (i__21364__auto___25832 + (1));
i__21364__auto___25832 = G__25833;
continue;
} else {
}
break;
}

var G__25763 = args25761.length;
switch (G__25763) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args25761.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__23149__auto___25835 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__23149__auto___25835,out){
return (function (){
var f__23150__auto__ = (function (){var switch__23037__auto__ = ((function (c__23149__auto___25835,out){
return (function (state_25801){
var state_val_25802 = (state_25801[(1)]);
if((state_val_25802 === (7))){
var inst_25797 = (state_25801[(2)]);
var state_25801__$1 = state_25801;
var statearr_25803_25836 = state_25801__$1;
(statearr_25803_25836[(2)] = inst_25797);

(statearr_25803_25836[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25802 === (1))){
var inst_25764 = (new Array(n));
var inst_25765 = inst_25764;
var inst_25766 = (0);
var state_25801__$1 = (function (){var statearr_25804 = state_25801;
(statearr_25804[(7)] = inst_25766);

(statearr_25804[(8)] = inst_25765);

return statearr_25804;
})();
var statearr_25805_25837 = state_25801__$1;
(statearr_25805_25837[(2)] = null);

(statearr_25805_25837[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25802 === (4))){
var inst_25769 = (state_25801[(9)]);
var inst_25769__$1 = (state_25801[(2)]);
var inst_25770 = (inst_25769__$1 == null);
var inst_25771 = cljs.core.not.call(null,inst_25770);
var state_25801__$1 = (function (){var statearr_25806 = state_25801;
(statearr_25806[(9)] = inst_25769__$1);

return statearr_25806;
})();
if(inst_25771){
var statearr_25807_25838 = state_25801__$1;
(statearr_25807_25838[(1)] = (5));

} else {
var statearr_25808_25839 = state_25801__$1;
(statearr_25808_25839[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25802 === (15))){
var inst_25791 = (state_25801[(2)]);
var state_25801__$1 = state_25801;
var statearr_25809_25840 = state_25801__$1;
(statearr_25809_25840[(2)] = inst_25791);

(statearr_25809_25840[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25802 === (13))){
var state_25801__$1 = state_25801;
var statearr_25810_25841 = state_25801__$1;
(statearr_25810_25841[(2)] = null);

(statearr_25810_25841[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25802 === (6))){
var inst_25766 = (state_25801[(7)]);
var inst_25787 = (inst_25766 > (0));
var state_25801__$1 = state_25801;
if(cljs.core.truth_(inst_25787)){
var statearr_25811_25842 = state_25801__$1;
(statearr_25811_25842[(1)] = (12));

} else {
var statearr_25812_25843 = state_25801__$1;
(statearr_25812_25843[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25802 === (3))){
var inst_25799 = (state_25801[(2)]);
var state_25801__$1 = state_25801;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25801__$1,inst_25799);
} else {
if((state_val_25802 === (12))){
var inst_25765 = (state_25801[(8)]);
var inst_25789 = cljs.core.vec.call(null,inst_25765);
var state_25801__$1 = state_25801;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_25801__$1,(15),out,inst_25789);
} else {
if((state_val_25802 === (2))){
var state_25801__$1 = state_25801;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25801__$1,(4),ch);
} else {
if((state_val_25802 === (11))){
var inst_25781 = (state_25801[(2)]);
var inst_25782 = (new Array(n));
var inst_25765 = inst_25782;
var inst_25766 = (0);
var state_25801__$1 = (function (){var statearr_25813 = state_25801;
(statearr_25813[(10)] = inst_25781);

(statearr_25813[(7)] = inst_25766);

(statearr_25813[(8)] = inst_25765);

return statearr_25813;
})();
var statearr_25814_25844 = state_25801__$1;
(statearr_25814_25844[(2)] = null);

(statearr_25814_25844[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25802 === (9))){
var inst_25765 = (state_25801[(8)]);
var inst_25779 = cljs.core.vec.call(null,inst_25765);
var state_25801__$1 = state_25801;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_25801__$1,(11),out,inst_25779);
} else {
if((state_val_25802 === (5))){
var inst_25769 = (state_25801[(9)]);
var inst_25766 = (state_25801[(7)]);
var inst_25765 = (state_25801[(8)]);
var inst_25774 = (state_25801[(11)]);
var inst_25773 = (inst_25765[inst_25766] = inst_25769);
var inst_25774__$1 = (inst_25766 + (1));
var inst_25775 = (inst_25774__$1 < n);
var state_25801__$1 = (function (){var statearr_25815 = state_25801;
(statearr_25815[(11)] = inst_25774__$1);

(statearr_25815[(12)] = inst_25773);

return statearr_25815;
})();
if(cljs.core.truth_(inst_25775)){
var statearr_25816_25845 = state_25801__$1;
(statearr_25816_25845[(1)] = (8));

} else {
var statearr_25817_25846 = state_25801__$1;
(statearr_25817_25846[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25802 === (14))){
var inst_25794 = (state_25801[(2)]);
var inst_25795 = cljs.core.async.close_BANG_.call(null,out);
var state_25801__$1 = (function (){var statearr_25819 = state_25801;
(statearr_25819[(13)] = inst_25794);

return statearr_25819;
})();
var statearr_25820_25847 = state_25801__$1;
(statearr_25820_25847[(2)] = inst_25795);

(statearr_25820_25847[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25802 === (10))){
var inst_25785 = (state_25801[(2)]);
var state_25801__$1 = state_25801;
var statearr_25821_25848 = state_25801__$1;
(statearr_25821_25848[(2)] = inst_25785);

(statearr_25821_25848[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25802 === (8))){
var inst_25765 = (state_25801[(8)]);
var inst_25774 = (state_25801[(11)]);
var tmp25818 = inst_25765;
var inst_25765__$1 = tmp25818;
var inst_25766 = inst_25774;
var state_25801__$1 = (function (){var statearr_25822 = state_25801;
(statearr_25822[(7)] = inst_25766);

(statearr_25822[(8)] = inst_25765__$1);

return statearr_25822;
})();
var statearr_25823_25849 = state_25801__$1;
(statearr_25823_25849[(2)] = null);

(statearr_25823_25849[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__23149__auto___25835,out))
;
return ((function (switch__23037__auto__,c__23149__auto___25835,out){
return (function() {
var cljs$core$async$state_machine__23038__auto__ = null;
var cljs$core$async$state_machine__23038__auto____0 = (function (){
var statearr_25827 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25827[(0)] = cljs$core$async$state_machine__23038__auto__);

(statearr_25827[(1)] = (1));

return statearr_25827;
});
var cljs$core$async$state_machine__23038__auto____1 = (function (state_25801){
while(true){
var ret_value__23039__auto__ = (function (){try{while(true){
var result__23040__auto__ = switch__23037__auto__.call(null,state_25801);
if(cljs.core.keyword_identical_QMARK_.call(null,result__23040__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__23040__auto__;
}
break;
}
}catch (e25828){if((e25828 instanceof Object)){
var ex__23041__auto__ = e25828;
var statearr_25829_25850 = state_25801;
(statearr_25829_25850[(5)] = ex__23041__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_25801);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e25828;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__23039__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25851 = state_25801;
state_25801 = G__25851;
continue;
} else {
return ret_value__23039__auto__;
}
break;
}
});
cljs$core$async$state_machine__23038__auto__ = function(state_25801){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__23038__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__23038__auto____1.call(this,state_25801);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__23038__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__23038__auto____0;
cljs$core$async$state_machine__23038__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__23038__auto____1;
return cljs$core$async$state_machine__23038__auto__;
})()
;})(switch__23037__auto__,c__23149__auto___25835,out))
})();
var state__23151__auto__ = (function (){var statearr_25830 = f__23150__auto__.call(null);
(statearr_25830[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__23149__auto___25835);

return statearr_25830;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__23151__auto__);
});})(c__23149__auto___25835,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var args25852 = [];
var len__21363__auto___25926 = arguments.length;
var i__21364__auto___25927 = (0);
while(true){
if((i__21364__auto___25927 < len__21363__auto___25926)){
args25852.push((arguments[i__21364__auto___25927]));

var G__25928 = (i__21364__auto___25927 + (1));
i__21364__auto___25927 = G__25928;
continue;
} else {
}
break;
}

var G__25854 = args25852.length;
switch (G__25854) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args25852.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__23149__auto___25930 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__23149__auto___25930,out){
return (function (){
var f__23150__auto__ = (function (){var switch__23037__auto__ = ((function (c__23149__auto___25930,out){
return (function (state_25896){
var state_val_25897 = (state_25896[(1)]);
if((state_val_25897 === (7))){
var inst_25892 = (state_25896[(2)]);
var state_25896__$1 = state_25896;
var statearr_25898_25931 = state_25896__$1;
(statearr_25898_25931[(2)] = inst_25892);

(statearr_25898_25931[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25897 === (1))){
var inst_25855 = [];
var inst_25856 = inst_25855;
var inst_25857 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_25896__$1 = (function (){var statearr_25899 = state_25896;
(statearr_25899[(7)] = inst_25857);

(statearr_25899[(8)] = inst_25856);

return statearr_25899;
})();
var statearr_25900_25932 = state_25896__$1;
(statearr_25900_25932[(2)] = null);

(statearr_25900_25932[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25897 === (4))){
var inst_25860 = (state_25896[(9)]);
var inst_25860__$1 = (state_25896[(2)]);
var inst_25861 = (inst_25860__$1 == null);
var inst_25862 = cljs.core.not.call(null,inst_25861);
var state_25896__$1 = (function (){var statearr_25901 = state_25896;
(statearr_25901[(9)] = inst_25860__$1);

return statearr_25901;
})();
if(inst_25862){
var statearr_25902_25933 = state_25896__$1;
(statearr_25902_25933[(1)] = (5));

} else {
var statearr_25903_25934 = state_25896__$1;
(statearr_25903_25934[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25897 === (15))){
var inst_25886 = (state_25896[(2)]);
var state_25896__$1 = state_25896;
var statearr_25904_25935 = state_25896__$1;
(statearr_25904_25935[(2)] = inst_25886);

(statearr_25904_25935[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25897 === (13))){
var state_25896__$1 = state_25896;
var statearr_25905_25936 = state_25896__$1;
(statearr_25905_25936[(2)] = null);

(statearr_25905_25936[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25897 === (6))){
var inst_25856 = (state_25896[(8)]);
var inst_25881 = inst_25856.length;
var inst_25882 = (inst_25881 > (0));
var state_25896__$1 = state_25896;
if(cljs.core.truth_(inst_25882)){
var statearr_25906_25937 = state_25896__$1;
(statearr_25906_25937[(1)] = (12));

} else {
var statearr_25907_25938 = state_25896__$1;
(statearr_25907_25938[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25897 === (3))){
var inst_25894 = (state_25896[(2)]);
var state_25896__$1 = state_25896;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25896__$1,inst_25894);
} else {
if((state_val_25897 === (12))){
var inst_25856 = (state_25896[(8)]);
var inst_25884 = cljs.core.vec.call(null,inst_25856);
var state_25896__$1 = state_25896;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_25896__$1,(15),out,inst_25884);
} else {
if((state_val_25897 === (2))){
var state_25896__$1 = state_25896;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25896__$1,(4),ch);
} else {
if((state_val_25897 === (11))){
var inst_25860 = (state_25896[(9)]);
var inst_25864 = (state_25896[(10)]);
var inst_25874 = (state_25896[(2)]);
var inst_25875 = [];
var inst_25876 = inst_25875.push(inst_25860);
var inst_25856 = inst_25875;
var inst_25857 = inst_25864;
var state_25896__$1 = (function (){var statearr_25908 = state_25896;
(statearr_25908[(11)] = inst_25874);

(statearr_25908[(7)] = inst_25857);

(statearr_25908[(12)] = inst_25876);

(statearr_25908[(8)] = inst_25856);

return statearr_25908;
})();
var statearr_25909_25939 = state_25896__$1;
(statearr_25909_25939[(2)] = null);

(statearr_25909_25939[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25897 === (9))){
var inst_25856 = (state_25896[(8)]);
var inst_25872 = cljs.core.vec.call(null,inst_25856);
var state_25896__$1 = state_25896;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_25896__$1,(11),out,inst_25872);
} else {
if((state_val_25897 === (5))){
var inst_25857 = (state_25896[(7)]);
var inst_25860 = (state_25896[(9)]);
var inst_25864 = (state_25896[(10)]);
var inst_25864__$1 = f.call(null,inst_25860);
var inst_25865 = cljs.core._EQ_.call(null,inst_25864__$1,inst_25857);
var inst_25866 = cljs.core.keyword_identical_QMARK_.call(null,inst_25857,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_25867 = (inst_25865) || (inst_25866);
var state_25896__$1 = (function (){var statearr_25910 = state_25896;
(statearr_25910[(10)] = inst_25864__$1);

return statearr_25910;
})();
if(cljs.core.truth_(inst_25867)){
var statearr_25911_25940 = state_25896__$1;
(statearr_25911_25940[(1)] = (8));

} else {
var statearr_25912_25941 = state_25896__$1;
(statearr_25912_25941[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25897 === (14))){
var inst_25889 = (state_25896[(2)]);
var inst_25890 = cljs.core.async.close_BANG_.call(null,out);
var state_25896__$1 = (function (){var statearr_25914 = state_25896;
(statearr_25914[(13)] = inst_25889);

return statearr_25914;
})();
var statearr_25915_25942 = state_25896__$1;
(statearr_25915_25942[(2)] = inst_25890);

(statearr_25915_25942[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25897 === (10))){
var inst_25879 = (state_25896[(2)]);
var state_25896__$1 = state_25896;
var statearr_25916_25943 = state_25896__$1;
(statearr_25916_25943[(2)] = inst_25879);

(statearr_25916_25943[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25897 === (8))){
var inst_25860 = (state_25896[(9)]);
var inst_25864 = (state_25896[(10)]);
var inst_25856 = (state_25896[(8)]);
var inst_25869 = inst_25856.push(inst_25860);
var tmp25913 = inst_25856;
var inst_25856__$1 = tmp25913;
var inst_25857 = inst_25864;
var state_25896__$1 = (function (){var statearr_25917 = state_25896;
(statearr_25917[(14)] = inst_25869);

(statearr_25917[(7)] = inst_25857);

(statearr_25917[(8)] = inst_25856__$1);

return statearr_25917;
})();
var statearr_25918_25944 = state_25896__$1;
(statearr_25918_25944[(2)] = null);

(statearr_25918_25944[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__23149__auto___25930,out))
;
return ((function (switch__23037__auto__,c__23149__auto___25930,out){
return (function() {
var cljs$core$async$state_machine__23038__auto__ = null;
var cljs$core$async$state_machine__23038__auto____0 = (function (){
var statearr_25922 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25922[(0)] = cljs$core$async$state_machine__23038__auto__);

(statearr_25922[(1)] = (1));

return statearr_25922;
});
var cljs$core$async$state_machine__23038__auto____1 = (function (state_25896){
while(true){
var ret_value__23039__auto__ = (function (){try{while(true){
var result__23040__auto__ = switch__23037__auto__.call(null,state_25896);
if(cljs.core.keyword_identical_QMARK_.call(null,result__23040__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__23040__auto__;
}
break;
}
}catch (e25923){if((e25923 instanceof Object)){
var ex__23041__auto__ = e25923;
var statearr_25924_25945 = state_25896;
(statearr_25924_25945[(5)] = ex__23041__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_25896);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e25923;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__23039__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25946 = state_25896;
state_25896 = G__25946;
continue;
} else {
return ret_value__23039__auto__;
}
break;
}
});
cljs$core$async$state_machine__23038__auto__ = function(state_25896){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__23038__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__23038__auto____1.call(this,state_25896);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__23038__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__23038__auto____0;
cljs$core$async$state_machine__23038__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__23038__auto____1;
return cljs$core$async$state_machine__23038__auto__;
})()
;})(switch__23037__auto__,c__23149__auto___25930,out))
})();
var state__23151__auto__ = (function (){var statearr_25925 = f__23150__auto__.call(null);
(statearr_25925[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__23149__auto___25930);

return statearr_25925;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__23151__auto__);
});})(c__23149__auto___25930,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;


//# sourceMappingURL=async.js.map?rel=1482335099838