(ns clj-scala-ds.health
  (:require [aleph.http :as http]
            [clojure.data.json :as json]
            [clj-scala-ds.util :refer [body->edn ]]))


(defn players-health [{:keys [status server token apiToken] :as previous} playerId fields]
  (if (= status "login.success")
    (let [path (str "/" ctx "/api/rest/playerhealth")
          url (str server path)]
      (try
        (-> @(http/request  {:url url
                             :request-method "get"
                             :headers {:content-type "application/json"
                                       "apiToken" apiToken
                                       "Cookie" (str "token:" token)}
                             })
            body->edn)
        (catch clojure.lang.ExceptionInfo e
          e)))
    previous))
