(ns clj-scala-ds.players
  (:require [clj-http.client :as http]
            [clojure.data.json :as json]
            [clj-scala-ds.util :refer [body->edn ctx]]))

(defn get-current-state-for-a-player [{:keys [status server token apiToken timeout] :or {timeout 10000} :as previous} id]
  (if (= status "login.success")
    (let [path (str  "/" ctx "/api/rest/players/" id "/state")
          url (str server path)]
      (try
        (-> (http/get url  {:connection-timeout timeout
                            :headers {:content-type "application/json"
                                      "apiToken" apiToken
                                      "Cookie" (str "token:" token)}})
            body->edn)
        (catch clojure.lang.ExceptionInfo e
          (.printStackTrace e)
          (-> e .getData body->edn))))
    previous))

(defn list-players [{:keys [status server token apiToken timeout] :or {timeout 10000} :as previous}]
  (if (= status "login.success")
    (let [path (str "/" ctx "/api/rest/players")
          url (str server path)]
      (try
        (-> (http/get url {:connection-timeout timeout
                           :headers {:content-type "application/json"
                                     "apiToken" apiToken
                                     "Cookie" (str "token:" token)}
                           :query-params {"limit" "1000"}})
            body->edn)
        (catch clojure.lang.ExceptionInfo e
          (.printStackTrace e)
          (-> e .getData body->edn))))
    previous))

(defn get-player-plans [{:keys [status server token apiToken timeout] :or {timeout 10000} :as previous} id]
  (if (= status "login.success")
    (let [path (str "/" ctx "/api/rest/players/" id "/plans")
          url (str server path)]
      (try
        (-> (http/get url {:connection-timeout timeout
                           :headers {:content-type "application/json"
                                     "apiToken" apiToken
                                     "Cookie" (str "token:" token)}})
            body->edn)
        (catch clojure.lang.ExceptionInfo e
          (.printStackTrace e)
          (-> e .getData body->edn))))
    previous))

(defn list-players-inventory [{:keys [status server token apiToken timeout] :or {timeout 10000} :as previous} id]
  (if (= status "login.success")
    (let [path (str "/" ctx "/api/rest/players/" id "/inventory")
          url (str server path)]
      (try
        (-> (http/get url  {:connection-timeout timeout
                            :headers {:content-type "application/json"
                                      "apiToken" apiToken
                                      "Cookie" (str "token:" token)}
                            :query-params {"limit" "1000"}})
            body->edn)
        (catch clojure.lang.ExceptionInfo e
          (.printStackTrace e)
          (-> e .getData body->edn))))
    previous))

(defn request-players-logs [{:keys [status server token apiToken timeout] :or {timeout 10000} :as previous} uuid]
  (if (= status "login.success")
    (let [path (str "/" ctx "/api/rest/players/" uuid "/requestlog")
          url (str server path)]
      (try
        (-> (http/get url {:connection-timeout timeout
                           :headers {:content-type "application/json"
                                      "apiToken" apiToken
                                      "Cookie" (str "token:" token)}})
            body->edn)
        (catch clojure.lang.ExceptionInfo e
          (.printStackTrace e)
          (-> e .getData body->edn))))
    previous))
