(ns clj-scala-ds.health
  (:require [clj-http.client :as http]
            [clojure.data.json :as json]
            [clj-scala-ds.util :refer [body->edn ctx]]))


(defn players-health [{:keys [status server token apiToken timeout] :or {timeout 10000} :as previous}]
  (if (= status "login.success")
    (let [path (str "/" ctx "/api/rest/playerhealth")
          url (str server path)]
      (try
        (-> (http/get url {:connection-timeout timeout
                           :headers {:content-type "application/json"
                                     "apiToken" apiToken
                                     "Cookie" (str "token:" token)}
                           })
            body->edn)
        (catch clojure.lang.ExceptionInfo e
          e)))
    previous))
