(ns leiningen.new.column
  (:require [leiningen.new.templates :refer [renderer name-to-path ->files]]
            [leiningen.core.main :as main]))

(def render (renderer "column"))

(defn column
  "column is a starter template for Pedestal based webapps"
  [name]
  (let [data {:name name
              :sanitized (name-to-path name)}]
    (main/info "Generating fresh 'lein new' column project.")
    (->files data
             ["project.clj" (render "project.clj" data)]
             ["README.md" (render "README.md" data)]
             ["ARCHITECTURE.md" (render "ARCHITECTURE.md" data)]
             ["CHANGELOG.md" (render "CHANGELOG.md" data)]
             ["CONTRIBUTING.md" (render "CONTRIBUTING.md" data)]
             [".gitignore" (render "gitignore" data)]
             ["config/logback.xml" (render "config/logback.xml" data)]
             ["resources/env/jdbc.edn" (render "resources/env/jdbc.edn" data)]
             ["resources/env/secret.edn" (render "resources/env/secret.edn" data)]
             ["resources/migrations/001-create-roles.edn" (render "resources/migrations/001-create-roles.edn" data)]
             ["resources/migrations/002-create-roles-data.edn" (render "resources/migrations/002-create-roles-data.edn" data)]
             ["resources/migrations/003-create-users.edn" (render "resources/migrations/003-create-users.edn" data)]
             ["src/{{sanitized}}/server.clj" (render "src/column/server.clj" data)]
             ["src/{{sanitized}}/service.clj" (render "src/column/service.clj" data)]
             ["src/{{sanitized}}/site.clj" (render "src/column/site.clj" data)]
             ["src/{{sanitized}}/site/home.clj" (render "src/column/site/home.clj" data)]
             ["src/{{sanitized}}/auth.clj" (render "src/column/auth.clj" data)]
             ["src/{{sanitized}}/auth/site.clj" (render "src/column/auth/site.clj" data)]
             ["src/{{sanitized}}/db.clj" (render "src/column/db.clj" data)]
             ["src/{{sanitized}}/db/users.clj" (render "src/column/db/users.clj" data)]
             ["src/{{sanitized}}/db/sql/users.sql" (render "src/column/db/sql/users.sql" data)]
             ["test/{{sanitized}}/service_test.clj" (render "test/column/service_test.clj" data)]
             )))
