(ns {{name}}.auth
  (:require [buddy.hashers :as hashers]
            [{{name}}.auth.users :as users]
            [{{name}}.db :as db]))

(defn user-by-email-exists?
  "Checks if user for the given email exists"
  [email]
  (let [data (users/user-by-email db/jdbc email)]
    (nil? data)))

(defn user-by-username-exists?
  "Checks if user for the given username exists"
  [username]
  (let [data (users/user-by-email db/jdbc username)]
    (nil? data)))

(defn hash-password
  "Wrapper to hash password to abstract algorithm"
  [password]
  (hashers/derive password {:alg :bcrypt+blake2b-512}))

(defn new-user
  "Creates a new user in the db"
  [data]
  (println data)
  (let [datum
        {:username (:username data)
         :email (:email data)
         :password (hash-password (:password data))}]
    (println datum)
    (if (user-by-email-exists? datum)
      (users/insert-user  db/jdbc datum)
      (println "User exists"))))

(defn authenticate
  "Authenticates the user. First checks if the user exists"
  [data]
  (let [user (users/user-by-username db/jdbc data)]
    (if (nil? user)
      {:err_msg "Username or Password is wrong"}
      (let [attempt (:password data)
            password (:password user)]
        (if (hashers/check attempt password)
          user
          {:err_msg "Username or Password is wrong"})))))

(defn derive-password [data]
  (hashers/derive  data {:alg :bcrypt+blake2b-512}))
