(ns orcl.naive.tests-runner
  (:require [orcl.naive :as naive]
            [orcl.analyzer :as analyzer]
            [orcl.parser :as parser]
            [orcl.compiler :as compiler]
            [orcl.testkit.proto :as proto]
            [orcl.naive.lib :as lib]))

(defn compiler []
  (let [backend (naive/backend)]
    (reify proto/OrcCompiler
      (compile [this program]
        (let [ast      (parser/parse program)
              analyzed (analyzer/analyze ast lib/prelude {:deflate?     true
                                                          :patterns?    true
                                                          :clauses?     true
                                                          :conditional? true})]
          (compiler/compile backend analyzed))))))
